using System;
using Server;
using Server.Network;
using Server.Commands;
using System.Net;
using System.IO;

namespace Server.Stark
{
    public class Chat
    {
		public static string publish_key = "";
		public static string tag_name = "chat_message";
        public static HttpWebRequest webRequest;
		
        public static void Initialize()
        {
            CommandSystem.Register("c", AccessLevel.GameMaster, new CommandEventHandler(ChatAll_OnCommand));
			CommandSystem.Register("ч", AccessLevel.GameMaster, new CommandEventHandler(ChatAll_OnCommand));
        }

        private static void ChatAll_OnCommand(CommandEventArgs e)
        {
			string Msg = String.Concat(e.Mobile.RawName, ": ", e.ArgString);
			
			WebRequest req = null;
			WebRequestState reqState = null;
			
			Uri fileURI = new Uri("http://partcl.com/publish?publish_key="+ publish_key +"&id="+ tag_name +"&value="+ Msg);
		
			// send msg to all online users
			foreach (NetState ns in NetState.Instances)
                if (ns.Mobile != null)
                    ns.Mobile.SendMessage(Msg);
					
			
			// making request to partcl
			req = (HttpWebRequest)HttpWebRequest.Create(fileURI);
            reqState = new HttpWebRequestState(1448);
            reqState.request = req;
			
			if (req != null)
			{
				reqState.fileURI = fileURI;
				//reqState.respInfoCB = new ResponseInfoDelegate(SetResponseInfo);
				//reqState.progCB = new ProgressDelegate(Progress);
				//reqState.doneCB = new DoneDelegate(Done);
				reqState.transferStart = DateTime.Now;
				// Start the asynchronous request.
				IAsyncResult result = (IAsyncResult)req.BeginGetResponse(new AsyncCallback(RespCallback), reqState);
			}

        }
		
		/// <summary>
        /// Main response callback, invoked once we have first Response packet from
        /// server.  This is where we initiate the actual file transfer, reading from
        /// a stream.
        /// </summary>
        private static void RespCallback(IAsyncResult asyncResult)
        {
		
        }
    }
}