﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace UOPilotPlugIns
{
    /*
      tInitStruct = packed record
        FunctionCount : Cardinal;
        FunctionNames : Array of Pchar;
      end;
 
     tParamStruct = packed record
        WindowHandle : Cardinal; // Handle of workWindow
        WindowPID    : Cardinal; // pid of process of workWindow
        Reserved     : Cardinal;
        ParamString     : Pchar; // string of parameters with substituted variables
        ParamStringOrig : Pchar; // original string of parameters
        Result : array [0..32767] of char // array for returned values
      end;
    */

    public struct TInitStruct {
        public UInt32 functionCount;
        public String[] functionNames;
    }

    public struct TParamStruct {
        public UInt32 windowHandle; // Handle of workWindow
        public UInt32 windowPID; // pid of process of workWindow
        public UInt32 reserved;
        public String paramString; // string of parameters with substituted variables
        public String paramStringOrig; // original string of parameters
        public String result; // array for returned values
    }

    public class Test
    {
        TInitStruct initStruct = new TInitStruct();

        public TInitStruct InitPlugin(Int32 app, Int32 scr, ref double version) {
            // проверяем версию пилота, если нужно.
            // пилот анализирует возвращаемое значение и выгружает dll, если false
            if (version > 2.18)
            {
                initStruct.functionCount = 1;
                Array.Resize(ref initStruct.functionNames, (int)initStruct.functionCount);
                initStruct.functionNames[0] = "Func1";
            }
            else initStruct.functionCount = 0;
            return initStruct;
        }

        public bool Func1(TParamStruct addressPS) {
            addressPS.result = "AllRight";
            return true;
        }
    }
}
