/*
 * Decompiled with CFR 0.152.
 */
package com.google.scrollview.ui;

import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;

public class SVImageHandler {
    static HashMap<String, PImage> images = new HashMap();
    static boolean readImageData = false;
    static String imageName = null;
    static int bytesRead = 0;
    static int bpp = 0;
    static int[] pictureArray;
    static int bytePerPixel;
    static int width;
    static int height;

    private SVImageHandler() {
    }

    private static int[] processBinaryImage(String string) {
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        int[] nArray = new int[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '0') {
                nArray[i] = n2;
                continue;
            }
            if (string.charAt(i) == '1') {
                nArray[i] = n;
                continue;
            }
            System.out.println("Error: unexpected non-image-data: (" + bytesRead + "," + string.length() + "," + height * width + ")");
            System.exit(1);
        }
        return nArray;
    }

    private static int[] processGrayImage(String string) {
        int[] nArray = new int[string.length() / 2];
        for (int i = 0; i < string.length(); i += 2) {
            String string2 = string.substring(i, i + 1);
            nArray[i] = Integer.parseInt(string2, 16);
        }
        return nArray;
    }

    private static int[] process32bppImage(String string) {
        String[] stringArray = string.split("#");
        int[] nArray = new int[stringArray.length - 1];
        for (int i = 1; i < stringArray.length; ++i) {
            nArray[i - 1] = Integer.parseInt(stringArray[i], 16);
        }
        return nArray;
    }

    private static void closeImage() {
        BufferedImage bufferedImage = null;
        if (bpp == 1) {
            bufferedImage = new BufferedImage(width, height, 12);
        } else if (bpp == 8) {
            bufferedImage = new BufferedImage(width, height, 10);
        } else if (bpp == 32) {
            bufferedImage = new BufferedImage(width, height, 1);
        } else {
            System.out.println("Unsupported Image Type: " + bpp + " bpp");
            System.exit(1);
        }
        bufferedImage.setRGB(0, 0, width, height, pictureArray, 0, width);
        PImage pImage = new PImage((Image)bufferedImage);
        images.put(imageName, pImage);
        imageName = null;
        readImageData = false;
        System.out.println("(server, #Bytes:" + bytesRead + ") Image Completed");
        bytesRead = 0;
        bpp = 0;
    }

    public static void createImage(String string, int n, int n2, int n3) {
        bpp = n3;
        if (bpp == 1) {
            bytePerPixel = 1;
        } else if (bpp == 8) {
            bytePerPixel = 2;
        } else if (bpp == 32) {
            bytePerPixel = 7;
        } else {
            throw new IllegalArgumentException("bpp should be 1 (binary), 8 (gray) or 32 (argb), is " + bpp);
        }
        if (imageName != null) {
            throw new IllegalArgumentException("Image " + imageName + " already opened!");
        }
        imageName = string;
        bytesRead = 0;
        readImageData = true;
        height = n2;
        width = n;
        pictureArray = new int[n * n2];
        System.out.println("Processing Image with " + bpp + " bpp, size " + n + "x" + n2);
    }

    public static void openImage(String string) {
        PImage pImage = new PImage(string);
        images.put(string, pImage);
    }

    public static PImage getImage(String string) {
        return images.get(string);
    }

    public static void parseData(String string) {
        int[] nArray = null;
        if (bpp == 1) {
            nArray = SVImageHandler.processBinaryImage(string);
        } else if (bpp == 8) {
            nArray = SVImageHandler.processGrayImage(string);
        } else if (bpp == 32) {
            nArray = SVImageHandler.process32bppImage(string);
        } else {
            System.out.println("Unsupported Bit Type: " + bpp);
        }
        System.arraycopy(nArray, 0, pictureArray, bytesRead, nArray.length);
        if ((bytesRead += nArray.length) == height * width) {
            SVImageHandler.closeImage();
        }
    }

    public static boolean getReadImageData() {
        return readImageData;
    }

    public static int getMissingRemainingBytes() {
        return height * width * bytePerPixel - bytesRead;
    }

    static {
        bytePerPixel = 0;
        width = 0;
        height = 0;
    }
}

