--lua
function find_heap_pixel(find)
	if not (find.deviation) then
        find["deviation"] = {}
        for i = 1, #find.color do
            table.insert(find.deviation, 0)
        end
    elseif #find.deviation < #find.color then
        for i = #find.deviation, #find.color - 1 do
            table.insert(find.deviation, 0)
        end
    elseif #find.deviation > #find.color then
        for i = #find.deviation, #find.color + 1, -1 do
           table.remove(find.deviation)
        end
    end

    if not (find.min_pixel_color) then
        find["min_pixel_color"] = {}
        for i = 1, #find.color do
            table.insert(find.min_pixel_color, 0)
        end
    elseif #find.min_pixel_color < #find.color then
    		for i = #find.min_pixel_color, #find.color - 1 do
    			table.insert(find.min_pixel_color, 0)	
    		end
    end

    if table.maxn(find) == 4 then
        table.insert(find, 1)
        table.insert(find, 1)
    elseif  table.maxn(find) == 5 then
        table.insert(find, 1)
    end


	local function func_deviation(color1, deviat)
    	local dev, R, G, B
    	local tmp = {}
    	for i = 1, #color1 do
        	dev = math.floor(255 * deviat[i] / 100)
        	R = color1[i] - math.floor(color1[i] / 256) * 256
        	G = math.floor((color1[i] - math.floor(color1[i] / 65536) * 65536) / 256)
        	B = math.floor(color1[i] / 65536)
        	local Rmin,Rmax,Gmin,Gmax,Bmin,Bmax = R-dev,R+dev,G-dev,G+dev,B-dev,B+dev
        	if Rmin < 0 then Rmin = 0 end
        	if Rmax > 255 then Rmax = 255 end
        	if Gmin < 0 then Gmin = 0 end
        	if Gmax > 255 then Gmax = 255 end
        	if Bmin < 0 then Bmin = 0 end
        	if Bmax > 255 then Bmax = 255 end
        	table.insert(tmp, {Rmin + Gmin * 256 + Bmin * 65536, Rmax + Gmax * 256 + Bmax * 65536})
   		end
    	return tmp
	end


	local function find_color(rgb)
   		local max_deviation = 0
    	for i = 1, #find.deviation do
        	if find.deviation[i] > max_deviation then
           		max_deviation = find.deviation[i]
        	end
    	end
   		local a = findcolor(find[1], find[2], find[3], find[4], find[5], find[6], "(", table.concat(find.color, ", "), ")", "%zxy", 2, -1, max_deviation)
    	if tonumber(a) > 0 then
    		local z
        	for i = #zxy, 1, -1 do
            	z = 0
            	for j = 1, #rgb do
                	if tonumber(zxy[i][3]) >= rgb[j][1] and tonumber(zxy[i][3]) <= rgb[j][2] then
                    	z = 1
                    	break
                	end
            	end
            	if z == 0 then
                	table.remove(zxy, i)
            	end
        	end
    	end
    	return #zxy, zxy
	end

	local function find_group(rgb)
    	local z, r = 0, find.radius
    	local result = {{}}
    	
    	
    	table.insert(result[1], {tonumber(zxy[1][1]), tonumber(zxy[1][2]), tonumber(zxy[1][3])})   	
    	for i = 1, #zxy do
    		z = 0
    		for j = 1, #result do
    			if math.sqrt((zxy[i][1]-result[j][1][1])^2+(zxy[i][2]-result[j][1][2])^2) < r then
    				z = j
    				break	
    			end
    		end
    		if z == 0 then
    			result[#result+1] = {}
    			table.insert(result[#result], {tonumber(zxy[i][1]), tonumber(zxy[i][2]), tonumber(zxy[i][3])}) 
    		else
    			table.insert(result[z], {tonumber(zxy[i][1]), tonumber(zxy[i][2]), tonumber(zxy[i][3])})
    		end
    	end

    	for i = #result, 1, -1 do
        	if #result[i] < find.min_pixel_count or #result[i] > find.max_pixel_count then
            	table.remove(result, i)
        	end
    	end    
    	local count = {{}}
    	for i = 1, #result do
        	count[i] = {}
        	for j = 1, #find.color do
            	count[i][j] = 0
        	end
    	end   	 	
    	for i = #result, 1, -1 do
        	for j = 1, #result[i] do
            	for k = 1, #find.color do        	
            	if result[i][j][3] >= rgb[k][1] and result[i][j][3] <= rgb[k][2] then
                    	count[i][k] = count[i][k] + 1
                    	break
                	end
            	end
        	end
    	end
		for i = #count, 1, -1 do
       		local z = 0
       		for j = 1, #count[i] do
           		if count[i][j] > find.min_pixel_color[j] then
    				z = z + 1
            	end
       		end
        	if z < find.min_color then
        			table.remove(result, i)
         	   		table.remove(count, i)
        	end
    	end  		   	
   	 	local array_group = {}
    	for i = 1, #result do
        	local x, y = 0, 0
        	array_group[i] = {}
        	for j = 1, #result[i] do
           		x = x + result[i][j][1]
           		y = y + result[i][j][2]
        	end
        	x = tonumber(round(x / #result[i]))
        	y = tonumber(round(y / #result[i]))
        	table.insert(array_group[i], 1, x)
        	table.insert(array_group[i], 2, y)
    	end
    	for i = 1, #count do
    	local z = 0
        	for j = 1, #count[i] do
           	 z = z + count[i][j]
        	end
        	table.insert(array_group[i], 3, z)
        	for j = 1, #find.color do
            	table.insert(array_group[i], j + 3, count[i][j])
        	end
    	end
    	return array_group 
	end
		
	local rgb, find_col = {}, {}
	local rgb = func_deviation(find.color, find.deviation)	
	local pixel, find_col = find_color(rgb)
	if pixel > 0 then
		local find_g = find_group(rgb)
		return pixel, find_g
	else
		return 0, nil
	end
	
end