--lua
function find_heap_pixel(find)
	----- check for errors ---------------
	for i = 1, #find.color do
		if type(find.color[i]) ~= "string" and find.color[i] < 0  then
			log ("Error - Incorrect color")
			return 0, nil
		end
	end
	if find.x then
		if find.y == nil then
			log ("Error - Missing variable Y")
			return 0, nil	
		end
		if find.x < 1 or find.y < 1 then
			log ("Error - Incorrect variable X or Y")
			return 0, nil
		end
		if find.deltaX == nil then
    		find["deltaX"] = 0	
   		end
    	if math.abs(find.deltaX) > find.x / 2 then
    		log ("Error - Incorrect deltaX. Maximum deltaX = x / 2. Minimum deltaX = -x / 2")
    		return 0, nil	
    	end
    end
    if find.y and find.x == nil then
    	log ("Error - Incorrect variable X")
    	return 0, nil	
    end
    if find.radius == nil then
    	if find.x == nil or find.y == nil then
    		log ("Error - incorrect object size")
    		return 0, nil
    	end
    end
    if find[1] > find [3] or find[2] > find [4] then
    	log ("Error - Incorrect search area")
    	return 0, nil	
    end
    if find[5] and find[5] < 1 or find[6] and find[6] < 1 then
    	log ("Error - Incorrect step")
    	return 0, nil	
    end
    if #find.color < find.min_color then
    	log ("Error - Size array find.color < min_color")	
    end
	if not (find.deviation) then
        find["deviation"] = {}
        for i = 1, #find.color do
            table.insert(find.deviation, 0)
        end
    elseif #find.deviation < #find.color then
        for i = #find.deviation, #find.color - 1 do
            table.insert(find.deviation, 0)
        end
    elseif #find.deviation > #find.color then
        for i = #find.deviation, #find.color + 1, -1 do
           table.remove(find.deviation)
        end
    end
    if not (find.min_pixel_color) then
        find["min_pixel_color"] = {}
        for i = 1, #find.color do
            table.insert(find.min_pixel_color, 0)
        end
    elseif #find.min_pixel_color < #find.color then
    		for i = #find.min_pixel_color, #find.color - 1 do
    			table.insert(find.min_pixel_color, 0)	
    		end
    end
    if table.maxn(find) == 4 then
        table.insert(find, 1)
        table.insert(find, 1)
    elseif  table.maxn(find) == 5 then
        table.insert(find, 1)
    end
   ------------------------------------------------ 
    
	local function func_deviation(color1, deviat)
		local function color_to_rgb(clr)
			local R, G, B, R1, G1, B1
			if string.match(clr, "^%s*%d+%s*$") then
				clr = tonumber(clr) 
    			R = clr - math.floor(clr / 256) * 256
    			G = math.floor((clr - math.floor(clr / 65536) * 65536) / 256)
    			B = math.floor(clr / 65536)
    		elseif string.match(clr, "^%s*%d+%s*%-*%s*%d+%s*$") then 
    		    	local clr1, clr2 = clr:match("%s*(%d+)%s*%-*%s*(%d+)%s*")
    		    	clr1, clr2 = tonumber(clr1), tonumber(clr2) 
    				R = clr1 - math.floor(clr1 / 256) * 256
    				G = math.floor((clr1 - math.floor(clr1 / 65536) * 65536) / 256)
    				B = math.floor(clr1 / 65536)
    				R1 = clr2 - math.floor(clr2 / 256) * 256
    				G1 = math.floor((clr2 - math.floor(clr2 / 65536) * 65536) / 256)
    				B1 = math.floor(clr2 / 65536)  				
    			else
					R, R1, G, G1, B, B1 = string.match(clr,"%s*R*%s*%(*%s*(%d*)%s*%-*%s*(%d*)%s*%)*%s*%+*%s*G*%s*%(*%s*(%d*)%s*%-*%s*(%d*)%s*%)*%s*%+*%s*B*%s*%(*%s*(%d*)%s*%-*%s*(%d*)%s*%)*%s*")
					R, R1, G, G1, B, B1 = tonumber(R),tonumber(R1),tonumber(G),tonumber(G1),tonumber(B),tonumber(B1)
					if R1 == nil then R1 = R end
					if G1 == nil then G1 = G end
					if B1 == nil then B1 = B end
    		end		
    		return R, G, B, R1, G1, B1
		end
		
		local function RGB_min_max(Rmin,Rmax,Gmin,Gmax,Bmin,Bmax)
			local Rmin,Rmax,Gmin,Gmax,Bmin,Bmax = Rmin,Rmax,Gmin,Gmax,Bmin,Bmax
				if Rmin and Rmin < 0 then Rmin = 0 end
        		if Rmax and Rmax > 255 then Rmax = 255 end
        		if Gmin and Gmin < 0 then Gmin = 0 end
        		if Gmax and Gmax > 255 then Gmax = 255 end
        		if Bmin and Bmin < 0 then Bmin = 0 end
        		if Bmin and Bmax > 255 then Bmax = 255 end	
			return Rmin,Rmax,Gmin,Gmax,Bmin,Bmax
		end
			
    	local dev, R, G, B
    	local tmp = {}
    	for i = 1, #color1 do
        	dev = math.floor(255 * deviat[i] / 100)   	
        	R, G, B, R1, G1, B1 = color_to_rgb(color1[i])	
        	if string.match(color1[i], "^%s*%d+%s*$") then	
        		local Rmin,Rmax,Gmin,Gmax,Bmin,Bmax = R-dev,R+dev,G-dev,G+dev,B-dev,B+dev
        		Rmin,Rmax,Gmin,Gmax,Bmin,Bmax = RGB_min_max(Rmin,Rmax,Gmin,Gmax,Bmin,Bmax) 
        		table.insert(tmp, {Rmin, Rmax, Gmin, Gmax, Bmin, Bmax})
        	elseif string.match(color1[i], "^%s*%d+%s*%-*%s*%d+%s*$") then
        		local Rmin,Rmax,Gmin,Gmax,Bmin,Bmax = R-dev,R+dev,G-dev,G+dev,B-dev,B+dev
        		local R1min,R1max,G1min,G1max,B1min,B1max = R1-dev,R1+dev,G1-dev,G1+dev,B1-dev,B1+dev
        		Rmin,_,Gmin,_,Bmin,_ = RGB_min_max(Rmin,Rmax,Gmin,Gmax,Bmin,Bmax)
        		_,R1max,_,G1max,_,B1max = RGB_min_max(R1min,R1max,G1min,G1max,B1min,B1max)
        		table.insert(tmp, {Rmin, R1max, Gmin, G1max, Bmin, B1max})
        	else      		
        		local Rmin,Rmax,Gmin,Gmax,Bmin,Bmax = R and R-dev or nil,R1 and R1+dev or nil,G and G-dev or nil,G1 and G1+dev or nil,B and B-dev or nil,B1 and B1+dev or nil
        		Rmin,Rmax,Gmin,Gmax,Bmin,Bmax = RGB_min_max(Rmin,Rmax,Gmin,Gmax,Bmin,Bmax)
        		table.insert(tmp, {Rmin,Rmax,Gmin,Gmax,Bmin,Bmax})
        	end
   		end
    	return tmp
	end

	local function find_color(rgb)
   		local max_deviation = 0
    	for i = 1, #find.deviation do
        	if find.deviation[i] > max_deviation then
           		max_deviation = find.deviation[i]
        	end
    	end
    	max_deviation = math.ceil(max_deviation)
   		local a = findcolor(find[1], find[2], find[3], find[4], find[5], find[6], "(", table.concat(find.color, ", "), ")", "%zxy", 2, -1, max_deviation)
    	if tonumber(a) > 0 then
    		local z, R, G, B
    		for i = 1, #zxy do
    			R = tonumber(zxy[i][3]) - math.floor(tonumber(zxy[i][3]) / 256) * 256
    			G = math.floor((tonumber(zxy[i][3]) - math.floor(tonumber(zxy[i][3]) / 65536) * 65536) / 256)
    			B = math.floor(tonumber(zxy[i][3]) / 65536)
    			table.insert(zxy[i], R)
        		table.insert(zxy[i], G)
        		table.insert(zxy[i], B)				
    		end    				
    		for i = #zxy, 1, -1 do
            	z = 0
            	for j = 1, #rgb do           		
					if ((rgb[j][1] == nil or zxy[i][4] >= rgb[j][1]) and (rgb[j][2] == nil or zxy[i][4] <= rgb[j][2])) and ((rgb[j][3] == nil or zxy[i][5] >= rgb[j][3]) and (rgb[j][4] == nil or zxy[i][5] <= rgb[j][4])) and ((rgb[j][5] == nil or zxy[i][6] >= rgb[j][5]) and (rgb[j][6] == nil or zxy[i][6] <= rgb[j][6])) then            	
						z = 1
                    	break
                	end
            	end
            	if z == 0 then
                	table.remove(zxy, i)
            	end
        	end
    	end
    	return #zxy, zxy
	end

	local function find_group(rgb)
    	local z, r = 0, find.radius
    	local result = {{}}    	
    	table.insert(result[1], {tonumber(zxy[1][1]), tonumber(zxy[1][2]), tonumber(zxy[1][3])})   	
    	for i = 2, #zxy do
    		z = 0
    		for j = 1, #result do
    			if find.radius then
    				if math.sqrt((zxy[i][1]-result[j][1][1])^2+(zxy[i][2]-result[j][1][2])^2) < r then
    					z = j
    					break	
    				end
    			else
    				if find.deltaX <= 0 then
    					if result[j][1][1] <= tonumber(zxy[i][1]) then
    						if zxy[i][1] - result[j][1][1] <= find.x / 2 - math.abs(find.deltaX) and zxy[i][2] - result[j][1][2] <= find.y then 
    							z = j
    							break	
    						end
    					elseif result[j][1][1] - zxy[i][1] <= find.x / 2 + math.abs(find.deltaX) and zxy[i][2] - result[j][1][2] <= find.y then
    						z = j
    						break
    					end
    				elseif result[j][1][1] <= tonumber(zxy[i][1]) then
    						if zxy[i][1] - result[j][1][1] <= find.x / 2 + find.deltaX and zxy[i][2] - result[j][1][2] <= find.y then
    					 		z = j
    							break
    					 	end
					elseif result[j][1][1] - zxy[i][1] <= find.x / 2 - find.deltaX and zxy[i][2] - result[j][1][2] <= find.y then	    					 	
    						z = j
    						break		 	
    				end	 			
    			end		   						
    		end
    		if z == 0 then
    			result[#result+1] = {}
    			table.insert(result[#result], {tonumber(zxy[i][1]), tonumber(zxy[i][2]), tonumber(zxy[i][3])}) 
    		else
    			table.insert(result[z], {tonumber(zxy[i][1]), tonumber(zxy[i][2]), tonumber(zxy[i][3])})
    		end
    	end   
    	for i = #result, 1, -1 do
        	if #result[i] < find.min_pixel_count or #result[i] > find.max_pixel_count then
            	table.remove(result, i)
        	end
    	end    
    	local count = {{}}    	
    	for i = 1, #result do
        	count[i] = {}
        	for j = 1, #find.color do
            	count[i][j] = 0
        	end
    	end      	 	 	
    	local R, G, B 	
    	for i = #result, 1, -1 do
        	for j = 1, #result[i] do
            	for k = 1, #find.color do
             		R = result[i][j][3] - math.floor(result[i][j][3] / 256) * 256
    				G = math.floor((result[i][j][3] - math.floor(result[i][j][3] / 65536) * 65536) / 256)
    				B = math.floor(result[i][j][3] / 65536)        
					if ((rgb[k][1] == nil or R >= rgb[k][1]) and (rgb[k][2] == nil or R <= rgb[k][2])) and ((rgb[k][3] == nil or G >= rgb[k][3]) and (rgb[k][4] == nil or G <= rgb[k][4])) and ((rgb[k][5] == nil or B >= rgb[k][5]) and (rgb[k][6] == nil or B <= rgb[k][6])) then                   
                    	count[i][k] = count[i][k] + 1
                    	break
                    end
            	end
        	end
    	end   	 
		for i = #count, 1, -1 do
       		local z = 0
       		for j = 1, #count[i] do
           		if count[i][j] > find.min_pixel_color[j] then
    				z = z + 1
            	end
       		end
        	if z < find.min_color then
        		table.remove(result, i)
         	   	table.remove(count, i)
        	end
    	end 		   	
   	 	local array_group = {}
    	for i = 1, #result do
        	local x, y = 0, 0
        	array_group[i] = {}
        	for j = 1, #result[i] do
           		x = x + result[i][j][1]
           		y = y + result[i][j][2]
        	end
        	x = tonumber(round(x / #result[i]))
        	y = tonumber(round(y / #result[i]))
        	table.insert(array_group[i], 1, x)
        	table.insert(array_group[i], 2, y)
    	end
    	for i = 1, #count do
    	local z = 0
        	for j = 1, #count[i] do
           	 z = z + count[i][j]
        	end
        	table.insert(array_group[i], 3, z)
        	for j = 1, #find.color do
            	table.insert(array_group[i], j + 3, count[i][j])
        	end
    	end

	if #array_group > 0 then
    		return array_group 
	end
	return nil	
end
		
	local rgb, find_col = {}, {}
	local rgb = func_deviation(find.color, find.deviation)	
	local pixel, find_col = find_color(rgb)
	if pixel > 0 then
		local find_g = find_group(rgb)
                if find_g then
			return pixel, find_g
		else
			return pixel, nil
		end
	end
	return 0, nil
end