.data

HotKeyTable db VK_BACK,"Backspace",0
db VK_TAB,"Tab",0
db VK_RETURN,"Enter",0
db VK_ESCAPE,"Esc",0
db VK_SPACE,"Space",0
db VK_INSERT,"Insert",0
db VK_DELETE,"Delete",0

db VK_PRIOR,"Page Up",0
db VK_NEXT,"Page Down",0
db VK_END,"End",0
db VK_HOME,"Home",0
db VK_LEFT,"Left arrow",0
db VK_RIGHT,"Right arrow",0
db VK_UP,"Up arrow",0
db VK_DOWN,"Down arrow",0
db VK_SELECT,"Select",0
db VK_SNAPSHOT,"Print screen",0

db VK_0,"0",0
db VK_1,"1",0
db VK_2,"2",0
db VK_3,"3",0
db VK_4,"4",0
db VK_5,"5",0
db VK_6,"6",0
db VK_7,"7",0
db VK_8,"8",0
db VK_9,"9",0

db VK_NUMPAD0,"Num 0",0
db VK_NUMPAD1,"Num 1",0
db VK_NUMPAD2,"Num 2",0
db VK_NUMPAD3,"Num 3",0
db VK_NUMPAD4,"Num 4",0
db VK_NUMPAD5,"Num 5",0
db VK_NUMPAD6,"Num 6",0
db VK_NUMPAD7,"Num 7",0
db VK_NUMPAD8,"Num 8",0
db VK_NUMPAD9,"Num 9",0

db VK_A,"A",0
db VK_B,"B",0
db VK_C,"C",0
db VK_D,"D",0
db VK_E,"E",0
db VK_F,"F",0
db VK_G,"G",0
db VK_H,"H",0
db VK_I,"I",0
db VK_J,"J",0
db VK_K,"K",0
db VK_L,"L",0
db VK_M,"M",0
db VK_N,"N",0
db VK_O,"O",0
db VK_P,"P",0
db VK_Q,"Q",0
db VK_R,"R",0
db VK_S,"S",0
db VK_T,"T",0
db VK_U,"U",0
db VK_V,"V",0
db VK_W,"W",0
db VK_X,"X",0
db VK_Y,"Y",0
db VK_Z,"Z",0

db VK_F1,"F1",0
db VK_F2,"F2",0
db VK_F3,"F3",0
db VK_F4,"F4",0
db VK_F5,"F5",0
db VK_F6,"F6",0
db VK_F7,"F7",0
db VK_F8,"F8",0
db VK_F9,"F9",0
db VK_F10,"F10",0
db VK_F11,"F11",0
db VK_F12,"F12",0

db 0 ;  

.code

Register_HotKey proc wnd:HWND, id:DWORD, hotkey:PTR
    mov ecx,hotkey
assume ecx:PTR HotKeyDescr
    push [ecx].HotKey
    push [ecx].Modifiers
    push id
    push wnd
    call RegisterHotKey
assume ecx:nothing
    ret
Register_HotKey endp

ReRegister_HotKey proc wnd:HWND, id:DWORD, hotkey:PTR
    invoke UnregisterHotKey,wnd,id
    invoke Register_HotKey,wnd,id,hotkey
    ret
ReRegister_HotKey endp


RegStoreHotKey proc val_name:PTR, hotkey:PTR
LOCAL res:DWORD
    invoke RegCreateKey,HKEY_CURRENT_USER,ADDR szInqSoftSB,ADDR res
    .if eax==ERROR_SUCCESS
        invoke RegSetValueEx,res,val_name,0,REG_BINARY,hotkey,8
        invoke RegCloseKey,res
    .endif
    ret
RegStoreHotKey endp

RegReadHotKey proc val_name:PTR, hotkey:PTR
LOCAL res:DWORD, sz:DWORD
    invoke RegOpenKey,HKEY_CURRENT_USER,ADDR szInqSoftSB,ADDR res
    .if eax==ERROR_SUCCESS
        mov sz,SIZEOF HotKeyDescr
        invoke RegQueryValueEx,res,val_name,0,NULL,hotkey,ADDR sz
        invoke RegCloseKey,res
    .endif
    ret

RegReadHotKey endp

GetHotKey proc hk:PTR, wnd:HWND, ctrl_id:DWORD, alt_id:DWORD, shift_id:DWORD, win_id:DWORD, combo_id:DWORD
LOCAL modifier:DWORD,    
      hotkey:DWORD
    invoke IsDlgButtonChecked,wnd,ctrl_id
    .if eax
        mov modifier,MOD_CONTROL
    .else
        mov modifier,0
    .endif
    invoke IsDlgButtonChecked,wnd,alt_id
    .if eax
        or modifier,MOD_ALT
    .endif
    invoke IsDlgButtonChecked,wnd,shift_id
    .if eax
        or modifier,MOD_SHIFT
    .endif
    invoke IsDlgButtonChecked,wnd,win_id
    .if eax
        or modifier,MOD_WIN
    .endif
    
    invoke SendDlgItemMessage,wnd,combo_id,CB_GETCURSEL,0,0
    .if eax==CB_ERR
        mov hotkey,0
    .else
        mov hotkey,eax
        mov ecx,OFFSET HotKeyTable
_loop:
        .if hotkey==0
         movzx eax,byte ptr [ecx]
         mov hotkey,eax
         jmp _exit
        .else
         push ecx
         invoke lstrlen,ecx
         pop ecx
         add ecx,eax
         inc ecx
         dec hotkey
         jmp _loop
        .endif
    .endif
    
_exit:
    mov ecx,hk
assume ecx:PTR HotKeyDescr
    push modifier
    pop [ecx].Modifiers
    push hotkey
    pop [ecx].HotKey
assume ecx:nothing    
    
    ret

GetHotKey endp

FillHotKeyCombo proc wnd:HWND, combo_id:DWORD
    mov ecx,OFFSET HotKeyTable
    .while byte ptr [ecx]    
     inc ecx
     push ecx
     push ecx
     invoke SendDlgItemMessage,wnd,combo_id,CB_ADDSTRING,0,ecx
     pop ecx
     invoke lstrlen,ecx
     inc eax
     pop ecx
     add ecx,eax
    .endw
    ret
FillHotKeyCombo endp

IsHKMod proc hk:DWORD, hkmod:DWORD, wnd:HWND, cb_id:DWORD
    
    mov eax,hk
    and eax,hkmod
    .if eax
        mov eax,1        
    .endif
    invoke CheckDlgButton,wnd,cb_id,eax
    ret

IsHKMod endp

ShowHotKey proc hkd:PTR HotKeyDescr, wnd:HWND, ctrl_id:DWORD, alt_id:DWORD, shift_id:DWORD, win_id:DWORD, combo_id:DWORD
LOCAL mods:DWORD,
      key:BYTE,
      counter:DWORD

    mov ecx, hkd
assume ecx:PTR HotKeyDescr
    push [ecx].Modifiers
assume ecx:nothing
    pop mods
    invoke IsHKMod,mods,MOD_CONTROL,wnd,ctrl_id
    invoke IsHKMod,mods,MOD_ALT,wnd,alt_id
    invoke IsHKMod,mods,MOD_SHIFT,wnd,shift_id
    invoke IsHKMod,mods,MOD_WIN,wnd,win_id
    
    mov ecx,hkd
assume ecx:PTR HotKeyDescr
    mov eax,[ecx].HotKey
assume ecx:nothing

    mov key,al
    mov ecx,OFFSET HotKeyTable
    mov counter,0
    
_loop:
    mov al,byte ptr [ecx]
    .if al==0
     jmp _not_found
    .elseif al==key
     mov eax,counter
     jmp _ex_from_loop
    .endif
    inc ecx
    push ecx
    invoke lstrlen,ecx
    pop ecx
    add ecx,eax
    inc ecx
    inc counter
    jmp _loop
    
_not_found:
    mov eax,-1
_ex_from_loop:    
    invoke SendDlgItemMessage,wnd,combo_id,CB_SETCURSEL,eax,0
    ret

ShowHotKey endp
