unit LuaFuncImpl;

interface

uses lua, lauxlib, lualib;

  function forLua_MultAllNumbers(L: Plua_State): Integer; cdecl;
  function forLua_GetHostAppPath(L: Plua_State): Integer; cdecl;

implementation

uses Windows, SysUtils;

function forLua_MultAllNumbers(L: Plua_State): Integer; cdecl;
var
    n,i: Integer;
    res: Double;
    isNumberFound: Boolean;
begin
    n := lua_gettop(L);  //   
    res := 1;
    isNumberFound := false;
    for i := 1 to n do
      begin
        if lua_type(L,i) = LUA_TNUMBER then
          begin
            res := res * lua_tonumber(L,i);
            isNumberFound := true;
          end;
      end;

    if isNumberFound then
        lua_pushnumber(L, res)  //        -  
    else
        lua_pushnil(L);         //            -   nil

    Result := 1;  //   
end;

function forLua_GetHostAppPath(L: Plua_State): Integer; cdecl;
var
    ModuleName: array[0..255] of Char;
begin
    if GetModuleFileName(0, ModuleName, sizeof(ModuleName)) <> 0 then
        lua_pushstring(L, PChar(ExtractFilePath(ModuleName)))
    else
        lua_pushnil(L);  //    nil

    Result := 1;
end;

end.

