setfenv(1, require'winapi')

local ffi = require("ffi")
ffi.cdef[[
int WideCharToMultiByte(UINT CodePage, DWORD dwFlags, LPCWSTR lpWideCharStr, int cchWideChar,
LPSTR lpMultiByteStr, int cbMultiByte, LPCSTR lpDefaultChar, LPBOOL lpUsedDefaultChar);
int MultiByteToWideChar(UINT CodePage, DWORD dwFlags, LPCSTR lpMultiByteStr, int cbMultiByte,
LPWSTR lpWideCharStr, int cchWideChar);
]]
local CP_ACP = 0
local CP_UTF8 = 65001

function utf16_to_ansi(s)
    local sz = C.WideCharToMultiByte(CP_UTF8, 0, s, -1, nil, 0, nil, nil)  -- узнать какого размера нужен массив
    local ctype = ffi.typeof'CHAR[?]'
    local buf = ctype(sz)
    C.WideCharToMultiByte(CP_ACP, 0, s, -1, buf, sz, nil, nil)  -- из utf16 в ansi
    return ffi.string(buf)
end


function utf8_to_ansi(s)
    local sz = #s + 1
    local ctype = ffi.typeof'WCHAR[?]'
    local buf = ctype(sz)
    if s:byte(1) == 239 and s:byte(2) == 187 and s:byte(3) == 191 then   -- если есть метка BOM
        s=s:sub(4)  --  передаём текст без метки
        C.MultiByteToWideChar(CP_UTF8, 0, s, #s, buf, sz)
    else
        C.MultiByteToWideChar(CP_UTF8, 0, s, #s, buf, sz)
    end
    return utf16_to_ansi(buf)
end

function is_utf (path_to_file)
    local f = io.open(path_to_file, "rb")  -- открыть файл
    if f then   -- если открылся
        local s = f:read("*a") 
		f:close()
        if s:byte(1) == 239 and s:byte(2) == 187 and s:byte(3) == 191  then return 1 end   -- если есть bom uft8
        -- поиск русских символов в юникоде
        for i = 144, 191 do 
			if string.match(table.concat({s:byte(1, #s)}, ' '), "208 " .. tostring(i)) then return 1 end 
		end
        for i = 128, 143 do
            if string.match(table.concat({s:byte(1, #s)}, ' '), "209 " .. tostring(i)) then return 1 end
        end
        return 0
    end
    return false
end

function readfile(path_to_file)
    local f = io.open(path_to_file, "rb")  -- открыть файл для чтения
    if f then
        local s = f:read("*a")     -- прочитать весь файл 
        f:close()  -- закрыть файл

        if is_utf(path_to_file) == 1 then  -- если файл uft8 
            return utf8_to_ansi(s)
        end
        return s
    end
    return nil
end