DELAY_KEY = 20  --    
DELAY_MOUSE = 20  --       
COM = 5     --  

MOUSE_LEFT = 1
MOUSE_RIGHT = 2
MOUSE_MIDDLE = 4

KEY_LEFT_CTRL = 0x80
KEY_LEFT_SHIFT = 0x81
KEY_LEFT_ALT = 0x82
KEY_LEFT_GUI = 0x83
KEY_RIGHT_CTRL = 0x84
KEY_RIGHT_SHIFT = 0x85
KEY_RIGHT_ALT = 0x86
KEY_RIGHT_GUI = 0x87
KEY_UP_ARROW = 0xDA
KEY_DOWN_ARROW = 0xD9
KEY_LEFT_ARROW = 0xD8
KEY_RIGHT_ARROW = 0xD7
KEY_BACKSPACE = 0xB2
KEY_TAB = 0xB3
KEY_RETURN = 0xB0
KEY_ESC = 0xB1
KEY_INSERT = 0xD1
KEY_DELETE = 0xD4
KEY_PAGE_UP = 0xD3
KEY_PAGE_DOWN = 0xD6
KEY_HOME = 0xD2
KEY_END = 0xD5
KEY_CAPS_LOCK = 0xC1
KEY_F1 = 0xC2
KEY_F2 = 0xC3
KEY_F3 = 0xC4
KEY_F4 = 0xC5
KEY_F5 = 0xC6
KEY_F6 = 0xC7
KEY_F7 = 0xC8
KEY_F8 = 0xC9
KEY_F9 = 0xCA
KEY_F10 = 0xCB
KEY_F11 = 0xCC
KEY_F12 = 0xCD


function command (text)
    local file = io.open("COM" .. tostring(COM),"w")
    if file then
        file:write(text)
        file:close()
        wait(#text * (DELAY_KEY + DELAY_KEY * 0.2))    --   *  + 20%
    else
	log('  ,  ')
	end_script()
    end
end


function delaykey(ms)
    if type(tonumber(ms)) ~= 'number' then return end
    command ('00' .. tostring(ms))
    DELAY_KEY = ms
end

function delaymouse(ms)
    if type(tonumber(ms)) ~= 'number' then return end
    command ('01' .. tostring(ms))
    DELAY_MOUSE = ms
end

function key (code)
     if type(code) == 'number' then command ('1' .. tostring(tonumber(code)))
     else command ('1' .. tostring(code:byte()))
     end
end


function text (text)
     command ('2' .. text)
end


function keydown (code)
     if type(code) == 'number' then command ('3' .. tostring(tonumber(code)))
     else command ('3' .. tostring(code:byte()))
     end
end

function keyup (code)
     if type(code) == 'number' then command ('4' .. tostring(tonumber(code)))
     else command ('4' .. tostring(code:byte()))
     end
end

function mousemove (x, y)
    local mouseX, mouseY = mouse_pos('abs')
    local znakX, znakY = '+', '+'
    if mouseX - x > 0 then znakX = '-' end
    if mouseY - y > 0 then znakY = '-' end
    command ('5' .. znakX .. znakY .. tostring(math.abs(mouseX - x) * 0xFFFF + math.abs(mouseY - y)))
end


function mouse (x, y, button)
    if button == nil then button = MOUSE_LEFT end
    mousemove(x, y)
    command ('6' .. tostring(button))
end

function mousedbl (x, y, button)
    if button == nil then button = MOUSE_LEFT end
    mousemove(x, y)
    command ('6' .. tostring(button))
    wait(100)
    command ('6' .. tostring(button))
end

function mousedown (x, y, button)
    if button == nil then button = MOUSE_LEFT end
    mousemove(x, y)
    command ('7' .. tostring(button))
end


function mouseup (x, y, button)
    if button == nil then button = MOUSE_LEFT end
    command ('8' .. tostring(button))
end