local export_array = {}

export_array.com = 5          --  
export_array.delay_key = 20   --    .  ,   set_delay_key.
export_array.delay_mouse = 20 --       .  ,   set_delay_mouse.

export_array.mouse_left_button = 1
export_array.mouse_right_button = 2
export_array.mouse_middle_button = 4

export_array.left_ctrl = 0x80
export_array.left_shift = 0x81
export_array.left_alt = 0x82
export_array.left_gui = 0x83
export_array.right_ctrl = 0x84
export_array.right_shift = 0x85
export_array.right_alt = 0x86
export_array.right_gui = 0x87
export_array.up_arrow = 0xDA
export_array.down_arrow = 0xD9
export_array.left_arrow = 0xD8
export_array.right_arrow = 0xD7
export_array.backspace = 0xB2
export_array.tab = 0xB3
export_array.enter = 0xB0
export_array.esc = 0xB1
export_array.insert = 0xD1
export_array.delete = 0xD4
export_array.page_up = 0xD3
export_array.page_down = 0xD6
export_array.home = 0xD2
export_array["end"] = 0xD5
export_array.caps_lock = 0xC1
export_array.f1 = 0xC2
export_array.f2 = 0xC3
export_array.f3 = 0xC4
export_array.f4 = 0xC5
export_array.f5 = 0xC6
export_array.f6 = 0xC7
export_array.f7 = 0xC8
export_array.f8 = 0xC9
export_array.f9 = 0xCA
export_array.f10 = 0xCB
export_array.f11 = 0xCC
export_array.f12 = 0xCD
export_array.F1 = 0xC2
export_array.F2 = 0xC3
export_array.F3 = 0xC4
export_array.F4 = 0xC5
export_array.F5 = 0xC6
export_array.F6 = 0xC7
export_array.F7 = 0xC8
export_array.F8 = 0xC9
export_array.F9 = 0xCA
export_array.F10 = 0xCB
export_array.F11 = 0xCC
export_array.F12 = 0xCD

local command = function (text)  
    local file = io.open("COM" .. tostring(export_array.com),"w")
    if file then
        file:write(text)
        file:close()
        
        -- ,    
        local action = text:match('.') 
        if tonumber(action) == 0 then wait (5) return end  --  
        if tonumber(action) > 0 and tonumber(action) < 5 then 
            wait(math.floor(#text * (export_array.delay_key + export_array.delay_key* 0.2)))    --  ,   *  + 20%
            return
        end
        wait(math.floor(export_array.delay_mouse + export_array.delay_mouse* 0.2))    --    
    else
    	log('  ,  ')
    	end_script()
    end
end


export_array.set_delay_key = function (ms)
    if type(tonumber(ms)) ~= 'number' then return end
    command ('00' .. tostring(ms))
    export_array.delay_key = ms
end

export_array.set_delay_mouse = function (ms)
    if type(tonumber(ms)) ~= 'number' then return end
    command ('01' .. tostring(ms))
    export_array.delay_mouse = ms
end

export_array.key = function (code)
     if type(code) == 'number' then command ('1' .. tostring(tonumber(code)))
     else command ('1' .. tostring(code:byte()))
     end
end


export_array.text = function (text)
    if #text > 59 then
        for i=1, #text, 60 do
            command ('2' .. text:sub(i, i+59))
        end
    else
        command ('2' .. text)
    end
end


export_array.key_down = function (code)
     if type(code) == 'number' then command ('3' .. tostring(tonumber(code)))
     else command ('3' .. tostring(code:byte()))
     end
end

export_array.key_up = function (code)
     if type(code) == 'number' then command ('4' .. tostring(tonumber(code)))
     else command ('4' .. tostring(code:byte()))
     end
end



export_array.mouse = {}


export_array.mouse.move = function (x, y)
    local mouseX, mouseY = mouse_pos('abs')
    local znakX, znakY = '+', '+'
    if mouseX - x > 0 then znakX = '-' end
    if mouseY - y > 0 then znakY = '-' end
    command ('5' .. znakX .. znakY .. tostring(math.abs(mouseX - x) * 0xFFFF + math.abs(mouseY - y)))
end


export_array.mouse.click = function (x, y, button)
    if button == nil then button = export_array.mouse_left_button end
    export_array.mouse.move(x, y)
    command ('6' .. tostring(button))
end

export_array.mouse.left = function (x, y)
    export_array.mouse.move(x, y)
    command ('6' .. tostring(export_array.mouse_left_button))
end

export_array.mouse.right = function (x, y)
    export_array.mouse.move(x, y)
    command ('6' .. tostring(export_array.mouse_right_button))
end

export_array.mouse.middle = function (x, y)
    export_array.mouse.move(x, y)
    command ('6' .. tostring(export_array.mouse_middle_button))
end



export_array.mouse.dbl = function (x, y, button)
    if button == nil then button = export_array.mouse_left_button end
    export_array.mouse.move(x, y)
    command ('6' .. tostring(button))
    command ('6' .. tostring(button))
end

export_array.mouse.left_dbl = function (x, y)
    export_array.mouse.move(x, y)
    command ('6' .. tostring(export_array.mouse_left_button))
    command ('6' .. tostring(export_array.mouse_left_button))
end

export_array.mouse.right_dbl = function (x, y)
    export_array.mouse.move(x, y)
    command ('6' .. tostring(export_array.mouse_right_button))
    command ('6' .. tostring(export_array.mouse_right_button))
end

export_array.mouse.middle_dbl = function (x, y)
    export_array.mouse.move(x, y)
    command ('6' .. tostring(export_array.mouse_middle_button))
    command ('6' .. tostring(export_array.mouse_middle_button))
end



export_array.mouse.down = function (x, y, button)
    if button == nil then button = export_array.mouse_left_button end
    export_array.mouse.move(x, y)
    command ('7' .. tostring(button))
end

export_array.mouse.left_down = function (x, y)
    export_array.mouse.move(x, y)
    command ('7' .. tostring(export_array.mouse_left_button))
end

export_array.mouse.right_down = function (x, y)
    export_array.mouse.move(x, y)
    command ('7' .. tostring(export_array.mouse_right_button))
end

export_array.mouse.middle_down = function (x, y)
    export_array.mouse.move(x, y)
    command ('7' .. tostring(export_array.mouse_middle_button))
end



export_array.mouse.up = function (x, y, button)
    if button == nil then button = export_array.mouse_left_button end
    export_array.mouse.move(x, y)
    command ('8' .. tostring(button))
end

export_array.mouse.left_up = function (x, y)
    export_array.mouse.move(x, y)
    command ('8' .. tostring(export_array.mouse_left_button))
end

export_array.mouse.right_up = function (x, y)
    export_array.mouse.move(x, y)
    command ('8' .. tostring(export_array.mouse_right_button))
end

export_array.mouse.middle_up = function (x, y)
    export_array.mouse.move(x, y)
    command ('8' .. tostring(export_array.mouse_middle_button))
end

export_array.mouse.drag = function (x, y, x2, y2)
    export_array.mouse.move(x, y)
    export_array.mouse.left_down(x, y)
    export_array.mouse.move(x2, y2)
    export_array.mouse.left_up(x2, y2)
end

export_array.mouse.wheel = function (x, y, wheel)
    if wheel == nil then wheel = -1 end
    export_array.mouse.move(x, y)
    command ('9' .. tostring(wheel))
end

return export_array