local export_array = {}

local ffi = require("ffi")
require'types'

local WM_CREATE = 0x0001
local WM_CLOSE = 0x0010
local WS_CHILD = 0x40000000
local WS_BORDER = 0x00800000
local WM_COMMAND = 0x0111
local WS_CAPTION = 0x00C00000
local WS_SYSMENU = 0x00080000
local WS_EX_DLGMODALFRAME = 0x00000001
local WS_EX_TOPMOST = 0x00000008
local COLOR_WINDOW = 5
local IDC_ARROW = 32512
local WS_VISIBLE = 0x10000000
local BS_AUTORADIOBUTTON = 0x00000009
local BS_AUTOCHECKBOX	= 0x0003
local WM_SETFONT = 48
local RUSSIAN_CHARSET = 204
local SWP_NOMOVE = 0x0002
local SWP_NOZORDER = 0x0004
local ES_AUTOHSCROLL = 0x0080
local BM_GETCHECK = 0x00F0 

ffi.cdef[[
typedef struct {
  UINT      style;
  WNDPROC   lpfnWndProc;
  int       cbClsExtra;
  int       cbWndExtra;
  HINSTANCE hInstance;
  HICON     hIcon;
  HCURSOR   hCursor;
  HBRUSH    hbrBackground;
  LPCSTR    lpszMenuName;
  LPCSTR    lpszClassName;
} WNDCLASSA, *PWNDCLASSA, *NPWNDCLASSA, *LPWNDCLASSA;

typedef struct {
  HWND   hwnd;
  UINT   message;
  WPARAM wParam;
  LPARAM lParam;
  DWORD  time;
  POINT  pt;
  DWORD  lPrivate;
} MSG, *PMSG, *NPMSG, *LPMSG;

typedef struct {
  DWORD cbSize;
  RECT  rcWindow;
  RECT  rcClient;
  DWORD dwStyle;
  DWORD dwExStyle;
  DWORD dwWindowStatus;
  UINT  cxWindowBorders;
  UINT  cyWindowBorders;
  ATOM  atomWindowType;
  WORD  wCreatorVersion;
} WINDOWINFO, *PWINDOWINFO, *LPWINDOWINFO;

HCURSOR LoadCursorA(
  HINSTANCE hInstance,
  LPCSTR    lpCursorName
);

ATOM RegisterClassA(
  const WNDCLASSA *lpWndClass
);

BOOL UnregisterClassA(
  LPCSTR    lpClassName,
  HINSTANCE hInstance
);

HWND CreateWindowExA(
  DWORD     dwExStyle,
  LPCSTR    lpClassName,
  LPCSTR    lpWindowName,
  DWORD     dwStyle,
  int       X,
  int       Y,
  int       nWidth,
  int       nHeight,
  HWND      hWndParent,
  HMENU     hMenu,
  HINSTANCE hInstance,
  LPVOID    lpParam
);

BOOL DestroyWindow(
  HWND hWnd
);

 LRESULT DefWindowProcA(
     HWND hWnd,
     UINT Msg,
     WPARAM wParam,
     LPARAM lParam);

BOOL PeekMessageA(
  LPMSG lpMsg,
  HWND  hWnd,
  UINT  wMsgFilterMin,
  UINT  wMsgFilterMax,
  UINT  wRemoveMsg
);

BOOL GetMessageA(
  LPMSG lpMsg,
  HWND  hWnd,
  UINT  wMsgFilterMin,
  UINT  wMsgFilterMax
);

BOOL TranslateMessage(
  const MSG *lpMsg
);


LRESULT DispatchMessageA(
  const MSG *lpMsg
);

void PostQuitMessage(
  int nExitCode
);


LRESULT SendMessageA(
  HWND   hWnd,
  UINT   Msg,
  WPARAM wParam,
  LPARAM lParam
);

HFONT CreateFontA(
  int    cHeight,
  int    cWidth,
  int    cEscapement,
  int    cOrientation,
  int    cWeight,
  DWORD  bItalic,
  DWORD  bUnderline,
  DWORD  bStrikeOut,
  DWORD  iCharSet,
  DWORD  iOutPrecision,
  DWORD  iClipPrecision,
  DWORD  iQuality,
  DWORD  iPitchAndFamily,
  LPCSTR pszFaceName
);

BOOL GetTextExtentPoint32A(
  HDC    hdc,
  LPCSTR lpString,
  int    c,
  LPSIZE psizl
);

HDC GetDC(
  HWND hWnd
);

BOOL SetWindowPos(
  HWND hWnd,
  HWND hWndInsertAfter,
  int  X,
  int  Y,
  int  cx,
  int  cy,
  UINT uFlags
);

BOOL GetWindowInfo(
  HWND        hwnd,
  PWINDOWINFO pwi
);

BOOL DeleteObject(
  HGDIOBJ ho
);

int GetWindowTextA(
  HWND  hWnd,
  LPSTR lpString,
  int   nMaxCount
);

int GetWindowTextLengthA(
  HWND hWnd
);
]]


export_array.promptposX = 0
export_array.promptposY = 0


local main_window 
local font_check
local flag_autocheck = 0
local check = {} 
local check_array = {} 
local check_array_state = {}
local edit = 0 
local text_edit = ''
local buttonOK = 0
local buttonOK_array = 0



local function WindowProc(hWnd, message, wParam, lParam)
    if message == WM_CREATE then
        font_check = ffi.C.CreateFontA(-12, 0, 0, 0, 500, 0, 0, 0, RUSSIAN_CHARSET, 0, 0, 0, 0, "Arial")
    end

    if message == WM_CLOSE then
        ffi.C.DeleteObject(font_check) 
        ffi.C.PostQuitMessage(0)
    end

    if message == WM_COMMAND then
		if ffi.cast('HWND', lParam) == buttonOK then
			local len_text_edit = ffi.C.GetWindowTextLengthA(edit)
			local buffer = ffi.new('char[?]', len_text_edit+1)
			ffi.C.GetWindowTextA(edit, buffer, ffi.sizeof(buffer))
			text_edit = ffi.string(buffer)
			ffi.C.SendMessageA(hWnd, WM_CLOSE, 0, 0)
		end
		
		if ffi.cast('HWND', lParam) == buttonOK_array then
			for i=1, #check_array do 
				check_array_state[i] = ffi.C.SendMessageA(check_array[i], BM_GETCHECK, 0, 0)
			end
			ffi.C.SendMessageA(hWnd, WM_CLOSE, 0, 0)
		end
		
		
		
        for i=1, #check do
            if ffi.cast('HWND', lParam) == check[i] then
                flag_autocheck = i
				ffi.C.SendMessageA(hWnd, WM_CLOSE, 0, 0)
            end
        end
        
		

    end
    return ffi.C.DefWindowProcA(hWnd, message, wParam, lParam)
end




local function create_check(check_name)
	
    check = {}
    local posX, posY = 10, 10
    local width = 0
    local sizl = ffi.new('SIZE', {0, 0})

    local wi = ffi.new('WINDOWINFO', {ffi.sizeof('WINDOWINFO')})
    ffi.C.GetWindowInfo(main_window, wi)
    local header_width, header_height = wi.rcClient.left - wi.rcWindow.left, wi.rcClient.top - wi.rcWindow.top

	local count 
	if (type(check_name[1]) == 'string') then
		count = #check_name
	else
		count = #check_name[1]
	end

    for i = 1, count do
		if (type(check_name[1]) == 'string') then
			check[#check+1] = ffi.C.CreateWindowExA(0, 'BUTTON', check_name[i], BS_AUTORADIOBUTTON + WS_CHILD + WS_VISIBLE,
				posX, posY+(i-1)*20, 80, 20, main_window, ffi.cast('HMENU', 0), ffi.cast('HINSTANCE', 0), ffi.cast('LPVOID', 0))
		else
			check[#check+1] = ffi.C.CreateWindowExA(0, 'BUTTON', check_name[1][i], BS_AUTORADIOBUTTON + WS_CHILD + WS_VISIBLE,
				posX, posY+(i-1)*20, 80, 20, main_window, ffi.cast('HMENU', 0), ffi.cast('HINSTANCE', 0), ffi.cast('LPVOID', 0))
		end	
			
        ffi.C.SendMessageA(check[i], WM_SETFONT, ffi.cast('WPARAM', font_check), 0)

        local HDC = ffi.C.GetDC(check[i])
		
		if (type(check_name[1]) == 'string') then
			ffi.C.GetTextExtentPoint32A(HDC, check_name[i], #check_name[i], sizl)
		else 
			ffi.C.GetTextExtentPoint32A(HDC, check_name[1][i], #check_name[1][i], sizl)
		end
        if sizl.cx > width then
            width = sizl.cx
        end
        ffi.C.SetWindowPos(check[i], nil, 0, 0, width + 20, 20, SWP_NOMOVE + SWP_NOZORDER)
    end
	
	ffi.C.SetWindowPos(main_window, nil, 0, 0, width + header_width + 30, (count + 1) * 20 + header_height, SWP_NOMOVE + SWP_NOZORDER)
end



local function create_check_array(check_name)
	
    check_array = {}
	check_array_state = {}
    local posX, posY = 10, 10
    local width = 0
    local sizl = ffi.new('SIZE', {0, 0})

    local wi = ffi.new('WINDOWINFO', {ffi.sizeof('WINDOWINFO')})
    ffi.C.GetWindowInfo(main_window, wi)
    local header_width, header_height = wi.rcClient.left - wi.rcWindow.left, wi.rcClient.top - wi.rcWindow.top

	local count 
	if (type(check_name[1]) == 'string') then
		count = #check_name
	else
		count = #check_name[1]
	end

    for i = 1, count do
		if (type(check_name[1]) == 'string') then
			check_array[#check_array+1] = ffi.C.CreateWindowExA(0, 'BUTTON', check_name[i], WS_CHILD + WS_VISIBLE + BS_AUTOCHECKBOX,
				posX, posY+(i-1)*20, 80, 20, main_window, ffi.cast('HMENU', 0), ffi.cast('HINSTANCE', 0), ffi.cast('LPVOID', 0))
		else
			check_array[#check_array+1] = ffi.C.CreateWindowExA(0, 'BUTTON', check_name[1][i], WS_CHILD + WS_VISIBLE + BS_AUTOCHECKBOX,
				posX, posY+(i-1)*20, 80, 20, main_window, ffi.cast('HMENU', 0), ffi.cast('HINSTANCE', 0), ffi.cast('LPVOID', 0))
		end	
			
        ffi.C.SendMessageA(check_array[i], WM_SETFONT, ffi.cast('WPARAM', font_check), 0)

        local HDC = ffi.C.GetDC(check_array[i])
		
		if (type(check_name[1]) == 'string') then
			ffi.C.GetTextExtentPoint32A(HDC, check_name[i], #check_name[i], sizl)
		else 
			ffi.C.GetTextExtentPoint32A(HDC, check_name[1][i], #check_name[1][i], sizl)
		end
        if sizl.cx > width then
            width = sizl.cx
        end
        ffi.C.SetWindowPos(check_array[i], nil, 0, 0, width + 20, 20, SWP_NOMOVE + SWP_NOZORDER)
    end
	
	buttonOK_array = ffi.C.CreateWindowExA(0, 'BUTTON', 'Ok', WS_CHILD + WS_VISIBLE, (width + header_width + 40) / 2, (count + 1) * 20, 40, 20, main_window, ffi.cast('HMENU', 0), ffi.cast('HINSTANCE', 0), ffi.cast('LPVOID', 0))
	
	ffi.C.SetWindowPos(main_window, nil, 0, 0, width + header_width + 30, (count + 1) * 20 + header_height + 30, SWP_NOMOVE + SWP_NOZORDER)
end





export_array.lua_prompt = function (...)
	local window_class = 'prompt'
    local wcWindowClass = ffi.new('WNDCLASSA', 0)
	wcWindowClass.lpfnWndProc = WindowProc   
	wcWindowClass.lpszClassName = window_class       
	wcWindowClass.hCursor = ffi.C.LoadCursorA(ffi.cast('HINSTANCE', NULL), ffi.cast('LPCSTR', IDC_ARROW))   
	wcWindowClass.hbrBackground = ffi.cast('HBRUSH', COLOR_WINDOW)
	ffi.C.RegisterClassA(wcWindowClass)
	main_window = ffi.C.CreateWindowExA(WS_EX_TOPMOST + WS_EX_DLGMODALFRAME, window_class, 'UoPilot prompt', WS_CAPTION + WS_SYSMENU + WS_VISIBLE, export_array.promptposX, export_array.promptposY, 0, 0,
	ffi.cast('HWND', 0),
	ffi.cast('HMENU', 0),
	ffi.cast('HINSTANCE', 0),
	ffi.cast('LPVOID', 0))
	
	
	local arg={...}
    create_check(arg)

    

    local message = ffi.new('MSG') 
    repeat
        local bRet = ffi.C.GetMessageA(message, NULL, 0, 0)
        if bRet == -1 then break end
        ffi.C.TranslateMessage(message)
        ffi.C.DispatchMessageA(message)
    until bRet == 0
	
	
    ffi.C.DestroyWindow(main_window)
    ffi.C.UnregisterClassA(window_class, ffi.cast('HINSTANCE', 0))
    return flag_autocheck
end


export_array.lua_prompt_edit = function ()
	local window_class = 'prompt'
    local wcWindowClass = ffi.new('WNDCLASSA', 0)
	wcWindowClass.lpfnWndProc = WindowProc   
	wcWindowClass.lpszClassName = window_class       
	wcWindowClass.hCursor = ffi.C.LoadCursorA(ffi.cast('HINSTANCE', NULL), ffi.cast('LPCSTR', IDC_ARROW))   
	wcWindowClass.hbrBackground = ffi.cast('HBRUSH', COLOR_WINDOW)
	ffi.C.RegisterClassA(wcWindowClass)
	main_window = ffi.C.CreateWindowExA(WS_EX_TOPMOST + WS_EX_DLGMODALFRAME, window_class, 'UoPilot prompt', WS_CAPTION + WS_SYSMENU + WS_VISIBLE, export_array.promptposX, export_array.promptposY, 0, 0,
	ffi.cast('HWND', 0),
	ffi.cast('HMENU', 0),
	ffi.cast('HINSTANCE', 0),
	ffi.cast('LPVOID', 0))
	

	local wi = ffi.new('WINDOWINFO', {ffi.sizeof('WINDOWINFO')})
    ffi.C.GetWindowInfo(main_window, wi)
    local header_width, header_height = wi.rcClient.left - wi.rcWindow.left, wi.rcClient.top - wi.rcWindow.top
	
	edit = ffi.C.CreateWindowExA(0, 'EDIT', '', WS_CHILD + WS_VISIBLE + WS_BORDER + ES_AUTOHSCROLL, 10, 20, 175, 20, main_window, ffi.cast('HMENU', 0), ffi.cast('HINSTANCE', 0), ffi.cast('LPVOID', 0))
	buttonOK = ffi.C.CreateWindowExA(0, 'BUTTON', 'Ok', WS_CHILD + WS_VISIBLE, 100, 50, 40, 20, main_window, ffi.cast('HMENU', 0), ffi.cast('HINSTANCE', 0), ffi.cast('LPVOID', 0))
	ffi.C.SetWindowPos(main_window, nil, 0, 0, header_width + 200, header_height + 80, SWP_NOMOVE + SWP_NOZORDER)

	
    local message = ffi.new('MSG') 
    repeat
        local bRet = ffi.C.GetMessageA(message, NULL, 0, 0)
        if bRet == -1 then break end
        ffi.C.TranslateMessage(message)
        ffi.C.DispatchMessageA(message)
    until bRet == 0

    ffi.C.DestroyWindow(main_window)
    ffi.C.UnregisterClassA(window_class, ffi.cast('HINSTANCE', 0))
    return text_edit
end


export_array.lua_prompt_check = function (...)
	local window_class = 'prompt'
    local wcWindowClass = ffi.new('WNDCLASSA', 0)
	wcWindowClass.lpfnWndProc = WindowProc   
	wcWindowClass.lpszClassName = window_class       
	wcWindowClass.hCursor = ffi.C.LoadCursorA(ffi.cast('HINSTANCE', NULL), ffi.cast('LPCSTR', IDC_ARROW))   
	wcWindowClass.hbrBackground = ffi.cast('HBRUSH', COLOR_WINDOW)
	ffi.C.RegisterClassA(wcWindowClass)
	main_window = ffi.C.CreateWindowExA(WS_EX_TOPMOST + WS_EX_DLGMODALFRAME, window_class, 'UoPilot prompt', WS_CAPTION + WS_SYSMENU + WS_VISIBLE, export_array.promptposX, export_array.promptposY, 0, 0,
	ffi.cast('HWND', 0),
	ffi.cast('HMENU', 0),
	ffi.cast('HINSTANCE', 0),
	ffi.cast('LPVOID', 0))
	
	
	local arg={...}
    create_check_array(arg)

    

    local message = ffi.new('MSG') 
    repeat
        local bRet = ffi.C.GetMessageA(message, NULL, 0, 0)
        if bRet == -1 then break end
        ffi.C.TranslateMessage(message)
        ffi.C.DispatchMessageA(message)
    until bRet == 0
	
	
    ffi.C.DestroyWindow(main_window)
    ffi.C.UnregisterClassA(window_class, ffi.cast('HINSTANCE', 0))
    return check_array_state
end

return export_array