--lua
local gra={}
--======= !!    !! ============================================================================================================================================================
local maxWidth,maxHeight=1920,1080                                             --  +       : ; .
--/\             ,     
--==================================================================================================================================================================================================================
ffi=require "ffi"
new=ffi.new
local maxPix=maxWidth*maxHeight
CI={}
CI[0]=new("uint16_t["..maxPix.."][5]")
CI[1]=new('unsigned char[?]',maxPix*3+4)
CI[2]=new('unsigned char[?]',maxPix*3+4)

ffi.cdef[[
  typedef long LONG;
  typedef unsigned short WORD;
  typedef unsigned long DWORD;
  typedef unsigned char BYTE;
  typedef void *LPVOID; 
  typedef const void *LPCVOID;
  typedef DWORD *LPDWORD;
  #pragma pack (push, 1)
  typedef struct {WORD bfType;DWORD bfSize;WORD bfReserved1;WORD bfReserved2;DWORD bfOffBits;} BITMAPFILEHEADER;
  #pragma pack (pop)
  typedef struct {DWORD biSize; LONG  biWidth; LONG  biHeight; WORD  biPlanes; WORD  biBitCount; DWORD biCompression; DWORD biSizeImage;
        LONG  biXPelsPerMeter; LONG biYPelsPerMeter; DWORD biClrUsed; DWORD biClrImportant;} BITMAPINFOHEADER;
  
  int GetDC(int hWnd);                                                           //      (DC)          ( )
  int CreateCompatibleDC(int hdc);                                               //      (DC),     ( DC)
  int CreateCompatibleBitmap(int hdc,int nWidth,int nHeight);                    //   ,   ,       ( DC,   ( ),   ( ))
  int SelectObject(int hdc,int hgdiobj);                                         //       (DC).          (   (DC),  )
  // \/      ,             (  DC,      ,      ,   ,   ,   DC,      ,      ,   )
  bool BitBlt(int hdcDest,int XDest,int YDest,int Width,int Height,int hdcSrc,int XSrc,int YSrc,unsigned long dwRop);
  // \/             DIB,    ( DC,  ,    ,    ,    ,   ,  RGB  )
  int GetDIBits(int hdc,int hbmp,unsigned int StartScan,unsigned int ScanLines,LPVOID lpvBits,BITMAPINFOHEADER* lpbmi,unsigned int usage);
  int ReleaseDC(int hWnd,int hDC);                                               //    (DC)     ( ;   )
  bool DeleteObject(int hObject);                                                //    ,     (  )
  void memcpy(void *Destination,void const *Source,unsigned int Length);         //        (  ,  ,   )
  // \/       / ( ,  ,  , SD ( ), ,  ,   )
  int CreateFileA(const char *lpFileName,DWORD dwDesiredAccess,DWORD dwShareMode,int lpSecurityAttributes,DWORD dwCreationDisposition,DWORD dwFlagsAndAttributes,int hTemplateFile);
  // \/      ,      ( ,  ,    ,   ,  )
  bool WriteFile(int hFile, LPCVOID lpBuffer, DWORD nNumberOfBytesToWrite, LPDWORD lpNumberOfBytesWritten, int lpOverLapped);
  // \/      ,      ( ,  ,    ,   ,  )
  bool ReadFile(int hFile, LPCVOID lpBuffer, DWORD nNumberOfBytesToRead, LPDWORD lpNumberOfBytesRead, int lpOverLapped);
  bool CloseHandle(int hObject);                                                 //     ( )
  int GetFileSize(int hFile,LPDWORD lpFileSizeHigh);                             //     ( ;   ,       )
]]
local BMPFH=new('BITMAPFILEHEADER',{0x4D42,0,0,0,54})                          --  +    'BITMAPFILEHEADER' (    0  )
local BMPIH=new('BITMAPINFOHEADER',{40,0,0,1,24,0,0,0,0,0,0})                  --  +    'BITMAPINFOHEADER' (    0  )
local lpdwordTmp=new'DWORD[1]'                                                 --  +     LPDWORD (    )
local MIR=new('unsigned char[?]',maxPix*3+4)
local bgr=new("uint8_t[3]")
local pP,dD=new("uint8_t[6]"),new("int16_t[6]")

gra.Div=function(a,b)  local r=math.modf(a/b)  return r  end
gra.Mod=function(a,b)  return math.fmod(a,b)  end


local function SetBMI(n,w,h) --==================================================    : ;  (      , , ) ==
  CI[n][1],CI[n][0]=math.fmod(w,256),math.modf(w/256)                            --     (         .    )
  CI[n][3],CI[n][2]=math.fmod(h,256),math.modf(h/256)                            --     (         .    )
end ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
gra.GetBMI=function(n) --========================================================    :  ; ;  (      ) ====
  local w,h=CI[n][0]*256+CI[n][1],CI[n][2]*256+CI[n][3]                          --  +  :   (           );   (           )
  return math.ceil(w*3/4)*4,w,h                                                  --  :     ( 4 );  ;  
end ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
gra.GetImage=function(x1,y1,x2,y2,n,handle) --===================================        ( ,    ,   ) ====
  n,handle=n or 1,handle or workwindow()                                         --    :   ,  -    (  = 1);    (   ) (  0      -    )
  local w,h,hdcWindow=x2-x1+1,y2-y1+1,ffi.C.GetDC(handle)                        --  + :   ;   ;  ()   (DC)     
  local hdcMemDC=ffi.C.CreateCompatibleDC(hdcWindow)                             --  +   ()   ,    (DC)       
  local hbmScreen=ffi.C.CreateCompatibleBitmap(hdcWindow,w,h)                    --  +   () ,     
  ffi.C.SelectObject(hdcMemDC,hbmScreen)                                         --      
  ffi.C.BitBlt(hdcMemDC,0,0,w,h,hdcWindow,x1,y1,0x00CC0020)                      --     (    (); , ,      (  );     (  ),        ;    (  SRCCOPY -       ))
  BMPIH.biWidth,BMPIH.biHeight=w,-h                                              --     'BITMAPINFOHEADER':     (    ) (   , ..   )
  ffi.C.GetDIBits(hdcWindow,hbmScreen,0,h,CI[n]+4,BMPIH,0)                       --        CI[n]    4  ( DC,  ,    ,    ,    ,   ,  RGB   - DIB_RGB_COLORS = 0)
  SetBMI(n,w,h)  ffi.C.ReleaseDC(handle, hdcWindow)                              --         (  4-  ).     (  )
  ffi.C.DeleteObject(hdcMemDC)  ffi.C.DeleteObject(hbmScreen)                    --    ,     -   .    ,     - 
end ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
gra.SaveImage=function(path,n,x1,y1,x2,y2) --====================================        ( ,    ,   ) ===============
  n=n or 1  local lS,w,h=GetBMI(n)                                               --      ,  -    (  = 1)
  if x1 then  w,h=x2-x1+1,y2-y1+1  else  x1,y1,x2,y2=0,0,w-1,h-1  end
  local lD,iD,iS=math.ceil(w*3/4)*4,0,y2*lS+x1*3+4                                       -- +4  
  BMPFH.bfSize,BMPIH.biWidth,BMPIH.biHeight,BMPIH.biSizeImage=h*lD+54,w,h,h*lD
  for i=y1,y2 do  memcpy(MIR+iD,CI[n]+iS,w*3)  iD,iS=iD+lD,iS-lS  end --  
  local f=CreateFileA(path,0x40000000,3,0,2,128,0),GetBMI(n)                     --  + :    (      (  ));      ;   ;   . (      ffi   :  ;      (GENERIC_WRITE);     -    (FILE_SHARE_READ + FILE_SHARE_WRITE = 1+2);      = 0;       (CREATE_ALWAYS = 2);    (FILE_ATTRIBUTE_NORMAL = 128),    -  = 0). (    ,      4-     ).
  WriteFile(f,BMPFH,14,lpdwordTmp,0)  WriteFile(f,BMPIH,40,lpdwordTmp,0)
  WriteFile(f,MIR,h*lD,lpdwordTmp,0)  CloseHandle(f)
end----------------------------------------------------------------------------
gra.LoadImage=function(path,n)  -- n -    (  1)
  local f=CreateFileA(path,0x80000000,3,0,3,128,0)                               --    ( +  ) ( ,      (GENERIC_READ),     -    (FILE_SHARE_READ + FILE_SHARE_WRITE = 1+2),      = 0,    (OPEN_EXISTING = 3),    (FILE_ATTRIBUTE_NORMAL = 128),    -  = 0)
  ReadFile(f,BMPFH,14,lpdwordTmp,0)  ReadFile(f,BMPIH,40,lpdwordTmp,0) --
  ReadFile(f,MIR,BMPFH.bfSize-54,lpdwordTmp,0)  CloseHandle(f)                              --
  BMPIH.biXPelsPerMeter,BMPIH.biYPelsPerMeter=0,0          --    -   72
  n=n or 1    --   -    ,      1
  local l=math.ceil(BMPIH.biWidth*3/4)*4
  local iD,iS=4,(BMPIH.biHeight-1)*l                                       --
  for i=1,BMPIH.biHeight do   --  
    memcpy(CI[n]+iD,MIR+iS,BMPIH.biWidth*3)  iD,iS=iD+l,iS-l
  end
  SetBMI(n,BMPIH.biWidth,BMPIH.biHeight)
end----------------------------------------------------------------------------
gra.FindColor=function(x1,y1,x2,y2,co) --========================================      ( ,   (condition)) ==================================================
  if type(x2)=="table"then  co,x2,y2=x2,x1,y1  end                               --         
  local bm,nP,stX,stY=co.bm or 1,co.nP or 1,co.stX or 1,co.stY or 1              --    
  local res,k,R,G,B,P,D,RG,RB,GB,ind=true,0,true,true,true,true,true,true,true,true
  if co.hW then  GetImage(x1,y1,x2,y2,bm,co.hW)  x1,y1,x2,y2=0,0,x2-x1,y2-y1  end
  local x,y,l=x1,y1,GetBMI(bm)  if nP<0 then  nP=maxPix  end
  if co.r then  P,R,pP[0],pP[1]=false,false,co.r,co.R or co.r  end
  if co.g then  P,G,pP[2],pP[3]=false,false,co.g,co.G or co.g  end
  if co.b then  P,B,pP[4],pP[5]=false,false,co.b,co.B or co.b  end
  if co.rg then  D,RG,dD[0],dD[1]=false,false,co.rg,co.RG or 255  end
  if co.rb then  D,RB,dD[2],dD[3]=false,false,co.rb,co.RB or 255  end
  if co.gb then  D,GB,dD[4],dD[5]=false,false,co.gb,co.GB or 255  end
  while y<=y2 do
    ind=x*3+y*l+4
    while x<=x2 do
      memcpy(bgr,CI[bm]+ind,3)
      if(D or((RG or bgr[2]-bgr[1]>=dD[0]and bgr[2]-bgr[1]<=dD[1])and(RB or bgr[2]-bgr[0]>=dD[2]and bgr[2]-bgr[0]<=dD[3])and(GB or bgr[1]-bgr[0]>=dD[4]and bgr[1]-bgr[0]<=dD[5])))
          and(P or((R or bgr[2]>=pP[0]and bgr[2]<=pP[1])and(G or bgr[1]>=pP[2]and bgr[1]<=pP[3])and(B or bgr[0]>=pP[4]and bgr[0]<=pP[5])))then
        k,CI[0][k]=k+1,{x,y,bgr[0],bgr[1],bgr[2]}
        if nP==k then  return res,k-1  end
      end
      x,ind=x+stX,ind+3*stX
    end
    x,y=x1,y+stY
  end
  if k<1 then  res=false  end  return res,k-1
end ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
gra.CreateFindArray=function(co,L)
  local bm,k,z=co[1].bm or 2,0,0
  local w,h,l,x,y,i,R,G,B,P,D,RG,RB,GB,ba,ga,ra,acc,dev,zat,n
  if co[1].nf then  LoadImage(co[1].nf,bm)  end  l,w,h=GetBMI(bm)  n=w*h+1
  local arD,arI,arF=new("uint8_t[?][6]",n),new("uint32_t["..n.."]"),new("uint16_t["..h.."]["..w.."]")
  if co[1].zat then  zat=co[1].zat/100  else  zat=0  end                                                               
  while z<#co do
    z,R,G,B,P,D,RG,RB,GB,y,x,i=z+1,true,true,true,true,true,true,true,true,0,0,4
    if co[z].r then  P,R,pP[0],pP[1]=false,false,co[z].r,co[z].R or co[z].r  end     --
    if co[z].g then  P,G,pP[2],pP[3]=false,false,co[z].g,co[z].G or co[z].g  end
    if co[z].b then  P,B,pP[4],pP[5]=false,false,co[z].b,co[z].B or co[z].b  end
    if co[z].rg then  D,RG,dD[0],dD[1]=false,false,co[z].rg,co[z].RG or 255  end
    if co[z].rb then  D,RB,dD[2],dD[3]=false,false,co[z].rb,co[z].RB or 255  end
    if co[z].gb then  D,GB,dD[4],dD[5]=false,false,co[z].gb,co[z].GB or 255  end
    if co[z].acc and co[z].acc<100 then  acc=(100-co[z].acc)/100  else  acc=0  end
    if co[z].dev then  dev=co[z].dev  else  dev=0  end
    while y<h do
      while x<w do
        if arF[y][x]==0 then
          memcpy(bgr,CI[bm]+i,3)
          if(co[z].fgr
                and(D or((RG or bgr[2]-bgr[1]>=dD[0]and bgr[2]-bgr[1]<=dD[1])and(RB or bgr[2]-bgr[0]>=dD[2]and bgr[2]-bgr[0]<=dD[3])and(GB or bgr[1]-bgr[0]>=dD[4]and bgr[1]-bgr[0]<=dD[5])))
                and(P or((R or bgr[2]>=pP[0]and bgr[2]<=pP[1])and(G or bgr[1]>=pP[2]and bgr[1]<=pP[3])and(B or bgr[0]>=pP[4]and bgr[0]<=pP[5]))))
              or not(co[z].fgr)and not(
                (D or((RG or bgr[2]-bgr[1]>=dD[0]and bgr[2]-bgr[1]<=dD[1])and(RB or bgr[2]-bgr[0]>=dD[2]and bgr[2]-bgr[0]<=dD[3])and(GB or bgr[1]-bgr[0]>=dD[4]and bgr[1]-bgr[0]<=dD[5])))
                and(P or((R or bgr[2]>=pP[0]and bgr[2]<=pP[1])and(G or bgr[1]>=pP[2]and bgr[1]<=pP[3])and(B or bgr[0]>=pP[4]and bgr[0]<=pP[5]))))then
            if zat>0 then  bgr[0],bgr[1],bgr[2]=math.floor(bgr[0]-bgr[0]*zat),math.floor(bgr[1]-bgr[1]*zat),math.floor(bgr[2]-bgr[2]*zat)  end
            k,ba,ga,ra,arF[y][x]=k+1,bgr[0]*acc+dev,bgr[1]*acc+dev,bgr[2]*acc+dev,1
            arD[k]={math.max(0,math.floor(bgr[0]-ba)),math.max(0,math.floor(bgr[1]-ga)),math.max(0,math.floor(bgr[2]-ra)),
                math.min(255,math.ceil(bgr[0]+ba)),math.min(255,math.ceil(bgr[1]+ga)),math.min(255,math.ceil(bgr[2]+ra))}
            arI[k]=x*3+y*L
          end
        end
        i,x=i+3,x+1
      end
      y=y+1  i,x=4+y*l,0
    end
  end
  arD[0]={Mod(L,256),Div(L,256),Mod(w,256),Div(w,256),Mod(h,256),Div(h,256)}
  arI[0]=k  return {arI,arD}
end --------------------------------------------------------------------------------
gra.FindImage=function(x1,y1,x2,y2,pic,so)
  local af,k,shi,   hW,bm,nP,sim,shiX,shiY,v1,v2,v3={},1,false
  if so then
      hW,bm,nP,sim,shiX,shiY,v1,v2,v3=so.hW,so.bm or 1,so.nP or 1,so.sim or 100,so.shiX or 0,so.shiY or 0,so.v1 or 2,so.v2 or 1,so.v3 or 0
    else  bm,nP,sim,shiX,shiY,v1,v2,v3=1,1,100,0,0,2,1,0
  end
  if hW then  GetImage(x1,y1,x2,y2,bm,hW)  x1,y1,x2,y2=0,0,x2-x1,y2-y1  end
  local l=GetBMI(bm)  local ic=4+x1*3+y1*l
  if nP<0 then  nP=2073600  end
  if type(pic[1])~="cdata" then  pic=CreateFindArray(pic,l)  end
  memcpy(dD,pic[2][0],6)  --    :      (dD[0]);  (dD[1])   (dD[2])    -- (  6-        - 3-  )
  if dD[0]~=l then
    log("  =",l,dD[0])  --    , ..   
    for i=1,pic[1][0]do  pic[1][i]=pic[1][i]+Div(pic[1][i],dD[0])*(l-dD[0])  end   --  . --             
    pic[2][0][0],pic[2][0][1]=Mod(l,256),Div(l,256)
  end
  local sr,x,y,ind,wF,hF,V1,V2,V3=true,0,0,  ic,  x2-x1+2-dD[1],y2-y1+2-dD[2],  v1+3,v2+3,v3+3
  sim=math.floor(pic[1][0]*0.01*(100-sim))
  local j=0  if sim==1 then sim=2  end    --   ;  
  while y<hF do             --     
    while x<wF do           --     
      for i=1,pic[1][0]do   --     
        memcpy(bgr,CI[bm]+ind+pic[1][i],3)  --   RGB      
        if bgr[v1]<pic[2][i][v1]or bgr[v1]>pic[2][i][V1]or bgr[v2]<pic[2][i][v2]or bgr[v2]>pic[2][i][V2]or bgr[v3]<pic[2][i][v3]or bgr[v3]>pic[2][i][V3]then
          j=j+1  if j>sim then  sr=false  break  end                                 --     --    -   ,  
        end
      end
      if sr then                          --  
        af[k],k={x,y},k+1  if k>nP then  return k-1,af  end               --      --      - 
        if shiX>0 then  x=x+shiX  ind=ind+3*shiX  shi=true  end                  --    ()   -- ,  ,     
        if shiY>0 then  shi=true  end
      end
      x,sr,  ind,j=x+1,true,  ind+3,0
    end
    x,y=0,y+1  if shi then  y=y+shiY  shi=false  end  --       - ,  
    ind=ic+y*l     --    
  end
  return k-1,af
end ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

memcpy=ffi.C.memcpy
CreateFileA=ffi.C.CreateFileA
WriteFile=ffi.C.WriteFile
ReadFile=ffi.C.ReadFile
CloseHandle=ffi.C.CloseHandle
GetFileSize=ffi.C.GetFileSize
Mod=gra.Mod
Div=gra.Div
GetBMI=gra.GetBMI
GetImage=gra.GetImage
SaveImage=gra.SaveImage
LoadImage=gra.LoadImage
FindColor=gra.FindColor
CreateFindArray=gra.CreateFindArray
FindImage=gra.FindImage

return gra
