--lua
local cif={}
--======= !!    !! ============================================================================================================================================================
local maxWidth,maxHeight=1920,1080         --!!  +       : ; .
local maxBuf=40000000                      --!!  +           .
local numImage=2                           --!!  +      .
--/\             ,     .
--==================================================================================================================================================================================================================
ffi=require "ffi"
new=ffi.new                      --      
local maxPix=maxWidth*maxHeight  --       FindColor

local nsl=numImage+1
CIP=new("uint16_t["..nsl.."][4]")      --  
CI={}
CI[0]=new("uint16_t["..maxPix.."][5]")
for i=1,numImage do
  CI[i]=new("uint8_t["..maxHeight.."]["..maxWidth.."][3]")
  CIP[i][2]=maxWidth
  CIP[i][3]=maxHeight
end
CI32=new("uint32_t[1]")       --     LPDWORD (    ,     )
local CI64=new("int64_t[1]")  --   
local freq                    --  (  )

ffi.cdef[[
  typedef long LONG;
  typedef unsigned short WORD;
  typedef unsigned long DWORD;
  typedef unsigned char BYTE;
  typedef void *LPVOID; 
  typedef const void *LPCVOID;
  typedef DWORD *LPDWORD;
  #pragma pack (push, 1)
  typedef struct {WORD bfType;DWORD bfSize;WORD bfReserved1;WORD bfReserved2;DWORD bfOffBits;} BITMAPFILEHEADER;
  #pragma pack (pop)
  typedef struct {DWORD biSize; LONG  biWidth; LONG  biHeight; WORD  biPlanes; WORD  biBitCount; DWORD biCompression; DWORD biSizeImage;
        LONG  biXPelsPerMeter; LONG biYPelsPerMeter; DWORD biClrUsed; DWORD biClrImportant;} BITMAPINFOHEADER;
  
  int GetDC(int hWnd);                                                           //      (DC)          ( )
  int CreateCompatibleDC(int hdc);                                               //      (DC),     ( DC)
  int CreateCompatibleBitmap(int hdc,int nWidth,int nHeight);                    //   ,   ,       ( DC,   ( ),   ( ))
  int SelectObject(int hdc,int hgdiobj);                                         //       (DC).          (   (DC),  )
  // \/      ,             (  DC,      ,      ,   ,   ,   DC,      ,      ,   )
  bool BitBlt(int hdcDest,int XDest,int YDest,int Width,int Height,int hdcSrc,int XSrc,int YSrc,unsigned long dwRop);
  // \/             DIB,    ( DC,  ,    ,    ,    ,   ,  RGB  )
  int GetDIBits(int hdc,int hbmp,unsigned int StartScan,unsigned int ScanLines,LPVOID lpvBits,BITMAPINFOHEADER* lpbmi,unsigned int usage);
  int ReleaseDC(int hWnd,int hDC);                                               //    (DC)     ( ;   )
  bool DeleteObject(int hObject);                                                //    ,     (  )
  void memcpy(void *Destination,void const *Source,unsigned int Length);         //        (  ,  ,   )
  // \/       / ( ,  ,  , SD ( ), ,  ,   )
  int CreateFileA(const char *lpFileName,DWORD dwDesiredAccess,DWORD dwShareMode,int lpSecurityAttributes,DWORD dwCreationDisposition,DWORD dwFlagsAndAttributes,int hTemplateFile);
  // \/      ,      ( ,  ,    ,   ,  )
  bool WriteFile(int hFile, LPCVOID lpBuffer, DWORD nNumberOfBytesToWrite, LPDWORD lpNumberOfBytesWritten, int lpOverLapped);
  // \/      ,      ( ,  ,    ,   ,  )
  bool ReadFile(int hFile, LPCVOID lpBuffer, DWORD nNumberOfBytesToRead, LPDWORD lpNumberOfBytesRead, int lpOverLapped);
  bool CloseHandle(int hObject);                                                 //     ( )
  int GetFileSize(int hFile,LPDWORD lpFileSizeHigh);                             //     ( ;   ,       )

    int QueryPerformanceFrequency(int64_t *lpFrequency);
    int QueryPerformanceCounter(int64_t *lpPerformanceCount);
    short GetKeyState(int vKey);
]]
local BUF=new('unsigned char[?]',maxBuf)                                       --    
local BMPFH=new('BITMAPFILEHEADER',{0x4D42,0,0,0,54})                          --  +    'BITMAPFILEHEADER' (    0  )
local BMPIH=new('BITMAPINFOHEADER',{40,0,0,1,24,0,0,0,0,0,0})                  --  +    'BITMAPINFOHEADER' (    0  )
local BitMap=new('unsigned char[?]',maxPix*3)
local bgr=new("uint8_t[3]")
local pP,dD=new("uint8_t[6]"),new("int16_t[6]")

cif.Div=function(a)  local r=math.modf(a)  return r  end




cif.GetImage=function(x1,y1,x2,y2,n,handle) --===================================        ( ,    ,   ) ==
  n,handle=n or 1,handle or workwindow()  CIP[n][0],CIP[n][1]=x2-x1+1,y2-y1+1    --    :       (  = 1);    (   ) (  0      -    ).  (        ):     ;     .
  local hdcWindow=ffi.C.GetDC(handle)                                            --  +   ()   (DC)       .
  local hdcMemDC=ffi.C.CreateCompatibleDC(hdcWindow)                             --  +   ()   ,    (DC)       .
  local hbmScreen=ffi.C.CreateCompatibleBitmap(hdcWindow,CIP[n][0],CIP[n][1])          --  +   () ,     .
  ffi.C.SelectObject(hdcMemDC,hbmScreen)                                         --      .
  ffi.C.BitBlt(hdcMemDC,0,0,CIP[n][0],CIP[n][1],hdcWindow,x1,y1,0x00CC0020)            --     (    (); , ,      (  );     (  ),        ;    (  SRCCOPY -       )).
  BMPIH.biWidth,BMPIH.biHeight=CIP[n][0],-CIP[n][1]                                    --     'BITMAPINFOHEADER':     (    ) (   , ..   ).
  ffi.C.GetDIBits(hdcWindow,hbmScreen,0,CIP[n][1],BitMap,BMPIH,0)                   --           ( DC,  ,    ,    ,    ,   ,  RGB   - DIB_RGB_COLORS = 0).
  ffi.C.ReleaseDC(handle, hdcWindow)                                             --     (  ).
  ffi.C.DeleteObject(hdcMemDC)  ffi.C.DeleteObject(hbmScreen)                    --    ,     -   .    ,     - .
  local w3=CIP[n][0]*3  local l=math.ceil(w3/4)*4                                   --  +          .  +             ( 4- ).
  for i=0,CIP[n][1]-1 do  memcpy(CI[n][i],BitMap+i*l,w3)  end                       --       =>>     (1- )  ,      ,      ,     .
end ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
cif.SaveImage=function(path,n,x1,y1,x2,y2) --====================================         ( ,    ,   ) =======
  n=n or 1  local w,h=CIP[n][0],CIP[n][1]                                              --         ,     (  = 1).  +     ,     (   ,         ):  ;  .
  if x1 then  w,h=x2-x1+1,y2-y1+1  else  x1,y1,y2=0,0,h-1  end                   --        ,     (!! ,       ) =>  ():  ;   <=  =>  ,       ,    (   ):      ( = 0);      ( = 0);     .
  local w3=w*3  local l,ind=math.ceil(w3/4)*4,0
  BMPFH.bfSize,BMPIH.biWidth,BMPIH.biHeight,BMPIH.biSizeImage=h*l+54,w,h,h*l
  for i=y2,y1,-1 do  memcpy(BitMap+ind,CI[n][i][x1],w3)  ind=ind+l  end          --     ,      ( ) =>>     (2- )   (1- ) ,   ,       (3- )         . ->>         (     ).
  local f=CreateFileA(path,0x40000000,3,0,2,128,0)                               --       (   ) ( +  ) (      ffi   :  ;      (GENERIC_WRITE);     -    (FILE_SHARE_READ + FILE_SHARE_WRITE = 1+2);      = 0;       (CREATE_ALWAYS = 2);    (FILE_ATTRIBUTE_NORMAL = 128),    -  = 0).
  WriteFile(f,BMPFH,14,CI32,0)  WriteFile(f,BMPIH,40,CI32,0)         --    (   ffi)   'BITMAPFILEHEADER'.    (  )   'BITMAPINFOHEADER'.
  WriteFile(f,BitMap,h*l,CI32,0)  CloseHandle(f)                           --    (  )      .   ( )
end ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
cif.LoadImage=function(path,n) --================================================      ( ,    ) =====================================================
  local f=CreateFileA(path,0x80000000,3,0,3,128,0)                               --    ( +  ) (      ffi   :  ,      (GENERIC_READ),     -    (FILE_SHARE_READ + FILE_SHARE_WRITE = 1+2),      = 0,    (OPEN_EXISTING = 3),    (FILE_ATTRIBUTE_NORMAL = 128),    -  = 0).
  ReadFile(f,BMPFH,14,CI32,0)  ReadFile(f,BMPIH,40,CI32,0) --
  ReadFile(f,BitMap,BMPFH.bfSize-54,CI32,0)  CloseHandle(f)                              --
  BMPIH.biXPelsPerMeter,BMPIH.biYPelsPerMeter=0,0          --    -   72
  n=n or 1  local w3=BMPIH.biWidth*3  local l,ind=math.ceil(w3/4)*4,0
  for i=BMPIH.biHeight-1,0,-1 do  memcpy(CI[n][i],BitMap+ind,w3)  ind=ind+l  end --
  CIP[n][0]=BMPIH.biWidth  CIP[n][1]=BMPIH.biHeight
end ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
cif.FindColor=function(x1,y1,x2,y2,co) --========================================        ( ,   (condition)) ======================================
  if type(x2)=="table"then  co,x2,y2=x2,x1,y1  end                               --         
  local bm,nP,stX,stY=co.bm or 1,co.nP or 1,co.stX or 1,co.stY or 1              --    
  local res,k,R,G,B,P,D,RG,RB,GB,ind=true,0,true,true,true,true,true,true,true,true
  if co.hW then  GetImage(x1,y1,x2,y2,bm,co.hW)  x1,y1,x2,y2=0,0,x2-x1,y2-y1  end
  local x,y=x1,y1  if nP<0 then  nP=maxPix  end
  if co.r then  P,R,pP[0],pP[1]=false,false,co.r,co.R or co.r  end
  if co.g then  P,G,pP[2],pP[3]=false,false,co.g,co.G or co.g  end
  if co.b then  P,B,pP[4],pP[5]=false,false,co.b,co.B or co.b  end
  if co.rg then  D,RG,dD[0],dD[1]=false,false,co.rg,co.RG or 255  end
  if co.rb then  D,RB,dD[2],dD[3]=false,false,co.rb,co.RB or 255  end
  if co.gb then  D,GB,dD[4],dD[5]=false,false,co.gb,co.GB or 255  end
  while y<=y2 do
    while x<=x2 do
      if(D or((RG or CI[bm][y][x][2]-CI[bm][y][x][1]>=dD[0]and CI[bm][y][x][2]-CI[bm][y][x][1]<=dD[1])and(RB or CI[bm][y][x][2]-CI[bm][y][x][0]>=dD[2]and CI[bm][y][x][2]-CI[bm][y][x][0]<=dD[3])and(GB or CI[bm][y][x][1]-CI[bm][y][x][0]>=dD[4]and CI[bm][y][x][1]-CI[bm][y][x][0]<=dD[5])))
          and(P or((R or CI[bm][y][x][2]>=pP[0]and CI[bm][y][x][2]<=pP[1])and(G or CI[bm][y][x][1]>=pP[2]and CI[bm][y][x][1]<=pP[3])and(B or CI[bm][y][x][0]>=pP[4]and CI[bm][y][x][0]<=pP[5])))then
        k,CI[0][k]=k+1,{x,y,CI[bm][y][x][0],CI[bm][y][x][1],CI[bm][y][x][2]}
        if nP==k then  return res,k-1  end
      end
      x=x+stX
    end
    x,y=x1,y+stY
  end
  if k<1 then  res=false  end  return res,k-1
end ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
cif.CreateFindArray=function(co)
  local bm,k,z=co[1].bm or 2,0,0
  local w,h,l,x,y,i,R,G,B,P,D,RG,RB,GB,ba,ga,ra,acc,dev,zat,n
  if co[1].nf then  LoadImage(co[1].nf,bm)  end
  w,h=CIP[bm][0],CIP[bm][1]  n=w*h+1
  local arD,arI,arF=new("uint8_t[?][6]",n),   new("uint16_t["..n.."][2]"),  new("uint16_t["..h.."]["..w.."]")
  if co[1].zat then  zat=co[1].zat/100  else  zat=0  end
  while z<#co do
    z,R,G,B,P,D,RG,RB,GB,y,x=z+1,true,true,true,true,true,true,true,true,0,0
    if co[z].r then  P,R,pP[0],pP[1]=false,false,co[z].r,co[z].R or co[z].r  end     --
    if co[z].g then  P,G,pP[2],pP[3]=false,false,co[z].g,co[z].G or co[z].g  end
    if co[z].b then  P,B,pP[4],pP[5]=false,false,co[z].b,co[z].B or co[z].b  end
    if co[z].rg then  D,RG,dD[0],dD[1]=false,false,co[z].rg,co[z].RG or 255  end
    if co[z].rb then  D,RB,dD[2],dD[3]=false,false,co[z].rb,co[z].RB or 255  end
    if co[z].gb then  D,GB,dD[4],dD[5]=false,false,co[z].gb,co[z].GB or 255  end
    if co[z].acc and co[z].acc<100 then  acc=(100-co[z].acc)/100  else  acc=0  end
    if co[z].dev then  dev=co[z].dev  else  dev=0  end

    if co[z].fgr then
        while y<h do
          while x<w do
            if arF[y][x]==0 then
              memcpy(bgr,CI[bm][y][x],3)
              if(D or((RG or bgr[2]-bgr[1]>=dD[0]and bgr[2]-bgr[1]<=dD[1])and(RB or bgr[2]-bgr[0]>=dD[2]and bgr[2]-bgr[0]<=dD[3])and(GB or bgr[1]-bgr[0]>=dD[4]and bgr[1]-bgr[0]<=dD[5])))
                    and(P or((R or bgr[2]>=pP[0]and bgr[2]<=pP[1])and(G or bgr[1]>=pP[2]and bgr[1]<=pP[3])and(B or bgr[0]>=pP[4]and bgr[0]<=pP[5])))then
                if zat>0 then  bgr[0],bgr[1],bgr[2]=math.floor(bgr[0]-bgr[0]*zat),math.floor(bgr[1]-bgr[1]*zat),math.floor(bgr[2]-bgr[2]*zat)  end
                k,ba,ga,ra,arF[y][x]=k+1,bgr[0]*acc+dev,bgr[1]*acc+dev,bgr[2]*acc+dev,1
                arD[k]={math.max(0,math.floor(bgr[0]-ba)),math.max(0,math.floor(bgr[1]-ga)),math.max(0,math.floor(bgr[2]-ra)),
                    math.min(255,math.ceil(bgr[0]+ba)),math.min(255,math.ceil(bgr[1]+ga)),math.min(255,math.ceil(bgr[2]+ra))}
                arI[k][0]=y  arI[k][1]=x
              end
            end
            x=x+1
          end
          y=y+1  x=0
        end
      else
        while y<h do
          while x<w do
            if arF[y][x]==0 then
              memcpy(bgr,CI[bm][y][x],3)
              if not((D or((RG or bgr[2]-bgr[1]>=dD[0]and bgr[2]-bgr[1]<=dD[1])and(RB or bgr[2]-bgr[0]>=dD[2]and bgr[2]-bgr[0]<=dD[3])and(GB or bgr[1]-bgr[0]>=dD[4]and bgr[1]-bgr[0]<=dD[5])))
                    and(P or((R or bgr[2]>=pP[0]and bgr[2]<=pP[1])and(G or bgr[1]>=pP[2]and bgr[1]<=pP[3])and(B or bgr[0]>=pP[4]and bgr[0]<=pP[5]))))then
                if zat>0 then  bgr[0],bgr[1],bgr[2]=math.floor(bgr[0]-bgr[0]*zat),math.floor(bgr[1]-bgr[1]*zat),math.floor(bgr[2]-bgr[2]*zat)  end
                k,ba,ga,ra,arF[y][x]=k+1,bgr[0]*acc+dev,bgr[1]*acc+dev,bgr[2]*acc+dev,1
                arD[k]={math.max(0,math.floor(bgr[0]-ba)),math.max(0,math.floor(bgr[1]-ga)),math.max(0,math.floor(bgr[2]-ra)),
                    math.min(255,math.ceil(bgr[0]+ba)),math.min(255,math.ceil(bgr[1]+ga)),math.min(255,math.ceil(bgr[2]+ra))}
                arI[k][0]=y  arI[k][1]=x
              end
            end
            x=x+1
          end
          y=y+1  x=0
        end
    end

--    while y<h do
--      while x<w do
--        if arF[y][x]==0 then
--          memcpy(bgr,CI[bm][y][x],3)
--          if(co[z].fgr
--                and(D or((RG or bgr[2]-bgr[1]>=dD[0]and bgr[2]-bgr[1]<=dD[1])and(RB or bgr[2]-bgr[0]>=dD[2]and bgr[2]-bgr[0]<=dD[3])and(GB or bgr[1]-bgr[0]>=dD[4]and bgr[1]-bgr[0]<=dD[5])))
--                and(P or((R or bgr[2]>=pP[0]and bgr[2]<=pP[1])and(G or bgr[1]>=pP[2]and bgr[1]<=pP[3])and(B or bgr[0]>=pP[4]and bgr[0]<=pP[5]))))
--              or not(co[z].fgr)and not(
--                (D or((RG or bgr[2]-bgr[1]>=dD[0]and bgr[2]-bgr[1]<=dD[1])and(RB or bgr[2]-bgr[0]>=dD[2]and bgr[2]-bgr[0]<=dD[3])and(GB or bgr[1]-bgr[0]>=dD[4]and bgr[1]-bgr[0]<=dD[5])))
--                and(P or((R or bgr[2]>=pP[0]and bgr[2]<=pP[1])and(G or bgr[1]>=pP[2]and bgr[1]<=pP[3])and(B or bgr[0]>=pP[4]and bgr[0]<=pP[5]))))then
--            if zat>0 then  bgr[0],bgr[1],bgr[2]=math.floor(bgr[0]-bgr[0]*zat),math.floor(bgr[1]-bgr[1]*zat),math.floor(bgr[2]-bgr[2]*zat)  end
--            k,ba,ga,ra,arF[y][x]=k+1,bgr[0]*acc+dev,bgr[1]*acc+dev,bgr[2]*acc+dev,1
--            arD[k]={math.max(0,math.floor(bgr[0]-ba)),math.max(0,math.floor(bgr[1]-ga)),math.max(0,math.floor(bgr[2]-ra)),
--                math.min(255,math.ceil(bgr[0]+ba)),math.min(255,math.ceil(bgr[1]+ga)),math.min(255,math.ceil(bgr[2]+ra))}
--            arI[k][0]=y  arI[k][1]=x
--          end
--        end
--        x=x+1
--      end
--      y=y+1  x=0
--    end



  end
  arD[0]={Mod(w,256),Div(w/256),Mod(h,256),Div(h/256)}
  arI[0][0]=Mod(k,65536)  arI[0][1]=Div(k/65536)
--  return {arI,arD}
  k=k+1  local k1,k2=k*6,k*4  local arDnew,arInew = new("uint8_t[?][6]",k), new("uint16_t[?][2]",k)
  memcpy(arDnew,arD,k1)  memcpy(arInew,arI,k2)  return {arInew,arDnew}
end --------------------------------------------------------------------------------
cif.FindImage=function(x1,y1,x2,y2,pic,so)
  if type(pic[1])~="cdata" then  pic=CreateFindArray(pic)  end
  local kk=pic[1][0][0]+pic[1][0][1]*65536
  if kk==0 then  return 0,nil  end
  local af,k,shi,   hW,bm,nP,sim,shiX,shiY,v1,v2,v3={},1,false
  if so then
      hW,bm,nP,sim,shiX,shiY,v1,v2,v3=so.hW,so.bm or 1,so.nP or 1,so.sim or 100,so.shiX or 0,so.shiY or 0,so.v1 or 2,so.v2 or 1,so.v3 or 0
    else  bm,nP,sim,shiX,shiY,v1,v2,v3=1,1,100,0,0,2,1,0
  end
  if hW then  GetImage(x1,y1,x2,y2,bm,hW)  x1,y1,x2,y2=0,0,x2-x1,y2-y1  end
  if nP<0 then  nP=2073600  end
  memcpy(dD,pic[2][0],4)  --    :  (dD[0])   (dD[1])  
  local sr,x,y,wF,hF,V1,V2,V3=true,x1,y1,  x2+2-dD[0],y2+2-dD[1],  v1+3,v2+3,v3+3
  sim=math.floor(kk*0.01*(100-sim))  local j=0  if sim==1 then sim=2  end    --   ;  
  local iy,ix
  while y<hF do             --     
    while x<wF do           --     
      for i=1,kk do   --     
        iy,ix=pic[1][i][0]+y,pic[1][i][1]+x
        if CI[bm][iy][ix][v1]<pic[2][i][v1]or CI[bm][iy][ix][v1]>pic[2][i][V1]or CI[bm][iy][ix][v2]<pic[2][i][v2]or
            CI[bm][iy][ix][v2]>pic[2][i][V2]or CI[bm][iy][ix][v3]<pic[2][i][v3]or CI[bm][iy][ix][v3]>pic[2][i][V3]then
          j=j+1  if j>sim then  sr=false  break  end          --     --    -   ,  
        end
      end
      if sr then                          --  
        af[k],k={x,y},k+1  if k>nP then  return k-1,af  end    --      --      - 
        if shiX>0 then  x=x+shiX  shi=true  end           --    ()   -- ,  ,     
        if shiY>0 then  shi=true  end
      end
      x,sr,j=x+1,true,0
    end
    x,y=x1,y+1  if shi then  y=y+shiY  shi=false  end  --       - ,  
  end
  return k-1,af
end ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
cif.SaveBin=function(u,L1i1,L1i2,L2i1,L2i2)  -- L1i1,L1i2 - ,   1-    ; L2i1,L2i2 - ,   2-    
--      1-  
-- nf  -      
-- hf  -   .   ,       ,     
-- cf  -   |   (      -   )
-- zat -  (  : 0; 1;  2)
  local fName,pref,suf,z,  a,n,k,f=u[1].nf,"","",0     -- a - 2- -   n -      k - -   
  
  if u[1].cf then  u[1].nf=nil  end  --     CreateFindArray -     -      
  if not(L1i2)then  L1i1,L1i2=0,0  end  if not(L2i2)then  L2i1,L2i2=0,0  end
  for i=L1i1,L1i2 do
    if not(u[1].cf)and L1i1~=L1i2 then                                             --         bmp
      pref=string.format("%0"..#tostring(L1i2).."d",i)
    end
    for j=L2i1,L2i2 do
      if not(u[1].cf)then
        if L2i1~=L2i2 then  suf=string.format("%0"..#tostring(L2i2).."d",j)  end
        u[1].nf=fName..pref..suf..[[.bmp]]
      end
      a=CreateFindArray(u)  k=a[1][0][0]+a[1][0][1]*65536+1              --    + 1
      n=k*4  memcpy(BUF+z,a[1],n)  z=z+n  n=k*6  memcpy(BUF+z,a[2],n)  z=z+n  --     --    RGB
    end
  end
  
  if not(u[1].hf)then
    if u[1].zat then  suf=math.ceil(Div(u[1].zat/20))  else  suf=""  end          --      1-  
    u[1].hf=CreateFileA(fName..suf..[[.dat]],0x40000000,3,0,2,128,0)               --       (  ) ( +  ) ( ,      (GENERIC_WRITE),     -    (FILE_SHARE_READ + FILE_SHARE_WRITE = 1+2),      = 0,       (CREATE_ALWAYS = 2),    (FILE_ATTRIBUTE_NORMAL = 128),    -  = 0)
  end
  WriteFile(u[1].hf,BUF,z,CI32,0)     --          .
  if not(u[1].cf)then  CloseHandle(u[1].hf)  end
end----------------------------------------------------------------------------
cif.LoadBin=function(fName,L1i1,L1i2,L2i1,L2i2) --===============================     -   ( ,  1- ,   ) ==============
  local aC,z,f={},0,CreateFileA(fName,0x80000000,3,0,3,128,0)                      --    ( +  ) ( ,      (GENERIC_READ),     -    (FILE_SHARE_READ + FILE_SHARE_WRITE = 1+2),      = 0,    (OPEN_EXISTING = 3),    (FILE_ATTRIBUTE_NORMAL = 128),    -  = 0)
  ReadFile(f,BUF,GetFileSize(f,CI32),CI32,0)  CloseHandle(f) --
  if not(L1i2)then  L1i1,L1i2=0,0  end  if not(L2i2)then  L2i1,L2i2=0,0  end
  local function CreatePix()
    local a={}
    for i=L2i1,L2i2 do
      memcpy(CI32,BUF+z,4)  CI32[0]=CI32[0]+1  --       
      a[i]={new("uint16_t[?][2]",CI32[0]),new("uint8_t[?][6]",CI32[0])}                         --
      memcpy(a[i][1],BUF+z,CI32[0]*4)  z=z+CI32[0]*4
      memcpy(a[i][2],BUF+z,CI32[0]*6)  z=z+CI32[0]*6     --
    end
    if L2i1~=L2i2 then  return a  else  return a[L2i1]  end            --        
  end
  for j=L1i1,L1i2 do  aC[j]=CreatePix()  end
  if L1i1~=L1i2 then  return aC  else  return aC[L1i1]  end
end----------------------------------------------------------------------------
function SaveArray(arr,FileName)                                         --     (arr -     ; FileName -    )
  local n,r=0
    for y=1,#arr do
      for x=1,#arr[y] do
        s=tostring(arr[y][x]) r=#s  memcpy(BUF+n,s,r)  n=n+r  BUF[n]=9  n=n+1
      end
      BUF[n-1],BUF[n]=13,10  n=n+1
    end
  local ff=CreateFileA(FileName,0x40000000,3,0,2,128,0)
  WriteFile(ff,BUF,n,CI32,0)  CloseHandle(ff)
end----------------------------------------------------------------------------
function LoadArray(FileName)                                             --     (FileName -    ) ret -     
  local fl=io.open(FileName,"rb")  local z=fl:read("*a")  fl:close()
  local i,j,y,x,a,r,b,  s,d,t=0,0,1,1,{},#z,{}
  if r==0 then  return a  end
  local function Element()
    s=z:sub(i-j,i-1)  d=tonumber(s)
    if d then  b[x]=d  else  b[x]=s  end
  end
  while i<r do
    i=i+1  t=z:byte(i)
    if t>13 then  j=j+1
      elseif t<10 then  Element()  j,x=0,x+1
        else  Element()  a[y],b,i,j,y,x=b,{},i+1,0,y+1,1
    end
  end
  if z:byte(i)~=10 then  i=i+1  Element()  a[y]=b  end
  return a
end----------------------------------------------------------------------------

--\/    -    
--  :
-- local Timer1=Timer()           --  
-- Wait(1500)                     --    (.  )
-- local Timer2=Timer()           --   
-- local TimeLast=Timer2-Timer1   --   (    )
cif.Timer=function()
  ffi.C.QueryPerformanceCounter(CI64)
  return Div(1000*tonumber(CI64[0])/freq)
end

cif.Wait=function(p)         --   
  local t=Timer()  while Timer()-t<p do  end
end

--   256  1 -     NUM CAPS  ..
cif.StatusKey=function(k1,k2,k3) --    1-  3- 
  local function getkeystate(key)
    if bit.band(ffi.C.GetKeyState(key), 256) ~= 0 then  return true
        else  return false
    end
  end
  if getkeystate(k1)then
    if not(k2)or getkeystate(k2)then
      if not(k3)or getkeystate(k3)then  return  true  end
    end
  end
  return false
end


--\/   
--\/    ,         .   .
--\/      ,        .
memcpy=ffi.C.memcpy
CreateFileA=ffi.C.CreateFileA
WriteFile=ffi.C.WriteFile
ReadFile=ffi.C.ReadFile
CloseHandle=ffi.C.CloseHandle
GetFileSize=ffi.C.GetFileSize
Mod=math.fmod                  --      
Div=cif.Div                    --      
GetImage=cif.GetImage
SaveImage=cif.SaveImage
LoadImage=cif.LoadImage
FindColor=cif.FindColor
CreateFindArray=cif.CreateFindArray
FindImage=cif.FindImage
SaveBin=cif.SavePix       --     
LoadBin=cif.LoadPix       --     
Timer=cif.Timer           --  
Wait=cif.Wait             --   
StatusKey=cif.StatusKey   --    (     ,        )

ffi.C.QueryPerformanceFrequency(CI64)  
freq=tonumber(CI64[0])                 --     

return cif
