--lua
local api = require('telegram.core').configure(TOKEN) --  TOKEN     @BotFather
local chat_id = CHAT_ID --  CHAT_ID  ,         

local function start_keyboard()
  local keyboard = {['inline_keyboard'] = {{}}}
  local count_scipts = scripts()
  local row = 1
  local count = 0
  for i = 2, #count_scipts do
    count = count + 1
    if count == 8 then
      row = row + 1
      table.insert(keyboard.inline_keyboard, {})
      count = 0
    end
    table.insert(keyboard.inline_keyboard[row], {['text'] = count_scipts[i][1], ['callback_data'] = 'Start ' .. count_scipts[i][1]})
  end
  return keyboard
end

local function stop_keyboard()
  local keyboard = {['inline_keyboard'] = {{}}}
  local count_scipts = scripts()
  local row = 1
  local count = 0
  for i = 2, #count_scipts do
    count = count + 1
    if count == 8 then
      row = row + 1
      table.insert(keyboard.inline_keyboard, {})
      count = 0
    end
    table.insert(keyboard.inline_keyboard[row], {['text'] = count_scipts[i][1], ['callback_data'] = 'Stop ' .. count_scipts[i][1]})
  end
  return keyboard
end

local function status_keyboard()
  local keyboard = {['inline_keyboard'] = {{}}}
  local count_scipts = scripts()
  local row = 1
  local count = 0
  for i = 2, #count_scipts do
    count = count + 1
    if count == 8 then
      row = row + 1
      table.insert(keyboard.inline_keyboard, {})
      count = 0
    end
    table.insert(keyboard.inline_keyboard[row], {['text'] = count_scipts[i][1], ['callback_data'] = 'Script ' .. count_scipts[i][1] .. ' Status ' .. count_scipts[i][3]})
  end
  return keyboard
end

api.send_message(chat_id, 'Pilot online', nil, true, false, nil, api.keyboard():row(api.row():button('Start script'):button('Stop script')):row(api.row():button('Status script'):button('Log')):row(api.row():button('Screenshot')))

local subs = {runing = ' ', stoped = ' '}

function api.on_callback_query(callback_query)
  local script_num, status
  local message = callback_query.message
  if callback_query.data:match('Start') then
    script_num = callback_query.data:match('Start (%d+)')
    if script_num then
      api.edit_message_text(message.chat.id, message.message_id, '  ' .. script_num)
      start_script(script_num)
    end
  elseif callback_query.data:match('Stop') then
    script_num = callback_query.data:match('Stop (%d+)')
    if script_num then
      api.edit_message_text(message.chat.id, message.message_id, '  ' .. script_num)
      stop_script(script_num)
    end
  elseif callback_query.data:match('Status') then
    script_num, status = callback_query.data:match('Script (%d+) Status (%S+)')
    if script_num and status then
      api.edit_message_text(message.chat.id, message.message_id, ' ' .. script_num .. ' ' .. string.gsub(status, '(%w+)', subs))
    end
  end
end

function api.on_message(message)
  if message.chat.id == chat_id then
    if message.text and message.text:match('Screenshot') then
      printscreen (0, 0, 0, 0, 0, 'screen.jpg')
      api.send_photo(chat_id, 'screen.jpg')
    elseif message.text and message.text:match('Start script') then
      api.send_message(message.chat.id, '   :', nil, true, false, nil, start_keyboard())
    elseif message.text and message.text:match('Stop script') then
      api.send_message(message.chat.id, '   :', nil, true, false, nil, stop_keyboard())
    elseif message.text and message.text:match('Status script') then
      api.send_message(message.chat.id, '   :', nil, true, false, nil, status_keyboard())
    elseif message.text and message.text:match('Log') then
      local log_path = 'pilot_log.txt'
      log('save', log_path)
      local log_file = io.open(log_path)
      local log_text = log_file:read('*a')
      log_file:close()
      if #log_text > 0 then
--      api.send_document(message.chat.id, log_path) --       
        api.send_message(message.chat.id, log_text)
      else
        api.send_message(message.chat.id, 'Log ')
      end
    elseif message.text and message.text:match('Terminate') then --           'Terminate # #'  'Terminate '
      local terminate_window = message.text:match('Terminate%s+(.+)')
      if terminate_window then
        local handle = findwindow(terminate_window)
        if handle then
          terminate(terminate_window)
          api.send_message(message.chat.id, ' ' .. terminate_window .. ' ')
        else
          api.send_message(message.chat.id, ' ' .. terminate_window .. '  ')
        end
      end
    end
  end
end

api.run(1, 100)
