-- Module options:
local error_msg_htmlEntities = false
local debug_htmlEntities = false
local ASCII_htmlEntities = true
local register_global_module_htmlEntities = false
local global_module_name_htmlEntities = 'htmlEntities'

local htmlEntities = {
	about = 'HTML entities decoding/encoding',
	version = '1.3.1',
	name = 'htmlEntities-for-lua',
	author = 'Tiago Danin',
	license = 'MIT',
	page = 'https://TiagoDanin.github.io/htmlEntities-for-lua/'
}

if register_global_module_htmlEntities then
	_G[global_module_name_htmlEntities] = htmlEntities
end

local htmlEntities_table = {
	['&Tab;'] = ' ',
	['&NewLine;'] = '\n',
	['&excl;'] = '!',
	['&QUOT;'] = '"',
	['&QUOT'] = '"',
	['&quot;'] = '"',
	['&quot'] = '"',
	['&num;'] = '#',
	['&dollar;'] = '$',
	['&percnt;'] = '%%',
	['&AMP;'] = '&',
	['&AMP'] = '&',
	['&amp;'] = '&',
	['&amp'] = '&',
	['&apos;'] = "'",
	['&lpar;'] = '(',
	['&rpar;'] = ')',
	['&ast;'] = '*',
	['&midast;'] = '*',
	['&plus;'] = '+',
	['&comma;'] = ',',
	['&period;'] = '.',
	['&sol;'] = '/',
	['&colon;'] = ':',
	['&semi;'] = ';',
	['&LT;'] = '<',
	['&LT'] = '<',
	['&lt;'] = '<',
	['&lt'] = '<',
	['&nvlt;'] = '<⃒',
	['&equals;'] = '=',
	['&bne;'] = '=⃥',
	['&GT;'] = '>',
	['&GT'] = '>',
	['&gt;'] = '>',
	['&gt'] = '>',
	['&nvgt;'] = '>⃒',
	['&quest;'] = '?',
	['&commat;'] = '@',
	['&lbrack;'] = '[',
	['&lsqb;'] = '[',
	['&bsol;'] = '\\',
	['&rbrack;'] = ']',
	['&rsqb;'] = ']',
	['&Hat;'] = '^',
	['&UnderBar;'] = '_',
	['&lowbar;'] = '_',
	['&DiacriticalGrave;'] = '`',
	['&grave;'] = '`',
	['&fjlig;'] = 'fj',
	['&lbrace;'] = '{',
	['&lcub;'] = '{',
	['&VerticalLine;'] = '|',
	['&verbar;'] = '|',
	['&vert;'] = '|',
	['&rbrace;'] = '}',
	['&rcub;'] = '}',
	['&NonBreakingSpace;'] = ' ',
	['&nbsp;'] = ' ',
	['&nbsp'] = ' ',
	['&iexcl;'] = '¡',
	['&iexcl'] = '¡',
	['&cent;'] = '¢',
	['&cent'] = '¢',
	['&pound;'] = '£',
	['&pound'] = '£',
	['&curren;'] = '¤',
	['&curren'] = '¤',
	['&yen;'] = '¥',
	['&yen'] = '¥',
	['&brvbar;'] = '¦',
	['&brvbar'] = '¦',
	['&sect;'] = '§',
	['&sect'] = '§',
	['&Dot;'] = '¨',
	['&DoubleDot;'] = '¨',
	['&die;'] = '¨',
	['&uml;'] = '¨',
	['&uml'] = '¨',
	['&COPY;'] = '©',
	['&COPY'] = '©',
	['&copy;'] = '©',
	['&copy'] = '©',
	['&ordf;'] = 'ª',
	['&ordf'] = 'ª',
	['&laquo;'] = '«',
	['&laquo'] = '«',
	['&not;'] = '¬',
	['&not'] = '¬',
	['&shy;'] = '­',
	['&shy'] = '­',
	['&REG;'] = '®',
	['&REG'] = '®',
	['&circledR;'] = '®',
	['&reg;'] = '®',
	['&reg'] = '®',
	['&macr;'] = '¯',
	['&macr'] = '¯',
	['&strns;'] = '¯',
	['&deg;'] = '°',
	['&deg'] = '°',
	['&PlusMinus;'] = '±',
	['&plusmn;'] = '±',
	['&plusmn'] = '±',
	['&pm;'] = '±',
	['&sup2;'] = '²',
	['&sup2'] = '²',
	['&sup3;'] = '³',
	['&sup3'] = '³',
	['&DiacriticalAcute;'] = '´',
	['&acute;'] = '´',
	['&acute'] = '´',
	['&micro;'] = 'µ',
	['&micro'] = 'µ',
	['&para;'] = '¶',
	['&para'] = '¶',
	['&CenterDot;'] = '·',
	['&centerdot;'] = '·',
	['&middot;'] = '·',
	['&middot'] = '·',
	['&Cedilla;'] = '¸',
	['&cedil;'] = '¸',
	['&cedil'] = '¸',
	['&sup1;'] = '¹',
	['&sup1'] = '¹',
	['&ordm;'] = 'º',
	['&ordm'] = 'º',
	['&raquo;'] = '»',
	['&raquo'] = '»',
	['&frac14;'] = '¼',
	['&frac14'] = '¼',
	['&frac12;'] = '½',
	['&frac12'] = '½',
	['&half;'] = '½',
	['&frac34;'] = '¾',
	['&frac34'] = '¾',
	['&iquest;'] = '¿',
	['&iquest'] = '¿',
	['&Agrave;'] = 'À',
	['&Agrave'] = 'À',
	['&Aacute;'] = 'Á',
	['&Aacute'] = 'Á',
	['&Acirc;'] = 'Â',
	['&Acirc'] = 'Â',
	['&Atilde;'] = 'Ã',
	['&Atilde'] = 'Ã',
	['&Auml;'] = 'Ä',
	['&Auml'] = 'Ä',
	['&Aring;'] = 'Å',
	['&Aring'] = 'Å',
	['&angst;'] = 'Å',
	['&AElig;'] = 'Æ',
	['&AElig'] = 'Æ',
	['&Ccedil;'] = 'Ç',
	['&Ccedil'] = 'Ç',
	['&Egrave;'] = 'È',
	['&Egrave'] = 'È',
	['&Eacute;'] = 'É',
	['&Eacute'] = 'É',
	['&Ecirc;'] = 'Ê',
	['&Ecirc'] = 'Ê',
	['&Euml;'] = 'Ë',
	['&Euml'] = 'Ë',
	['&Igrave;'] = 'Ì',
	['&Igrave'] = 'Ì',
	['&Iacute;'] = 'Í',
	['&Iacute'] = 'Í',
	['&Icirc;'] = 'Î',
	['&Icirc'] = 'Î',
	['&Iuml;'] = 'Ï',
	['&Iuml'] = 'Ï',
	['&ETH;'] = 'Ð',
	['&ETH'] = 'Ð',
	['&Ntilde;'] = 'Ñ',
	['&Ntilde'] = 'Ñ',
	['&Ograve;'] = 'Ò',
	['&Ograve'] = 'Ò',
	['&Oacute;'] = 'Ó',
	['&Oacute'] = 'Ó',
	['&Ocirc;'] = 'Ô',
	['&Ocirc'] = 'Ô',
	['&Otilde;'] = 'Õ',
	['&Otilde'] = 'Õ',
	['&Ouml;'] = 'Ö',
	['&Ouml'] = 'Ö',
	['&times;'] = '×',
	['&times'] = '×',
	['&Oslash;'] = 'Ø',
	['&Oslash'] = 'Ø',
	['&Ugrave;'] = 'Ù',
	['&Ugrave'] = 'Ù',
	['&Uacute;'] = 'Ú',
	['&Uacute'] = 'Ú',
	['&Ucirc;'] = 'Û',
	['&Ucirc'] = 'Û',
	['&Uuml;'] = 'Ü',
	['&Uuml'] = 'Ü',
	['&Yacute;'] = 'Ý',
	['&Yacute'] = 'Ý',
	['&THORN;'] = 'Þ',
	['&THORN'] = 'Þ',
	['&szlig;'] = 'ß',
	['&szlig'] = 'ß',
	['&agrave;'] = 'à',
	['&agrave'] = 'à',
	['&aacute;'] = 'á',
	['&aacute'] = 'á',
	['&acirc;'] = 'â',
	['&acirc'] = 'â',
	['&atilde;'] = 'ã',
	['&atilde'] = 'ã',
	['&auml;'] = 'ä',
	['&auml'] = 'ä',
	['&aring;'] = 'å',
	['&aring'] = 'å',
	['&aelig;'] = 'æ',
	['&aelig'] = 'æ',
	['&ccedil;'] = 'ç',
	['&ccedil'] = 'ç',
	['&egrave;'] = 'è',
	['&egrave'] = 'è',
	['&eacute;'] = 'é',
	['&eacute'] = 'é',
	['&ecirc;'] = 'ê',
	['&ecirc'] = 'ê',
	['&euml;'] = 'ë',
	['&euml'] = 'ë',
	['&igrave;'] = 'ì',
	['&igrave'] = 'ì',
	['&iacute;'] = 'í',
	['&iacute'] = 'í',
	['&icirc;'] = 'î',
	['&icirc'] = 'î',
	['&iuml;'] = 'ï',
	['&iuml'] = 'ï',
	['&eth;'] = 'ð',
	['&eth'] = 'ð',
	['&ntilde;'] = 'ñ',
	['&ntilde'] = 'ñ',
	['&ograve;'] = 'ò',
	['&ograve'] = 'ò',
	['&oacute;'] = 'ó',
	['&oacute'] = 'ó',
	['&ocirc;'] = 'ô',
	['&ocirc'] = 'ô',
	['&otilde;'] = 'õ',
	['&otilde'] = 'õ',
	['&ouml;'] = 'ö',
	['&ouml'] = 'ö',
	['&div;'] = '÷',
	['&divide;'] = '÷',
	['&divide'] = '÷',
	['&oslash;'] = 'ø',
	['&oslash'] = 'ø',
	['&ugrave;'] = 'ù',
	['&ugrave'] = 'ù',
	['&uacute;'] = 'ú',
	['&uacute'] = 'ú',
	['&ucirc;'] = 'û',
	['&ucirc'] = 'û',
	['&uuml;'] = 'ü',
	['&uuml'] = 'ü',
	['&yacute;'] = 'ý',
	['&yacute'] = 'ý',
	['&thorn;'] = 'þ',
	['&thorn'] = 'þ',
	['&yuml;'] = 'ÿ',
	['&yuml'] = 'ÿ',
	['&Amacr;'] = 'Ā',
	['&amacr;'] = 'ā',
	['&Abreve;'] = 'Ă',
	['&abreve;'] = 'ă',
	['&Aogon;'] = 'Ą',
	['&aogon;'] = 'ą',
	['&Cacute;'] = 'Ć',
	['&cacute;'] = 'ć',
	['&Ccirc;'] = 'Ĉ',
	['&ccirc;'] = 'ĉ',
	['&Cdot;'] = 'Ċ',
	['&cdot;'] = 'ċ',
	['&Ccaron;'] = 'Č',
	['&ccaron;'] = 'č',
	['&Dcaron;'] = 'Ď',
	['&dcaron;'] = 'ď',
	['&Dstrok;'] = 'Đ',
	['&dstrok;'] = 'đ',
	['&Emacr;'] = 'Ē',
	['&emacr;'] = 'ē',
	['&Edot;'] = 'Ė',
	['&edot;'] = 'ė',
	['&Eogon;'] = 'Ę',
	['&eogon;'] = 'ę',
	['&Ecaron;'] = 'Ě',
	['&ecaron;'] = 'ě',
	['&Gcirc;'] = 'Ĝ',
	['&gcirc;'] = 'ĝ',
	['&Gbreve;'] = 'Ğ',
	['&gbreve;'] = 'ğ',
	['&Gdot;'] = 'Ġ',
	['&gdot;'] = 'ġ',
	['&Gcedil;'] = 'Ģ',
	['&Hcirc;'] = 'Ĥ',
	['&hcirc;'] = 'ĥ',
	['&Hstrok;'] = 'Ħ',
	['&hstrok;'] = 'ħ',
	['&Itilde;'] = 'Ĩ',
	['&itilde;'] = 'ĩ',
	['&Imacr;'] = 'Ī',
	['&imacr;'] = 'ī',
	['&Iogon;'] = 'Į',
	['&iogon;'] = 'į',
	['&Idot;'] = 'İ',
	['&imath;'] = 'ı',
	['&inodot;'] = 'ı',
	['&IJlig;'] = 'Ĳ',
	['&ijlig;'] = 'ĳ',
	['&Jcirc;'] = 'Ĵ',
	['&jcirc;'] = 'ĵ',
	['&Kcedil;'] = 'Ķ',
	['&kcedil;'] = 'ķ',
	['&kgreen;'] = 'ĸ',
	['&Lacute;'] = 'Ĺ',
	['&lacute;'] = 'ĺ',
	['&Lcedil;'] = 'Ļ',
	['&lcedil;'] = 'ļ',
	['&Lcaron;'] = 'Ľ',
	['&lcaron;'] = 'ľ',
	['&Lmidot;'] = 'Ŀ',
	['&lmidot;'] = 'ŀ',
	['&Lstrok;'] = 'Ł',
	['&lstrok;'] = 'ł',
	['&Nacute;'] = 'Ń',
	['&nacute;'] = 'ń',
	['&Ncedil;'] = 'Ņ',
	['&ncedil;'] = 'ņ',
	['&Ncaron;'] = 'Ň',
	['&ncaron;'] = 'ň',
	['&napos;'] = 'ŉ',
	['&ENG;'] = 'Ŋ',
	['&eng;'] = 'ŋ',
	['&Omacr;'] = 'Ō',
	['&omacr;'] = 'ō',
	['&Odblac;'] = 'Ő',
	['&odblac;'] = 'ő',
	['&OElig;'] = 'Œ',
	['&oelig;'] = 'œ',
	['&Racute;'] = 'Ŕ',
	['&racute;'] = 'ŕ',
	['&Rcedil;'] = 'Ŗ',
	['&rcedil;'] = 'ŗ',
	['&Rcaron;'] = 'Ř',
	['&rcaron;'] = 'ř',
	['&Sacute;'] = 'Ś',
	['&sacute;'] = 'ś',
	['&Scirc;'] = 'Ŝ',
	['&scirc;'] = 'ŝ',
	['&Scedil;'] = 'Ş',
	['&scedil;'] = 'ş',
	['&Scaron;'] = 'Š',
	['&scaron;'] = 'š',
	['&Tcedil;'] = 'Ţ',
	['&tcedil;'] = 'ţ',
	['&Tcaron;'] = 'Ť',
	['&tcaron;'] = 'ť',
	['&Tstrok;'] = 'Ŧ',
	['&tstrok;'] = 'ŧ',
	['&Utilde;'] = 'Ũ',
	['&utilde;'] = 'ũ',
	['&Umacr;'] = 'Ū',
	['&umacr;'] = 'ū',
	['&Ubreve;'] = 'Ŭ',
	['&ubreve;'] = 'ŭ',
	['&Uring;'] = 'Ů',
	['&uring;'] = 'ů',
	['&Udblac;'] = 'Ű',
	['&udblac;'] = 'ű',
	['&Uogon;'] = 'Ų',
	['&uogon;'] = 'ų',
	['&Wcirc;'] = 'Ŵ',
	['&wcirc;'] = 'ŵ',
	['&Ycirc;'] = 'Ŷ',
	['&ycirc;'] = 'ŷ',
	['&Yuml;'] = 'Ÿ',
	['&Zacute;'] = 'Ź',
	['&zacute;'] = 'ź',
	['&Zdot;'] = 'Ż',
	['&zdot;'] = 'ż',
	['&Zcaron;'] = 'Ž',
	['&zcaron;'] = 'ž',
	['&fnof;'] = 'ƒ',
	['&imped;'] = 'Ƶ',
	['&gacute;'] = 'ǵ',
	['&jmath;'] = 'ȷ',
	['&circ;'] = 'ˆ',
	['&Hacek;'] = 'ˇ',
	['&caron;'] = 'ˇ',
	['&Breve;'] = '˘',
	['&breve;'] = '˘',
	['&DiacriticalDot;'] = '˙',
	['&dot;'] = '˙',
	['&ring;'] = '˚',
	['&ogon;'] = '˛',
	['&DiacriticalTilde;'] = '˜',
	['&tilde;'] = '˜',
	['&DiacriticalDoubleAcute;'] = '˝',
	['&dblac;'] = '˝',
	['&DownBreve;'] = '̑',
	['&Alpha;'] = 'Α',
	['&Beta;'] = 'Β',
	['&Gamma;'] = 'Γ',
	['&Delta;'] = 'Δ',
	['&Epsilon;'] = 'Ε',
	['&Zeta;'] = 'Ζ',
	['&Eta;'] = 'Η',
	['&Theta;'] = 'Θ',
	['&Iota;'] = 'Ι',
	['&Kappa;'] = 'Κ',
	['&Lambda;'] = 'Λ',
	['&Mu;'] = 'Μ',
	['&Nu;'] = 'Ν',
	['&Xi;'] = 'Ξ',
	['&Omicron;'] = 'Ο',
	['&Pi;'] = 'Π',
	['&Rho;'] = 'Ρ',
	['&Sigma;'] = 'Σ',
	['&Tau;'] = 'Τ',
	['&Upsilon;'] = 'Υ',
	['&Phi;'] = 'Φ',
	['&Chi;'] = 'Χ',
	['&Psi;'] = 'Ψ',
	['&Omega;'] = 'Ω',
	['&ohm;'] = 'Ω',
	['&alpha;'] = 'α',
	['&beta;'] = 'β',
	['&gamma;'] = 'γ',
	['&delta;'] = 'δ',
	['&epsi;'] = 'ε',
	['&epsilon;'] = 'ε',
	['&zeta;'] = 'ζ',
	['&eta;'] = 'η',
	['&theta;'] = 'θ',
	['&iota;'] = 'ι',
	['&kappa;'] = 'κ',
	['&lambda;'] = 'λ',
	['&mu;'] = 'μ',
	['&nu;'] = 'ν',
	['&xi;'] = 'ξ',
	['&omicron;'] = 'ο',
	['&pi;'] = 'π',
	['&rho;'] = 'ρ',
	['&sigmaf;'] = 'ς',
	['&sigmav;'] = 'ς',
	['&varsigma;'] = 'ς',
	['&sigma;'] = 'σ',
	['&tau;'] = 'τ',
	['&upsi;'] = 'υ',
	['&upsilon;'] = 'υ',
	['&phi;'] = 'φ',
	['&chi;'] = 'χ',
	['&psi;'] = 'ψ',
	['&omega;'] = 'ω',
	['&thetasym;'] = 'ϑ',
	['&thetav;'] = 'ϑ',
	['&vartheta;'] = 'ϑ',
	['&Upsi;'] = 'ϒ',
	['&upsih;'] = 'ϒ',
	['&phiv;'] = 'ϕ',
	['&straightphi;'] = 'ϕ',
	['&varphi;'] = 'ϕ',
	['&piv;'] = 'ϖ',
	['&varpi;'] = 'ϖ',
	['&Gammad;'] = 'Ϝ',
	['&digamma;'] = 'ϝ',
	['&gammad;'] = 'ϝ',
	['&kappav;'] = 'ϰ',
	['&varkappa;'] = 'ϰ',
	['&rhov;'] = 'ϱ',
	['&varrho;'] = 'ϱ',
	['&epsiv;'] = 'ϵ',
	['&straightepsilon;'] = 'ϵ',
	['&varepsilon;'] = 'ϵ',
	['&backepsilon;'] = '϶',
	['&bepsi;'] = '϶',
	['&IOcy;'] = 'Ё',
	['&DJcy;'] = 'Ђ',
	['&GJcy;'] = 'Ѓ',
	['&Jukcy;'] = 'Є',
	['&DScy;'] = 'Ѕ',
	['&Iukcy;'] = 'І',
	['&YIcy;'] = 'Ї',
	['&Jsercy;'] = 'Ј',
	['&LJcy;'] = 'Љ',
	['&NJcy;'] = 'Њ',
	['&TSHcy;'] = 'Ћ',
	['&KJcy;'] = 'Ќ',
	['&Ubrcy;'] = 'Ў',
	['&DZcy;'] = 'Џ',
	['&Acy;'] = 'А',
	['&Bcy;'] = 'Б',
	['&Vcy;'] = 'В',
	['&Gcy;'] = 'Г',
	['&Dcy;'] = 'Д',
	['&IEcy;'] = 'Е',
	['&ZHcy;'] = 'Ж',
	['&Zcy;'] = 'З',
	['&Icy;'] = 'И',
	['&Jcy;'] = 'Й',
	['&Kcy;'] = 'К',
	['&Lcy;'] = 'Л',
	['&Mcy;'] = 'М',
	['&Ncy;'] = 'Н',
	['&Ocy;'] = 'О',
	['&Pcy;'] = 'П',
	['&Rcy;'] = 'Р',
	['&Scy;'] = 'С',
	['&Tcy;'] = 'Т',
	['&Ucy;'] = 'У',
	['&Fcy;'] = 'Ф',
	['&KHcy;'] = 'Х',
	['&TScy;'] = 'Ц',
	['&CHcy;'] = 'Ч',
	['&SHcy;'] = 'Ш',
	['&SHCHcy;'] = 'Щ',
	['&HARDcy;'] = 'Ъ',
	['&Ycy;'] = 'Ы',
	['&SOFTcy;'] = 'Ь',
	['&Ecy;'] = 'Э',
	['&YUcy;'] = 'Ю',
	['&YAcy;'] = 'Я',
	['&acy;'] = 'а',
	['&bcy;'] = 'б',
	['&vcy;'] = 'в',
	['&gcy;'] = 'г',
	['&dcy;'] = 'д',
	['&iecy;'] = 'е',
	['&zhcy;'] = 'ж',
	['&zcy;'] = 'з',
	['&icy;'] = 'и',
	['&jcy;'] = 'й',
	['&kcy;'] = 'к',
	['&lcy;'] = 'л',
	['&mcy;'] = 'м',
	['&ncy;'] = 'н',
	['&ocy;'] = 'о',
	['&pcy;'] = 'п',
	['&rcy;'] = 'р',
	['&scy;'] = 'с',
	['&tcy;'] = 'т',
	['&ucy;'] = 'у',
	['&fcy;'] = 'ф',
	['&khcy;'] = 'х',
	['&tscy;'] = 'ц',
	['&chcy;'] = 'ч',
	['&shcy;'] = 'ш',
	['&shchcy;'] = 'щ',
	['&hardcy;'] = 'ъ',
	['&ycy;'] = 'ы',
	['&softcy;'] = 'ь',
	['&ecy;'] = 'э',
	['&yucy;'] = 'ю',
	['&yacy;'] = 'я',
	['&iocy;'] = 'ё',
	['&djcy;'] = 'ђ',
	['&gjcy;'] = 'ѓ',
	['&jukcy;'] = 'є',
	['&dscy;'] = 'ѕ',
	['&iukcy;'] = 'і',
	['&yicy;'] = 'ї',
	['&jsercy;'] = 'ј',
	['&ljcy;'] = 'љ',
	['&njcy;'] = 'њ',
	['&tshcy;'] = 'ћ',
	['&kjcy;'] = 'ќ',
	['&ubrcy;'] = 'ў',
	['&dzcy;'] = 'џ',
	['&ensp;'] = ' ',
	['&emsp;'] = ' ',
	['&emsp13;'] = ' ',
	['&emsp14;'] = ' ',
	['&numsp;'] = ' ',
	['&puncsp;'] = ' ',
	['&ThinSpace;'] = ' ',
	['&thinsp;'] = ' ',
	['&VeryThinSpace;'] = ' ',
	['&hairsp;'] = ' ',
	['&NegativeMediumSpace;'] = '​',
	['&NegativeThickSpace;'] = '​',
	['&NegativeThinSpace;'] = '​',
	['&NegativeVeryThinSpace;'] = '​',
	['&ZeroWidthSpace;'] = '​',
	['&zwnj;'] = '‌',
	['&zwj;'] = '‍',
	['&lrm;'] = '‎',
	['&rlm;'] = '‏',
	['&dash;'] = '‐',
	['&hyphen;'] = '‐',
	['&ndash;'] = '–',
	['&mdash;'] = '—',
	['&horbar;'] = '―',
	['&Verbar;'] = '‖',
	['&Vert;'] = '‖',
	['&OpenCurlyQuote;'] = '‘',
	['&lsquo;'] = '‘',
	['&CloseCurlyQuote;'] = '’',
	['&rsquo;'] = '’',
	['&rsquor;'] = '’',
	['&lsquor;'] = '‚',
	['&sbquo;'] = '‚',
	['&OpenCurlyDoubleQuote;'] = '“',
	['&ldquo;'] = '“',
	['&CloseCurlyDoubleQuote;'] = '”',
	['&rdquo;'] = '”',
	['&rdquor;'] = '”',
	['&bdquo;'] = '„',
	['&ldquor;'] = '„',
	['&dagger;'] = '†',
	['&Dagger;'] = '‡',
	['&ddagger;'] = '‡',
	['&bull;'] = '•',
	['&bullet;'] = '•',
	['&nldr;'] = '‥',
	['&hellip;'] = '…',
	['&mldr;'] = '…',
	['&permil;'] = '‰',
	['&pertenk;'] = '‱',
	['&prime;'] = '′',
	['&Prime;'] = '″',
	['&tprime;'] = '‴',
	['&backprime;'] = '‵',
	['&bprime;'] = '‵',
	['&lsaquo;'] = '‹',
	['&rsaquo;'] = '›',
	['&OverBar;'] = '‾',
	['&oline;'] = '‾',
	['&caret;'] = '⁁',
	['&hybull;'] = '⁃',
	['&frasl;'] = '⁄',
	['&bsemi;'] = '⁏',
	['&qprime;'] = '⁗',
	['&MediumSpace;'] = ' ',
	['&ThickSpace;'] = '  ',
	['&NoBreak;'] = '⁠',
	['&ApplyFunction;'] = '⁡',
	['&af;'] = '⁡',
	['&InvisibleTimes;'] = '⁢',
	['&it;'] = '⁢',
	['&InvisibleComma;'] = '⁣',
	['&ic;'] = '⁣',
	['&euro;'] = '€',
	['&TripleDot;'] = '⃛',
	['&tdot;'] = '⃛',
	['&DotDot;'] = '⃜',
	['&Copf;'] = 'ℂ',
	['&complexes;'] = 'ℂ',
	['&incare;'] = '℅',
	['&gscr;'] = 'ℊ',
	['&HilbertSpace;'] = 'ℋ',
	['&Hscr;'] = 'ℋ',
	['&hamilt;'] = 'ℋ',
	['&Hfr;'] = 'ℌ',
	['&Poincareplane;'] = 'ℌ',
	['&Hopf;'] = 'ℍ',
	['&quaternions;'] = 'ℍ',
	['&planckh;'] = 'ℎ',
	['&hbar;'] = 'ℏ',
	['&hslash;'] = 'ℏ',
	['&planck;'] = 'ℏ',
	['&plankv;'] = 'ℏ',
	['&Iscr;'] = 'ℐ',
	['&imagline;'] = 'ℐ',
	['&Ifr;'] = 'ℑ',
	['&Im;'] = 'ℑ',
	['&image;'] = 'ℑ',
	['&imagpart;'] = 'ℑ',
	['&Laplacetrf;'] = 'ℒ',
	['&Lscr;'] = 'ℒ',
	['&lagran;'] = 'ℒ',
	['&ell;'] = 'ℓ',
	['&Nopf;'] = 'ℕ',
	['&naturals;'] = 'ℕ',
	['&numero;'] = '№',
	['&copysr;'] = '℗',
	['&weierp;'] = '℘',
	['&wp;'] = '℘',
	['&Popf;'] = 'ℙ',
	['&primes;'] = 'ℙ',
	['&Qopf;'] = 'ℚ',
	['&rationals;'] = 'ℚ',
	['&Rscr;'] = 'ℛ',
	['&realine;'] = 'ℛ',
	['&Re;'] = 'ℜ',
	['&Rfr;'] = 'ℜ',
	['&real;'] = 'ℜ',
	['&realpart;'] = 'ℜ',
	['&Ropf;'] = 'ℝ',
	['&reals;'] = 'ℝ',
	['&rx;'] = '℞',
	['&TRADE;'] = '™',
	['&trade;'] = '™',
	['&Zopf;'] = 'ℤ',
	['&integers;'] = 'ℤ',
	['&mho;'] = '℧',
	['&Zfr;'] = 'ℨ',
	['&zeetrf;'] = 'ℨ',
	['&iiota;'] = '℩',
	['&Bernoullis;'] = 'ℬ',
	['&Bscr;'] = 'ℬ',
	['&bernou;'] = 'ℬ',
	['&Cayleys;'] = 'ℭ',
	['&Cfr;'] = 'ℭ',
	['&escr;'] = 'ℯ',
	['&Escr;'] = 'ℰ',
	['&expectation;'] = 'ℰ',
	['&Fouriertrf;'] = 'ℱ',
	['&Fscr;'] = 'ℱ',
	['&Mellintrf;'] = 'ℳ',
	['&Mscr;'] = 'ℳ',
	['&phmmat;'] = 'ℳ',
	['&order;'] = 'ℴ',
	['&orderof;'] = 'ℴ',
	['&oscr;'] = 'ℴ',
	['&alefsym;'] = 'ℵ',
	['&aleph;'] = 'ℵ',
	['&beth;'] = 'ℶ',
	['&gimel;'] = 'ℷ',
	['&daleth;'] = 'ℸ',
	['&CapitalDifferentialD;'] = 'ⅅ',
	['&DD;'] = 'ⅅ',
	['&DifferentialD;'] = 'ⅆ',
	['&dd;'] = 'ⅆ',
	['&ExponentialE;'] = 'ⅇ',
	['&ee;'] = 'ⅇ',
	['&exponentiale;'] = 'ⅇ',
	['&ImaginaryI;'] = 'ⅈ',
	['&ii;'] = 'ⅈ',
	['&frac13;'] = '⅓',
	['&frac23;'] = '⅔',
	['&frac15;'] = '⅕',
	['&frac25;'] = '⅖',
	['&frac35;'] = '⅗',
	['&frac45;'] = '⅘',
	['&frac16;'] = '⅙',
	['&frac56;'] = '⅚',
	['&frac18;'] = '⅛',
	['&frac38;'] = '⅜',
	['&frac58;'] = '⅝',
	['&frac78;'] = '⅞',
	['&LeftArrow;'] = '←',
	['&ShortLeftArrow;'] = '←',
	['&larr;'] = '←',
	['&leftarrow;'] = '←',
	['&slarr;'] = '←',
	['&ShortUpArrow;'] = '↑',
	['&UpArrow;'] = '↑',
	['&uarr;'] = '↑',
	['&uparrow;'] = '↑',
	['&RightArrow;'] = '→',
	['&ShortRightArrow;'] = '→',
	['&rarr;'] = '→',
	['&rightarrow;'] = '→',
	['&srarr;'] = '→',
	['&DownArrow;'] = '↓',
	['&ShortDownArrow;'] = '↓',
	['&darr;'] = '↓',
	['&downarrow;'] = '↓',
	['&LeftRightArrow;'] = '↔',
	['&harr;'] = '↔',
	['&leftrightarrow;'] = '↔',
	['&UpDownArrow;'] = '↕',
	['&updownarrow;'] = '↕',
	['&varr;'] = '↕',
	['&UpperLeftArrow;'] = '↖',
	['&nwarr;'] = '↖',
	['&nwarrow;'] = '↖',
	['&UpperRightArrow;'] = '↗',
	['&nearr;'] = '↗',
	['&nearrow;'] = '↗',
	['&LowerRightArrow;'] = '↘',
	['&searr;'] = '↘',
	['&searrow;'] = '↘',
	['&LowerLeftArrow;'] = '↙',
	['&swarr;'] = '↙',
	['&swarrow;'] = '↙',
	['&nlarr;'] = '↚',
	['&nleftarrow;'] = '↚',
	['&nrarr;'] = '↛',
	['&nrightarrow;'] = '↛',
	['&rarrw;'] = '↝',
	['&rightsquigarrow;'] = '↝',
	['&nrarrw;'] = '↝̸',
	['&Larr;'] = '↞',
	['&twoheadleftarrow;'] = '↞',
	['&Uarr;'] = '↟',
	['&Rarr;'] = '↠',
	['&twoheadrightarrow;'] = '↠',
	['&Darr;'] = '↡',
	['&larrtl;'] = '↢',
	['&leftarrowtail;'] = '↢',
	['&rarrtl;'] = '↣',
	['&rightarrowtail;'] = '↣',
	['&LeftTeeArrow;'] = '↤',
	['&mapstoleft;'] = '↤',
	['&UpTeeArrow;'] = '↥',
	['&mapstoup;'] = '↥',
	['&RightTeeArrow;'] = '↦',
	['&map;'] = '↦',
	['&mapsto;'] = '↦',
	['&DownTeeArrow;'] = '↧',
	['&mapstodown;'] = '↧',
	['&hookleftarrow;'] = '↩',
	['&larrhk;'] = '↩',
	['&hookrightarrow;'] = '↪',
	['&rarrhk;'] = '↪',
	['&larrlp;'] = '↫',
	['&looparrowleft;'] = '↫',
	['&looparrowright;'] = '↬',
	['&rarrlp;'] = '↬',
	['&harrw;'] = '↭',
	['&leftrightsquigarrow;'] = '↭',
	['&nharr;'] = '↮',
	['&nleftrightarrow;'] = '↮',
	['&Lsh;'] = '↰',
	['&lsh;'] = '↰',
	['&Rsh;'] = '↱',
	['&rsh;'] = '↱',
	['&ldsh;'] = '↲',
	['&rdsh;'] = '↳',
	['&crarr;'] = '↵',
	['&cularr;'] = '↶',
	['&curvearrowleft;'] = '↶',
	['&curarr;'] = '↷',
	['&curvearrowright;'] = '↷',
	['&circlearrowleft;'] = '↺',
	['&olarr;'] = '↺',
	['&circlearrowright;'] = '↻',
	['&orarr;'] = '↻',
	['&LeftVector;'] = '↼',
	['&leftharpoonup;'] = '↼',
	['&lharu;'] = '↼',
	['&DownLeftVector;'] = '↽',
	['&leftharpoondown;'] = '↽',
	['&lhard;'] = '↽',
	['&RightUpVector;'] = '↾',
	['&uharr;'] = '↾',
	['&upharpoonright;'] = '↾',
	['&LeftUpVector;'] = '↿',
	['&uharl;'] = '↿',
	['&upharpoonleft;'] = '↿',
	['&RightVector;'] = '⇀',
	['&rharu;'] = '⇀',
	['&rightharpoonup;'] = '⇀',
	['&DownRightVector;'] = '⇁',
	['&rhard;'] = '⇁',
	['&rightharpoondown;'] = '⇁',
	['&RightDownVector;'] = '⇂',
	['&dharr;'] = '⇂',
	['&downharpoonright;'] = '⇂',
	['&LeftDownVector;'] = '⇃',
	['&dharl;'] = '⇃',
	['&downharpoonleft;'] = '⇃',
	['&RightArrowLeftArrow;'] = '⇄',
	['&rightleftarrows;'] = '⇄',
	['&rlarr;'] = '⇄',
	['&UpArrowDownArrow;'] = '⇅',
	['&udarr;'] = '⇅',
	['&LeftArrowRightArrow;'] = '⇆',
	['&leftrightarrows;'] = '⇆',
	['&lrarr;'] = '⇆',
	['&leftleftarrows;'] = '⇇',
	['&llarr;'] = '⇇',
	['&upuparrows;'] = '⇈',
	['&uuarr;'] = '⇈',
	['&rightrightarrows;'] = '⇉',
	['&rrarr;'] = '⇉',
	['&ddarr;'] = '⇊',
	['&downdownarrows;'] = '⇊',
	['&ReverseEquilibrium;'] = '⇋',
	['&leftrightharpoons;'] = '⇋',
	['&lrhar;'] = '⇋',
	['&Equilibrium;'] = '⇌',
	['&rightleftharpoons;'] = '⇌',
	['&rlhar;'] = '⇌',
	['&nLeftarrow;'] = '⇍',
	['&nlArr;'] = '⇍',
	['&nLeftrightarrow;'] = '⇎',
	['&nhArr;'] = '⇎',
	['&nRightarrow;'] = '⇏',
	['&nrArr;'] = '⇏',
	['&DoubleLeftArrow;'] = '⇐',
	['&Leftarrow;'] = '⇐',
	['&lArr;'] = '⇐',
	['&DoubleUpArrow;'] = '⇑',
	['&Uparrow;'] = '⇑',
	['&uArr;'] = '⇑',
	['&DoubleRightArrow;'] = '⇒',
	['&Implies;'] = '⇒',
	['&Rightarrow;'] = '⇒',
	['&rArr;'] = '⇒',
	['&DoubleDownArrow;'] = '⇓',
	['&Downarrow;'] = '⇓',
	['&dArr;'] = '⇓',
	['&DoubleLeftRightArrow;'] = '⇔',
	['&Leftrightarrow;'] = '⇔',
	['&hArr;'] = '⇔',
	['&iff;'] = '⇔',
	['&DoubleUpDownArrow;'] = '⇕',
	['&Updownarrow;'] = '⇕',
	['&vArr;'] = '⇕',
	['&nwArr;'] = '⇖',
	['&neArr;'] = '⇗',
	['&seArr;'] = '⇘',
	['&swArr;'] = '⇙',
	['&Lleftarrow;'] = '⇚',
	['&lAarr;'] = '⇚',
	['&Rrightarrow;'] = '⇛',
	['&rAarr;'] = '⇛',
	['&zigrarr;'] = '⇝',
	['&LeftArrowBar;'] = '⇤',
	['&larrb;'] = '⇤',
	['&RightArrowBar;'] = '⇥',
	['&rarrb;'] = '⇥',
	['&DownArrowUpArrow;'] = '⇵',
	['&duarr;'] = '⇵',
	['&loarr;'] = '⇽',
	['&roarr;'] = '⇾',
	['&hoarr;'] = '⇿',
	['&ForAll;'] = '∀',
	['&forall;'] = '∀',
	['&comp;'] = '∁',
	['&complement;'] = '∁',
	['&PartialD;'] = '∂',
	['&part;'] = '∂',
	['&npart;'] = '∂̸',
	['&Exists;'] = '∃',
	['&exist;'] = '∃',
	['&NotExists;'] = '∄',
	['&nexist;'] = '∄',
	['&nexists;'] = '∄',
	['&empty;'] = '∅',
	['&emptyset;'] = '∅',
	['&emptyv;'] = '∅',
	['&varnothing;'] = '∅',
	['&Del;'] = '∇',
	['&nabla;'] = '∇',
	['&Element;'] = '∈',
	['&in;'] = '∈',
	['&isin;'] = '∈',
	['&isinv;'] = '∈',
	['&NotElement;'] = '∉',
	['&notin;'] = '∉',
	['&notinva;'] = '∉',
	['&ReverseElement;'] = '∋',
	['&SuchThat;'] = '∋',
	['&ni;'] = '∋',
	['&niv;'] = '∋',
	['&NotReverseElement;'] = '∌',
	['&notni;'] = '∌',
	['&notniva;'] = '∌',
	['&Product;'] = '∏',
	['&prod;'] = '∏',
	['&Coproduct;'] = '∐',
	['&coprod;'] = '∐',
	['&Sum;'] = '∑',
	['&sum;'] = '∑',
	['&minus;'] = '−',
	['&MinusPlus;'] = '∓',
	['&mnplus;'] = '∓',
	['&mp;'] = '∓',
	['&dotplus;'] = '∔',
	['&plusdo;'] = '∔',
	['&Backslash;'] = '∖',
	['&setminus;'] = '∖',
	['&setmn;'] = '∖',
	['&smallsetminus;'] = '∖',
	['&ssetmn;'] = '∖',
	['&lowast;'] = '∗',
	['&SmallCircle;'] = '∘',
	['&compfn;'] = '∘',
	['&Sqrt;'] = '√',
	['&radic;'] = '√',
	['&Proportional;'] = '∝',
	['&prop;'] = '∝',
	['&propto;'] = '∝',
	['&varpropto;'] = '∝',
	['&vprop;'] = '∝',
	['&infin;'] = '∞',
	['&angrt;'] = '∟',
	['&ang;'] = '∠',
	['&angle;'] = '∠',
	['&nang;'] = '∠⃒',
	['&angmsd;'] = '∡',
	['&measuredangle;'] = '∡',
	['&angsph;'] = '∢',
	['&VerticalBar;'] = '∣',
	['&mid;'] = '∣',
	['&shortmid;'] = '∣',
	['&smid;'] = '∣',
	['&NotVerticalBar;'] = '∤',
	['&nmid;'] = '∤',
	['&nshortmid;'] = '∤',
	['&nsmid;'] = '∤',
	['&DoubleVerticalBar;'] = '∥',
	['&par;'] = '∥',
	['&parallel;'] = '∥',
	['&shortparallel;'] = '∥',
	['&spar;'] = '∥',
	['&NotDoubleVerticalBar;'] = '∦',
	['&npar;'] = '∦',
	['&nparallel;'] = '∦',
	['&nshortparallel;'] = '∦',
	['&nspar;'] = '∦',
	['&and;'] = '∧',
	['&wedge;'] = '∧',
	['&or;'] = '∨',
	['&vee;'] = '∨',
	['&cap;'] = '∩',
	['&caps;'] = '∩︀',
	['&cup;'] = '∪',
	['&cups;'] = '∪︀',
	['&Integral;'] = '∫',
	['&int;'] = '∫',
	['&Int;'] = '∬',
	['&iiint;'] = '∭',
	['&tint;'] = '∭',
	['&ContourIntegral;'] = '∮',
	['&conint;'] = '∮',
	['&oint;'] = '∮',
	['&Conint;'] = '∯',
	['&DoubleContourIntegral;'] = '∯',
	['&Cconint;'] = '∰',
	['&cwint;'] = '∱',
	['&ClockwiseContourIntegral;'] = '∲',
	['&cwconint;'] = '∲',
	['&CounterClockwiseContourIntegral;'] = '∳',
	['&awconint;'] = '∳',
	['&Therefore;'] = '∴',
	['&there4;'] = '∴',
	['&therefore;'] = '∴',
	['&Because;'] = '∵',
	['&becaus;'] = '∵',
	['&because;'] = '∵',
	['&ratio;'] = '∶',
	['&Colon;'] = '∷',
	['&Proportion;'] = '∷',
	['&dotminus;'] = '∸',
	['&minusd;'] = '∸',
	['&mDDot;'] = '∺',
	['&homtht;'] = '∻',
	['&Tilde;'] = '∼',
	['&sim;'] = '∼',
	['&thicksim;'] = '∼',
	['&thksim;'] = '∼',
	['&nvsim;'] = '∼⃒',
	['&backsim;'] = '∽',
	['&bsim;'] = '∽',
	['&race;'] = '∽̱',
	['&ac;'] = '∾',
	['&mstpos;'] = '∾',
	['&acE;'] = '∾̳',
	['&acd;'] = '∿',
	['&VerticalTilde;'] = '≀',
	['&wr;'] = '≀',
	['&wreath;'] = '≀',
	['&NotTilde;'] = '≁',
	['&nsim;'] = '≁',
	['&EqualTilde;'] = '≂',
	['&eqsim;'] = '≂',
	['&esim;'] = '≂',
	['&nesim;'] = '≂̸',
	['&NotEqualTilde;'] = '≂̸',
	['&TildeEqual;'] = '≃',
	['&sime;'] = '≃',
	['&simeq;'] = '≃',
	['&NotTildeEqual;'] = '≄',
	['&nsime;'] = '≄',
	['&nsimeq;'] = '≄',
	['&TildeFullEqual;'] = '≅',
	['&cong;'] = '≅',
	['&simne;'] = '≆',
	['&NotTildeFullEqual;'] = '≇',
	['&ncong;'] = '≇',
	['&TildeTilde;'] = '≈',
	['&ap;'] = '≈',
	['&approx;'] = '≈',
	['&asymp;'] = '≈',
	['&thickapprox;'] = '≈',
	['&thkap;'] = '≈',
	['&NotTildeTilde;'] = '≉',
	['&nap;'] = '≉',
	['&napprox;'] = '≉',
	['&ape;'] = '≊',
	['&approxeq;'] = '≊',
	['&apid;'] = '≋',
	['&napid;'] = '≋̸',
	['&backcong;'] = '≌',
	['&bcong;'] = '≌',
	['&CupCap;'] = '≍',
	['&asympeq;'] = '≍',
	['&nvap;'] = '≍⃒',
	['&Bumpeq;'] = '≎',
	['&HumpDownHump;'] = '≎',
	['&bump;'] = '≎',
	['&nbump;'] = '≎̸',
	['&NotHumpDownHump;'] = '≎̸',
	['&HumpEqual;'] = '≏',
	['&bumpe;'] = '≏',
	['&bumpeq;'] = '≏',
	['&nbumpe;'] = '≏̸',
	['&NotHumpEqual;'] = '≏̸',
	['&DotEqual;'] = '≐',
	['&doteq;'] = '≐',
	['&esdot;'] = '≐',
	['&nedot;'] = '≐̸',
	['&doteqdot;'] = '≑',
	['&eDot;'] = '≑',
	['&efDot;'] = '≒',
	['&fallingdotseq;'] = '≒',
	['&erDot;'] = '≓',
	['&risingdotseq;'] = '≓',
	['&Assign;'] = '≔',
	['&colone;'] = '≔',
	['&coloneq;'] = '≔',
	['&ecolon;'] = '≕',
	['&eqcolon;'] = '≕',
	['&ecir;'] = '≖',
	['&eqcirc;'] = '≖',
	['&circeq;'] = '≗',
	['&cire;'] = '≗',
	['&wedgeq;'] = '≙',
	['&veeeq;'] = '≚',
	['&triangleq;'] = '≜',
	['&trie;'] = '≜',
	['&equest;'] = '≟',
	['&questeq;'] = '≟',
	['&NotEqual;'] = '≠',
	['&ne;'] = '≠',
	['&Congruent;'] = '≡',
	['&equiv;'] = '≡',
	['&bnequiv;'] = '≡⃥',
	['&NotCongruent;'] = '≢',
	['&nequiv;'] = '≢',
	['&le;'] = '≤',
	['&leq;'] = '≤',
	['&nvle;'] = '≤⃒',
	['&GreaterEqual;'] = '≥',
	['&ge;'] = '≥',
	['&geq;'] = '≥',
	['&nvge;'] = '≥⃒',
	['&LessFullEqual;'] = '≦',
	['&lE;'] = '≦',
	['&leqq;'] = '≦',
	['&nlE;'] = '≦̸',
	['&nleqq;'] = '≦̸',
	['&GreaterFullEqual;'] = '≧',
	['&gE;'] = '≧',
	['&geqq;'] = '≧',
	['&ngE;'] = '≧̸',
	['&ngeqq;'] = '≧̸',
	['&NotGreaterFullEqual;'] = '≧̸',
	['&lnE;'] = '≨',
	['&lneqq;'] = '≨',
	['&lvertneqq;'] = '≨︀',
	['&lvnE;'] = '≨︀',
	['&gnE;'] = '≩',
	['&gneqq;'] = '≩',
	['&gvertneqq;'] = '≩︀',
	['&gvnE;'] = '≩︀',
	['&Lt;'] = '≪',
	['&NestedLessLess;'] = '≪',
	['&ll;'] = '≪',
	['&nLtv;'] = '≪̸',
	['&NotLessLess;'] = '≪̸',
	['&nLt;'] = '≪⃒',
	['&Gt;'] = '≫',
	['&NestedGreaterGreater;'] = '≫',
	['&gg;'] = '≫',
	['&nGtv;'] = '≫̸',
	['&NotGreaterGreater;'] = '≫̸',
	['&nGt;'] = '≫⃒',
	['&between;'] = '≬',
	['&twixt;'] = '≬',
	['&NotCupCap;'] = '≭',
	['&NotLess;'] = '≮',
	['&nless;'] = '≮',
	['&nlt;'] = '≮',
	['&NotGreater;'] = '≯',
	['&ngt;'] = '≯',
	['&ngtr;'] = '≯',
	['&NotLessEqual;'] = '≰',
	['&nle;'] = '≰',
	['&nleq;'] = '≰',
	['&NotGreaterEqual;'] = '≱',
	['&nge;'] = '≱',
	['&ngeq;'] = '≱',
	['&LessTilde;'] = '≲',
	['&lesssim;'] = '≲',
	['&lsim;'] = '≲',
	['&GreaterTilde;'] = '≳',
	['&gsim;'] = '≳',
	['&gtrsim;'] = '≳',
	['&NotLessTilde;'] = '≴',
	['&nlsim;'] = '≴',
	['&NotGreaterTilde;'] = '≵',
	['&ngsim;'] = '≵',
	['&LessGreater;'] = '≶',
	['&lessgtr;'] = '≶',
	['&lg;'] = '≶',
	['&GreaterLess;'] = '≷',
	['&gl;'] = '≷',
	['&gtrless;'] = '≷',
	['&NotLessGreater;'] = '≸',
	['&ntlg;'] = '≸',
	['&NotGreaterLess;'] = '≹',
	['&ntgl;'] = '≹',
	['&Precedes;'] = '≺',
	['&pr;'] = '≺',
	['&prec;'] = '≺',
	['&Succeeds;'] = '≻',
	['&sc;'] = '≻',
	['&succ;'] = '≻',
	['&PrecedesSlantEqual;'] = '≼',
	['&prcue;'] = '≼',
	['&preccurlyeq;'] = '≼',
	['&SucceedsSlantEqual;'] = '≽',
	['&sccue;'] = '≽',
	['&succcurlyeq;'] = '≽',
	['&PrecedesTilde;'] = '≾',
	['&precsim;'] = '≾',
	['&prsim;'] = '≾',
	['&SucceedsTilde;'] = '≿',
	['&scsim;'] = '≿',
	['&succsim;'] = '≿',
	['&NotSucceedsTilde;'] = '≿̸',
	['&NotPrecedes;'] = '⊀',
	['&npr;'] = '⊀',
	['&nprec;'] = '⊀',
	['&NotSucceeds;'] = '⊁',
	['&nsc;'] = '⊁',
	['&nsucc;'] = '⊁',
	['&sub;'] = '⊂',
	['&subset;'] = '⊂',
	['&NotSubset;'] = '⊂⃒',
	['&nsubset;'] = '⊂⃒',
	['&vnsub;'] = '⊂⃒',
	['&Superset;'] = '⊃',
	['&sup;'] = '⊃',
	['&supset;'] = '⊃',
	['&NotSuperset;'] = '⊃⃒',
	['&nsupset;'] = '⊃⃒',
	['&vnsup;'] = '⊃⃒',
	['&nsub;'] = '⊄',
	['&nsup;'] = '⊅',
	['&SubsetEqual;'] = '⊆',
	['&sube;'] = '⊆',
	['&subseteq;'] = '⊆',
	['&SupersetEqual;'] = '⊇',
	['&supe;'] = '⊇',
	['&supseteq;'] = '⊇',
	['&NotSubsetEqual;'] = '⊈',
	['&nsube;'] = '⊈',
	['&nsubseteq;'] = '⊈',
	['&NotSupersetEqual;'] = '⊉',
	['&nsupe;'] = '⊉',
	['&nsupseteq;'] = '⊉',
	['&subne;'] = '⊊',
	['&subsetneq;'] = '⊊',
	['&varsubsetneq;'] = '⊊︀',
	['&vsubne;'] = '⊊︀',
	['&supne;'] = '⊋',
	['&supsetneq;'] = '⊋',
	['&varsupsetneq;'] = '⊋︀',
	['&vsupne;'] = '⊋︀',
	['&cupdot;'] = '⊍',
	['&UnionPlus;'] = '⊎',
	['&uplus;'] = '⊎',
	['&SquareSubset;'] = '⊏',
	['&sqsub;'] = '⊏',
	['&sqsubset;'] = '⊏',
	['&NotSquareSubset;'] = '⊏̸',
	['&SquareSuperset;'] = '⊐',
	['&sqsup;'] = '⊐',
	['&sqsupset;'] = '⊐',
	['&NotSquareSuperset;'] = '⊐̸',
	['&SquareSubsetEqual;'] = '⊑',
	['&sqsube;'] = '⊑',
	['&sqsubseteq;'] = '⊑',
	['&SquareSupersetEqual;'] = '⊒',
	['&sqsupe;'] = '⊒',
	['&sqsupseteq;'] = '⊒',
	['&SquareIntersection;'] = '⊓',
	['&sqcap;'] = '⊓',
	['&sqcaps;'] = '⊓︀',
	['&SquareUnion;'] = '⊔',
	['&sqcup;'] = '⊔',
	['&sqcups;'] = '⊔︀',
	['&CirclePlus;'] = '⊕',
	['&oplus;'] = '⊕',
	['&CircleMinus;'] = '⊖',
	['&ominus;'] = '⊖',
	['&CircleTimes;'] = '⊗',
	['&otimes;'] = '⊗',
	['&osol;'] = '⊘',
	['&CircleDot;'] = '⊙',
	['&odot;'] = '⊙',
	['&circledcirc;'] = '⊚',
	['&ocir;'] = '⊚',
	['&circledast;'] = '⊛',
	['&oast;'] = '⊛',
	['&circleddash;'] = '⊝',
	['&odash;'] = '⊝',
	['&boxplus;'] = '⊞',
	['&plusb;'] = '⊞',
	['&boxminus;'] = '⊟',
	['&minusb;'] = '⊟',
	['&boxtimes;'] = '⊠',
	['&timesb;'] = '⊠',
	['&dotsquare;'] = '⊡',
	['&sdotb;'] = '⊡',
	['&RightTee;'] = '⊢',
	['&vdash;'] = '⊢',
	['&LeftTee;'] = '⊣',
	['&dashv;'] = '⊣',
	['&DownTee;'] = '⊤',
	['&top;'] = '⊤',
	['&UpTee;'] = '⊥',
	['&bot;'] = '⊥',
	['&bottom;'] = '⊥',
	['&perp;'] = '⊥',
	['&models;'] = '⊧',
	['&DoubleRightTee;'] = '⊨',
	['&vDash;'] = '⊨',
	['&Vdash;'] = '⊩',
	['&Vvdash;'] = '⊪',
	['&VDash;'] = '⊫',
	['&nvdash;'] = '⊬',
	['&nvDash;'] = '⊭',
	['&nVdash;'] = '⊮',
	['&nVDash;'] = '⊯',
	['&prurel;'] = '⊰',
	['&LeftTriangle;'] = '⊲',
	['&vartriangleleft;'] = '⊲',
	['&vltri;'] = '⊲',
	['&RightTriangle;'] = '⊳',
	['&vartriangleright;'] = '⊳',
	['&vrtri;'] = '⊳',
	['&LeftTriangleEqual;'] = '⊴',
	['&ltrie;'] = '⊴',
	['&trianglelefteq;'] = '⊴',
	['&nvltrie;'] = '⊴⃒',
	['&RightTriangleEqual;'] = '⊵',
	['&rtrie;'] = '⊵',
	['&trianglerighteq;'] = '⊵',
	['&nvrtrie;'] = '⊵⃒',
	['&origof;'] = '⊶',
	['&imof;'] = '⊷',
	['&multimap;'] = '⊸',
	['&mumap;'] = '⊸',
	['&hercon;'] = '⊹',
	['&intcal;'] = '⊺',
	['&intercal;'] = '⊺',
	['&veebar;'] = '⊻',
	['&barvee;'] = '⊽',
	['&angrtvb;'] = '⊾',
	['&lrtri;'] = '⊿',
	['&Wedge;'] = '⋀',
	['&bigwedge;'] = '⋀',
	['&xwedge;'] = '⋀',
	['&Vee;'] = '⋁',
	['&bigvee;'] = '⋁',
	['&xvee;'] = '⋁',
	['&Intersection;'] = '⋂',
	['&bigcap;'] = '⋂',
	['&xcap;'] = '⋂',
	['&Union;'] = '⋃',
	['&bigcup;'] = '⋃',
	['&xcup;'] = '⋃',
	['&Diamond;'] = '⋄',
	['&diam;'] = '⋄',
	['&diamond;'] = '⋄',
	['&sdot;'] = '⋅',
	['&Star;'] = '⋆',
	['&sstarf;'] = '⋆',
	['&divideontimes;'] = '⋇',
	['&divonx;'] = '⋇',
	['&bowtie;'] = '⋈',
	['&ltimes;'] = '⋉',
	['&rtimes;'] = '⋊',
	['&leftthreetimes;'] = '⋋',
	['&lthree;'] = '⋋',
	['&rightthreetimes;'] = '⋌',
	['&rthree;'] = '⋌',
	['&backsimeq;'] = '⋍',
	['&bsime;'] = '⋍',
	['&curlyvee;'] = '⋎',
	['&cuvee;'] = '⋎',
	['&curlywedge;'] = '⋏',
	['&cuwed;'] = '⋏',
	['&Sub;'] = '⋐',
	['&Subset;'] = '⋐',
	['&Sup;'] = '⋑',
	['&Supset;'] = '⋑',
	['&Cap;'] = '⋒',
	['&Cup;'] = '⋓',
	['&fork;'] = '⋔',
	['&pitchfork;'] = '⋔',
	['&epar;'] = '⋕',
	['&lessdot;'] = '⋖',
	['&ltdot;'] = '⋖',
	['&gtdot;'] = '⋗',
	['&gtrdot;'] = '⋗',
	['&Ll;'] = '⋘',
	['&nLl;'] = '⋘̸',
	['&Gg;'] = '⋙',
	['&ggg;'] = '⋙',
	['&nGg;'] = '⋙̸',
	['&LessEqualGreater;'] = '⋚',
	['&leg;'] = '⋚',
	['&lesseqgtr;'] = '⋚',
	['&lesg;'] = '⋚︀',
	['&GreaterEqualLess;'] = '⋛',
	['&gel;'] = '⋛',
	['&gtreqless;'] = '⋛',
	['&gesl;'] = '⋛︀',
	['&cuepr;'] = '⋞',
	['&curlyeqprec;'] = '⋞',
	['&cuesc;'] = '⋟',
	['&curlyeqsucc;'] = '⋟',
	['&NotPrecedesSlantEqual;'] = '⋠',
	['&nprcue;'] = '⋠',
	['&NotSucceedsSlantEqual;'] = '⋡',
	['&nsccue;'] = '⋡',
	['&NotSquareSubsetEqual;'] = '⋢',
	['&nsqsube;'] = '⋢',
	['&NotSquareSupersetEqual;'] = '⋣',
	['&nsqsupe;'] = '⋣',
	['&lnsim;'] = '⋦',
	['&gnsim;'] = '⋧',
	['&precnsim;'] = '⋨',
	['&prnsim;'] = '⋨',
	['&scnsim;'] = '⋩',
	['&succnsim;'] = '⋩',
	['&NotLeftTriangle;'] = '⋪',
	['&nltri;'] = '⋪',
	['&ntriangleleft;'] = '⋪',
	['&NotRightTriangle;'] = '⋫',
	['&nrtri;'] = '⋫',
	['&ntriangleright;'] = '⋫',
	['&NotLeftTriangleEqual;'] = '⋬',
	['&nltrie;'] = '⋬',
	['&ntrianglelefteq;'] = '⋬',
	['&NotRightTriangleEqual;'] = '⋭',
	['&nrtrie;'] = '⋭',
	['&ntrianglerighteq;'] = '⋭',
	['&vellip;'] = '⋮',
	['&ctdot;'] = '⋯',
	['&utdot;'] = '⋰',
	['&dtdot;'] = '⋱',
	['&disin;'] = '⋲',
	['&isinsv;'] = '⋳',
	['&isins;'] = '⋴',
	['&isindot;'] = '⋵',
	['&notindot;'] = '⋵̸',
	['&notinvc;'] = '⋶',
	['&notinvb;'] = '⋷',
	['&isinE;'] = '⋹',
	['&notinE;'] = '⋹̸',
	['&nisd;'] = '⋺',
	['&xnis;'] = '⋻',
	['&nis;'] = '⋼',
	['&notnivc;'] = '⋽',
	['&notnivb;'] = '⋾',
	['&barwed;'] = '⌅',
	['&barwedge;'] = '⌅',
	['&Barwed;'] = '⌆',
	['&doublebarwedge;'] = '⌆',
	['&LeftCeiling;'] = '⌈',
	['&lceil;'] = '⌈',
	['&RightCeiling;'] = '⌉',
	['&rceil;'] = '⌉',
	['&LeftFloor;'] = '⌊',
	['&lfloor;'] = '⌊',
	['&RightFloor;'] = '⌋',
	['&rfloor;'] = '⌋',
	['&drcrop;'] = '⌌',
	['&dlcrop;'] = '⌍',
	['&urcrop;'] = '⌎',
	['&ulcrop;'] = '⌏',
	['&bnot;'] = '⌐',
	['&profline;'] = '⌒',
	['&profsurf;'] = '⌓',
	['&telrec;'] = '⌕',
	['&target;'] = '⌖',
	['&ulcorn;'] = '⌜',
	['&ulcorner;'] = '⌜',
	['&urcorn;'] = '⌝',
	['&urcorner;'] = '⌝',
	['&dlcorn;'] = '⌞',
	['&llcorner;'] = '⌞',
	['&drcorn;'] = '⌟',
	['&lrcorner;'] = '⌟',
	['&frown;'] = '⌢',
	['&sfrown;'] = '⌢',
	['&smile;'] = '⌣',
	['&ssmile;'] = '⌣',
	['&cylcty;'] = '⌭',
	['&profalar;'] = '⌮',
	['&topbot;'] = '⌶',
	['&ovbar;'] = '⌽',
	['&solbar;'] = '⌿',
	['&angzarr;'] = '⍼',
	['&lmoust;'] = '⎰',
	['&lmoustache;'] = '⎰',
	['&rmoust;'] = '⎱',
	['&rmoustache;'] = '⎱',
	['&OverBracket;'] = '⎴',
	['&tbrk;'] = '⎴',
	['&UnderBracket;'] = '⎵',
	['&bbrk;'] = '⎵',
	['&bbrktbrk;'] = '⎶',
	['&OverParenthesis;'] = '⏜',
	['&UnderParenthesis;'] = '⏝',
	['&OverBrace;'] = '⏞',
	['&UnderBrace;'] = '⏟',
	['&trpezium;'] = '⏢',
	['&elinters;'] = '⏧',
	['&blank;'] = '␣',
	['&circledS;'] = 'Ⓢ',
	['&oS;'] = 'Ⓢ',
	['&HorizontalLine;'] = '─',
	['&boxh;'] = '─',
	['&boxv;'] = '│',
	['&boxdr;'] = '┌',
	['&boxdl;'] = '┐',
	['&boxur;'] = '└',
	['&boxul;'] = '┘',
	['&boxvr;'] = '├',
	['&boxvl;'] = '┤',
	['&boxhd;'] = '┬',
	['&boxhu;'] = '┴',
	['&boxvh;'] = '┼',
	['&boxH;'] = '═',
	['&boxV;'] = '║',
	['&boxdR;'] = '╒',
	['&boxDr;'] = '╓',
	['&boxDR;'] = '╔',
	['&boxdL;'] = '╕',
	['&boxDl;'] = '╖',
	['&boxDL;'] = '╗',
	['&boxuR;'] = '╘',
	['&boxUr;'] = '╙',
	['&boxUR;'] = '╚',
	['&boxuL;'] = '╛',
	['&boxUl;'] = '╜',
	['&boxUL;'] = '╝',
	['&boxvR;'] = '╞',
	['&boxVr;'] = '╟',
	['&boxVR;'] = '╠',
	['&boxvL;'] = '╡',
	['&boxVl;'] = '╢',
	['&boxVL;'] = '╣',
	['&boxHd;'] = '╤',
	['&boxhD;'] = '╥',
	['&boxHD;'] = '╦',
	['&boxHu;'] = '╧',
	['&boxhU;'] = '╨',
	['&boxHU;'] = '╩',
	['&boxvH;'] = '╪',
	['&boxVh;'] = '╫',
	['&boxVH;'] = '╬',
	['&uhblk;'] = '▀',
	['&lhblk;'] = '▄',
	['&block;'] = '█',
	['&blk14;'] = '░',
	['&blk12;'] = '▒',
	['&blk34;'] = '▓',
	['&Square;'] = '□',
	['&squ;'] = '□',
	['&square;'] = '□',
	['&FilledVerySmallSquare;'] = '▪',
	['&blacksquare;'] = '▪',
	['&squarf;'] = '▪',
	['&squf;'] = '▪',
	['&EmptyVerySmallSquare;'] = '▫',
	['&rect;'] = '▭',
	['&marker;'] = '▮',
	['&fltns;'] = '▱',
	['&bigtriangleup;'] = '△',
	['&xutri;'] = '△',
	['&blacktriangle;'] = '▴',
	['&utrif;'] = '▴',
	['&triangle;'] = '▵',
	['&utri;'] = '▵',
	['&blacktriangleright;'] = '▸',
	['&rtrif;'] = '▸',
	['&rtri;'] = '▹',
	['&triangleright;'] = '▹',
	['&bigtriangledown;'] = '▽',
	['&xdtri;'] = '▽',
	['&blacktriangledown;'] = '▾',
	['&dtrif;'] = '▾',
	['&dtri;'] = '▿',
	['&triangledown;'] = '▿',
	['&blacktriangleleft;'] = '◂',
	['&ltrif;'] = '◂',
	['&ltri;'] = '◃',
	['&triangleleft;'] = '◃',
	['&loz;'] = '◊',
	['&lozenge;'] = '◊',
	['&cir;'] = '○',
	['&tridot;'] = '◬',
	['&bigcirc;'] = '◯',
	['&xcirc;'] = '◯',
	['&ultri;'] = '◸',
	['&urtri;'] = '◹',
	['&lltri;'] = '◺',
	['&EmptySmallSquare;'] = '◻',
	['&FilledSmallSquare;'] = '◼',
	['&bigstar;'] = '★',
	['&starf;'] = '★',
	['&star;'] = '☆',
	['&phone;'] = '☎',
	['&female;'] = '♀',
	['&male;'] = '♂',
	['&spades;'] = '♠',
	['&spadesuit;'] = '♠',
	['&clubs;'] = '♣',
	['&clubsuit;'] = '♣',
	['&hearts;'] = '♥',
	['&heartsuit;'] = '♥',
	['&diamondsuit;'] = '♦',
	['&diams;'] = '♦',
	['&sung;'] = '♪',
	['&flat;'] = '♭',
	['&natur;'] = '♮',
	['&natural;'] = '♮',
	['&sharp;'] = '♯',
	['&check;'] = '✓',
	['&checkmark;'] = '✓',
	['&cross;'] = '✗',
	['&malt;'] = '✠',
	['&maltese;'] = '✠',
	['&sext;'] = '✶',
	['&VerticalSeparator;'] = '❘',
	['&lbbrk;'] = '❲',
	['&rbbrk;'] = '❳',
	['&bsolhsub;'] = '⟈',
	['&suphsol;'] = '⟉',
	['&LeftDoubleBracket;'] = '⟦',
	['&lobrk;'] = '⟦',
	['&RightDoubleBracket;'] = '⟧',
	['&robrk;'] = '⟧',
	['&LeftAngleBracket;'] = '⟨',
	['&lang;'] = '⟨',
	['&langle;'] = '⟨',
	['&RightAngleBracket;'] = '⟩',
	['&rang;'] = '⟩',
	['&rangle;'] = '⟩',
	['&Lang;'] = '⟪',
	['&Rang;'] = '⟫',
	['&loang;'] = '⟬',
	['&roang;'] = '⟭',
	['&LongLeftArrow;'] = '⟵',
	['&longleftarrow;'] = '⟵',
	['&xlarr;'] = '⟵',
	['&LongRightArrow;'] = '⟶',
	['&longrightarrow;'] = '⟶',
	['&xrarr;'] = '⟶',
	['&LongLeftRightArrow;'] = '⟷',
	['&longleftrightarrow;'] = '⟷',
	['&xharr;'] = '⟷',
	['&DoubleLongLeftArrow;'] = '⟸',
	['&Longleftarrow;'] = '⟸',
	['&xlArr;'] = '⟸',
	['&DoubleLongRightArrow;'] = '⟹',
	['&Longrightarrow;'] = '⟹',
	['&xrArr;'] = '⟹',
	['&DoubleLongLeftRightArrow;'] = '⟺',
	['&Longleftrightarrow;'] = '⟺',
	['&xhArr;'] = '⟺',
	['&longmapsto;'] = '⟼',
	['&xmap;'] = '⟼',
	['&dzigrarr;'] = '⟿',
	['&nvlArr;'] = '⤂',
	['&nvrArr;'] = '⤃',
	['&nvHarr;'] = '⤄',
	['&Map;'] = '⤅',
	['&lbarr;'] = '⤌',
	['&bkarow;'] = '⤍',
	['&rbarr;'] = '⤍',
	['&lBarr;'] = '⤎',
	['&dbkarow;'] = '⤏',
	['&rBarr;'] = '⤏',
	['&RBarr;'] = '⤐',
	['&drbkarow;'] = '⤐',
	['&DDotrahd;'] = '⤑',
	['&UpArrowBar;'] = '⤒',
	['&DownArrowBar;'] = '⤓',
	['&Rarrtl;'] = '⤖',
	['&latail;'] = '⤙',
	['&ratail;'] = '⤚',
	['&lAtail;'] = '⤛',
	['&rAtail;'] = '⤜',
	['&larrfs;'] = '⤝',
	['&rarrfs;'] = '⤞',
	['&larrbfs;'] = '⤟',
	['&rarrbfs;'] = '⤠',
	['&nwarhk;'] = '⤣',
	['&nearhk;'] = '⤤',
	['&hksearow;'] = '⤥',
	['&searhk;'] = '⤥',
	['&hkswarow;'] = '⤦',
	['&swarhk;'] = '⤦',
	['&nwnear;'] = '⤧',
	['&nesear;'] = '⤨',
	['&toea;'] = '⤨',
	['&seswar;'] = '⤩',
	['&tosa;'] = '⤩',
	['&swnwar;'] = '⤪',
	['&rarrc;'] = '⤳',
	['&nrarrc;'] = '⤳̸',
	['&cudarrr;'] = '⤵',
	['&ldca;'] = '⤶',
	['&rdca;'] = '⤷',
	['&cudarrl;'] = '⤸',
	['&larrpl;'] = '⤹',
	['&curarrm;'] = '⤼',
	['&cularrp;'] = '⤽',
	['&rarrpl;'] = '⥅',
	['&harrcir;'] = '⥈',
	['&Uarrocir;'] = '⥉',
	['&lurdshar;'] = '⥊',
	['&ldrushar;'] = '⥋',
	['&LeftRightVector;'] = '⥎',
	['&RightUpDownVector;'] = '⥏',
	['&DownLeftRightVector;'] = '⥐',
	['&LeftUpDownVector;'] = '⥑',
	['&LeftVectorBar;'] = '⥒',
	['&RightVectorBar;'] = '⥓',
	['&RightUpVectorBar;'] = '⥔',
	['&RightDownVectorBar;'] = '⥕',
	['&DownLeftVectorBar;'] = '⥖',
	['&DownRightVectorBar;'] = '⥗',
	['&LeftUpVectorBar;'] = '⥘',
	['&LeftDownVectorBar;'] = '⥙',
	['&LeftTeeVector;'] = '⥚',
	['&RightTeeVector;'] = '⥛',
	['&RightUpTeeVector;'] = '⥜',
	['&RightDownTeeVector;'] = '⥝',
	['&DownLeftTeeVector;'] = '⥞',
	['&DownRightTeeVector;'] = '⥟',
	['&LeftUpTeeVector;'] = '⥠',
	['&LeftDownTeeVector;'] = '⥡',
	['&lHar;'] = '⥢',
	['&uHar;'] = '⥣',
	['&rHar;'] = '⥤',
	['&dHar;'] = '⥥',
	['&luruhar;'] = '⥦',
	['&ldrdhar;'] = '⥧',
	['&ruluhar;'] = '⥨',
	['&rdldhar;'] = '⥩',
	['&lharul;'] = '⥪',
	['&llhard;'] = '⥫',
	['&rharul;'] = '⥬',
	['&lrhard;'] = '⥭',
	['&UpEquilibrium;'] = '⥮',
	['&udhar;'] = '⥮',
	['&ReverseUpEquilibrium;'] = '⥯',
	['&duhar;'] = '⥯',
	['&RoundImplies;'] = '⥰',
	['&erarr;'] = '⥱',
	['&simrarr;'] = '⥲',
	['&larrsim;'] = '⥳',
	['&rarrsim;'] = '⥴',
	['&rarrap;'] = '⥵',
	['&ltlarr;'] = '⥶',
	['&gtrarr;'] = '⥸',
	['&subrarr;'] = '⥹',
	['&suplarr;'] = '⥻',
	['&lfisht;'] = '⥼',
	['&rfisht;'] = '⥽',
	['&ufisht;'] = '⥾',
	['&dfisht;'] = '⥿',
	['&lopar;'] = '⦅',
	['&ropar;'] = '⦆',
	['&lbrke;'] = '⦋',
	['&rbrke;'] = '⦌',
	['&lbrkslu;'] = '⦍',
	['&rbrksld;'] = '⦎',
	['&lbrksld;'] = '⦏',
	['&rbrkslu;'] = '⦐',
	['&langd;'] = '⦑',
	['&rangd;'] = '⦒',
	['&lparlt;'] = '⦓',
	['&rpargt;'] = '⦔',
	['&gtlPar;'] = '⦕',
	['&ltrPar;'] = '⦖',
	['&vzigzag;'] = '⦚',
	['&vangrt;'] = '⦜',
	['&angrtvbd;'] = '⦝',
	['&ange;'] = '⦤',
	['&range;'] = '⦥',
	['&dwangle;'] = '⦦',
	['&uwangle;'] = '⦧',
	['&angmsdaa;'] = '⦨',
	['&angmsdab;'] = '⦩',
	['&angmsdac;'] = '⦪',
	['&angmsdad;'] = '⦫',
	['&angmsdae;'] = '⦬',
	['&angmsdaf;'] = '⦭',
	['&angmsdag;'] = '⦮',
	['&angmsdah;'] = '⦯',
	['&bemptyv;'] = '⦰',
	['&demptyv;'] = '⦱',
	['&cemptyv;'] = '⦲',
	['&raemptyv;'] = '⦳',
	['&laemptyv;'] = '⦴',
	['&ohbar;'] = '⦵',
	['&omid;'] = '⦶',
	['&opar;'] = '⦷',
	['&operp;'] = '⦹',
	['&olcross;'] = '⦻',
	['&odsold;'] = '⦼',
	['&olcir;'] = '⦾',
	['&ofcir;'] = '⦿',
	['&olt;'] = '⧀',
	['&ogt;'] = '⧁',
	['&cirscir;'] = '⧂',
	['&cirE;'] = '⧃',
	['&solb;'] = '⧄',
	['&bsolb;'] = '⧅',
	['&boxbox;'] = '⧉',
	['&trisb;'] = '⧍',
	['&rtriltri;'] = '⧎',
	['&LeftTriangleBar;'] = '⧏',
	['&NotLeftTriangleBar;'] = '⧏̸',
	['&RightTriangleBar;'] = '⧐',
	['&NotRightTriangleBar;'] = '⧐̸',
	['&iinfin;'] = '⧜',
	['&infintie;'] = '⧝',
	['&nvinfin;'] = '⧞',
	['&eparsl;'] = '⧣',
	['&smeparsl;'] = '⧤',
	['&eqvparsl;'] = '⧥',
	['&blacklozenge;'] = '⧫',
	['&lozf;'] = '⧫',
	['&RuleDelayed;'] = '⧴',
	['&dsol;'] = '⧶',
	['&bigodot;'] = '⨀',
	['&xodot;'] = '⨀',
	['&bigoplus;'] = '⨁',
	['&xoplus;'] = '⨁',
	['&bigotimes;'] = '⨂',
	['&xotime;'] = '⨂',
	['&biguplus;'] = '⨄',
	['&xuplus;'] = '⨄',
	['&bigsqcup;'] = '⨆',
	['&xsqcup;'] = '⨆',
	['&iiiint;'] = '⨌',
	['&qint;'] = '⨌',
	['&fpartint;'] = '⨍',
	['&cirfnint;'] = '⨐',
	['&awint;'] = '⨑',
	['&rppolint;'] = '⨒',
	['&scpolint;'] = '⨓',
	['&npolint;'] = '⨔',
	['&pointint;'] = '⨕',
	['&quatint;'] = '⨖',
	['&intlarhk;'] = '⨗',
	['&pluscir;'] = '⨢',
	['&plusacir;'] = '⨣',
	['&simplus;'] = '⨤',
	['&plusdu;'] = '⨥',
	['&plussim;'] = '⨦',
	['&plustwo;'] = '⨧',
	['&mcomma;'] = '⨩',
	['&minusdu;'] = '⨪',
	['&loplus;'] = '⨭',
	['&roplus;'] = '⨮',
	['&Cross;'] = '⨯',
	['&timesd;'] = '⨰',
	['&timesbar;'] = '⨱',
	['&smashp;'] = '⨳',
	['&lotimes;'] = '⨴',
	['&rotimes;'] = '⨵',
	['&otimesas;'] = '⨶',
	['&Otimes;'] = '⨷',
	['&odiv;'] = '⨸',
	['&triplus;'] = '⨹',
	['&triminus;'] = '⨺',
	['&tritime;'] = '⨻',
	['&intprod;'] = '⨼',
	['&iprod;'] = '⨼',
	['&amalg;'] = '⨿',
	['&capdot;'] = '⩀',
	['&ncup;'] = '⩂',
	['&ncap;'] = '⩃',
	['&capand;'] = '⩄',
	['&cupor;'] = '⩅',
	['&cupcap;'] = '⩆',
	['&capcup;'] = '⩇',
	['&cupbrcap;'] = '⩈',
	['&capbrcup;'] = '⩉',
	['&cupcup;'] = '⩊',
	['&capcap;'] = '⩋',
	['&ccups;'] = '⩌',
	['&ccaps;'] = '⩍',
	['&ccupssm;'] = '⩐',
	['&And;'] = '⩓',
	['&Or;'] = '⩔',
	['&andand;'] = '⩕',
	['&oror;'] = '⩖',
	['&orslope;'] = '⩗',
	['&andslope;'] = '⩘',
	['&andv;'] = '⩚',
	['&orv;'] = '⩛',
	['&andd;'] = '⩜',
	['&ord;'] = '⩝',
	['&wedbar;'] = '⩟',
	['&sdote;'] = '⩦',
	['&simdot;'] = '⩪',
	['&congdot;'] = '⩭',
	['&ncongdot;'] = '⩭̸',
	['&easter;'] = '⩮',
	['&apacir;'] = '⩯',
	['&apE;'] = '⩰',
	['&napE;'] = '⩰̸',
	['&eplus;'] = '⩱',
	['&pluse;'] = '⩲',
	['&Esim;'] = '⩳',
	['&Colone;'] = '⩴',
	['&Equal;'] = '⩵',
	['&ddotseq;'] = '⩷',
	['&eDDot;'] = '⩷',
	['&equivDD;'] = '⩸',
	['&ltcir;'] = '⩹',
	['&gtcir;'] = '⩺',
	['&ltquest;'] = '⩻',
	['&gtquest;'] = '⩼',
	['&LessSlantEqual;'] = '⩽',
	['&leqslant;'] = '⩽',
	['&les;'] = '⩽',
	['&nleqslant;'] = '⩽̸',
	['&nles;'] = '⩽̸',
	['&NotLessSlantEqual;'] = '⩽̸',
	['&GreaterSlantEqual;'] = '⩾',
	['&geqslant;'] = '⩾',
	['&ges;'] = '⩾',
	['&ngeqslant;'] = '⩾̸',
	['&nges;'] = '⩾̸',
	['&NotGreaterSlantEqual;'] = '⩾̸',
	['&lesdot;'] = '⩿',
	['&gesdot;'] = '⪀',
	['&lesdoto;'] = '⪁',
	['&gesdoto;'] = '⪂',
	['&lesdotor;'] = '⪃',
	['&gesdotol;'] = '⪄',
	['&lap;'] = '⪅',
	['&lessapprox;'] = '⪅',
	['&gap;'] = '⪆',
	['&gtrapprox;'] = '⪆',
	['&lne;'] = '⪇',
	['&lneq;'] = '⪇',
	['&gne;'] = '⪈',
	['&gneq;'] = '⪈',
	['&lnap;'] = '⪉',
	['&lnapprox;'] = '⪉',
	['&gnap;'] = '⪊',
	['&gnapprox;'] = '⪊',
	['&lEg;'] = '⪋',
	['&lesseqqgtr;'] = '⪋',
	['&gEl;'] = '⪌',
	['&gtreqqless;'] = '⪌',
	['&lsime;'] = '⪍',
	['&gsime;'] = '⪎',
	['&lsimg;'] = '⪏',
	['&gsiml;'] = '⪐',
	['&lgE;'] = '⪑',
	['&glE;'] = '⪒',
	['&lesges;'] = '⪓',
	['&gesles;'] = '⪔',
	['&els;'] = '⪕',
	['&eqslantless;'] = '⪕',
	['&egs;'] = '⪖',
	['&eqslantgtr;'] = '⪖',
	['&elsdot;'] = '⪗',
	['&egsdot;'] = '⪘',
	['&el;'] = '⪙',
	['&eg;'] = '⪚',
	['&siml;'] = '⪝',
	['&simg;'] = '⪞',
	['&simlE;'] = '⪟',
	['&simgE;'] = '⪠',
	['&LessLess;'] = '⪡',
	['&NotNestedLessLess;'] = '⪡̸',
	['&GreaterGreater;'] = '⪢',
	['&NotNestedGreaterGreater;'] = '⪢̸',
	['&glj;'] = '⪤',
	['&gla;'] = '⪥',
	['&ltcc;'] = '⪦',
	['&gtcc;'] = '⪧',
	['&lescc;'] = '⪨',
	['&gescc;'] = '⪩',
	['&smt;'] = '⪪',
	['&lat;'] = '⪫',
	['&smte;'] = '⪬',
	['&smtes;'] = '⪬︀',
	['&late;'] = '⪭',
	['&lates;'] = '⪭︀',
	['&bumpE;'] = '⪮',
	['&PrecedesEqual;'] = '⪯',
	['&pre;'] = '⪯',
	['&preceq;'] = '⪯',
	['&NotPrecedesEqual;'] = '⪯̸',
	['&npre;'] = '⪯̸',
	['&npreceq;'] = '⪯̸',
	['&SucceedsEqual;'] = '⪰',
	['&sce;'] = '⪰',
	['&succeq;'] = '⪰',
	['&NotSucceedsEqual;'] = '⪰̸',
	['&nsce;'] = '⪰̸',
	['&nsucceq;'] = '⪰̸',
	['&prE;'] = '⪳',
	['&scE;'] = '⪴',
	['&precneqq;'] = '⪵',
	['&prnE;'] = '⪵',
	['&scnE;'] = '⪶',
	['&succneqq;'] = '⪶',
	['&prap;'] = '⪷',
	['&precapprox;'] = '⪷',
	['&scap;'] = '⪸',
	['&succapprox;'] = '⪸',
	['&precnapprox;'] = '⪹',
	['&prnap;'] = '⪹',
	['&scnap;'] = '⪺',
	['&succnapprox;'] = '⪺',
	['&Pr;'] = '⪻',
	['&Sc;'] = '⪼',
	['&subdot;'] = '⪽',
	['&supdot;'] = '⪾',
	['&subplus;'] = '⪿',
	['&supplus;'] = '⫀',
	['&submult;'] = '⫁',
	['&supmult;'] = '⫂',
	['&subedot;'] = '⫃',
	['&supedot;'] = '⫄',
	['&subE;'] = '⫅',
	['&subseteqq;'] = '⫅',
	['&nsubE;'] = '⫅̸',
	['&nsubseteqq;'] = '⫅̸',
	['&supE;'] = '⫆',
	['&supseteqq;'] = '⫆',
	['&nsupE;'] = '⫆̸',
	['&nsupseteqq;'] = '⫆̸',
	['&subsim;'] = '⫇',
	['&supsim;'] = '⫈',
	['&subnE;'] = '⫋',
	['&subsetneqq;'] = '⫋',
	['&varsubsetneqq;'] = '⫋︀',
	['&vsubnE;'] = '⫋︀',
	['&supnE;'] = '⫌',
	['&supsetneqq;'] = '⫌',
	['&varsupsetneqq;'] = '⫌︀',
	['&vsupnE;'] = '⫌︀',
	['&csub;'] = '⫏',
	['&csup;'] = '⫐',
	['&csube;'] = '⫑',
	['&csupe;'] = '⫒',
	['&subsup;'] = '⫓',
	['&supsub;'] = '⫔',
	['&subsub;'] = '⫕',
	['&supsup;'] = '⫖',
	['&suphsub;'] = '⫗',
	['&supdsub;'] = '⫘',
	['&forkv;'] = '⫙',
	['&topfork;'] = '⫚',
	['&mlcp;'] = '⫛',
	['&Dashv;'] = '⫤',
	['&DoubleLeftTee;'] = '⫤',
	['&Vdashl;'] = '⫦',
	['&Barv;'] = '⫧',
	['&vBar;'] = '⫨',
	['&vBarv;'] = '⫩',
	['&Vbar;'] = '⫫',
	['&Not;'] = '⫬',
	['&bNot;'] = '⫭',
	['&rnmid;'] = '⫮',
	['&cirmid;'] = '⫯',
	['&midcir;'] = '⫰',
	['&topcir;'] = '⫱',
	['&nhpar;'] = '⫲',
	['&parsim;'] = '⫳',
	['&parsl;'] = '⫽',
	['&nparsl;'] = '⫽⃥',
	['&fflig;'] = 'ﬀ',
	['&filig;'] = 'ﬁ',
	['&fllig;'] = 'ﬂ',
	['&ffilig;'] = 'ﬃ',
	['&ffllig;'] = 'ﬄ',
	['&Ascr;'] = '𝒜',
	['&Cscr;'] = '𝒞',
	['&Dscr;'] = '𝒟',
	['&Gscr;'] = '𝒢',
	['&Jscr;'] = '𝒥',
	['&Kscr;'] = '𝒦',
	['&Nscr;'] = '𝒩',
	['&Oscr;'] = '𝒪',
	['&Pscr;'] = '𝒫',
	['&Qscr;'] = '𝒬',
	['&Sscr;'] = '𝒮',
	['&Tscr;'] = '𝒯',
	['&Uscr;'] = '𝒰',
	['&Vscr;'] = '𝒱',
	['&Wscr;'] = '𝒲',
	['&Xscr;'] = '𝒳',
	['&Yscr;'] = '𝒴',
	['&Zscr;'] = '𝒵',
	['&ascr;'] = '𝒶',
	['&bscr;'] = '𝒷',
	['&cscr;'] = '𝒸',
	['&dscr;'] = '𝒹',
	['&fscr;'] = '𝒻',
	['&hscr;'] = '𝒽',
	['&iscr;'] = '𝒾',
	['&jscr;'] = '𝒿',
	['&kscr;'] = '𝓀',
	['&lscr;'] = '𝓁',
	['&mscr;'] = '𝓂',
	['&nscr;'] = '𝓃',
	['&pscr;'] = '𝓅',
	['&qscr;'] = '𝓆',
	['&rscr;'] = '𝓇',
	['&sscr;'] = '𝓈',
	['&tscr;'] = '𝓉',
	['&uscr;'] = '𝓊',
	['&vscr;'] = '𝓋',
	['&wscr;'] = '𝓌',
	['&xscr;'] = '𝓍',
	['&yscr;'] = '𝓎',
	['&zscr;'] = '𝓏',
	['&Afr;'] = '𝔄',
	['&Bfr;'] = '𝔅',
	['&Dfr;'] = '𝔇',
	['&Efr;'] = '𝔈',
	['&Ffr;'] = '𝔉',
	['&Gfr;'] = '𝔊',
	['&Jfr;'] = '𝔍',
	['&Kfr;'] = '𝔎',
	['&Lfr;'] = '𝔏',
	['&Mfr;'] = '𝔐',
	['&Nfr;'] = '𝔑',
	['&Ofr;'] = '𝔒',
	['&Pfr;'] = '𝔓',
	['&Qfr;'] = '𝔔',
	['&Sfr;'] = '𝔖',
	['&Tfr;'] = '𝔗',
	['&Ufr;'] = '𝔘',
	['&Vfr;'] = '𝔙',
	['&Wfr;'] = '𝔚',
	['&Xfr;'] = '𝔛',
	['&Yfr;'] = '𝔜',
	['&afr;'] = '𝔞',
	['&bfr;'] = '𝔟',
	['&cfr;'] = '𝔠',
	['&dfr;'] = '𝔡',
	['&efr;'] = '𝔢',
	['&ffr;'] = '𝔣',
	['&gfr;'] = '𝔤',
	['&hfr;'] = '𝔥',
	['&ifr;'] = '𝔦',
	['&jfr;'] = '𝔧',
	['&kfr;'] = '𝔨',
	['&lfr;'] = '𝔩',
	['&mfr;'] = '𝔪',
	['&nfr;'] = '𝔫',
	['&ofr;'] = '𝔬',
	['&pfr;'] = '𝔭',
	['&qfr;'] = '𝔮',
	['&rfr;'] = '𝔯',
	['&sfr;'] = '𝔰',
	['&tfr;'] = '𝔱',
	['&ufr;'] = '𝔲',
	['&vfr;'] = '𝔳',
	['&wfr;'] = '𝔴',
	['&xfr;'] = '𝔵',
	['&yfr;'] = '𝔶',
	['&zfr;'] = '𝔷',
	['&Aopf;'] = '𝔸',
	['&Bopf;'] = '𝔹',
	['&Dopf;'] = '𝔻',
	['&Eopf;'] = '𝔼',
	['&Fopf;'] = '𝔽',
	['&Gopf;'] = '𝔾',
	['&Iopf;'] = '𝕀',
	['&Jopf;'] = '𝕁',
	['&Kopf;'] = '𝕂',
	['&Lopf;'] = '𝕃',
	['&Mopf;'] = '𝕄',
	['&Oopf;'] = '𝕆',
	['&Sopf;'] = '𝕊',
	['&Topf;'] = '𝕋',
	['&Uopf;'] = '𝕌',
	['&Vopf;'] = '𝕍',
	['&Wopf;'] = '𝕎',
	['&Xopf;'] = '𝕏',
	['&Yopf;'] = '𝕐',
	['&aopf;'] = '𝕒',
	['&bopf;'] = '𝕓',
	['&copf;'] = '𝕔',
	['&dopf;'] = '𝕕',
	['&eopf;'] = '𝕖',
	['&fopf;'] = '𝕗',
	['&gopf;'] = '𝕘',
	['&hopf;'] = '𝕙',
	['&iopf;'] = '𝕚',
	['&jopf;'] = '𝕛',
	['&kopf;'] = '𝕜',
	['&lopf;'] = '𝕝',
	['&mopf;'] = '𝕞',
	['&nopf;'] = '𝕟',
	['&oopf;'] = '𝕠',
	['&popf;'] = '𝕡',
	['&qopf;'] = '𝕢',
	['&ropf;'] = '𝕣',
	['&sopf;'] = '𝕤',
	['&topf;'] = '𝕥',
	['&uopf;'] = '𝕦',
	['&vopf;'] = '𝕧',
	['&wopf;'] = '𝕨',
	['&xopf;'] = '𝕩',
	['&yopf;'] = '𝕪',
	['&zopf;'] = '𝕫',
	['&#32;'] = ' ',
	['&#33;'] = '!',
	['&#34;'] = '"',
	['&#35;'] = '#',
	['&#36;'] = '$',
	['&#37;'] = '%%',
	['&#38;'] = '&',
	['&#39;'] = "'",
	['&#40;'] = '(',
	['&#41;'] = ')',
	['&#42;'] = '*',
	['&#43;'] = '+',
	['&#44;'] = ',',
	['&#45;'] = '-',
	['&#46;'] = '.',
	['&#47;'] = '/',
	['&#160;'] = ' ',
	['&#338;'] = 'Œ',
	['&#339;'] = 'œ',
	['&#352;'] = 'Š',
	['&#353;'] = 'š',
	['&#376;'] = 'Ÿ',
	['&#402;'] = 'ƒ',
	['&#8211;'] = '–',
	['&#8212;'] = '—',
	['&#8216;'] = '‘',
	['&#8217;'] = '’',
	['&#8218;'] = '‚',
	['&#8220;'] = '“',
	['&#8221;'] = '”',
	['&#8222;'] = '„',
	['&#8224;'] = '†',
	['&#8225;'] = '‡',
	['&#8226;'] = '•',
	['&#8230;'] = '…',
	['&#8240;'] = '‰',
	['&#8364;'] = '€',
	['&#8482;'] = '™'
}

function htmlEntities.filter (input, table)
	if not input then
		if error_msg_htmlEntities then error('htmlEntities[filter] >> ERROR: input is value nil') end
		return false
	end
	if not table then
		if error_msg_htmlEntities then error('htmlEntities[filter] >> ERROR: table is value nil') end
		return false
	end
	local output = input
	for s, v in pairs(table) do
		output = output:gsub(s, v)
	end
	return output
end

function htmlEntities.ASCII_HEX (input)
	if not input then
		if error_msg_htmlEntities then error('htmlEntities[ASCII_HEX] >> ERROR: input is value nil') end
		return false
	end
	if math.abs(_VERSION:sub(-1)) >= 3 then
		return utf8.char(input)
	else
		input = math.abs(input)
		if input < 128 then
			return string.char(input)
		else
			--> FIX UTF8 for Lua 5.2 and 5.1 https://stackoverflow.com/a/26052539
			local bytemarkers = {{0x7FF,192},{0xFFFF,224},{0x1FFFFF,240}}
			local charbytes = {}
			for bytes, vals in ipairs(bytemarkers) do
				if input <= vals[1] then
					for b = bytes+1, 2, -1 do
						local mod = input % 64
						input = (input - mod) / 64
						charbytes[b] = string.char(128 + mod)
					end
					charbytes[1] = string.char(vals[2] + input)
					break
				end
			end
			return table.concat(charbytes)
		end
	end
end

function htmlEntities.ASCII_DEC (input)
	if not input then
		if error_msg_htmlEntities then error('htmlEntities[ASCII_DEC] >> ERROR: input is value nil') end
		return false
	end
	local output = htmlEntities.ASCII_HEX(tonumber(input, 16))
	return output
end

function htmlEntities.decode (input)
	if not input then
		if error_msg_htmlEntities then error('htmlEntities[decode] >> ERROR: input is value nil') end
		return false
	end
	local output = string.gsub(input, '&[%w#]-;', htmlEntities_table)
	if ASCII_htmlEntities then
		output = string.gsub(output, '&#x([%w%d]*);', htmlEntities.ASCII_DEC)
		output = string.gsub(output, '&#([%d]*);', htmlEntities.ASCII_HEX)
	end

	if debug_htmlEntities then print('>>'..output) end
	return output
end

function htmlEntities.encode (input)
	if not input then
		if error_msg_htmlEntities then error('htmlEntities[encode] >> ERROR: input is value nil') end
		return false
	end
	input = htmlEntities.decode(input)
	local output = input:gsub('([%z\1-\127\194-\244][\128-\191]*)',
	function(char)
		local charbyte = char:byte()
		if (string.len(char) == 1) then
			if charbyte == 32 then -- Space char
				return ' '
			end
			return '&#'.. charbyte ..';'
		else
			return char
		end
	end)
	if debug_htmlEntities then print('>>'..output) end
	return output
end

function string:htmlDecode(filter)
	if not self then return false end
	return htmlEntities.decode(self)
end

function string:htmlEncode(filter)
	if not self then return false end
	return htmlEntities.encode(self)
end

return htmlEntities
