--lua
--[[
    Copyright (c) <2021>, <DarkMaster forum.uokit.com> All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
    are permitted provided that the following conditions are met:

    Usage is only allowed in not modifed UOPilot (uopilot.uokit.com) program,
    use in other programs is allowed only with the written permission of the owner.
    Redistribution of the original or modified code must be free, sale or commercial
    gain in any form is possible only with the written permission of the owner.
    Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.
    Neither the name of the owner nor the names of its contributors
    may be used to endorse or promote products derived from this software
    without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
    ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
    WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
    IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
    INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
    BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
    OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
    WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
    ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
    OF THE POSSIBILITY OF SUCH DAMAGE.
]]

local ffi=require "ffi"
local e=require "lua_system\\system"
local array_comparator = ffi.load([[E:\backup 37.6\system\RAD\drive\J\projects\find_dll_release\find_dll_release.dll]])

local C = ffi.C

ffi.cdef[[
    typedef long           LONG;
    typedef long*          PLONG;
    typedef unsigned short WORD;
    typedef unsigned long  DWORD, *PDWORD, *LPDWORD;
    typedef unsigned char  BYTE;
    typedef void*          LPVOID;
    typedef void           VOID, *PVOID, *LPVOID;
    typedef VOID*          HANDLE, *PHANDLE;
    typedef const void*    LPCVOID;
    typedef char*          LPSTR;
    typedef const char*    LPCSTR;
    typedef wchar_t        WCHAR;
    typedef const WCHAR*   LPCWSTR;
    typedef int            BOOL;

    typedef struct {DWORD biSize; LONG  biWidth; LONG  biHeight; WORD  biPlanes; WORD  biBitCount; DWORD biCompression; DWORD biSizeImage;
    LONG  biXPelsPerMeter; LONG biYPelsPerMeter; DWORD biClrUsed; DWORD biClrImportant;} BITMAPINFOHEADER;
    typedef struct {BYTE rgbBlue; BYTE rgbGreen; BYTE rgbRed; BYTE rgbReserved;} RGBQUAD;
    typedef struct {BITMAPINFOHEADER bmiHeader; RGBQUAD bmiColors[1];} BITMAPINFO;
    typedef struct {DWORD  nLength; LPVOID lpSecurityDescriptor; BOOL bInheritHandle; } SECURITY_ATTRIBUTES, *LPSECURITY_ATTRIBUTES;

    int GetDC(int hWnd);
    int ReleaseDC(int hWnd, int hDC);
    int SelectObject(int hdc, int h);
    int CreateCompatibleDC(int hdc);
    int CreateCompatibleBitmap(int hdc, int cx, int cy);
    bool DeleteObject(int ho);
    void delete(void *ptr);
    bool BitBlt(int hdc, int x, int y, int cx, int cy, int hdcSrc, int x1, int y1, unsigned long rop);
    int GetDIBits(int hdc, int hbm, unsigned int start, unsigned int cLines, LPVOID lpvBits, BITMAPINFO* lpbmi, unsigned int usage);

    void free(void *ptr);
    void *malloc(size_t size);
    void *memcpy( void * destination, const void * source, size_t num );


    HANDLE CreateFileA(
        LPCSTR lpFileName,
        DWORD dwDesiredAccess,
        DWORD dwShareMode,
        LPSECURITY_ATTRIBUTES lpSecurityAttributes,
        DWORD dwCreationDisposition,
        DWORD dwFlagsAndAttributes,
        HANDLE hTemplateFile
    );
    BOOL CloseHandle(HANDLE hObject);

    BOOL WriteFile(
        HANDLE       hFile,
        LPCVOID      lpBuffer,
        DWORD        nNumberOfBytesToWrite,
        LPDWORD      lpNumberOfBytesWritten,
        void*        lpOverlapped
    );

    BOOL ReadFile(
        HANDLE       hFile,
        LPVOID       lpBuffer,
        DWORD        nNumberOfBytesToRead,
        LPDWORD      lpNumberOfBytesRead,
        void*        lpOverlapped
    );

    DWORD SetFilePointer(
      HANDLE hFile,
      LONG   lDistanceToMove,
      PLONG  lpDistanceToMoveHigh,
      DWORD  dwMoveMethod
    );

    DWORD GetLastError(void);
    void Sleep(int ms);

]]
ffi.cdef[[
// Структура с параметрами отклонения цвета.
// blue plus
// green plus
// red plus
// blue minus
// green minus
// red minus
struct deviation_c {unsigned char bp, gp, rp, bm, gm, rm;};
struct deviation_f {float bp, gp, rp, bm, gm, rm;};
// Структура с изображением.
// Указатель на bitmap
// ширина
// высота
// длина строки
struct img {unsigned char *bitmap;
    	int w, h, l;};
// чтобы можно было результат индексировать.
// этими типами объявляются указатели на результат.
typedef int int5[5];
typedef int int6[6];

// findimage no deviation
int accuracy_restrict2a4af5_no_d(
    unsigned char *restrict pattern,
    unsigned char *restrict area,
    unsigned char* pattern_limit,

    int pattern_width,
    int pattern_height,
    int step_x,
    int step_y,
    int from_end_to_start_x,

    int pattern_limit_x_add,
    int area_lenght,
    int area_offset_x1,
    int area_offset_y1,
    int area_offset_x2,
    unsigned char *restrict area_y_limit,

    int result[][5],
    int result_size,
    int dots_total,
    int accuracy_too_low
    );

// findimage no deviation with background
int accuracy_restrict2a4af5_no_d_bg(
    unsigned char *restrict pattern,
    unsigned char *restrict area,
    unsigned char* pattern_limit,

    int pattern_width,
    int pattern_height,
    int step_x,
    int step_y,
    int from_end_to_start_x,

    int pattern_limit_x_add,
    int area_lenght,
    int area_offset_x1,
    int area_offset_y1,
    int area_offset_x2,
    unsigned char *restrict area_y_limit,

    int result[][5],
    int result_size,
    int dots_total,
    int accuracy_too_low,
    char bg_blue,
    char bg_green,
    char bg_red
    );

// findimage "a" / "r"
int accuracy_restrict2a4af5(
    unsigned char *restrict pattern_min,
    unsigned char *restrict pattern_max,
    unsigned char *area,
    unsigned char *restrict pattern_limit,

    int pattern_width,
    int pattern_height,
    int real_step_x,
    int real_step_y,
    int from_end_to_start_x,

    int pattern_limit_x_add,
    int area_lenght,
    int area_offset_x1,
    int area_offset_y1,
    int area_offset_x2,
    unsigned char * area_y_limit,

    int result[][5],
    int result_size,
    int dots_total,
    int accuracy_too_low
    );

// findimage "a" / "r" with background
int accuracy_restrict2a4af5_bg(
    unsigned char *restrict pattern_min,
    unsigned char *restrict pattern_max,
    unsigned char *area,
    unsigned char *restrict pattern_limit,

    int pattern_width,
    int pattern_height,
    int real_step_x,
    int real_step_y,
    int from_end_to_start_x,

    int pattern_limit_x_add,
    int area_lenght,
    int area_offset_x1,
    int area_offset_y1,
    int area_offset_x2,
    unsigned char * area_y_limit,

    int result[][5],
    int result_size,
    int dots_total,
    int accuracy_too_low,
    char bg_blue,
    char bg_green,
    char bg_red
    );

// findimage "s"
int accuracy_restrict2a4af5_s_short(
    unsigned short *restrict pattern_min,
    unsigned short *restrict pattern_max,
    unsigned short *restrict area_converted,
    unsigned short *pattern_limit,

    int pattern_width,
    int pattern_height,
    int step_x,
    int step_y,
    int from_end_to_start_x,

    int pattern_limit_x_add,
    int area_lenght,
    int area_offset_x1,
    int area_offset_y1,
    int area_offset_x2,
    unsigned short *restrict area_y_limit,

    int result[][5],
    int result_size,
    int dots_total,
    int accuracy_too_low
    );

// findimage "s" with background
int accuracy_restrict2a4af5_s_short_bg(
    unsigned short *restrict pattern_min,
    unsigned short *restrict pattern_max,
    unsigned short *restrict area_converted,
    unsigned char  *restrict area_original,
    unsigned short *pattern_limit,

    int pattern_width,
    int pattern_height,
    int step_x,
    int step_y,
    int from_end_to_start_x,

    int pattern_limit_x_add,
    int area_lenght,
    int area_offset_x1,
    int area_offset_y1,
    int area_offset_x2,
    unsigned short *restrict area_y_limit,

    int result[][5],
    int result_size,
    int dots_total,
    int accuracy_too_low,
    char bg_blue,
    char bg_green,
    char bg_red
    );

// "a"
void converter_a2b(struct img source, struct deviation_c d,
                   unsigned char *result_min, unsigned char *result_max);
// "r"
void converter_r2b_symetric_d_float(struct img source, struct deviation_f d,
                   unsigned char *result_min, unsigned char *result_max);
void converter_r2b3_asymetric_d_float(struct img source, struct deviation_f d,
                   unsigned char *result_min, unsigned char *result_max);
// "s"
void converter_s5_screen(struct img source, unsigned short *result);
void converter_s5_pattern_d_float(struct img source, struct deviation_f d,
                  unsigned short *result_min, unsigned short *result_max);

// findcolor no deviation
int accuracy_restrict2a4af5_color_strict(
    unsigned char *restrict area,
    unsigned char *restrict area_y_limit,

    int area_lenght,
    int area_offset_x1,
    int area_offset_y1,
    int area_offset_x2,

    int result[][6],
    int result_size,

    unsigned char blue,
    unsigned char green,
    unsigned char red
    );

// findcolor "a" / "r"
int accuracy_restrict2a4af5_color(
    unsigned char *restrict area,
    unsigned char *restrict area_y_limit,

    int area_lenght,
    int area_offset_x1,
    int area_offset_y1,
    int area_offset_x2,

    int result[][6],
    int result_size,

    unsigned char blue_min,
    unsigned char green_min,
    unsigned char red_min,
    unsigned char blue_max,
    unsigned char green_max,
    unsigned char red_max
    );

// findcolor "s"
int accuracy_restrict2a4af5_color_s(
    unsigned char *restrict area,
    unsigned char *restrict area_y_limit,

    int area_lenght,
    int area_offset_x1,
    int area_offset_y1,
    int area_offset_x2,

    int result[][6],
    int result_size,

    unsigned short blue_min,
    unsigned short green_min,
    unsigned short red_min,
    unsigned short blue_max,
    unsigned short green_max,
    unsigned short red_max
    );
]]

jit.opt.start(
    "maxtrace=4000",    --Max. number of traces in the cache
    "maxrecord=16000",  --Max. number of recorded IR instructions
    "maxirconst=2000",  --Max. number of IR constants of a trace
    "maxside=400",      --Max. number of side traces of a root trace
    "maxsnap=125",      --Max. number of snapshots for a trace
    "hotloop=24",       --Number of iterations to detect a hot loop or hot call
    "hotexit=5",        --Number of taken exits to start a side trace
    "tryside=4",        --Number of attempts to compile a side trace
    "instunroll=4",	    --Max. unroll factor for instable loops
    "loopunroll=15",	--Max. unroll factor for loop ops in side traces
    "callunroll=3",	    --Max. unroll factor for pseudo-recursive calls
    "recunroll=2",      --Min. unroll factor for true recursion
    "sizemcode=256",    --Size of each machine code area in KBytes (Windows: 64K)
    "maxmcode=8192"     --Max. total size of all machine code areas in KBytes
    )


-- Адаптируем workwindow под пилот.
local workwindow = workwindow
if not workwindow then
    local wnd = 0
    workwindow = function(var)
        if var then
            wnd = var
        end
        return wnd
    end
end



local ext          = {} -- функции для экспорта.
      ext.images   = {} -- список функций буфера.
local images       = {} -- непосредственно буфер.
local internal     = {} -- внутренние функции.

--[[
    -- Создаем буфер для изображения.
    -- Выделяем память, создаем указатели
    -- Размер буфера для хранения времнно захваченных изображений
    -- При повторном getimage или convert(если конвертируется избражение НЕ из файла)
    -- предыдущий захват и результат будут перезаписаны.
    -- Для сохранения изображения использовать ext.image_copy
]]

local image_buffer_p_void = nil -- будущий указатель void          на temp_storage
local image_buffer_p_char = nil -- будущий указатель unsigned char на temp_storage
local links = {}
do
    -- Устанавливаем размер буфера.
    -- Синтаксис:
    -- [size] - размер буфера который необходимо устрановить. Необязательный параметр.
    -- Вернет:
    -- текущий размер в байтах
    local image_buffer_size = 0                                          -- 33554432 = 32 MB
    ext.images.temp_storage_size = function(size)
        if size and type(size) == "number" then
            image_buffer_size   = size
            image_buffer_p_void = nil
            collectgarbage()
            image_buffer_p_void = ffi.gc(C.malloc(image_buffer_size), C.free)     -- выделяем память, вернет указатель на void
            image_buffer_p_char = ffi.cast("unsigned char*", image_buffer_p_void) -- создаем указатель на unsigned char
        end
        return image_buffer_size
    end
    --ext.images.temp_storage_size(33554432)

    -- Задать размер буфера не менее, чем size.
    -- Если необходимо буфер будет увеличен.
    -- Размер буфера при вызове этой функции не уменьшается до size.
    -- Синтаксис:
    -- size - размер буфера который необходимо устрановить.
    -- Вернет:
    -- текущий размер в байтах
    ext.images.temp_storage_size_up = function(size)
        if size and type(size) == "number" then
            if size > image_buffer_size then
                image_buffer_size   = size
                image_buffer_p_void = nil
                collectgarbage()
                -- выделяем память, вернет указатель на void
                image_buffer_p_void = ffi.gc(C.malloc(image_buffer_size), C.free)
                -- создаем указатель на unsigned char
                image_buffer_p_char = ffi.cast("unsigned char*", image_buffer_p_void)
            end
        end
        return image_buffer_size
    end

end

--[[ Функция проверяет достаточного ли размера буфер
    -- для хранения набора изображений.
    -- При необходимости функция увеличит буфер.
    -- Изображения передаются в виде массива или массива массивов,
    -- размер результата в виде поля result={строки, столбцы} где:
    -- {   {size} -- просто указан размер.
    --
    --      -- при передаче необходимо указать ширину, высоту и [deviation_type] (опционально)
    --     {w=ширина_изображения,
    --      h=высота_изображения,
    --      [deviation_type=метод_которым_оно_будет_конвертировано("a"|"r"|"s"|nil)]} -- deviation_type необязательный параметр
    --
    --     -- либо указать стартовые и конечные коориданты в виде массива и [deviation_type] (опционально)
    --     {[1]=стартовая x координата,
    --      [2]=стартовая y координата,
    --      [3]=конечная  x координата,
    --      [4]=конечная  y координата,
    --      [deviation_type=метод_которым_оно_будет_конвертировано("a"|"r"|"s"|nil)]} -- deviation_type необязательный параметр
    --
    --     -- либо указать стартовые и конечные коориданты в виде таблицы
    --     -- (имеет более высокий приоритет чем массив) и [metod] (опционально)
    --     {x1=стартовая x координата,
    --      y1=стартовая y координата,
    --      x2=конечная  x координата,
    --      y2=конечная  y координата,
    --      [deviation_type=метод_которым_оно_будет_конвертировано("a"|"r"|"s"|nil)]} -- deviation_type необязательный параметр
    --     {false} - пропустить элемент.
    --
    --      result={количество_строк, количество_столбцов(findimage 5 столбцов, findcolor 6 столбцов)}
    --
    -- }
    -- Вернет массив массивов:
    -- {
    --     {bitmap=void*_для_размещения_изображения, address=адрес,
    --      w=ширина, h=высота, l=длина_с_выравниванием}
    -- }
]]
internal.temp_storage_get_pointers = function(img_array)
    if not (img_array[1] and type(img_array[1]) == "table" or img_array.result) then
        img_array = {img_array}
    end

    local pointers = {}
    -- рассчитываем размер необходимого буфера
    local image_buffer_required = 0
    for i=1, #img_array do
        -- Результат не требуется?
        -- Используется для сохранения индексации.
        if img_array[i] ~= false then
            -- Заполняем h, w, l в итоговом массиве.
            pointers[#pointers+1] = {}

            -- запрошен размер без дополнительных данных
            -- не изображение с винта (будет кэшировано
            -- в images а не в temp_storage).
            if  type(img_array[i]) ~= "number"
            and type(img_array[i][1]) ~= "string"
            then
                if img_array[i].w then
                    pointers[#pointers].w = img_array[i].w
                elseif img_array[i].x2 then
                    pointers[#pointers].w = img_array[i].x2 - img_array[i].x1 + 1
                else
                    pointers[#pointers].w = img_array[i][3] - img_array[i][1] + 1
                end

                if img_array[i].h then
                    pointers[#pointers].h = img_array[i].h
                elseif img_array[i].y2 then
                    pointers[#pointers].h = img_array[i].y2 - img_array[i].y1 + 1
                else
                    pointers[#pointers].h = img_array[i][4] - img_array[i][2] + 1
                end

                pointers[#pointers].l = img_array[i].l or math.ceil(pointers[#pointers].w*3/4)*4

                local bitmap_size = pointers[#pointers].l*pointers[#pointers].h
                if not img_array[i].deviation_type then
                    image_buffer_required = image_buffer_required + bitmap_size
                -- добавляем место под shadow метод
                elseif img_array[i].deviation_type == "s" then
                    image_buffer_required = image_buffer_required + bitmap_size*2
                -- добавляем место под a ли r метод
                elseif img_array[i].deviation_type == "r" or img_array[i].deviation_type == "a" then
                    image_buffer_required = image_buffer_required + bitmap_size
                end
            else
                pointers[#pointers+1] = false
            end
        else
            pointers[#pointers+1] = false
        end
    end

    -- Добавляем место под результат.
    if img_array.result then
        image_buffer_required = image_buffer_required + img_array.result[1]*img_array.result[2]*4
    end

    -- Буфер слишком мал, увеличиваем
    -- до необходимого размера плюс 1MB,
    -- чтобы не пересоздавался из-за каждого байта.
    ext.images.temp_storage_size_up(image_buffer_required + 1048576)


    -- создаем указатели.
    local pos = image_buffer_p_char
    for i = 1, #pointers do
        if not pointers[i] or type(pointers[i][1]) == "string" then
            pointers[i] = {bitmap=0}
        elseif type(pointers[i]) == "number" then
            -- размер задан числом, нет информации о ширине/высоте
            pointers[i].bitmap  = 0
            pointers[i].address = 0
            pos = pos + pointers[i]
        else
            -- размер задан координатами или шириной+высотой
            pointers[i].address = tonumber(pointers[i].bitmap)
            if img_array[i].deviation_type == "s" then
                pointers[i].bitmap = ffi.cast("unsigned short*", pos)
                pos = pos + pointers[i].h*pointers[i].l*2
            else
                pointers[i].bitmap = pos
                pos = pos + pointers[i].h*pointers[i].l
            end
            pointers[i].address = tonumber(pointers[i].bitmap)
        end
    end
    if img_array.result then
        if img_array.result[2] == 5 then
            pointers.result = ffi.cast("int5*", pos)
        else
            pointers.result = ffi.cast("int6*", pos)
        end
    end
    return pointers
end

--[[ Смещает параметры,
    -- если группа параметров задана массивом.
    -- parmas - массив с параметрами
    -- start_pos - начальная позиция
    -- distance - на сколько смещать.
    -- distance > 0 - вправо
    -- distance < 0 - влево
]]
internal.params_push = function(params, start_pos, distance)
    for i = #params, start_pos, -1 do
        params[i+distance] = params[i]
    end
    return params
end

--[[ Унифицирует формат координат,
    -- распаковывает их в отдельные переменные.
    -- Допустимый синтаксис:
    --
    -- <arr> - массив с координатам.
    -- Вернет 2 или 4 переменные с координатами.
    --
    -- <arr, pos>
    -- arr - массив в который необходимо поместить координаты
    -- pos - позиция в массиве куда должены быть помещены координаты
    -- arr[pos] - массив в котором находятся координаты
    -- Переформирует переданный массив arr
    --
    -- <arr, pos, crds>
    -- arr - массив в который необходимо поместить координаты
    -- pos - позиция в массиве куда должены быть помещены координаты
    -- crds - массив в котором находятся координаты
    -- Переформирует переданный массив arr
    --
    -- Массив с координатам может быть задан 4 способами:
    -- {x1=var, y1=var, x2=var, y2=var}
    -- {x =var, y =var}
    -- {x1=var, y1=var}
    -- {[1]=x1, [2]=y1, [3]=x2, [4]=y2}
    -- {[1]=x1, [2]=y1}
    -- Комбинирование синтаксиса не допускается.
    -- Синтаксис приведен в порядке убывания приоритета.
    -- Т.е. если будет обнаружено поле x1, то
    -- проверок существования поля x или [3] не будет.
]]
internal.unpack_crds = function(arr, pos, crds)
    local result = {}
    if crds then
        if type(crds) ~= "table" then return end
        if crds.x2 then
            internal.params_push(arr, pos+1, 3)
            arr[pos  ] = crds.x1
            arr[pos+1] = crds.y1
            arr[pos+2] = crds.x2
            arr[pos+3] = crds.y2
        elseif crds.x then
            internal.params_push(arr, pos+1, 1)
            arr[pos  ] = crds.x
            arr[pos+1] = crds.y
        elseif crds.x1 then
            internal.params_push(arr, pos+1, 1)
            arr[pos  ] = crds.x1
            arr[pos+1] = crds.y1
        elseif crds[3] then
            internal.params_push(arr, pos+1, 3)
            arr[pos  ] = crds[1]
            arr[pos+1] = crds[2]
            arr[pos+2] = crds[3]
            arr[pos+3] = crds[4]
        else
            internal.params_push(arr, pos+1, 1)
            arr[pos  ] = crds[1]
            arr[pos+1] = crds[2]
        end
    elseif pos then
        if type(arr[pos]) ~= "table" then return end
        if  arr[pos  ].x2 then
            internal.params_push(arr, pos+1, 3)
            arr[pos+1] = arr[pos].y1
            arr[pos+2] = arr[pos].x2
            arr[pos+3] = arr[pos].y2
            arr[pos  ] = arr[pos].x1
        elseif arr[pos].x then
            internal.params_push(arr, pos+1, 1)
            arr[pos+1] = arr[pos].y
            arr[pos  ] = arr[pos].x
        elseif arr[pos].x1 then
            internal.params_push(arr, pos+1, 1)
            arr[pos+1] = arr[pos].y1
            arr[pos  ] = arr[pos].x1
        elseif arr[pos][3] then
            internal.params_push(arr, pos+1, 3)
            arr[pos+1] = arr[pos][2]
            arr[pos+2] = arr[pos][3]
            arr[pos+3] = arr[pos][4]
            arr[pos  ] = arr[pos][1]
        else
            internal.params_push(arr, pos+1, 1)
            arr[pos+1] = arr[pos][2]
            arr[pos  ] = arr[pos][1]
        end
    else
        if type(arr) ~= "table" then return end
        if crds.x1 then
            return crds.x1, crds.y1, crds.x2, crds.y2
        elseif crds.x then
            return crds.x, crds.y
        elseif crds[3] then
            return crds[1], crds[2], crds[3], crds[4]
        else
            return crds[1], crds[2]
        end
    end
end

--[[
    -- Приводим параметры изображения к единому формату:
    -- method, {crds}, abs_flag
    -- значение не возвращаем
    -- перезаписываем оригинальную таблицу
]]
internal.parse_image_params = function(params)
    local result = {}
    if type(params[2]) == "number" then
        if type(params[5]) == "number" then
                params[2] = {params[2], params[3], params[4], params[5]}
                params[3] = params[5] -- abs
        else
            params[2] = {params[1], params[2], params[3], params[4]}
            params[1] = 0
            params[3] = params[6]     -- abs
        end
    elseif type(params[2]) == "table" then
        --params[2] = internal.unpack_crds(params[2])
    end
    --
    if params[#params] == true or params[#params] == "abs" then
        params[3] = true
    else
        params[3] = false
    end

    params[4] = nil
    params[5] = nil
    params[6] = nil
end

--[[Конвертирует изображение,
    если источник был путем,
    загрузит в буфер.
    Если изображение уже есть в буфере,
    то просто вернет ссылку
    (если не указан destination_bitmap).
    Допустимый синтаксис:
    <source>, <destination_bitmap|0>, <deviation_type>, <deviation>
    <source>                 - таблица с изображением с полями bitmap, a, h, w, l[, method].
    <destination_bitmap_1|0> - указатель по которому будет сохранен результат.
                               если задан 0 и (deviation ~= 0 или deviation_type == "s"),
                               то будет выделен новый учаток памяти.
    <destination_bitmap_2|0> - указатель по которому будет сохранен результат.
                               если задан 0 и deviation ~= 0 то будет выделен новый учаток памяти.
    <deviation_type>         - тип конвертации (a/r/s)
    <deviation>              - значение конвертации. Для конвертации скрина по типу s использовать 0.
                               должен быть задан, как таблица из 6 элементов.
    Внимание! Если указаны destination_bitmap_1(для скрина в "s")
    или destination_bitmap_1+destination_bitmap_2, то проверка буфера не производится.
    Предполагается, что пользователь знает что делает и хочет получить конвертацию
    в переданные участки памяти.

    Вернет:
    если deviation_type = "s", deviation = 0  - массив img (bitmap, a, h, w[, l][, method]).
                                                l и method берется из source,
                                                вследствии чего могут отсутствовать.
    В других случаях вернет два массива img (bitmap, address, h, w[, l][, method])
    с минимальными заначениями и максимальными значениями deviation соотвественно.
]]
do
    local source_C = ffi.new("struct img")
    source_C.bitmap = ffi.cast("unsigned char*", 0)
    source_C.w      = 0
    source_C.h      = 0
    source_C.l      = 0
    local d_с = ffi.new("struct deviation_c")
    d_с.bm = 0
    d_с.gm = 0
    d_с.rm = 0
    d_с.bp = 0
    d_с.gp = 0
    d_с.rp = 0
    local d_f = ffi.new("struct deviation_f")
    d_f.bm = 0
    d_f.gm = 0
    d_f.rm = 0
    d_f.bp = 0
    d_f.gp = 0
    d_f.rp = 0

    internal.image_converter = function(source, destination_bitmap_1, destination_bitmap_2,
                                        deviation_type, deviation)
        -- Приводим source к структуре СИ.
        source_C.bitmap = ffi.cast("void*", source.bitmap)
        source_C.w      = source.w
        source_C.h      = source.h
        source_C.l      = source.l

        local fuck_you_garbage_collector_1 = 0
        local fuck_you_garbage_collector_2 = 0

        -- Создаем строку deviation для проверки буфера.
        local deviation_str = deviation_type.."_"..table.concat(deviation, "_")

        if deviation_type == "s" then
            if deviation_str == "s_0_0_0_0_0_0" then -- конвертация скрина.
                -- нужно выделить память?
                if not destination_bitmap_1 or destination_bitmap_1 == 0 then
                    -- уже есть в буфере?
                    if images[source.address][deviation_str] then
                        return images[source.address][deviation_str]
                    end
                    fuck_you_garbage_collector_1 = ffi.gc(C.malloc(source.h*source.l*2), C.free)
                    destination_bitmap_1 = ffi.cast("unsigned short*", fuck_you_garbage_collector_1)
                end

                array_comparator.converter_s5_screen(source_C, destination_bitmap_1)
                if type(source.method) == "string" then
                    ext.images.add_sub(source.address, deviation_type, deviation, fuck_you_garbage_collector_1)
                end
                return {bitmap=destination_bitmap_1,
                        address=tonumber(ffi.cast('intptr_t', ffi.cast('void *', destination_bitmap_1))),
                        method=source.method, fuck_you_garbage_collector = fuck_you_garbage_collector_1,
                        h=source.h, w=source.w, l=source.l}
            else                   -- конвертация паттерна.
                d_f.bm = deviation[1]
                d_f.gm = deviation[2]
                d_f.rm = deviation[3]
                d_f.bp = deviation[4]
                d_f.gp = deviation[5]
                d_f.rp = deviation[6]
                -- уже есть в буфере?
                if (not destination_bitmap_1 or destination_bitmap_1 == 0)
                and(not destination_bitmap_2 or destination_bitmap_2 == 0) then
                    if images[source.address][deviation_str] then
                        return images[source.address][deviation_str].min,
                               images[source.address][deviation_str].max
                    end
                end

                -- нужно выделить память?
                if not destination_bitmap_1 or destination_bitmap_1 == 0 then
                    fuck_you_garbage_collector_1 = ffi.gc(C.malloc(source.h*source.l*2), C.free)
                    destination_bitmap_1 = ffi.cast("unsigned short*", fuck_you_garbage_collector_1)
                end
                if not destination_bitmap_2 or destination_bitmap_2 == 0 then
                    fuck_you_garbage_collector_2 = ffi.gc(C.malloc(source.h*source.l*2), C.free)
                    destination_bitmap_2 = ffi.cast("unsigned short*", fuck_you_garbage_collector_2)
                end
                array_comparator.converter_s5_pattern_d_float(source_C, d_f,
                                            destination_bitmap_1, destination_bitmap_2)
                if type(source.method) == "string" then
                    ext.images.add_sub(source.address, deviation_type, deviation,
                                       fuck_you_garbage_collector_1, fuck_you_garbage_collector_2)
                end
                return {bitmap=destination_bitmap_1,
                        address=tonumber(ffi.cast('intptr_t', ffi.cast('void *', destination_bitmap_1))),
                        method=source.method,
                        h=source.h, w=source.w, l=source.l},
                       {bitmap=destination_bitmap_2,
                        address=tonumber(ffi.cast('intptr_t', ffi.cast('void *', destination_bitmap_2))),
                        method=source.method,
                        h=source.h, w=source.w, l=source.l}
            end

        elseif deviation_type == "r" then
            d_f.bm = deviation[1]
            d_f.gm = deviation[2]
            d_f.rm = deviation[3]
            d_f.bp = deviation[4]
            d_f.gp = deviation[5]
            d_f.rp = deviation[6]


            -- уже есть в буфере?
            if (not destination_bitmap_1 or destination_bitmap_1 == 0)
            and(not destination_bitmap_2 or destination_bitmap_2 == 0) then
                if images[source.address][deviation_str] then
                    return images[source.address][deviation_str].min,
                           images[source.address][deviation_str].max
                end
            end

            -- нужно выделить память?
            if not destination_bitmap_1 or destination_bitmap_1 == 0 then
                fuck_you_garbage_collector_1 = ffi.gc(C.malloc(source.h*source.l), C.free)
                destination_bitmap_1 = ffi.cast("unsigned char*", fuck_you_garbage_collector_1)
            end
            if not destination_bitmap_2 or destination_bitmap_2 == 0 then
                fuck_you_garbage_collector_2 = ffi.gc(C.malloc(source.h*source.l), C.free)
                destination_bitmap_2 = ffi.cast("unsigned char*", fuck_you_garbage_collector_2)
            end
            if  d_f.bm == d_f.bp
            and d_f.gm == d_f.gp
            and d_f.rm == d_f.rp then
                array_comparator.converter_r2b_symetric_d_float(source_C, d_f,
                                            destination_bitmap_1, destination_bitmap_2)
            else
                array_comparator.converter_r2b3_asymetric_d_float(source_C, d_f,
                                            destination_bitmap_1, destination_bitmap_2)
            end

            if type(source.method) == "string" then
                ext.images.add_sub(source.address, deviation_type, deviation,
                                   fuck_you_garbage_collector_1, fuck_you_garbage_collector_2)
            end

            return {bitmap=destination_bitmap_1,
                    address=tonumber(ffi.cast('intptr_t', ffi.cast('void *', destination_bitmap_1))),
                    method=source.method,
                    h=source.h, w=source.w, l=source.l},
                   {bitmap=destination_bitmap_2,
                    address=tonumber(ffi.cast('intptr_t', ffi.cast('void *', destination_bitmap_2))),
                    method=source.method,
                    h=source.h, w=source.w, l=source.l}

        elseif deviation_type == "a" then
            d_с.bm = deviation[1]
            d_с.gm = deviation[2]
            d_с.rm = deviation[3]
            d_с.bp = deviation[4]
            d_с.gp = deviation[5]
            d_с.rp = deviation[6]

            -- уже есть в буфере?
            if (not destination_bitmap_1 or destination_bitmap_1 == 0)
            and(not destination_bitmap_2 or destination_bitmap_2 == 0) then
                if images[source.address][deviation_str] then
                    return images[source.address][deviation_str].min,
                           images[source.address][deviation_str].max
                end
            end

            -- нужно выделить память?
            if not destination_bitmap_1 or destination_bitmap_1 == 0 then
                fuck_you_garbage_collector_1 = ffi.gc(C.malloc(source.h*source.l), C.free)
                destination_bitmap_1 = ffi.cast("unsigned char*", fuck_you_garbage_collector_1)
            end
            if not destination_bitmap_2 or destination_bitmap_2 == 0 then
                fuck_you_garbage_collector_2 = ffi.gc(C.malloc(source.h*source.l), C.free)
                destination_bitmap_2 = ffi.cast("unsigned char*", fuck_you_garbage_collector_2)
            end
            array_comparator.converter_a2b(source_C, d_с,
                                        destination_bitmap_1, destination_bitmap_2)
            if type(source.method) == "string" then
                ext.images.add_sub(source.address, deviation_type, deviation,
                                   fuck_you_garbage_collector_1, fuck_you_garbage_collector_2)
            end

            return {bitmap=destination_bitmap_1,
                    address=tonumber(ffi.cast('intptr_t', ffi.cast('void *', destination_bitmap_1))),
                    method=source.method,
                    h=source.h, w=source.w, l=source.l},
                   {bitmap=destination_bitmap_2,
                    address=tonumber(ffi.cast('intptr_t', ffi.cast('void *', destination_bitmap_2))),
                    method=source.method,
                    h=source.h, w=source.w, l=source.l}
        end
    end
end

--[[Приводит deviation к полной таблице из 6 элементов.
    Синтаксис:
    <number> | {<var1>, <var2>, <var3>} | {<var1>, <var2>, <var3>, <var4>, <var5>, <var6>}, deviation_type
    Возможные варианты синтаксиса :
    deviation_general                       - задано одним числом на все каналы в + и в -
    {blue, green, red}                      - на каждый канал отдельно, + и - одинаковые.
    {blue_bottom, green_bottom, red_bottom, - на каждый канал отдельно, + и - индивидуальные.
    blue_upper,  green_upper,  red_upper}

    deviation_type                          - тип deviation s/r/a.
    Вернет новую таблицу deviation из 6 элементов (исходная не модифицируется).
]]
internal.deviation_parse = function(deviation, deviation_type)
    local deviation_parsed = {}
    if type(deviation) == "table" then
        if #deviation == 3 then
            deviation_parsed[1] = deviation[1]
            deviation_parsed[2] = deviation[2]
            deviation_parsed[3] = deviation[3]
            deviation_parsed[4] = deviation[1]
            deviation_parsed[5] = deviation[2]
            deviation_parsed[6] = deviation[3]

            if deviation_type ~= "a" then
                deviation_parsed[1] = 1/deviation_parsed[1]
                deviation_parsed[2] = 1/deviation_parsed[2]
                deviation_parsed[3] = 1/deviation_parsed[3]
            end
        else
            deviation_parsed[1] = deviation[1]
            deviation_parsed[2] = deviation[2]
            deviation_parsed[3] = deviation[3]
            deviation_parsed[4] = deviation[4]
            deviation_parsed[5] = deviation[5]
            deviation_parsed[6] = deviation[6]
        end
    else
        deviation_parsed[1] = deviation
        deviation_parsed[2] = deviation
        deviation_parsed[3] = deviation
        deviation_parsed[4] = deviation
        deviation_parsed[5] = deviation
        deviation_parsed[6] = deviation

        if deviation_type ~= "a" then
            deviation_parsed[1] = 1/deviation_parsed[1]
            deviation_parsed[2] = 1/deviation_parsed[2]
            deviation_parsed[3] = 1/deviation_parsed[3]
        end
    end

    return deviation_parsed
end


-- Раскладывает код цвета на отдельные каналы.
ext.rgb_color_to_rgb = function(c)
    local r,g,b
    r = math.floor(c/65536)
    g = math.floor(c/256-r*256)
    b = c-r*256*256-g*256
    return r, g ,b
end

ext.rgb_color_to_bgr = function(c)
    local r,g,b
    r = math.floor(c/65536)
    g = math.floor(c/256-r*256)
    b = c-r*256*256-g*256
    return b, g, r
end

ext.bgr_color_to_rgb = function(c)
    local r,g,b
    b = math.floor(c/65536)
    g = math.floor(c/256-b*256)
    r = c-b*256*256-g*256
    return r, g ,b
end

ext.bgr_color_to_bgr = function(c)
    local r,g,b
    b = math.floor(c/65536)
    g = math.floor(c/256-b*256)
    r = c-b*256*256-g*256
    return b, g, r
end

ext.rgb_to_bgr_color = function(r, g, b)
    return b*256*256 + g*256 + r
end

ext.bgr_to_bgr_color = function(b, g, r)
    return b*256*256 + g*256 + r
end

--[[
    -- Функция разворачивает цвет по каналам.
    -- Применяется для предварительной распаковки
    -- цветов и снижения нагрузки во время работы.
    -- <color>
    -- Непосредственно цвет, который может быть задан:
    -- color | {color} | {color1, color2}
    -- Вернет:
    -- {r, g, b} - если входящим параметром был color | {color}
    -- {r1, g1, b1, r2, g2, b2} - если входящим параметром был {color1, color2}
    -- Внимание! В случае если цвет был задан иным способом, включая:
    -- {r, g, b} или {r_min, g_min, b_min, r_max, g_max, b_max},
    -- значения будут просто откопированы и возвращены.
]]
function ext.parse_color(color)
    -- Разворачиваем color в нормальный массив rgb по каналам.
    if type(color) == "number" then
        return {ext.rgb_color_to_rgb(color)}
    elseif #color == 1 then
        return {ext.rgb_color_to_rgb(color[1])}
    elseif #color == 2 then
        local result = {ext.rgb_color_to_rgb(color[1])}
        result[4], result[5], result[6] = ext.rgb_color_to_rgb(color[2])
        return result
    else
        return {unpack(color[i])}
    end
end

--[[
    -- Функция разворачивает цвет по каналам.
    -- Применяется для предварительной распаковки
    -- цветов и снижения нагрузки во время работы.
    -- <color>
    -- МАССИВ цветов.
    -- Каждый из цветов может быть задан:
    -- color | {color} | {color1, color2}
    -- Вернет массив цветов разложенных по каналам,
    -- где каждый цвет будет иметь вид:
    -- {r, g, b} - если входящим параметром был color | {color}
    -- {r1, g1, b1, r2, g2, b2} - если входящим параметром был {color1, color2}
    -- Внимание! В случае если цвет был задан иным способом, включая:
    -- {r, g, b} или {r_min, g_min, b_min, r_max, g_max, b_max},
    -- значения будут просто откопированы и возвращены.
]]
function ext.parse_color_multi(color)
    -- Разворачиваем color в нормальный массив rgb по каналам.
    local result = {}
    for i = 1, #color do
        if type(color[i]) == "number" then
            result[i] = {ext.rgb_color_to_rgb(color[i])}
        elseif #color[i] == 1 then
            result[i] = {ext.rgb_color_to_rgb(color[i][1])}
        elseif #color[i] == 2 then
            result[i] = {ext.rgb_color_to_rgb(color[i][1])}
            result[i][4], result[i][5], result[i][6] = ext.rgb_color_to_rgb(color[i][2])
        else
            result[i] = {unpack(color[i])}
        end
    end
    return result
end

-- Возвращает цвет пикселя в захваченном изображении.
ext.get_pix = function(img, x, y)
    local r, g, b, dec, bright
    b = img.bitmap[ img.l*y + x*3 ]
    g = img.bitmap[ img.l*y + x*3+1]
    r = img.bitmap[ img.l*y + x*3+2]
    dec = b*255*255 + g*255 + r
    bright = b + g + r
    return {r, g, b, dec, bright}
end


-- Функция "искажает" цвет применя к нему deviation.
-- Цвет может быть задан:
-- {r, g, b}
-- deviaion
-- Вернет:
-- {r_min, g_min, b_min, r_max, g_max, b_max}
function ext.deviate_color(color_parsed, deviation, deviation_type)
    local result = {}
    for i = 1, #color_parsed do
        result[i] = {}
        if #color_parsed[i] == 3 and deviation then
            if deviation_type == "s" then
                local r = color_parsed[i][1]
                local g = color_parsed[i][2]
                local b = color_parsed[i][3]
                result[i][1] =           (r + 1) * 0xFF / (b + 1)*deviation[1]
                result[i][2] =           (g + 1) * 0xFF / (r + 1)*deviation[2]
                result[i][3] =           (b + 1) * 0xFF / (g + 1)*deviation[3]
                result[i][4] = math.ceil((r + 1) * 0xFF / (b + 1)*deviation[4])
                result[i][5] = math.ceil((g + 1) * 0xFF / (r + 1)*deviation[5])
                result[i][6] = math.ceil((b + 1) * 0xFF / (g + 1)*deviation[6])
            elseif deviation_type == "r" then
                result[i][1] = math.floor(color_parsed[i][1]*deviation[1])
                result[i][2] = math.floor(color_parsed[i][2]*deviation[2])
                result[i][3] = math.floor(color_parsed[i][3]*deviation[3])
                result[i][4] = math.min(math.ceil(color_parsed[i][1]*deviation[4]), 255)
                result[i][5] = math.min(math.ceil(color_parsed[i][2]*deviation[5]), 255)
                result[i][6] = math.min(math.ceil(color_parsed[i][3]*deviation[6]), 255)
            elseif deviation_type == "a" then
                result[i][1] = math.max(color_parsed[i][1] - deviation[1], 0  )
                result[i][2] = math.max(color_parsed[i][2] - deviation[2], 0  )
                result[i][3] = math.max(color_parsed[i][3] - deviation[3], 0  )
                result[i][4] = math.min(color_parsed[i][1] + deviation[4], 255)
                result[i][5] = math.min(color_parsed[i][2] + deviation[5], 255)
                result[i][6] = math.min(color_parsed[i][3] + deviation[6], 255)
            end
        end
    end
    return result
end

--[==[
    -- Функция проводит полный цикл преобразования
    -- по разложению цветов на каналы и
    -- применению deviation к каналам.
    -- <color>, [deviation[, deviation_type]]

    -- <color>
    -- МАССИВ цветов.
    -- Каждый из цветов может быть задан:
    -- color | {color} | {color1, color2}
    -- Вернет массив цветов разложенных по каналам,
    -- где каждый цвет будет иметь вид:
    -- {r, g, b} - если входящим параметром был color | {color}
    -- {r1, g1, b1, r2, g2, b2} - если входящим параметром был {color1, color2}

    -- [deviation]
    -- Допустимые отклонения цвета. Значение по умлочанию: 0.98, 0.98, 0.98, 1.02, 1.02, 1.02
    -- Возможные варианты синтаксиса:
    --  deviation_general                      - задано одним числом на все каналы в + и в -
    -- {blue, green, red}                      - на каждый канал отдельно, + и - одинаковые.
    -- {blue_lower, green_lower, red_lower, - на каждый канал отдельно, + и - индивидуальные.
    --  blue_upper, green_upper, red_upper}
    --
    -- [deviation_type]
    -- Тип расчета допустимого отклонения цвета. Значение по умолчанию "s".
    -- Возможные значения:
    -- "a" - absolute. Абсолютное отклонение канала.
    --       Например, при цвете 50 100 200 и абсолютном отклонении 10,
    --       допустимый диапазон цветов будет равен 40-60, 90-110, 190-210
    -- "r" - relative. Относительное отклонение, задается множителем.
    --       Например, при цвете 50 100 200 и относительном отклонении 0.1,
    --       допустимый диапазон цветов будет равен 45-55 90-110 180-220.
    --       Округление происход в сторону расширения диапазона.
    --       Например, при значении канала 101 и допустимом отклонении 10%,
    --       допустимыми значениями канала будут 101-11 101+11, т.е. 90-112.
    -- "s" - shadow. Затемнение/осветление. Рассчитывается соотношение каналов, отклонение задается множителем.
    --       Данный метод может быть полезен, например, при смене суток в игре.
    --       В рамках данного метода цвета 50 100 200 и 25 50 100 - будут полностью идентичны.
    --       Для указанных цветов: 200/50=4 50/100=0.5 100/200=0.5
    --                             100/25=4  25/50=0.5  50/100=0.5
    --       При допустимом отклонении в 0.1, будут считаться допустимыми соотношения каналов:
    --       3.6-4.4 0.45-0.55 0.45-0.55
]==]
function ext.evalute_color(color, deviation, deviation_type)
    local parsed_deviation = internal.deviation_parse(deviation, deviation_type)
    local parsed_color = ext.parse_color_multi(color)
    local result = ext.deviate_color(parsed_color, parsed_deviation, deviation_type)
    return result
end

--[==[
    -- Рассчитывает оптимальный step_x и step_y
    -- исходя из того, что:
    -- разница между step_x и step_y не должна
    -- быть больше, чем 1, а точек должно быть
    -- не больше, чем limit
    -- <w>, <h>, <limit>
]==]
function internal.get_step (w, h, limit)
    if w * h > limit then
        for s = 1, w do
            local x = math.min(s, w)
            local y = math.min(s, h)
            local dots_with_step = math.floor(w/x) * math.floor(h/y)
            if dots_with_step <= limit then


                local x_minus = math.min(s-1, w)
                local y_minus = math.min(s-1, h)
                local dots_with_step_x_minus = math.floor(w/x_minus) * math.floor(h/y)
                local dots_with_step_y_minus = math.floor(w/x) * math.floor(h/y_minus)


                if  dots_with_step_y_minus <= limit
                and dots_with_step_y_minus >= dots_with_step_y_minus then
                    return x, y_minus
                end

                if  dots_with_step_x_minus <= limit
                and dots_with_step_x_minus >= dots_with_step_y_minus then
                    return x_minus, y
                end

                return x, y
            end
        end
    end
end

--[====[
    -- findimage
    -- Ищет изображение в изображении.
    -- Синтаксис:
    -- ([{screen},] <{pattern}>, [acc[, deviation[, deviation_type] [, count[, step_x, step_y] [, bg]]]])
    -- Допустимые упрощенные варианты синтаксиса:
    -- (<pattern_source>)
    --
    -- screen и pattern
    -- массивы/массивы массивов с параметрами изображений.
    -- screen      - где искать. Значение по умолчанию {{workwindow()}}.
    -- pattern     - что искать
    --
    -- структруа массива с изображением:
    -- [path|handle|img_obj], [[x1, y1, x2, y2], abs_flag]
    --
    -- [path|handle|img_obj] - источник изображения. Для pattern является обязательным.
    -- path                  - путь по которому находится изображение.
    -- handle                - хэндл приложения из которого необходимо получить изображение. 0 - экран.
    -- img_obj               - таблица {address=адрес_bitmap_в_памяти, h=высота_изображения, w=ширина_изображеия}
    -- ------------------------------------------------------------------------------------------------
    --  x1, y1, x2, y2       - координаты могут быть заданы переменными,
    --
    -- {x1, y1, x2, y2}      - массивом,
    -- {x1, y1, x2, y2}      - массив массивов (например, результат работы findcolor/findimage),
    -- {x1=var1, y1=var2,    - таблицей с полями:
    --  x2=var3, y2=var4}    - x1, y1, x2, y2.
    -- ------------------------------------------------------------------------------------------------
    -- abs_flag              - флаг абсолютных координат
    --
    -- [acc]
    -- Минимальная допустимая точность. Указывается в процентах.
    -- Значение по умолчанию 90.
    --
    -- [deviation]
    -- Допустимые отклонения цвета. Значение по умлочанию: 0.98, 0.98, 0.98, 1.02, 1.02, 1.02
    -- Возможные варианты синтаксиса:
    --  deviation_general                      - задано одним числом на все каналы в + и в -
    -- {blue, green, red}                      - на каждый канал отдельно, + и - одинаковые.
    -- {blue_lower, green_lower, red_lower, - на каждый канал отдельно, + и - индивидуальные.
    --  blue_upper,  green_upper,  red_upper}
    --
    -- [deviation_type]
    -- Тип расчета допустимого отклонения цвета. Значение по умолчанию "s".
    -- Возможные значения:
    -- "a" - absolute. Абсолютное отклонение канала.
    --       Например, при цвете 50 100 200 и абсолютном отклонении 10,
    --       допустимый диапазон цветов будет равен 40-60, 90-110, 190-210
    -- "r" - relative. Относительное отклонение, задается множителем.
    --       Например, при цвете 50 100 200 и относительном отклонении 0.1,
    --       допустимый диапазон цветов будет равен 45-55 90-110 180-220.
    --       Округление происход в сторону расширения диапазона.
    --       Например, при значении канала 101 и допустимом отклонении 10%,
    --       допустимыми значениями канала будут 101-11 101+11, т.е. 90-112.
    -- "s" - shadow. Затемнение/осветление. Рассчитывается соотношение каналов, отклонение задается множителем.
    --       Данный метод может быть полезен, например, при смене суток в игре.
    --       В рамках данного метода цвета 50 100 200 и 25 50 100 - будут полностью идентичны.
    --       Для указанных цветов: 200/50=4 50/100=0.5 100/200=0.5
    --                             100/25=4  25/50=0.5  50/100=0.5
    --       При допустимом отклонении в 0.1, будут считаться допустимыми соотношения каналов:
    --       3.6-4.4 0.45-0.55 0.45-0.55
    --
    -- [count]
    -- Количество искомых изображений. По умолчанию 1.
    --
    -- [step_x, step_y]
    -- шаг поиска паттерна: проверять каждый step_x пиксель по горизонтали, step_y пиксель по вертикали.
    -- Увеличение step_y дает большую разгрузку процессора, чем step_x при том же количестве точек.
    -- Значение по умолчанию: рассчитывается исходя из размеров паттерна,
    -- максимальная разница между step_x и step_y не более 1,
    -- количество значимых пикселей от 11 до 21 если фон не задан.
    -- При заданном фоне количество искомых пикселей 21-40 (до вычета фона).
    --
    -- [bg]
    -- Цвет бэкграунда. Может быть задан:
    -- true      - будет считан цвет левого верхнего пикселя паттерна (с учетом start_x, start_y)
    -- false     - проверка бэкграунда выключена (поиск будет быстрее)
    -- number    - Цвет. Может быть задан десятичным значением либо в hex форме, например: 123456(десятичное), 0x123DEF(hex).
    -- {r, g, b} - массив с элементам 1-3 содержащими значения каналов r, g, b.
    -- {r=var1,  - таблица с полями r, g, b со значениями каналов (имеет больший приоритет чем массив).
    --  g=var2,
    --  b=var3}
    -- Значение по умолчанию true.
]====]
ext.findimage_multi = function(t)
    local screen, pattern, acc, deviation, deviation_type, count, step_x, step_y, bg = unpack(t)
e.lg(screen)
    -- опциональыне смещения при отсутсвии screen
    if type(pattern)  ~= "table" then
        bg             = step_y
        step_y         = step_x
        step_x         = count
        count          = deviation_type
        deviation_type = deviation
        deviation      = acc
        acc            = pattern
        pattern        = screen
        screen         = {{workwindow()}}
    end
    -- acc отсутствует?
    if deviation and type(deviation) == "string" then
        bg             = step_y
        step_y         = step_x
        step_x         = count
        count          = deviation_type
        deviation_type = deviation
        deviation      = acc
    end
    -- deviation_type отсутствует?
    if deviation_type and type(deviation_type) ~= "string" then
        bg             = step_y
        step_y         = step_x
        step_x         = count
        count          = deviation_type
        deviation_type = "s"
    end

    -- Применяем параметры по умолчанию, если они не заданы при вызове
    -- устанавливаем точность
    acc           = acc           or  90

    -- устанавливаем deviation,
    -- создаем штамп девиэйшена по которому будет проверяться кэш.
    local deviation_str = nil
    if deviation then
        deviation = internal.deviation_parse(deviation, deviation_type)
        deviation_str = table.concat(deviation, "_")
    else
        if deviation ~= false then
            deviation = {0.98, 0.98, 0.98, 1.02, 1.02, 1.02}
            deviation_str = table.concat(deviation, "_")
        end
    end

    -- устанавливаем тип deviation
    if deviation and deviation ~= 0 and deviation ~= false then
        deviation_type = deviation_type or "s"
        deviation_str = deviation_type.."_"..deviation_str
    else
        deviation_type = false
    end
    -- устанавливаем количество искомых изображений
    count         = count         or  1

    -- устанавливаем шаг перебора пикселей паттерна
    -- устанавливается ниже при загрузке паттернов

    -- Данные бэкграунда (bg) уточняются
    -- во вермя первого перебора паттернов.
    -- Т.к. на текущем этапе паттерны могут быть еще на загружены,
    -- а фон может быть указан цветом левого верхнего пикселя паттерна.
    bg = bg == nil and true or bg
    local bg_global = {}
    -- распаковываем данные бэкграунда
    if bg then
        if type(bg) == "number" then
            bg_global[1], bg_global[2], bg_global[3] = ext.rgb_color_to_bgr(bg)
        elseif type(bg) == "table" then
            bg_global[1] = bg.b or bg[3]
            bg_global[2] = bg.g or bg[2]
            bg_global[3] = bg.r or bg[1]
        else
            bg_global = nil -- бэкграунд задан, как "true", будет присвоен индивидуально.
        end
    else
        bg_global = nil -- бэкграунд не задан.
    end


    -- Рассчитывем необходимый размер буфера для screen.
    -- при переходе к новому элементу,
    -- прошлый screen[i], если он хранился в temp_storage
    -- будет перезаписан. Т.е. для screen тербуется размер
    -- самого большого screen[i], не всех элеметов.
    -- pattern будет в ходе работы подгружаться кумуятивно,
    -- выгружен не будет, останется в images буфере
	-- (другое адресное пространство, выделение в temp_storage не требуется).
    -- screen будет перезаписан при новом вызове findimage/findcolor.
    -- Перезапись происходит только в temp_storage,
	-- images автоматически не освобождается.

    -- Подготавливаем массив для рассчета буфера и смещений.
    local temp_storage_request = {}

    -- Находим самое большое (площадь с выравниванием) изображение в screen
    -- так же учитываем, что при deviation_type == "s" будут созданы копии.
    local screen_max_size = 0
    local max_image_i     = nil
    for i = 1, #screen do
        -- Стандартизируем параметры.
        internal.parse_image_params(screen[i])

        local screen_size = 0
        -- Уже в буфере?
        -- Создаем линк на буфер, где должно было
        -- бы находиться изоражение.
        -- Проверяем есть ли такой элемент буфера.
        local images_i = nil
        if     type(screen[i][1]) == "string" then
            -- загружаемые картинки всегда падают в images
            -- им не нужен temp_storage
            images_i = screen[i][1]
        elseif type(screen[i][1]) == "number" then
            -- с хендлом в буфере не может быть изображений
			-- исходим из того, что number - это адрес в памяти.
            screen_size = (screen[i][2][3]-screen[i][2][1]+1)
                             *(screen[i][2][4]-screen[i][2][2]+1)
            if deviation_type == "s" then
                screen_size = screen_size * 3
            end
        elseif type(screen[i][1]) == "table"  then
            images_i = screen[i][1].address

            -- Для deviation_type = "s" требует конвертация исходного скрина.
            -- Проверяем было ли уже конвертировано изображение ранее.
            if deviation_type == "s" then
                -- Если method задан числом,
                -- значит нужно забирать изображение
                -- и его не может быть в буфере.
                if not images[images_i] or not images[images_i].s then
                    screen_size = screen_size + (screen[i][2][3]-screen[i][2][1]+1)
                                               *(screen[i][2][4]-screen[i][2][2]+1)
                                               *2
                end
            end
        end
        screen[i].images_i = images_i

        if screen_size > screen_max_size then
            screen_max_size = screen_size
            max_image_i     = i
        end
    end

    -- Запрашиваем максимальный screen
    if max_image_i then
        temp_storage_request[1] = {screen[max_image_i][2][1],
                                   screen[max_image_i][2][2],
                                   screen[max_image_i][2][3],
                                   screen[max_image_i][2][4]}
        if   deviation_type == "s"
        and (   not images[screen[max_image_i].images_i]
             or not images[screen[max_image_i].images_i].s) then
            temp_storage_request[2] = screen[max_image_i][2]
            temp_storage_request[2].deviation_type = "s"
        end
    else
        temp_storage_request[1] = false
        if   deviation_type == "s" then
            temp_storage_request[2] = false
        end
    end

    -- Собираем все pattern
    -- в запрос на выдачу указателей.
    for i = 1, #pattern do
        -- Стандартизируем параметры.
        internal.parse_image_params(pattern[i])

        -- создаем имя элемента по которому он может
        -- находиться в буфере.
        local images_i = nil
        if     type(pattern[i][1]) == "string" then
            images_i = pattern[i][1]
        elseif type(pattern[i][1]) == "table"  then
            images_i = pattern[i][1].address
        elseif type(pattern[i][1]) == "number" then
            -- с хендлом в буфере не может быть изображений
        end

        -- Файлы будут кэшированы в images,
        -- запрашивать при этом temp_storage бессмысленно.
        if type(pattern[i][1]) ~= "string" then
            -- запоминаем адрес буфера (наличие в буфере не гарантировано)
            pattern[i].images_i = images_i
            -- Имеется ли в буфере изображение?
            if images[pattern[i].images_i] then
                temp_storage_request[#temp_storage_request+1] = false
            else
                temp_storage_request[#temp_storage_request+1] = pattern[i][2]
            end


            if deviation_type == "s" then
                if type(pattern[i][1]) ~= "number" then
                    pattern[i].images_s_path = "s"..deviation_str
                end
                if not images[pattern[i].images_i]
                or not images[pattern[i].images_i] [pattern[i].images_s_path] then
                    pattern[i][2].deviation_type = "s"
                    temp_storage_request[#temp_storage_request+1] = pattern[i][2]
                    temp_storage_request[#temp_storage_request+1] = pattern[i][2]
                else
                    temp_storage_request[#temp_storage_request+1] = false
                    temp_storage_request[#temp_storage_request+1] = false
                end

            elseif deviation_type == "r" then
                if type(pattern[i][1]) ~= "number" then
                    pattern[i].images_s_path = "r"..deviation_str
                end
                if not images[pattern[i].images_i]
                or not images[pattern[i].images_i] [pattern[i].images_s_path] then
                    pattern[i][2].deviation_type = "r"
                    temp_storage_request[#temp_storage_request+1] = pattern[i][2]
                    temp_storage_request[#temp_storage_request+1] = pattern[i][2]
                else
                    temp_storage_request[#temp_storage_request+1] = false
                    temp_storage_request[#temp_storage_request+1] = false
                end

            elseif deviation_type == "a" then
                if type(pattern[i][1]) ~= "number" then
                    pattern[i].images_s_path = "a"..deviation_str
                end
                if not images[pattern[i].images_i]
                or not images[pattern[i].images_i] [pattern[i].images_s_path] then
                    pattern[i][2].deviation_type = "a"
                    temp_storage_request[#temp_storage_request+1] = pattern[i][2]
                    temp_storage_request[#temp_storage_request+1] = pattern[i][2]
                else
                    temp_storage_request[#temp_storage_request+1] = false
                    temp_storage_request[#temp_storage_request+1] = false
                end
            end
        else
            temp_storage_request[#temp_storage_request+1] = false
            if deviation_type == "s" or deviation_type == "r" or deviation_type == "a" then
                temp_storage_request[#temp_storage_request+1] = false
                temp_storage_request[#temp_storage_request+1] = false
            end
        end
    end

    temp_storage_request.result={count, 5}
    local pointers = internal.temp_storage_get_pointers(temp_storage_request)

    local screen_buffer_pointer           = 0
    -- С какого индекса в массиве указателей
    -- начинаются паттерны.
    -- Зависит от того нужен ли буфер под скрин
    -- и будет ли производится конвертация скрина.
    local pattern_pointer_start_i   = 1

    -- Скринам треубется буфер.
    if max_image_i then
        screen_buffer_pointer = pointers[1].bitmap
        pattern_pointer_start_i   = 2
    end


    -- Получаем исходник скрина
    -- если его нет в буфере.
    local area = nil
    if type(screen[1][1]) == "table" then
        area = screen[1][1]
    else
        area = internal.getimage(screen_buffer_pointer,
                                 screen[1][2][1],
                                 screen[1][2][2],
                                 screen[1][2][3],
                                 screen[1][2][4],
                                 screen[1][1],
                                 screen[1][3])
    end

    -- дельта между оффсетом снятого изображения
    -- и координатами поиска.
    local offsets_delta_x = screen[1][2][1] - area.offset_x
    local offsets_delta_y = screen[1][2][2] - area.offset_y
    local C_result_size = 0
    -- Прогон первого скрина может потребовать
    -- конвертации и забора паттернов.
    -- Выполняем его отдельно,
    -- буферезуем паттерны.
    local pattern_converted = {}
    local result = {}
    if deviation_type then
        if deviation_type == "s" then
            -- Конвертируем скрин.
            local screen_buffer_pointer_converted = 0
            if type(area.method) ~= "string" then
                screen_buffer_pointer_converted = ffi.cast("unsigned short*", pointers[2].bitmap)
            end
            --[[local area_converted = internal.image_converter(area,
                                            screen_buffer_pointer_converted,
                                            0, deviation_type, {0,0,0,0,0,0})]]

			-- {0,0,0,0,0,0} флаг скрина. Скрин должен быть преобразован один раз.
			-- паттерн распадается на два - min и max положения deviaton.
            local area_converted = internal.image_converter(area,
                                            screen_buffer_pointer_converted,
                                            screen_buffer_pointer_converted + 33554432/2, deviation_type, {0,0,0,0,0,0})



            if bg then -- поиск с учетом фона
                for pattern_i = 1, #pattern do
                    local pattern_area = nil
                    -- получаем pattern из буфера / делаем забор паттерна.
                    if type(pattern[pattern_i][1]) ~= "table" then
                        pattern_area = internal.getimage(
                            pointers[pattern_pointer_start_i+(pattern_i-1)*3].bitmap,
                            pattern[pattern_i][2][1], -- x1
                            pattern[pattern_i][2][2], -- y1
                            pattern[pattern_i][2][3], -- x2
                            pattern[pattern_i][2][4], -- y2
                            pattern[pattern_i][1],    -- path / method
                            pattern[pattern_i][3])    -- abs_flag
                    else
                        pattern_area = pattern[pattern_i][1]
                    end

                    -- конвертируем паттерн
                    pattern_converted[pattern_i] = {
                        internal.image_converter(
                            pattern_area,
                            pointers[pattern_pointer_start_i+(pattern_i-1)*3+1].bitmap,
                            pointers[pattern_pointer_start_i+(pattern_i-1)*3+2].bitmap,
                            deviation_type, deviation)
                        }

                    if bg == true then -- бэкгрануд = левый верхний пиксель.
                        pattern_converted[pattern_i].bg = ext.get_pix(pattern_area, 0, 0)
                    else
                        pattern_converted[pattern_i].bg = bg_global
                    end

                    -- устанавливаем шаг перебора пикселей паттерна
                    if not step_x or not step_y then
                        pattern_converted[pattern_i].step_x,
                        pattern_converted[pattern_i].step_y = internal.get_step(
                                            pattern_converted[pattern_i][1].w,
                                            pattern_converted[pattern_i][1].h,
                                            40)
                    else
                        pattern_converted[pattern_i].step_x = step_x
                        pattern_converted[pattern_i].step_y = step_y
                    end

                    local dots_total_key = pattern_converted[pattern_i].step_x
                                    .."_"..pattern_converted[pattern_i].step_y
                                    .."_"..pattern_converted[pattern_i].bg[1].."_"
                                         ..pattern_converted[pattern_i].bg[2].."_"
                                         ..pattern_converted[pattern_i].bg[3]
                    if not pattern_area.dots_total[dots_total_key] then
                        pattern_area.dots_total[dots_total_key] = 0
                        for pattern_y = 0,
                            pattern_area.h*pattern_area.l-1,
                            pattern_area.l*pattern_converted[pattern_i].step_y do
                            for pattern_x = pattern_y,
                                pattern_y + pattern_area.w*3 - 2,
                                pattern_converted[pattern_i].step_x*3 do
                                if  pattern_area.bitmap[pattern_x]   ~= pattern_converted[pattern_i].bg[1]
                                or  pattern_area.bitmap[pattern_x+1] ~= pattern_converted[pattern_i].bg[2]
                                or  pattern_area.bitmap[pattern_x+2] ~= pattern_converted[pattern_i].bg[3] then
                                    pattern_area.dots_total[dots_total_key] = pattern_area.dots_total[dots_total_key] + 1
                                else
                                    print"same color"
                                end
                            end
                        end
                    end
                    pattern_converted[pattern_i].dots_total = pattern_area.dots_total[dots_total_key]

                    pattern_converted[pattern_i].accuracy_too_low = math.floor(pattern_converted[pattern_i].dots_total
                                                                               *(100-acc)/100)
                    local C_result_size = array_comparator.accuracy_restrict2a4af5_s_short_bg(
                        pattern_converted[pattern_i][1].bitmap,     -- unsigned char *restrict pattern_min,
                        pattern_converted[pattern_i][2].bitmap,     -- unsigned char *restrict pattern_max,
                        area_converted.bitmap,                      -- unsigned char *restrict area,
                        area.bitmap,                                -- unsigned char *restrict area_original,
                        pattern_converted[pattern_i][1].bitmap      -- unsigned char *pattern_limit,
                        +pattern_converted[pattern_i][1].l
                        *pattern_converted[pattern_i][1].h,

                        pattern_converted[pattern_i][1].w,                  -- int pattern_width,
                        pattern_converted[pattern_i][1].h,                  -- int pattern_height,
                        pattern_converted[pattern_i].step_x*3,              -- int step_x,
                        pattern_converted[pattern_i].step_y                 -- int step_y,
                        *pattern_converted[pattern_i][1].l,
                        area.l
                        *pattern_converted[pattern_i].step_y
                        -pattern_converted[pattern_i].step_x                -- int from_end_to_start_x,
                        *math.ceil(pattern_converted[pattern_i][1].w
                            /pattern_converted[pattern_i].step_x)*3,

                        pattern_converted[pattern_i][1].w*3-1,              -- int pattern_limit_x_add,
                        area.l,                                             -- int area_lenght,
                        offsets_delta_x*3,                                  -- int area_offset_x1,
                        offsets_delta_y*area.l,                             -- int area_offset_y1,
                        (area.w-pattern_converted[pattern_i][1].w+1)*3,     -- int area_offset_x2,
                        area_converted.bitmap                               -- unsigned char *restrict area_y_limit,
                        +(area.h-pattern_converted[pattern_i][1].h+1)
                        *area.l,

                        pointers.result,                                    -- int result[][5],
                        count,                                              -- int result_size,
                        pattern_converted[pattern_i].dots_total,            -- int dots_total,
                        pattern_converted[pattern_i].accuracy_too_low,      -- int accuracy_too_low,
                        pattern_converted[pattern_i].bg[1],                 -- char bg_blue,
                        pattern_converted[pattern_i].bg[2],                 -- char bg_green,
                        pattern_converted[pattern_i].bg[3]                  -- char bg_red
                    )

                    for i = 0, math.min(C_result_size-1, count-1) do
                        result[#result+1] = {}
                        result[#result].x1      = pointers.result[i][0]
                        result[#result].y1      = pointers.result[i][1]
                        result[#result].x2      = pointers.result[i][2]
                        result[#result].y2      = pointers.result[i][3]
                        result[#result].acc     = pointers.result[i][4]
                        result[#result].source  = screen[1]
                        result[#result].pattern = pattern[pattern_i]
                    end

                    count = count - C_result_size
                end
            else -- фона нет
                for pattern_i = 1, #pattern do
                    local pattern_area = nil
                    -- получаем pattern из буфера / делаем забор паттерна.
                    if type(pattern[pattern_i][1]) == "table" then
                        pattern_area = pattern[pattern_i][1]
                    else
                        pattern_area = internal.getimage(
                            pointers[pattern_pointer_start_i+(pattern_i-1)*3].bitmap,
                            pattern[pattern_i][2][1], -- x1
                            pattern[pattern_i][2][2], -- y1
                            pattern[pattern_i][2][3], -- x2
                            pattern[pattern_i][2][4], -- y2
                            pattern[pattern_i][1],    -- path / method
                            pattern[pattern_i][3])    -- abs_flag
                    end

                    -- конвертируем паттерн
                    pattern_converted[#pattern_converted+1] = {
                        internal.image_converter(
                            pattern_area,
                            pointers[pattern_pointer_start_i+(pattern_i-1)*3+1].bitmap,
                            pointers[pattern_pointer_start_i+(pattern_i-1)*3+2].bitmap,
                            deviation_type, deviation)
                        }

                    pattern_converted[pattern_i].accuracy_too_low = math.floor(pattern_area.h*pattern_area.w
                                                                                             *(100-acc)/100)

                    local C_result_size = array_comparator.accuracy_restrict2a4af5_s_short(
                        pattern_converted[pattern_i][1].bitmap,     -- unsigned char *restrict pattern_min,
                        pattern_converted[pattern_i][2].bitmap,     -- unsigned char *restrict pattern_max,
                        area_converted.bitmap,                      -- unsigned char *restrict area,
                        pattern_converted[pattern_i][1].bitmap      -- unsigned char *pattern_limit,
                        +pattern_converted[pattern_i][1].l
                        *pattern_converted[pattern_i][1].h,

                        pattern_converted[pattern_i][1].w,                  -- int pattern_width,
                        pattern_converted[pattern_i][1].h,                  -- int pattern_height,
                        pattern_converted[pattern_i].step_x*3,              -- int step_x,
                        pattern_converted[pattern_i].step_y
                        *pattern_converted[pattern_i][1].l,                 -- int step_y,
                        area.l                                              -- int from_end_to_start_x,
                        *pattern_converted[pattern_i].step_y
                        -pattern_converted[pattern_i].step_x
                        *math.ceil(pattern_converted[pattern_i][1].w
                            /pattern_converted[pattern_i].step_x)*3,

                        pattern_converted[pattern_i][1].w*3-1,              -- int pattern_limit_x_add,
                        area.l,                                             -- int area_lenght,
                        offsets_delta_x*3,                                  -- int area_offset_x1,
                        offsets_delta_y*area.l,                             -- int area_offset_y1,
                        (area.w-pattern_converted[pattern_i][1].w+1)*3,     -- int area_offset_x2,
                        area_converted.bitmap                               -- unsigned char *restrict area_y_limit,
                        +(area.h-pattern_converted[pattern_i][1].h+1)
                        *area.l,

                        pointers.result,                                    -- int result[][5],
                        count,                                              -- int result_size,
                        pattern_area.h*pattern_area.w,                      -- int dots_total,
                        pattern_converted[pattern_i].accuracy_too_low       -- int accuracy_too_low
                    )

                    for i = 0, math.min(C_result_size-1, count-1) do
                        result[#result+1] = {}
                        result[#result].x1      = pointers.result[i][0]
                        result[#result].y1      = pointers.result[i][1]
                        result[#result].x2      = pointers.result[i][2]
                        result[#result].y2      = pointers.result[i][3]
                        result[#result].acc     = pointers.result[i][4]
                        result[#result].source  = screen[1]
                        result[#result].pattern = pattern[pattern_i]
                    end

                    count = count - C_result_size
                end
            end
        elseif deviation_type == "r" or deviation_type == "a" then
            if bg then -- поиск с учетом фона
                for pattern_i = 1, #pattern do
                    local pattern_area = nil
                    -- получаем pattern из буфера / делаем забор паттерна.
                    if type(pattern[pattern_i][1]) ~= "table" then
                        pattern_area = internal.getimage(
                            pointers[pattern_pointer_start_i+(pattern_i-1)*3].bitmap,
                            pattern[pattern_i][2][1], -- x1
                            pattern[pattern_i][2][2], -- y1
                            pattern[pattern_i][2][3], -- x2
                            pattern[pattern_i][2][4], -- y2
                            pattern[pattern_i][1],    -- path / method
                            pattern[pattern_i][3])    -- abs_flag
                    else
                        pattern_area = pattern[pattern_i][1]
                    end

                    -- конвертируем паттерн
                    pattern_converted[#pattern_converted+1] = {
                        internal.image_converter(
                            pattern_area,
                            pointers[pattern_pointer_start_i+(pattern_i-1)*3+1].bitmap,
                            pointers[pattern_pointer_start_i+(pattern_i-1)*3+2].bitmap,
                            deviation_type, deviation)
                        }

                    if bg == true then -- бэкгрануд = левый верхний пиксель.
                        pattern_converted[pattern_i].bg = ext.get_pix(pattern_area, 0, 0)
                    else
                        pattern_converted[pattern_i].bg = bg_global
                    end


                    local dots_total_key = pattern_converted[pattern_i].step_x
                                    .."_"..pattern_converted[pattern_i].step_y
                                    .."_"..pattern_converted[pattern_i].bg[1].."_"
                                         ..pattern_converted[pattern_i].bg[2].."_"
                                         ..pattern_converted[pattern_i].bg[3]
                    if not pattern_area.dots_total[dots_total_key] then
                        pattern_area.dots_total[dots_total_key] = 0
                        for pattern_y = 0,
                            pattern_area.h*pattern_area.l-1,
                            pattern_area.l*pattern_converted[pattern_i].step_y do
                            for pattern_x = pattern_y,
                                pattern_y + pattern_area.w*3 - 2,
                                pattern_converted[pattern_i].step_x*3 do
                                if  pattern_area.bitmap[pattern_x]   ~= pattern_converted[pattern_i].bg[1]
                                or  pattern_area.bitmap[pattern_x+1] ~= pattern_converted[pattern_i].bg[2]
                                or  pattern_area.bitmap[pattern_x+2] ~= pattern_converted[pattern_i].bg[3] then
                                    pattern_area.dots_total[dots_total_key] = pattern_area.dots_total[dots_total_key] + 1
                                else
                                    print"same color"
                                end
                            end
                        end
                    end
                    pattern_converted[pattern_i].dots_total = pattern_area.dots_total[dots_total_key]

                    pattern_converted[pattern_i].accuracy_too_low = math.floor(pattern_converted[pattern_i].dots_total
                                                                               *(100-acc)/100)
                    local C_result_size = array_comparator.accuracy_restrict2a4af5_bg(
                        pattern_converted[pattern_i][1].bitmap,     -- unsigned char *restrict pattern_min,
                        pattern_converted[pattern_i][2].bitmap,     -- unsigned char *restrict pattern_max,
                        area.bitmap,                                -- unsigned char *restrict area_original,
                        pattern_converted[pattern_i][1].bitmap      -- unsigned char *pattern_limit,
                        +pattern_converted[pattern_i][1].l
                        *pattern_converted[pattern_i][1].h,

                        pattern_converted[pattern_i][1].w,                  -- int pattern_width,
                        pattern_converted[pattern_i][1].h,                  -- int pattern_height,
                        pattern_converted[pattern_i].step_x*3,              -- int step_x,
                        pattern_converted[pattern_i].step_y                 -- int step_y,
                        *pattern_converted[pattern_i][1].l,
                        area.l*pattern_converted[pattern_i].step_y          -- int from_end_to_start_x,
                        -pattern_converted[pattern_i].step_x
                        *math.ceil(pattern_converted[pattern_i][1].w
                            /pattern_converted[pattern_i].step_x)*3,

                        pattern_converted[pattern_i][1].w*3-1,              -- int pattern_limit_x_add,
                        area.l,                                             -- int area_lenght,
                        offsets_delta_x*3,                                  -- int area_offset_x1,
                        offsets_delta_y*area.l,                             -- int area_offset_y1,
                        (area.w-pattern_converted[pattern_i][1].w+1)*3,     -- int area_offset_x2,
                        area.bitmap                                         -- unsigned char *restrict area_y_limit,
                        +(area.h-pattern_converted[pattern_i][1].h+1)
                        *area.l,

                        pointers.result,                                    -- int result[][5],
                        count,                                              -- int result_size,
                        pattern_converted[pattern_i].dots_total,            -- int dots_total,
                        pattern_converted[pattern_i].accuracy_too_low,      -- int accuracy_too_low,
                        pattern_converted[pattern_i].bg[1],                 -- char bg_blue,
                        pattern_converted[pattern_i].bg[2],                 -- char bg_green,
                        pattern_converted[pattern_i].bg[3]                  -- char bg_red
                    )

                    for i = 0, math.min(C_result_size-1, count-1) do
                        result[#result+1] = {}
                        result[#result].x1      = pointers.result[i][0]
                        result[#result].y1      = pointers.result[i][1]
                        result[#result].x2      = pointers.result[i][2]
                        result[#result].y2      = pointers.result[i][3]
                        result[#result].acc     = pointers.result[i][4]
                        result[#result].source  = screen[1]
                        result[#result].pattern = pattern[pattern_i]
                    end

                    count = count - C_result_size
                end
            else -- фона нет
                for pattern_i = 1, #pattern do
                    local pattern_area = nil
                    -- получаем pattern из буфера / делаем забор паттерна.
                    if type(pattern[pattern_i][1]) == "table" then
                        pattern_area = pattern[pattern_i][1]
                    else
                        pattern_area = internal.getimage(
                            pointers[pattern_pointer_start_i+(pattern_i-1)*3].bitmap,
                            pattern[pattern_i][2][1], -- x1
                            pattern[pattern_i][2][2], -- y1
                            pattern[pattern_i][2][3], -- x2
                            pattern[pattern_i][2][4], -- y2
                            pattern[pattern_i][1],    -- path / method
                            pattern[pattern_i][3])    -- abs_flag
                    end

                    -- конвертируем паттерн
                    pattern_converted[#pattern_converted+1] = {
                        internal.image_converter(
                            pattern_area,
                            pointers[pattern_pointer_start_i+(pattern_i-1)*3+1].bitmap,
                            pointers[pattern_pointer_start_i+(pattern_i-1)*3+2].bitmap,
                            deviation_type, deviation)
                        }

                    pattern_converted[pattern_i].accuracy_too_low = math.floor(pattern_area.h*pattern_area.w
                                                                                             *(100-acc)/100)

                    local C_result_size = array_comparator.accuracy_restrict2a4af5(
                        pattern_converted[pattern_i][1].bitmap,     -- unsigned char *restrict pattern_min,
                        pattern_converted[pattern_i][2].bitmap,     -- unsigned char *restrict pattern_max,
                        area.bitmap,                                -- unsigned char *restrict area_original,
                        pattern_converted[pattern_i][1].bitmap      -- unsigned char *pattern_limit,
                        +pattern_converted[pattern_i][1].l
                        *pattern_converted[pattern_i][1].h,

                        pattern_converted[pattern_i][1].w,                  -- int pattern_width,
                        pattern_converted[pattern_i][1].h,                  -- int pattern_height,
                        pattern_converted[pattern_i].step_x*3,              -- int step_x,
                        pattern_converted[pattern_i].step_y                 -- int step_y,
                        *pattern_converted[pattern_i][1].l,
                        area.l*pattern_converted[pattern_i].step_y          -- int from_end_to_start_x,
                        -pattern_converted[pattern_i].step_x
                        *math.ceil(pattern_converted[pattern_i][1].w
                            /pattern_converted[pattern_i].step_x)*3,

                        pattern_converted[pattern_i][1].w*3-1,              -- int pattern_limit_x_add,
                        area.l,                                             -- int area_lenght,
                        offsets_delta_x*3,                                  -- int area_offset_x1,
                        offsets_delta_y*area.l,                             -- int area_offset_y1,
                        (area.w-pattern_converted[pattern_i][1].w+1)*3,     -- int area_offset_x2,
                        area.bitmap                                         -- unsigned char *restrict area_y_limit,
                        +(area.h-pattern_converted[pattern_i][1].h+1)
                        *area.l,

                        pointers.result,                                    -- int result[][5],
                        count,                                              -- int result_size,
                        pattern_area.h*pattern_area.w,                      -- int dots_total,
                        pattern_converted[pattern_i].accuracy_too_low       -- int accuracy_too_low
                    )

                    for i = 0, math.min(C_result_size-1, count-1) do
                        result[#result+1] = {}
                        result[#result].x1      = pointers.result[i][0]
                        result[#result].y1      = pointers.result[i][1]
                        result[#result].x2      = pointers.result[i][2]
                        result[#result].y2      = pointers.result[i][3]
                        result[#result].acc     = pointers.result[i][4]
                        result[#result].source  = screen[1]
                        result[#result].pattern = pattern[pattern_i]
                    end

                    count = count - C_result_size
                end
            end
        end
    else -- deviation отсутсвует
        if bg then -- поиск с учетом фона
            for pattern_i = 1, #pattern do
                local pattern_area = nil
                -- получаем pattern из буфера / делаем забор паттерна.
                if type(pattern[pattern_i][1]) ~= "table" then
                    pattern_area = internal.getimage(
                        pointers[pattern_pointer_start_i+pattern_i-1].bitmap,
                        pattern[pattern_i][2][1], -- x1
                        pattern[pattern_i][2][2], -- y1
                        pattern[pattern_i][2][3], -- x2
                        pattern[pattern_i][2][4], -- y2
                        pattern[pattern_i][1],    -- path / method
                        pattern[pattern_i][3])    -- abs_flag
                else
                    pattern_area = pattern[pattern_i][1]
                end

                -- конвертируем паттерн
                pattern_converted[#pattern_converted+1] = {pattern_area}

                if bg == true then -- бэкгрануд = левый верхний пиксель.
                    pattern_converted[pattern_i].bg = ext.get_pix(pattern_area, 0, 0)
                else
                    pattern_converted[pattern_i].bg = bg_global
                end


                local dots_total_key = pattern_converted[pattern_i].step_x
                                .."_"..pattern_converted[pattern_i].step_y
                                .."_"..pattern_converted[pattern_i].bg[1].."_"
                                     ..pattern_converted[pattern_i].bg[2].."_"
                                     ..pattern_converted[pattern_i].bg[3]
                if not pattern_area.dots_total[dots_total_key] then
                    pattern_area.dots_total[dots_total_key] = 0
                    for pattern_y = 0,
                        pattern_area.h*pattern_area.l-1,
                        pattern_area.l*pattern_converted[pattern_i].step_y do
                        for pattern_x = pattern_y,
                            pattern_y + pattern_area.w*3 - 2,
                            step_x*3 do
                            if  pattern_area.bitmap[pattern_x]   ~= pattern_converted[pattern_i].bg[1]
                            or  pattern_area.bitmap[pattern_x+1] ~= pattern_converted[pattern_i].bg[2]
                            or  pattern_area.bitmap[pattern_x+2] ~= pattern_converted[pattern_i].bg[3] then
                                pattern_area.dots_total[dots_total_key] = pattern_area.dots_total[dots_total_key] + 1
                            else
                                print"same color"
                            end
                        end
                    end
                end
                pattern_converted[pattern_i].dots_total = pattern_area.dots_total[dots_total_key]

                pattern_converted[pattern_i].accuracy_too_low = math.floor(pattern_converted[pattern_i].dots_total
                                                                           *(100-acc)/100)
                local C_result_size = array_comparator.accuracy_restrict2a4af5_no_d_bg(
                    pattern_converted[pattern_i][1].bitmap,     -- unsigned char *restrict pattern_min,
                    area.bitmap,                                -- unsigned char *restrict area_original,
                    pattern_converted[pattern_i][1].bitmap      -- unsigned char *pattern_limit,
                    +pattern_converted[pattern_i][1].l
                    *pattern_converted[pattern_i][1].h,

                    pattern_converted[pattern_i][1].w,                  -- int pattern_width,
                    pattern_converted[pattern_i][1].h,                  -- int pattern_height,
                    pattern_converted[pattern_i].step_x*3,              -- int step_x,
                    pattern_converted[pattern_i].step_y                 -- int step_y,
                    *pattern_converted[pattern_i][1].l,
                    area.l*pattern_converted[pattern_i].step_y          -- int from_end_to_start_x,
                    -pattern_converted[pattern_i].step_x
                    *math.ceil(pattern_converted[pattern_i][1].w
                        /pattern_converted[pattern_i].step_x)*3,

                    pattern_converted[pattern_i][1].w*3-1,              -- int pattern_limit_x_add,
                    area.l,                                             -- int area_lenght,
                    offsets_delta_x*3,                                  -- int area_offset_x1,
                    offsets_delta_y*area.l,                             -- int area_offset_y1,
                    (area.w-pattern_converted[pattern_i][1].w+1)*3,     -- int area_offset_x2,
                    area.bitmap                                         -- unsigned char *restrict area_y_limit,
                    +(area.h-pattern_converted[pattern_i][1].h+1)
                    *area.l,

                    pointers.result,                                    -- int result[][5],
                    count,                                              -- int result_size,
                    pattern_converted[pattern_i].dots_total,            -- int dots_total,
                    pattern_converted[pattern_i].accuracy_too_low,      -- int accuracy_too_low,
                    pattern_converted[pattern_i].bg[1],                 -- char bg_blue,
                    pattern_converted[pattern_i].bg[2],                 -- char bg_green,
                    pattern_converted[pattern_i].bg[3]                  -- char bg_red
                )

                for i = 0, math.min(C_result_size-1, count-1) do
                    result[#result+1] = {}
                    result[#result].x1      = pointers.result[i][0]
                    result[#result].y1      = pointers.result[i][1]
                    result[#result].x2      = pointers.result[i][2]
                    result[#result].y2      = pointers.result[i][3]
                    result[#result].acc     = pointers.result[i][4]
                    result[#result].source  = screen[1]
                    result[#result].pattern = pattern[pattern_i]
                end

                count = count - C_result_size
            end
        else -- фона нет
            for pattern_i = 1, #pattern do
                local pattern_area = nil
                -- получаем pattern из буфера / делаем забор паттерна.
                if type(pattern[pattern_i][1]) == "table" then
                    pattern_area = pattern[pattern_i][1]
                else
                    pattern_area = internal.getimage(
                        pointers[pattern_pointer_start_i+pattern_i-1].bitmap,
                        pattern[pattern_i][2][1], -- x1
                        pattern[pattern_i][2][2], -- y1
                        pattern[pattern_i][2][3], -- x2
                        pattern[pattern_i][2][4], -- y2
                        pattern[pattern_i][1],    -- path / method
                        pattern[pattern_i][3])    -- abs_flag
                end

                -- конвертируем паттерн
                pattern_converted[#pattern_converted+1] = {pattern_area}

                pattern_converted[pattern_i].accuracy_too_low = math.floor(pattern_area.h*pattern_area.w
                                                                                         *(100-acc)/100)

                local C_result_size = array_comparator.accuracy_restrict2a4af5_no_d(
                    pattern_converted[pattern_i][1].bitmap,     -- unsigned char *restrict pattern_min,
                    area.bitmap,                                -- unsigned char *restrict area_original,
                    pattern_converted[pattern_i][1].bitmap      -- unsigned char *pattern_limit,
                    +pattern_converted[pattern_i][1].l
                    *pattern_converted[pattern_i][1].h,

                    pattern_converted[pattern_i][1].w,                  -- int pattern_width,
                    pattern_converted[pattern_i][1].h,                  -- int pattern_height,
                    pattern_converted[pattern_i].step_x*3,              -- int step_x,
                    pattern_converted[pattern_i].step_y                 -- int step_y,
                    *pattern_converted[pattern_i][1].l,
                    area.l*pattern_converted[pattern_i].step_y          -- int from_end_to_start_x,
                    -pattern_converted[pattern_i].step_x
                    *math.ceil(pattern_converted[pattern_i][1].w
                        /pattern_converted[pattern_i].step_x)*3,

                    pattern_converted[pattern_i][1].w*3-1,              -- int pattern_limit_x_add,
                    area.l,                                             -- int area_lenght,
                    offsets_delta_x*3,                                  -- int area_offset_x1,
                    offsets_delta_y*area.l,                             -- int area_offset_y1,
                    (area.w-pattern_converted[pattern_i][1].w+1)*3,     -- int area_offset_x2,
                    area.bitmap                                         -- unsigned char *restrict area_y_limit,
                    +(area.h-pattern_converted[pattern_i][1].h+1)
                    *area.l,

                    pointers.result,                                    -- int result[][5],
                    count,                                              -- int result_size,
                    pattern_area.h*pattern_area.w,                      -- int dots_total,
                    pattern_converted[pattern_i].accuracy_too_low       -- int accuracy_too_low
                )

                for i = 0, math.min(C_result_size-1, count-1) do
                    result[#result+1] = {}
                    result[#result].x1      = pointers.result[i][0]
                    result[#result].y1      = pointers.result[i][1]
                    result[#result].x2      = pointers.result[i][2]
                    result[#result].y2      = pointers.result[i][3]
                    result[#result].acc     = pointers.result[i][4]
                    result[#result].source  = screen[1]
                    result[#result].pattern = pattern[pattern_i]
                end

                count = count - C_result_size
            end
        end
    end


    -- Прогон остальных скринов 2-n
    -- Если скринов больше 1 и с первого скрина
    -- не было получено необходимое количество
    -- результатов.
    if #screen > 1 and count > 0 then
        -- Получаем исходник скрина
        -- если его нет в буфере.
        for screen_i = 2, #screen do
            local area = nil
            if type(screen[screen_i][1]) == "table" then
                area = screen[screen_i][1]
            else
                area = internal.getimage(screen_buffer_pointer,
                                         screen[screen_i][2][1],
                                         screen[screen_i][2][2],
                                         screen[screen_i][2][3],
                                         screen[screen_i][2][4],
                                         screen[screen_i][1],
                                         screen[screen_i][3])
            end

            -- дельта между оффсетом снятого изображения
            -- и координатами поиска.
            local offsets_delta_x = screen[screen_i][2][1] - area.offset_x
            local offsets_delta_y = screen[screen_i][2][2] - area.offset_y
            local C_result_size = 0

            if deviation_type == "s" then
                -- Конвертируем скрин.
                local screen_buffer_pointer_converted = 0
                if type(area.method) ~= "string" then
                    screen_buffer_pointer_converted = ffi.cast("unsigned short*", screen_buffer_pointer) + area.h*area.l
                end
                local area_converted = internal.image_converter(area,
                                                screen_buffer_pointer_converted,
                                                0, deviation_type, {0,0,0,0,0,0})

                if bg then -- поиск с учетом фона
                    for pattern_i = 1, #pattern do
                        local C_result_size = array_comparator.accuracy_restrict2a4af5_s_short_bg(
                            pattern_converted[pattern_i][1].bitmap,     -- unsigned char *restrict pattern_min,
                            pattern_converted[pattern_i][2].bitmap,     -- unsigned char *restrict pattern_max,
                            area_converted.bitmap,                      -- unsigned char *restrict area,
                            area.bitmap,                                -- unsigned char *restrict area_original,
                            pattern_converted[pattern_i][1].bitmap      -- unsigned char *pattern_limit,
                            +pattern_converted[pattern_i][1].l
                            *pattern_converted[pattern_i][1].h,

                            pattern_converted[pattern_i][1].w,                  -- int pattern_width,
                            pattern_converted[pattern_i][1].h,                  -- int pattern_height,
                            pattern_converted[pattern_i].step_x*3,              -- int step_x,
                            pattern_converted[pattern_i].step_y                 -- int step_y,
                            *pattern_converted[pattern_i][1].l,
                            area.l*pattern_converted[pattern_i].step_y          -- int from_end_to_start_x,
                            -pattern_converted[pattern_i].step_x
                            *math.ceil(pattern_converted[pattern_i][1].w
                                /pattern_converted[pattern_i].step_x)*3,

                            pattern_converted[pattern_i][1].w*3-1,              -- int pattern_limit_x_add,
                            area.l,                                             -- int area_lenght,
                            offsets_delta_x*3,                                  -- int area_offset_x1,
                            offsets_delta_y*area.l,                             -- int area_offset_y1,
                            (area.w-pattern_converted[pattern_i][1].w+1)*3,     -- int area_offset_x2,
                            area_converted.bitmap                               -- unsigned char *restrict area_y_limit,
                            +(area.h-pattern_converted[pattern_i][1].h+1)
                            *area.l,

                            pointers.result,                                    -- int result[][5],
                            count,                                              -- int result_size,
                            pattern_converted[pattern_i].dots_total,            -- int dots_total,
                            pattern_converted[pattern_i].accuracy_too_low,      -- int accuracy_too_low,
                            pattern_converted[pattern_i].bg[1],                 -- char bg_blue,
                            pattern_converted[pattern_i].bg[2],                 -- char bg_green,
                            pattern_converted[pattern_i].bg[3]                  -- char bg_red
                        )

                        for i = 0, math.min(C_result_size-1, count-1) do
                            result[#result+1] = {}
                            result[#result].x1      = pointers.result[i][0]
                            result[#result].y1      = pointers.result[i][1]
                            result[#result].x2      = pointers.result[i][2]
                            result[#result].y2      = pointers.result[i][3]
                            result[#result].acc     = pointers.result[i][4]
                            result[#result].source  = screen[1]
                            result[#result].pattern = pattern[pattern_i]
                        end

                        count = count - C_result_size
                    end
                else -- фона нет
                    for pattern_i = 1, #pattern do
                        local C_result_size = array_comparator.accuracy_restrict2a4af5_s_short(
                            pattern_converted[pattern_i][1].bitmap,     -- unsigned char *restrict pattern_min,
                            pattern_converted[pattern_i][2].bitmap,     -- unsigned char *restrict pattern_max,
                            area_converted.bitmap,                      -- unsigned char *restrict area,
                            pattern_converted[pattern_i][1].bitmap      -- unsigned char *pattern_limit,
                            +pattern_converted[pattern_i][1].l
                            *pattern_converted[pattern_i][1].h,

                            pattern_converted[pattern_i][1].w,                  -- int pattern_width,
                            pattern_converted[pattern_i][1].h,                  -- int pattern_height,
                            pattern_converted[pattern_i].step_x*3,              -- int step_x,
                            pattern_converted[pattern_i].step_y                 -- int step_y,
                            *pattern_converted[pattern_i][1].l,
                            area.l*pattern_converted[pattern_i].step_y          -- int from_end_to_start_x,
                            -pattern_converted[pattern_i].step_x
                            *math.ceil(pattern_converted[pattern_i][1].w
                                /pattern_converted[pattern_i].step_x)*3,

                            pattern_converted[pattern_i][1].w*3-1,              -- int pattern_limit_x_add,
                            area.l,                                             -- int area_lenght,
                            offsets_delta_x*3,                                  -- int area_offset_x1,
                            offsets_delta_y*area.l,                             -- int area_offset_y1,
                            (area.w-pattern_converted[pattern_i][1].w+1)*3,     -- int area_offset_x2,
                            area_converted.bitmap                               -- unsigned char *restrict area_y_limit,
                            +(area.h-pattern_converted[pattern_i][1].h+1)
                            *area.l,

                            pointers.result,                                    -- int result[][5],
                            count,                                              -- int result_size,
                            pattern_converted[pattern_i][1].h                   -- int dots_total,
                            *pattern_converted[pattern_i][1].w,
                            pattern_converted[pattern_i].accuracy_too_low       -- int accuracy_too_low
                        )

                        for i = 0, math.min(C_result_size-1, count-1) do
                            result[#result+1] = {}
                            result[#result].x1      = pointers.result[i][0]
                            result[#result].y1      = pointers.result[i][1]
                            result[#result].x2      = pointers.result[i][2]
                            result[#result].y2      = pointers.result[i][3]
                            result[#result].acc     = pointers.result[i][4]
                            result[#result].source  = screen[1]
                            result[#result].pattern = pattern[pattern_i]
                        end

                        count = count - C_result_size
                    end
                end
            elseif deviation_type == "r" or deviation_type == "a" then
                if bg then -- поиск с учетом фона
                    for pattern_i = 1, #pattern do
                        local C_result_size = array_comparator.accuracy_restrict2a4af5_bg(
                            pattern_converted[pattern_i][1].bitmap,     -- unsigned char *restrict pattern_min,
                            pattern_converted[pattern_i][2].bitmap,     -- unsigned char *restrict pattern_max,
                            area.bitmap,                                -- unsigned char *restrict area_original,
                            pattern_converted[pattern_i][1].bitmap      -- unsigned char *pattern_limit,
                            +pattern_converted[pattern_i][1].l
                            *pattern_converted[pattern_i][1].h,

                            pattern_converted[pattern_i][1].w,                  -- int pattern_width,
                            pattern_converted[pattern_i][1].h,                  -- int pattern_height,
                            pattern_converted[pattern_i].step_x*3,              -- int step_x,
                            pattern_converted[pattern_i].step_y                 -- int step_y,
                            *pattern_converted[pattern_i][1].l,
                            area.l*pattern_converted[pattern_i].step_y          -- int from_end_to_start_x,
                            -pattern_converted[pattern_i].step_x
                            *math.ceil(pattern_converted[pattern_i][1].w
                                /pattern_converted[pattern_i].step_x)*3,

                            pattern_converted[pattern_i][1].w*3-1,              -- int pattern_limit_x_add,
                            area.l,                                             -- int area_lenght,
                            offsets_delta_x*3,                                  -- int area_offset_x1,
                            offsets_delta_y*area.l,                             -- int area_offset_y1,
                            (area.w-pattern_converted[pattern_i][1].w+1)*3,     -- int area_offset_x2,
                            area.bitmap                                         -- unsigned char *restrict area_y_limit,
                            +(area.h-pattern_converted[pattern_i][1].h+1)
                            *area.l,

                            pointers.result,                                    -- int result[][5],
                            count,                                              -- int result_size,
                            pattern_converted[pattern_i].dots_total,            -- int dots_total,
                            pattern_converted[pattern_i].accuracy_too_low,      -- int accuracy_too_low,
                            pattern_converted[pattern_i].bg[1],                 -- char bg_blue,
                            pattern_converted[pattern_i].bg[2],                 -- char bg_green,
                            pattern_converted[pattern_i].bg[3]                  -- char bg_red
                        )

                        for i = 0, math.min(C_result_size-1, count-1) do
                            result[#result+1] = {}
                            result[#result].x1      = pointers.result[i][0]
                            result[#result].y1      = pointers.result[i][1]
                            result[#result].x2      = pointers.result[i][2]
                            result[#result].y2      = pointers.result[i][3]
                            result[#result].acc     = pointers.result[i][4]
                            result[#result].source  = screen[1]
                            result[#result].pattern = pattern[pattern_i]
                        end

                        count = count - C_result_size
                    end
                else -- фона нет
                    for pattern_i = 1, #pattern do
                        local C_result_size = array_comparator.accuracy_restrict2a4af5(
                            pattern_converted[pattern_i][1].bitmap,     -- unsigned char *restrict pattern_min,
                            pattern_converted[pattern_i][2].bitmap,     -- unsigned char *restrict pattern_max,
                            area.bitmap,                                -- unsigned char *restrict area_original,
                            pattern_converted[pattern_i][1].bitmap      -- unsigned char *pattern_limit,
                            +pattern_converted[pattern_i][1].l
                            *pattern_converted[pattern_i][1].h,

                            pattern_converted[pattern_i][1].w,                  -- int pattern_width,
                            pattern_converted[pattern_i][1].h,                  -- int pattern_height,
                            pattern_converted[pattern_i].step_x*3,              -- int step_x,
                            pattern_converted[pattern_i].step_y                 -- int step_y,
                            *pattern_converted[pattern_i][1].l,
                            area.l*pattern_converted[pattern_i].step_y          -- int from_end_to_start_x,
                            -pattern_converted[pattern_i].step_x
                            *math.ceil(pattern_converted[pattern_i][1].w
                                /pattern_converted[pattern_i].step_x)*3,

                            pattern_converted[pattern_i][1].w*3-1,              -- int pattern_limit_x_add,
                            area.l,                                             -- int area_lenght,
                            offsets_delta_x*3,                                  -- int area_offset_x1,
                            offsets_delta_y*area.l,                             -- int area_offset_y1,
                            (area.w-pattern_converted[pattern_i][1].w+1)*3,     -- int area_offset_x2,
                            area.bitmap                                         -- unsigned char *restrict area_y_limit,
                            +(area.h-pattern_converted[pattern_i][1].h+1)
                            *area.l,

                            pointers.result,                                    -- int result[][5],
                            count,                                              -- int result_size,
                            pattern_converted[pattern_i][1].h                   -- int dots_total,
                            *pattern_converted[pattern_i][1].w,
                            pattern_converted[pattern_i].accuracy_too_low       -- int accuracy_too_low
                        )

                        for i = 0, math.min(C_result_size-1, count-1) do
                            result[#result+1] = {}
                            result[#result].x1      = pointers.result[i][0]
                            result[#result].y1      = pointers.result[i][1]
                            result[#result].x2      = pointers.result[i][2]
                            result[#result].y2      = pointers.result[i][3]
                            result[#result].acc     = pointers.result[i][4]
                            result[#result].source  = screen[1]
                            result[#result].pattern = pattern[pattern_i]
                        end

                        count = count - C_result_size
                    end
                end
            else -- deviation отсутсвует
                if bg then -- поиск с учетом фона
                    for pattern_i = 1, #pattern do
                        local C_result_size = array_comparator.accuracy_restrict2a4af5_no_d_bg(
                            pattern_converted[pattern_i][1].bitmap,     -- unsigned char *restrict pattern_min,
                            area.bitmap,                                -- unsigned char *restrict area_original,
                            pattern_converted[pattern_i][1].bitmap      -- unsigned char *pattern_limit,
                            +pattern_converted[pattern_i][1].l
                            *pattern_converted[pattern_i][1].h,

                            pattern_converted[pattern_i][1].w,                  -- int pattern_width,
                            pattern_converted[pattern_i][1].h,                  -- int pattern_height,
                            pattern_converted[pattern_i].step_x*3,              -- int step_x,
                            pattern_converted[pattern_i].step_y                 -- int step_y,
                            *pattern_converted[pattern_i][1].l,
                            area.l*pattern_converted[pattern_i].step_y          -- int from_end_to_start_x,
                            -pattern_converted[pattern_i].step_x
                            *math.ceil(pattern_converted[pattern_i][1].w
                                /pattern_converted[pattern_i].step_x)*3,

                            pattern_converted[pattern_i][1].w*3-1,              -- int pattern_limit_x_add,
                            area.l,                                             -- int area_lenght,
                            offsets_delta_x*3,                                  -- int area_offset_x1,
                            offsets_delta_y*area.l,                             -- int area_offset_y1,
                            (area.w-pattern_converted[pattern_i][1].w+1)*3,     -- int area_offset_x2,
                            area.bitmap                                         -- unsigned char *restrict area_y_limit,
                            +(area.h-pattern_converted[pattern_i][1].h+1)
                            *area.l,

                            pointers.result,                                    -- int result[][5],
                            count,                                              -- int result_size,
                            pattern_converted[pattern_i].dots_total,            -- int dots_total,
                            pattern_converted[pattern_i].accuracy_too_low,      -- int accuracy_too_low,
                            pattern_converted[pattern_i].bg[1],                 -- char bg_blue,
                            pattern_converted[pattern_i].bg[2],                 -- char bg_green,
                            pattern_converted[pattern_i].bg[3]                  -- char bg_red
                        )

                        for i = 0, math.min(C_result_size-1, count-1) do
                            result[#result+1] = {}
                            result[#result].x1      = pointers.result[i][0]
                            result[#result].y1      = pointers.result[i][1]
                            result[#result].x2      = pointers.result[i][2]
                            result[#result].y2      = pointers.result[i][3]
                            result[#result].acc     = pointers.result[i][4]
                            result[#result].source  = screen[1]
                            result[#result].pattern = pattern[pattern_i]
                        end

                        count = count - C_result_size
                    end
                else -- фона нет
                    for pattern_i = 1, #pattern do
                        local C_result_size = array_comparator.accuracy_restrict2a4af5_no_d(
                            pattern_converted[pattern_i][1].bitmap,     -- unsigned char *restrict pattern_min,
                            area.bitmap,                                -- unsigned char *restrict area_original,
                            pattern_converted[pattern_i][1].bitmap      -- unsigned char *pattern_limit,
                            +pattern_converted[pattern_i][1].l
                            *pattern_converted[pattern_i][1].h,

                            pattern_converted[pattern_i][1].w,                  -- int pattern_width,
                            pattern_converted[pattern_i][1].h,                  -- int pattern_height,
                            pattern_converted[pattern_i].step_x*3,              -- int step_x,
                            pattern_converted[pattern_i].step_y                 -- int step_y,
                            *pattern_converted[pattern_i][1].l,
                            area.l*pattern_converted[pattern_i].step_y          -- int from_end_to_start_x,
                            -pattern_converted[pattern_i].step_x
                            *math.ceil(pattern_converted[pattern_i][1].w
                                /pattern_converted[pattern_i].step_x)*3,

                            pattern_converted[pattern_i][1].w*3-1,              -- int pattern_limit_x_add,
                            area.l,                                             -- int area_lenght,
                            offsets_delta_x*3,                                  -- int area_offset_x1,
                            offsets_delta_y*area.l,                             -- int area_offset_y1,
                            (area.w-pattern_converted[pattern_i][1].w+1)*3,     -- int area_offset_x2,
                            area.bitmap                                         -- unsigned char *restrict area_y_limit,
                            +(area.h-pattern_converted[pattern_i][1].h+1)
                            *area.l,

                            pointers.result,                                    -- int result[][5],
                            count,                                              -- int result_size,
                            pattern_converted[pattern_i][1].h                   -- int dots_total,
                            *pattern_converted[pattern_i][1].w,
                            pattern_converted[pattern_i].accuracy_too_low       -- int accuracy_too_low
                        )

                        for i = 0, math.min(C_result_size-1, count-1) do
                            result[#result+1] = {}
                            result[#result].x1      = pointers.result[i][0]
                            result[#result].y1      = pointers.result[i][1]
                            result[#result].x2      = pointers.result[i][2]
                            result[#result].y2      = pointers.result[i][3]
                            result[#result].acc     = pointers.result[i][4]
                            result[#result].source  = screen[1]
                            result[#result].pattern = pattern[pattern_i]
                        end

                        count = count - C_result_size
                    end
                end
            end
        end
    end

    return #result > 0 and result or nil
end



--[==[
    -- ([screen,] <color> [, count] [, deviation] [, deviation_type])
    --
    -- [screen]
    -- массив массивов изображений. Значение по умолчанию {{workwindow()}}
    -- каждое изображение задается массивом:
    -- [path|handle|img_obj], [[x1, y1, x2, y2], abs_flag]
    --
    -- [path|handle|img_obj] - источник изображения.
    -- path                  - путь по которому находится изображение.
    -- handle                - хэндл приложения из которого необходимо получить изображение. 0 - экран.
    -- img_obj               - таблица {address=адрес_bitmap_в_памяти, h=высота_изображения, w=ширина_изображеия}
    -- ------------------------------------------------------------------------------------------------
    --  x1, y1, x2, y2       - координаты могут быть заданы переменными,
    --
    -- {x1, y1, x2, y2}      - массивом,
    -- {x1, y1, x2, y2}      - массив массивов (например, результат работы findcolor/findimage),
    -- {x1=var1, y1=var2,    - таблицей с полями:
    --  x2=var3, y2=var4}    - x1, y1, x2, y2.
    -- ------------------------------------------------------------------------------------------------
    -- abs_flag              - флаг абсолютных координат
    --
    -- <color>
    -- массив массивов искомых цветов.
    -- массив каждого цвета может быть заданы следующим образом:
    -- {color} | {color_dec_1, color_dec_2} | {r, g, b} | {r_min, g_min, b_min, r_max, g_max, b_max}
    --
    -- count - количество искомых пикселей. Значение по умолчанию 1.
    --
    -- [deviation]
    -- Допустимые отклонения цвета. Значение по умлочанию: 0.98, 0.98, 0.98, 1.02, 1.02, 1.02
    -- Возможные варианты синтаксиса:
    --  deviation_general                      - задано одним числом на все каналы в + и в -
    -- {blue, green, red}                      - на каждый канал отдельно, + и - одинаковые.
    -- {blue_lower, green_lower, red_lower, - на каждый канал отдельно, + и - индивидуальные.
    --  blue_upper, green_upper, red_upper}
    --
    -- [deviation_type]
    -- Тип расчета допустимого отклонения цвета. Значение по умолчанию "s".
    -- Возможные значения:
    -- "a" - absolute. Абсолютное отклонение канала.
    --       Например, при цвете 50 100 200 и абсолютном отклонении 10,
    --       допустимый диапазон цветов будет равен 40-60, 90-110, 190-210
    -- "r" - relative. Относительное отклонение, задается множителем.
    --       Например, при цвете 50 100 200 и относительном отклонении 0.1,
    --       допустимый диапазон цветов будет равен 45-55 90-110 180-220.
    --       Округление происход в сторону расширения диапазона.
    --       Например, при значении канала 101 и допустимом отклонении 10%,
    --       допустимыми значениями канала будут 101-11 101+11, т.е. 90-112.
    -- "s" - shadow. Затемнение/осветление. Рассчитывается соотношение каналов, отклонение задается множителем.
    --       Данный метод может быть полезен, например, при смене суток в игре.
    --       В рамках данного метода цвета 50 100 200 и 25 50 100 - будут полностью идентичны.
    --       Для указанных цветов: 200/50=4 50/100=0.5 100/200=0.5
    --                             100/25=4  25/50=0.5  50/100=0.5
    --       При допустимом отклонении в 0.1, будут считаться допустимыми соотношения каналов:
    --       3.6-4.4 0.45-0.55 0.45-0.55
]==]
function ext.findcolor_multi(t)
    local screen, color, count, deviation, deviation_type = unpack(t)

    -- смещения при отсутсвии screen
    if  type(color) ~= "table" then
        deviation_type  = deviation
        deviation       = count
        count           = color
        color           = screen
        screen          = {{workwindow()}}
    end
    if  type(count) == "string" then
        count = nil
        deviation = nil
        deviation_type = count
    end
    if  type(deviation) == "string" then
        deviation      = {0.98, 0.98, 0.98, 1.02, 1.02, 1.02}
        deviation_type = deviation
    end

    -- Разворачиваем color в нормальный массив по каналам.
    local color_parsed = ext.parse_color_multi(color)

    -- устанавливаем количество искомых пикселей
    count = count or 1

    -- устанавливаем deviation,
    if deviation then
        deviation = internal.deviation_parse(deviation, deviation_type)
    else
        if deviation ~= false then
            deviation = {0.98, 0.98, 0.98, 1.02, 1.02, 1.02}
        end
    end

    -- устанавливаем тип deviation
    if deviation and deviation ~= 0 and deviation ~= false then
        deviation_type = deviation_type or "s"
    else
        deviation_type = false
    end

    -- Применяем deviation к цвету
    color_parsed = ext.evalute_color(color, deviation, deviation_type)

    -- Рассчитывем необходимый размер буфера для screen.
    -- при переходе к новому элементу,
    -- прошлый screen[i], если он хранился в temp_storage
    -- будет перезаписан. Т.е. для screen тербуется размер
    -- самого большого screen[i], не всех элеметов.
    -- Впоследсвии перезапишется при новом вызове findimage/findcolor.
    -- Перезапись происходит только в temp_storage, images не освобождается.

    -- Подготавливаем массив для рассчета буфера и смещений.
    local temp_storage_request = {}

    -- Находим самое большое (площадь с выравниванием) изображение в screen
    -- так же учитываем, что при deviation_type == "s" будут созданы копии.
    local screen_max_size = 0
    local max_image_i     = nil
    for i = 1, #screen do
        -- Стандартизируем параметры.
        internal.parse_image_params(screen[i])

        local screen_size = 0
        -- Уже в буфере?
        -- Создаем линк на буфер, где должнл было
        -- бы находиться изоражение.
        -- Проверяем есть ли такой элемент буфера.
        local images_i = nil
        if     type(screen[i][1]) == "string" then
            -- загружаемые картинки всегда падают в images
            -- им не нужен temp_storage
        elseif type(screen[i][1]) == "number" then
            -- с хендлом в буфере не может быть изображений
            screen_size = (screen[i][2][3]-screen[i][2][1]+1)
                             *(screen[i][2][4]-screen[i][2][2]+1)
        elseif type(screen[i][1]) == "table"  then
            if not images[screen[i][1].address] then
                screen_size = screen_size + (screen[i][2][3]-screen[i][2][1]+1)
                                           *(screen[i][2][4]-screen[i][2][2]+1)
            end
        end

        if screen_size > screen_max_size then
            screen_max_size = screen_size
            max_image_i     = i
        end
    end

    -- Запрашиваем максимальный screen
    if max_image_i then
        temp_storage_request[1] = {screen[max_image_i][2][1],
                                   screen[max_image_i][2][2],
                                   screen[max_image_i][2][3],
                                   screen[max_image_i][2][4]}
    else
        temp_storage_request[1] = false
    end

    temp_storage_request.result={count, 6}
    local pointers = internal.temp_storage_get_pointers(temp_storage_request)



    local result = {}

    for screen_i = 1, #screen do
        local area = nil
        if type(screen[screen_i][1]) == "table" then
            area = screen[screen_i][1]
        else
            area = internal.getimage(image_buffer_p_char,
                                     screen[screen_i][2][1],
                                     screen[screen_i][2][2],
                                     screen[screen_i][2][3],
                                     screen[screen_i][2][4],
                                     screen[screen_i][1],
                                     screen[screen_i][3])
        end
        --[[
        local offsets_delta_x1 = screen[screen_i][2][1] - area.offset_x
        local offsets_delta_y1 = screen[screen_i][2][2] - area.offset_y
        local offsets_delta_x2 = screen[screen_i][2][3] - area.offset_x
        local offsets_delta_y2 = screen[screen_i][2][4] - area.offset_y
        ]]

        for i = 1, #color_parsed do
            local C_result_size = 0
            if deviation_type or #color_parsed[i] == 6 then
                local compare_func = array_comparator.accuracy_restrict2a4af5_color
                if deviation_type == "s" then
                    compare_func   = array_comparator.accuracy_restrict2a4af5_color_s
                end

                C_result_size = compare_func(
                    area.bitmap                    --unsigned char *restrict area,
                    - area.offset_y*area.l
                    - area.offset_x*3,

                    area.bitmap                    --unsigned char *restrict area_y_limit,
                    +(screen[screen_i][2][4]
                    -area.offset_y)*area.l
                    -area.offset_x*3
                    +1,

                    area.l,                        -- int area_lenght,
                    screen[screen_i][2][1]*3,      -- int area_offset_x1,
                    screen[screen_i][2][2]*area.l, -- int area_offset_y1,
                    screen[screen_i][2][3]*3+1,    -- int area_offset_x2,

                    pointers.result,               -- int result[][6],
                    count,                         -- int result_size,

                    color_parsed[i][3],            --char blue_min,
                    color_parsed[i][2],            --char green_min,
                    color_parsed[i][1],            --char red_min,
                    color_parsed[i][6],            --char blue_max,
                    color_parsed[i][5],            --char green_max,
                    color_parsed[i][4]             --char red_max

                --[[
                    -- кошерный вариант без хрени с компенсацией координат.
                    area.bitmap,                --unsigned char *restrict area,
                    area.bitmap                 --unsigned char *restrict area_y_limit,
                    +offsets_delta_y2*area.l+1,

                    area.l,                     -- int area_lenght,
                    offsets_delta_x1*3,         -- int area_offset_x1,
                    offsets_delta_y1*area.l,    -- int area_offset_y1,
                    offsets_delta_x2*3+1,       -- int area_offset_x2,

                    pointers.result,            -- int result[][6],
                    count,                      -- int result_size,

                    color_parsed[i][3],         --char blue_min,
                    color_parsed[i][2],         --char green_min,
                    color_parsed[i][1],         --char red_min,
                    color_parsed[i][6],         --char blue_max,
                    color_parsed[i][5],         --char green_max,
                    color_parsed[i][4]          --char red_max
                ]]
                )
                print(C_result_size)
            else
                -- коррекция координат путем увода стартового указателя и "воссоздания" большого изображения.
                -- метод очень опасный, если есть косяки по указателям и/или смещениям.
                -- фактически в основе метода передача указателя на неразмеченную область памяти и
                -- компенсация модифицированными оффсетами.
                -- Цель - уход от математики с результатами (жрет __очень__ много).
                C_result_size = array_comparator.accuracy_restrict2a4af5_color_strict(
                    area.bitmap                    --unsigned char *restrict area,
                    - area.offset_y*area.l
                    - area.offset_x*3,

                    area.bitmap                    --unsigned char *restrict area_y_limit,
                    +(screen[screen_i][2][4]
                    -area.offset_y)*area.l
                    -area.offset_x*3
                    +1,

                    area.l,                        -- int area_lenght,
                    screen[screen_i][2][1]*3,      -- int area_offset_x1,
                    screen[screen_i][2][2]*area.l, -- int area_offset_y1,
                    screen[screen_i][2][3]*3+1,    -- int area_offset_x2,

                    pointers.result,               -- int result[][6],
                    count,                         -- int result_size,

                    color_parsed[i][3],            --char blue,
                    color_parsed[i][2],            --char green,
                    color_parsed[i][1]             --char red
                )
                --[[
                    -- кошерный вариант без хрени с компенсацией координат.
                    area.bitmap,                --unsigned char *restrict area,
                    area.bitmap                 --unsigned char *restrict area_y_limit,
                    +offsets_delta_y2*area.l+1,

                    area.l,                     -- int area_lenght,
                    offsets_delta_x1*3,         -- int area_offset_x1,
                    offsets_delta_y1*area.l,    -- int area_offset_y1,
                    offsets_delta_x2*3+1,       -- int area_offset_x2,

                    pointers.result,            -- int result[][6],
                    count,                      -- int result_size,

                    color_parsed[i][3],         --char blue,
                    color_parsed[i][2],         --char green,
                    color_parsed[i][1]
                    ]]
            end

            for i = 0, C_result_size-1 do
                result[#result+1] = {}
                result[#result].x      = pointers.result[i][0]
                result[#result].y      = pointers.result[i][1]
                result[#result].dec    = pointers.result[i][2]
                result[#result].r      = pointers.result[i][3]
                result[#result].g      = pointers.result[i][4]
                result[#result].b      = pointers.result[i][5]
                result[#result].screen = screen[screen_i]
            end

            count = count - C_result_size

        end
    end

    return #result > 0 and result or nil
end

--[==[
    -- Упрощенный вызов findcolor
    -- Он НЕ быстрее findcolor_multi, а являеется его частным случаем
    -- и служит исключительно для упрощения синтаксиса.
    -- <x1, y1, x2, y2, color>[, count][, deviation][, deviation_type]
    --
    -- <x1> - стартовая x координата
    -- <y1> - стартовая y координата
    -- <x2> - конечная  x координата
    -- <y2> - конечная  y координата
    --
    -- <color>
    -- искомый цвет. Может быть задан:
    -- color | {color} | {color_dec_1, color_dec_2} | {r, g, b} | {r_min, g_min, b_min, r_max, g_max, b_max}
    --
    -- [count]
    -- количество искомых пикселей. Значение по умолчанию 1.
    --
    -- [deviation]
    -- Допустимые отклонения цвета. Значение по умлочанию: 0.98, 0.98, 0.98, 1.02, 1.02, 1.02
    -- Возможные варианты синтаксиса:
    --  deviation_general                      - задано одним числом на все каналы в + и в -
    -- {blue, green, red}                      - на каждый канал отдельно, + и - одинаковые.
    -- {blue_lower, green_lower, red_lower, - на каждый канал отдельно, + и - индивидуальные.
    --  blue_upper, green_upper, red_upper}
    --
    -- [deviation_type]
    -- Тип расчета допустимого отклонения цвета. Значение по умолчанию "s".
    -- Возможные значения:
    -- "a" - absolute. Абсолютное отклонение канала.
    --       Например, при цвете 50 100 200 и абсолютном отклонении 10,
    --       допустимый диапазон цветов будет равен 40-60, 90-110, 190-210
    -- "r" - relative. Относительное отклонение, задается множителем.
    --       Например, при цвете 50 100 200 и относительном отклонении 0.1,
    --       допустимый диапазон цветов будет равен 45-55 90-110 180-220.
    --       Округление происход в сторону расширения диапазона.
    --       Например, при значении канала 101 и допустимом отклонении 10%,
    --       допустимыми значениями канала будут 101-11 101+11, т.е. 90-112.
    -- "s" - shadow. Затемнение/осветление. Рассчитывается соотношение каналов, отклонение задается множителем.
    --       Данный метод может быть полезен, например, при смене суток в игре.
    --       В рамках данного метода цвета 50 100 200 и 25 50 100 - будут полностью идентичны.
    --       Для указанных цветов: 200/50=4 50/100=0.5 100/200=0.5
    --                             100/25=4  25/50=0.5  50/100=0.5
    --       При допустимом отклонении в 0.1, будут считаться допустимыми соотношения каналов:
    --       3.6-4.4 0.45-0.55 0.45-0.55
]==]
function ext.findcolor(t)
    local x1, y1, x2, y2, color, count, deviation, deviation_type = unpack(t)

    if type(x1) == "table" then
        deviation_type = color
        deviation      = y2
        count          = x2
        color          = y1
    end
    local screen = {{workwindow(), type(x1) == "table" and x1 or {x1, y1, x2, y2}}}
    if type(color) == "number" then
        color = {{color}}
    else
        color = {color}
    end
    return ext.findcolor_multi(screen, color, count, deviation, deviation_type)
end


do
--[[
    -- Создаем буфер для изображения.
    -- Выделяем память, создаем указатели
    -- Размер буфера для хранения результата findcolor_raw
    -- При повторном findcolor_raw
    -- предыдущий результат будут перезаписан.
    -- Синтаксис:
    -- [size] - размер буфера в штуках результата, который необходимо устрановить. Необязательный параметр.
    -- Вернет:
    -- текущий размер в штуках результата.
]]

    local result = nil -- будущий указатель на результат
    local result_void = nil
    -- Устанавливаем размер буфера.
    local image_buffer_size = 0
    ext.findcolor_raw_result_size = function(size)
        if size and type(size) == "number" then
            image_buffer_size   = size
            result_void         = nil
            collectgarbage()
            result_void = ffi.gc(C.malloc(image_buffer_size*24), C.free)     -- выделяем память, вернет указатель на void
            result = ffi.cast("int6*", result_void)                          -- создаем указатель на int[*][6]
        end
        return image_buffer_size
    end
    ext.findcolor_raw_result_size(100)



--[==[
    Задача данного финдколора быть максимально быстрым.
    Конвертация результата C -> Lua очень тяжелая,
    вследствии чего данная функция возвращает размер и массив С.
    Индексация с 0, оператор # для получения размера не работает!
    Результат будет перезаписан при следующем вызове findcolor_raw.

    <screen>, <color>, <count>, [deviation_type]

    [screen]
    массив массивов изображений. Значение по умолчанию {{workwindow()}}
    каждое изображение задается массивом:
    <path|handle|img_obj>, <x1, y1, x2, y2>, [abs_flag]

    [path|handle|img_obj] - источник изображения. Для pattern является обязательным.
    path                  - путь по которому находится изображение.
    handle                - хэндл приложения из которого необходимо получить изображение. 0 - экран.
    img_obj               - таблица {address=адрес_bitmap_в_памяти, h=высота_изображения, w=ширина_изображеия}
    ------------------------------------------------------------------------------------------------
    {x1, y1, x2, y2}      - массив координат
    ------------------------------------------------------------------------------------------------
    abs_flag              - флаг абсолютных координат

    <color>
    Массив с каналами цветов:
    {r, g, b} | {r_min, g_min, b_min, r_max, g_max, b_max}
    Внимание! Значение deviation не передается в функцию,
    конвертация цветов НЕ происходит.
    К цветам заранее должен быть применен deviation,
    если это не обходимо
    (смотрите функцию deviate_color/evalute_color).

    [deviation_type]
    Тип deviaton по которому необходимо работать.
    Фактически необходимо указывать только для типа "s",
    т.к. там другой обработчик.
]==]
    function ext.findcolor_raw(screen, color_parsed, count, deviation_type)
        local need_to_catch = count

        -- Рассчитывем необходимый размер буфера для результата.
        if ext.findcolor_raw_result_size() < count then
            ext.findcolor_raw_result_size(count)
        end

        for screen_i = 1, #screen do
            local area = nil
            if type(screen[screen_i][1]) == "table" then
                area = screen[screen_i][1]
            else
                area = ext.getimage(screen[screen_i][2][1],
                                         screen[screen_i][2][2],
                                         screen[screen_i][2][3],
                                         screen[screen_i][2][4],
                                         screen[screen_i][1],
                                         screen[screen_i][3])
            end
            local offsets_delta_x1 = screen[screen_i][2][1] - area.offset_x
            local offsets_delta_y1 = screen[screen_i][2][2] - area.offset_y
            local offsets_delta_x2 = screen[screen_i][2][3] - area.offset_x
            local offsets_delta_y2 = screen[screen_i][2][4] - area.offset_y

            for i = 1, #color_parsed do
                local C_result_size = 0
                if deviation_type or #color_parsed[i] == 6 then
                    local compare_func = array_comparator.accuracy_restrict2a4af5_color
                    if deviation_type == "s" then
                        compare_func   = array_comparator.accuracy_restrict2a4af5_color_s
                    end

                    C_result_size = compare_func(
                        area.bitmap                    --unsigned char *restrict area,
                        - area.offset_y*area.l
                        - area.offset_x*3,

                        area.bitmap                    --unsigned char *restrict area_y_limit,
                        +(screen[screen_i][2][4]
                        -area.offset_y)*area.l
                        -area.offset_x*3
                        +1,

                        area.l,                        -- int area_lenght,
                        screen[screen_i][2][1]*3,      -- int area_offset_x1,
                        screen[screen_i][2][2]*area.l, -- int area_offset_y1,
                        screen[screen_i][2][3]*3+1,    -- int area_offset_x2,

                        result,                        -- int result[][6],
                        count,                         -- int result_size,

                        color_parsed[i][3],            --char blue_min,
                        color_parsed[i][2],            --char green_min,
                        color_parsed[i][1],            --char red_min,
                        color_parsed[i][6],            --char blue_max,
                        color_parsed[i][5],            --char green_max,
                        color_parsed[i][4]             --char red_max

                    --[[
                        -- кошерный вариант без хрени с компенсацией координат.
                        area.bitmap,                --unsigned char *restrict area,
                        area.bitmap                 --unsigned char *restrict area_y_limit,
                        +offsets_delta_y2*area.l+1,

                        area.l,                     -- int area_lenght,
                        offsets_delta_x1*3,         -- int area_offset_x1,
                        offsets_delta_y1*area.l,    -- int area_offset_y1,
                        offsets_delta_x2*3+1,       -- int area_offset_x2,

                        pointers.result,            -- int result[][6],
                        count,                      -- int result_size,

                        color_parsed[i][3],         --char blue_min,
                        color_parsed[i][2],         --char green_min,
                        color_parsed[i][1],         --char red_min,
                        color_parsed[i][6],         --char blue_max,
                        color_parsed[i][5],         --char green_max,
                        color_parsed[i][4]          --char red_max
                    ]]
                )

                    print(C_result_size)

                    print"_____result_____"
                    print(result[0][0])
                    print(result[0][1])
                    print(result[0][2])
                    print(result[0][3])
                    print(result[0][4])
                    print(result[0][5])

                    print"_____echo_____"
                    print(result[1][0])
                    print(result[1][1])
                    print(result[1][2])
                    print(result[1][3])
                    print(result[1][4])
                    print(result[1][5])

                    print"_____screen_converted_____"
                    print(result[2][0])
                    print(result[2][1])
                    print(result[2][2])
                    print(result[2][3])
                    print(result[2][4])
                    print(result[2][5])

                    print"_____pix_____"
                    print(result[3][0])
                    print(result[3][1])
                    print(result[3][2])
                    os.exit()
                    local stop = 1
                else
                    -- коррекция координат путем увода стартового указателя и "воссоздания" большого изображения.
                    -- метод очень опасный, если есть косяки по указателям и/или смещениям.
                    -- фактически в основе метода передача указателя на неразмеченную область памяти и
                    -- компенсация модифицированными оффсетами.
                    -- Цель - уход от математики с результатами (жрет __очень__ много).
                    C_result_size = array_comparator.accuracy_restrict2a4af5_color_strict(
                        area.bitmap                    --unsigned char *restrict area,
                        - area.offset_y*area.l
                        - area.offset_x*3,

                        area.bitmap                    --unsigned char *restrict area_y_limit,
                        +(screen[screen_i][2][4]
                        -area.offset_y)*area.l
                        -area.offset_x*3
                        +1,

                        area.l,                        -- int area_lenght,
                        screen[screen_i][2][1]*3,      -- int area_offset_x1,
                        screen[screen_i][2][2]*area.l, -- int area_offset_y1,
                        screen[screen_i][2][3]*3+1,    -- int area_offset_x2,

                        result,                        -- int result[][6],
                        count,                         -- int result_size,

                        color_parsed[i][3],            --char blue,
                        color_parsed[i][2],            --char green,
                        color_parsed[i][1]             --char red
                    )
                    --[[
                        -- кошерный вариант без хрени с компенсацией координат.
                        area.bitmap,                --unsigned char *restrict area,
                        area.bitmap                 --unsigned char *restrict area_y_limit,
                        +offsets_delta_y2*area.l+1,

                        area.l,                     -- int area_lenght,
                        offsets_delta_x1*3,         -- int area_offset_x1,
                        offsets_delta_y1*area.l,    -- int area_offset_y1,
                        offsets_delta_x2*3+1,       -- int area_offset_x2,

                        pointers.result,            -- int result[][6],
                        count,                      -- int result_size,

                        color_parsed[i][3],         --char blue,
                        color_parsed[i][2],         --char green,
                        color_parsed[i][1]
                        ]]
                end

                need_to_catch = need_to_catch - C_result_size

            end
        end

        return count - need_to_catch, result
    end
end

--[===[ ext.images.add
    Добавляет изображение в буфер.
    Допустимый синтаксис:
    <method>, <address(ctype)>,  <width>, <height>[, <lenght>[, offest_x, offset_y]]
    <method> - метод получения изображения (0/1/2/хендл/путь)
    <address(ctype)> - адрес битовой маски. Указатель типа ctype.
    <width> - ширина изображения.
    <height> - высота изображения.
    <lenght> - длина строки в байтах с выравниванием (можно не указывать).

    Настоятельно рекомендуется передавать именно ctype.
    Если данные передаются <address(ctype)>,
    то в буфере будет хранится блокирующая очистку ссылка
    на данные, garbage collecor не будет удалять эти изображения
    вплоть до явного вызова deleteimage либо стандартное:
    <address(ctype)> = nil

    <address(number)> более не может быть передан, как параметр.
    Комментарий оставлен для справочной информации.
    В случае если передан <address(number)>,
    буфер не гарантирует сохранность данных.
    В случае если переданные вами данные были local,
    то наличие ссылки (number) в буфере не убережет
    их от очитски garbage colletor'ом.
    В случае использования старого встроенного
    getimage/loadimage необходимо использовать deleteimage.
]===]

ext.images.add = function(method, a, w, h, l, offset_x, offset_y)
    local address = tonumber(ffi.cast("int",a))
    images[address] = {}
    images[address].address = address
    images[address].fuck_you_garbage_collector = a
    images[address].bitmap = ffi.cast("unsigned char*",a)

    -- создаем перенаправление для getimage,
    -- если изображение было загружено с диска.
    if type(method) == "string" then
        images[method] = images[address]
    end

    images[address].method = method
    images[address].w = w
    images[address].h = h
    images[address].l = l or math.floor(w*3/4+0.75)*4
    images[address].offset_x = offset_x or 0
    images[address].offset_y = offset_y or 0
    images[address].dots_total={["1_1"] = w*h}
end

--[[ ext.images.add_sub
    Добавляем изображение прошедшее конвертацию
    к уже существующему изображению в буфере.
    Допустимый синтаксис:
    <deviation_type>, <parent>, <address_1(ctype)>[, <address_2(ctype)>]
    <deviation_type>    - метод конвертации изображения (a/r/s)
    <deviation>         - значение отклонения цвета.
    <parent_index>      - индекс в буфере с исходным изображением (адрес памяти(number) или path)
    <address_1(ctype)>  - адрес битовой маски на deviation min / либо для скрина "s". Указатель типа ctype.
    <address_2(ctype)>  - адрес битовой маски на deviation max. Указатель типа ctype.
]]
ext.images.add_sub = function(parent, deviation_type, deviation, bitmap_1, bitmap_2)
    -- Создаем строку deviation для проверки буфера.
    local deviation_str = deviation_type.."_"..table.concat(deviation, "_")
    if deviation_str == "s_0_0_0_0_0_0" then -- скрин "s"
        images[parent][deviation_str]            = images[parent][deviation_str] or {}
        images[parent][deviation_str].fuck_you_garbage_collector = bitmap_1
        if deviation_type == "s" then
            images[parent][deviation_str].bitmap = ffi.cast("unsigned short*", bitmap_1)
        else
            images[parent][deviation_str].bitmap = ffi.cast("unsigned char*", bitmap_1)
        end
        images[parent][deviation_str].method     = images[parent].method
        images[parent][deviation_str].address    = tonumber(ffi.cast("int", images[parent][deviation_str].bitmap))
        images[parent][deviation_str].w          = images[parent].w
        images[parent][deviation_str].h          = images[parent].h
        images[parent][deviation_str].l          = images[parent].l
        images[parent][deviation_str].offset_x   = images[parent].offset_x or 0
        images[parent][deviation_str].offset_y   = images[parent].offset_x or 0
        images[parent][deviation_str].dots_total = images[parent].dots_total
    else
        images[parent][deviation_str] = images[parent][deviation_str] or {min={}, max={}}
        images[parent][deviation_str].min.fuck_you_garbage_collector = bitmap_1
        if deviation_type == "s" then
            images[parent][deviation_str].min.bitmap = ffi.cast("unsigned short*", bitmap_1)
        else
            images[parent][deviation_str].min.bitmap = ffi.cast("unsigned char*",  bitmap_1)
        end
        images[parent][deviation_str].min.method     = images[parent].method
        images[parent][deviation_str].min.address    = tonumber(ffi.cast("int", images[parent][deviation_str].min.bitmap))
        images[parent][deviation_str].min.w          = images[parent].w
        images[parent][deviation_str].min.h          = images[parent].h
        images[parent][deviation_str].min.l          = images[parent].l
        images[parent][deviation_str].min.offset_x   = images[parent].offset_x or 0
        images[parent][deviation_str].min.offset_y   = images[parent].offset_y or 0
        images[parent][deviation_str].min.dots_total = images[parent].dots_total

        images[parent][deviation_str].max.fuck_you_garbage_collector = bitmap_2
        if deviation_type == "s" then
            images[parent][deviation_str].max.bitmap = ffi.cast("unsigned short*", bitmap_2)
        else
            images[parent][deviation_str].max.bitmap = ffi.cast("unsigned char*",  bitmap_2)
        end
        images[parent][deviation_str].max.method     = images[parent].method
        images[parent][deviation_str].max.address    = tonumber(ffi.cast("int", images[parent][deviation_str].max.bitmap))
        images[parent][deviation_str].max.w          = images[parent].w
        images[parent][deviation_str].max.h          = images[parent].h
        images[parent][deviation_str].max.l          = images[parent].l
        images[parent][deviation_str].max.offset_x   = images[parent].offset_x or 0
        images[parent][deviation_str].max.offset_y   = images[parent].offset_y or 0
        images[parent][deviation_str].max.dots_total = images[parent].dots_total
    end
end

-- Полностью очищаем буфер.
function ext.images.flush()
    for i = 1, #images do
        ext.deleteimage(i)
    end
    return true
end


internal.getimage_orig = getimage
ext.getimage = function(x1, y1, x2, y2, method, abs_flag)
    if type(x1) ~= "string" then
        ext.images.temp_storage_size_up((x2-x1+1)*math.ceil((x2-x1+1)*3/4)*4)
    end
    return internal.getimage(image_buffer_p_char, x1, y1, x2, y2, method, abs_flag)
end
-- buffer_pointer будет проигнорирован, если подгружается изображение из файла.
do
    --local bi = ffi.new('BITMAPINFO', { {ffi.sizeof('BITMAPINFOHEADER'), w, -h, 1, 24, BI_RGB,0,0,0,0,0} })
    local SRCCOPY = 0x00CC0020
    local DIB_RGB_COLORS = 0
    local BI_RGB = 0
    internal.getimage = function(buffer_pointer, x1, y1, x2, y2, method, abs_flag)
        if method == "abs" then
            abs_flag = true
            method = nil
        end
        method = method or 0

        if type(method) == 'number' and type(x1) ~= "string" then
            -- Преобразуем абсолютные координаты в относительные.
            -- При методе 0 изображение снимается с экрана,
            -- а не с приложения. Необходимо добавить смещение.
            if method == 0 and not abs_flag then
                local wnd = workwindow()
                local w_x, w_y = 0, 0
                if wnd ~= 0 then
                    w_x, w_y = windowpos(workwindow())
                end
                x1 = x1 + w_x
                y1 = y1 + w_y
                x2 = x2 + w_x
                y2 = y2 + w_y
            end


            if method > 2 or method == 0 then
                local a, w, h, l
                w = x2-x1 + 1
                h = y2-y1 + 1
                l = math.ceil(w*3/4)*4

                local hdcWindow = C.GetDC(method or 0)  -- если хендл не указан, то получим скрин с экрана
                if not hdcWindow or hdcWindow == 0 then
                    print("hdcWindow: "..(hdcWindow and hdcWindow or "nil"))
                    return nil
                end
                local hdcMemDC = C.CreateCompatibleDC(hdcWindow)
                if not hdcMemDC or hdcMemDC == 0 then
                    print("hdcMemDC: "..(hdcMemDC and hdcMemDC or "nil"))
                    return nil
                end
                local hbmScreen = C.CreateCompatibleBitmap(hbmScreen, w, h)
                if not hbmScreen or hbmScreen == 0 then
                    print("hbmScreen: "..(hbmScreen and hbmScreen or "nil"))
                    return nil
                end

                local objBackup = C.SelectObject(hdcMemDC,hbmScreen)
                -- сохранить в памяти скрин с окна или экрана
                C.BitBlt(hdcMemDC, 0, 0, w, h, hdcWindow, x1, y1, SRCCOPY)

                local bi = ffi.new('BITMAPINFO', { {ffi.sizeof('BITMAPINFOHEADER'), w, -h, 1, 24, BI_RGB,0,0,0,0,0} })
                -- узнать какого размера нужен массив
                C.GetDIBits(hdcWindow, hbmScreen, 0, h, nil, bi, DIB_RGB_COLORS)
                -- получить битовый массив
                local h_copied = C.GetDIBits(hdcWindow, hbmScreen, 0, h, buffer_pointer, bi, DIB_RGB_COLORS)

                C.SelectObject(hdcMemDC,objBackup)
                C.ReleaseDC(method, hdcWindow)
                C.DeleteObject(hdcMemDC)
                C.DeleteObject(hbmScreen)

                --return h_copied and ffi.cast("int", buffer_pointer) or nil, w, h_copied, math.floor(w*3/4+0.75)*4
                if h_copied > 0 then
                    a = tonumber(ffi.cast("int", buffer_pointer))
                    return {bitmap=buffer_pointer, address=a, w=w, h=h_copied, l=l, offset_x = x1, offset_y = y1,
                            dots_total={["1_1"] = w*h}}
                else
                    return nil
                end
            else
                return internal.getimage_orig(x1, y1, x2, y2, method, abs_flag)
            end
        else -- источник путь файла. Получаем адрес в памяти.
            if images[method] then -- уже загружен.
                return images[method]
            else -- подгружаем
                return ext.loadimage(type(x1) == "string" and x1 or method)
            end
        end
    end
end


--[[
    -- Получить цвет пикселя окна.
    -- <x>, <y>, [abs], [method]
    x - x координата
    y - y координата
    [abs] - флаг использования абсолютных координат. "abs" - вкл.
    [method] - метод получения изображения. Хэндл окна/путь к файлу.
]]
do
    -- создаем буфер для пикселя.
    local result = ffi.gc(C.malloc(4), C.free)     -- выделяем память, вернет указатель на void
    local result_char = ffi.cast("unsigned char*", result)
    function ext.color(x, y, abs, method)
        if abs and abs ~= "abs" then
            method = abs
            abs = false
        end
        internal.getimage(result_char, x, y, x, y, method or workwindow(), abs)
        return result_char[2]*0x10000 + result_char[1]*0x100 + result_char[0],
            result_char[2], result_char[1], result_char[0]
    end
end


-- Проверяет равенство цвета на экране
-- с заданным цветом, учитывает deviation.
-- <x>, <y>, [abs], <c>, [deviation, [deviation_type]]
do
    -- создаем буфер для пикселя.
    local result = ffi.gc(C.malloc(4), C.free)     -- выделяем память, вернет указатель на void
    local result_char = ffi.cast("unsigned char*", result)
    ext.is_color = function(x, y, abs, color, deviation, deviation_type)
        if abs and abs ~= "abs" then
            deviation_type = deviation
            deviation = color
            color = abs
            abs = false
        end
        deviation = deviation or {0.98, 0.98, 0.98, 1.02, 1.02, 1.02}
        deviation_type = deviation_type or "s"

        local color_evaluted = ext.evalute_color({color}, deviation, deviation_type)
        local img = internal.getimage(result_char, x, y, x, y, workwindow(), abs)
        return ext.findcolor_raw({{img, {x, y, x, y}, abs}}, color_evaluted, 1, deviation_type) > 0 and true or false
    end
end


internal.deleteimage_orig = deleteimage
ext.deleteimage = function(address)
--dbg.enable(1)
    if type(address) == "string" then
        local str = address
        address = image[address] -- Преобразуем путь в адрес.
        images[str] = nil
    end

    if type(address) == "table" then
        if images[address[1]] then
            --images[address[1]].bitmap = nil
            C.free(images[address[1]].bitmap)
            if images[address[1]].hdcWindow then -- получено захватом по хендлу или методом 0
                C.ReleaseDC(images[address[1]].method, images[address[1]].hdcWindow)
                C.DeleteObject(images[address[1]].hdcMemDC)
                C.DeleteObject(images[address[1]].hbmScreen)

            elseif type(images[address[1]].method) == "string" then -- загружено с диска, удаляем ссылку
                internal.deleteimage(address[1])
                images[images[address[1]].method] = nil
            end

            if images[address[1]].deviation then
                for k, v in pairs (images[address[1]].deviation) do -- удаляем кэшированные deviation
                    v[1] = nil
                    v[2] = nil
                    ext.deleteimage(v.a1)
                    ext.deleteimage(v.a2)
                end
            end
            collectgarbage()
            images[address] = nil
        end
    else
        internal.deleteimage_orig(address)
    end
end

--[[ ext.saveimage
    Сохранение изображений.
    Допустимый синтаксис:
    <path>, <address>[, x1, y1, x2, y2] -- если загружено новым getimage
    <path>, <{address, width, height}>[, x1, y1, x2, y2]
    <path>, <{a=val, w=val, h=val}>[, x1, y1, x2, y2]
    <path>, <{address=val, width=val, height=val}>[, x1, y1, x2, y2]
    path - пусть по которому необходимо сохранить изображение
    address - адрес в памяти по которму находится изображение
    width - ширина изображения
    height - высота изображения
    x1, y1 - начальные координаты сохраняемого изображения
    x2, y2 - конечные координаты сохраняемого изображения
    Если указаны x1, y1, x2, y2, то указывать высоту исходного
    изображения не обязательно.
]]
ext.saveimage = function()end
do
    local FILE_READ_DATA = 0x1
    local FILE_WRITE_DATA = 0x2

    local FILE_SHARE_READ = 0x00000001
    local FILE_SHARE_WRITE = 0x00000002

    local CREATE_ALWAYS = 0x2

    local FILE_ATTRIBUTE_NORMAL = 0x80

    local bmp_headers = {}

    bmp_headers[1] = ffi.new("const unsigned char[2]",{ 0x42,
                                                        0x4D}    )
                                                    --  file_size 4 bytes
    bmp_headers[2] = ffi.new("const unsigned char[12]",{0x00,
                                                        0x00,
                                                        0x00,
                                                        0x00,
                                                        0x36,
                                                        0x00,
                                                        0x00,
                                                        0x00,
                                                        0x28,
                                                        0x00,
                                                        0x00,
                                                        0x00    })
                                                    --  image_width 4 bytes signed integer
                                                    --  image_height 4 bytes signed integer
    bmp_headers[3] = ffi.new("const unsigned char[8]",{ 0x01,
                                                        0x00,
                                                        0x18, -- the number of bits per pixel, which is the color depth of the image. Typical values are 1, 4, 8, 16, 24 and 32
                                                        0x00,
                                                        0x00,
                                                        0x00,
                                                        0x00,
                                                        0x00    })
                                                    --  bitmap_size (w*h*3)
    bmp_headers[4] = ffi.new("const unsigned char[16]",{0x00,
                                                        0x00,
                                                        0x00,
                                                        0x00,
                                                        0x00,
                                                        0x00,
                                                        0x00,
                                                        0x00,
                                                        0x00,
                                                        0x00,
                                                        0x00,
                                                        0x00,
                                                        0x00,
                                                        0x00,
                                                        0x00,
                                                        0x00    })

    ext.saveimage = function(path, a, x1, y1, x2, y2)
    --log(a, path, x1, y1, x2, y2)
        local w, h, l
        local f = C.CreateFileA(
            path,
            FILE_READ_DATA + FILE_WRITE_DATA,
            FILE_SHARE_READ + FILE_SHARE_WRITE,
            nil,
            CREATE_ALWAYS,
            FILE_ATTRIBUTE_NORMAL,
            nil)
        local dwbuf = ffi.new'DWORD[1]'

        if type(a) == "number" then
            w = images[a].width
            h = images[a].height
            l = images[a].lenght
        else
            w = a[2] or a.width    or a.w
            h = a[3] or a.height   or a.h
            l = math.ceil(w*3/4)*4
            a = a[1] or a.address  or a.a
        end

        -- Заданы параметры на сохранение
        -- некоторой области изображения.
        -- Создаем временное изображение.
        if x1 then
            a, w, h, l = ext.image_copy({a, w}, x1, y1, x2, y2)
        end

        local success = C.WriteFile(f,                            bmp_headers[1],     2, dwbuf, nil)
        local success = C.WriteFile(f, ffi.new("uint32_t[1]",     h*l*3+54     ),     4, dwbuf, nil)
        local success = C.WriteFile(f,                            bmp_headers[2],    12, dwbuf, nil)
        local success = C.WriteFile(f, ffi.new("uint32_t[1]",     w            ),     4, dwbuf, nil)
        local success = C.WriteFile(f, ffi.new("uint32_t[1]",    -h            ),     4, dwbuf, nil)
        local success = C.WriteFile(f,                            bmp_headers[3],     8, dwbuf, nil)
        local success = C.WriteFile(f, ffi.new("uint32_t[1]",     l*h*3        ),     4, dwbuf, nil)
        local success = C.WriteFile(f,                            bmp_headers[4],    16, dwbuf, nil)

        local success = C.WriteFile(f, ffi.cast("void*",          a            ),   h*l, dwbuf, nil)

        C.CloseHandle(f)
        if x1 then
            ext.deleteimage(a)
        end
        --for i = 1, #bmp_headers do
            --C.DeleteObject(bmp_headers[i])
        --end
        --collectgarbage()
        return true
    end
end

--[[ext.loadimage
    Допустимый синтаксис:
    <path>
    Возвращает:
    address, widht, height, lenght
    address - адрес в памяти
    widht - ширина в пикселях
    height - высота в пикселях
    lenght - ширина в байтах с выравниванием
    Загружает изображение с диска в память.
    При загрузке оно помещается в буфер,
    при дальнейших вызовах для загрузки
    изображения по тому же адресу,
    релаьной загрузки происходить не будет,
    а будут возвращаться данные уже загруженного
    изображения.
    ]]
ext.loadimage = function(path)end
do
    local FILE_READ_DATA        = 0x1

    local FILE_SHARE_READ       = 0x00000001
    local FILE_SHARE_WRITE      = 0x00000002

    local OPEN_EXISISTING       = 0x03

    local FILE_ATTRIBUTE_NORMAL = 0x80

    ext.loadimage = function(path)
        if images[path] then
            return {images[path]}
        end
        local f = C.CreateFileA(
            path,
            FILE_READ_DATA,
            FILE_SHARE_READ + FILE_SHARE_WRITE,
            nil,
            OPEN_EXISISTING,
            FILE_ATTRIBUTE_NORMAL,
            nil)
        if (tonumber(ffi.cast("int", f))) < 0 then
            log("loadimage error: "..(tonumber(ffi.cast("int", f))))
            return nil, (tonumber(ffi.cast("int", f)))
        end

        local dwbuf             = ffi.new'DWORD[1]'

        local file_size         = ffi.new("unsigned int[1]")
        local dResult           = C.SetFilePointer(f,                  2, nil, 0)
        local success           = C.ReadFile(f,                                               file_size, 4, dwbuf, nil)
              file_size         = tonumber(file_size[0])

        local pixel_array_pos   = ffi.new("unsigned int[1]")
              dResult = C.SetFilePointer(f,                           10, nil, 0)
              success = C.ReadFile(f,                                                   pixel_array_pos, 4, dwbuf, nil)

        local w                 = ffi.new("unsigned int[1]")
              dResult           = C.SetFilePointer(f,                 18, nil, 0)
              success           = C.ReadFile(f,                                                       w, 4, dwbuf, nil)
              w                 = tonumber(w[0])

        local h                 = ffi.new("unsigned int[1]")
        local dResult           = C.SetFilePointer(f,                 22, nil, 0)
        local success           = C.ReadFile(f,                                                       h, 4, dwbuf, nil)
              h                 = tonumber(h[0])

        local l = math.ceil(w*3/4)*4
        --log("l:", l)


        local bitmap_size       = h*l
        --local bitmap    = ffi.gc(C.malloc(bitmap_size), C.free)
        local fuck_you_garbage_collector_1 = ffi.gc(C.malloc(bitmap_size), C.free)
        local bitmap            = ffi.cast("unsigned char*", fuck_you_garbage_collector_1)
        --log(tostring(bitmap), bitmap_size)
        local dResult           = C.SetFilePointer(f, pixel_array_pos[0], nil, 0)

        local success           = C.ReadFile(f,                     bitmap,            bitmap_size, dwbuf, nil)
        --log("pixel_array_pos:", tonumber(pixel_array_pos[0]))

        ext.images.add(path, fuck_you_garbage_collector_1, w, h, l)
        ext.image_mirror_v(tonumber(ffi.cast("unsigned int", bitmap)))
        --images[tonumber(ffi.cast("unsigned int", bitmap))].bitmap = bitmap
        --log("read error:", tonumber(C.GetLastError()))
        --log("type:", type(bitmap))

        collectgarbage()
        return images[path]
    end
end

--[[ ext.image_copy
    -- Копирует часть изображения.
    -- Допустимый синтаксис:
    -- <address>,<x1>,<y1>,<x2>,<y2> -- если изображение загружено новым getimage
    -- <{address, width}>,<x1>,<y1>,<x2>,<y2>
    -- <{address=val, width=val}>,<x1>,<y1>,<x2>,<y2>
    -- <{a=val, w=val}>,<x1>,<y1>,<x2>,<y2>
    -- Возвращает:
    -- address, width, height, lenght
]]

ext.image_copy = function(a, x1, y1, x2, y2)
--log(a, x1, y1, x2, y2)
    local w,l
    if type(a) == "number" then
        w = images[a].width
        l = images[a].lenght
    else
        w = a[2] or a.w or a.width
        l = math.ceil(w*3/4)*4
        a = a[1] or a.a or a.address
    end

    local cut_w = x2-x1 + 1
    local cut_h = y2-y1 + 1
    local cut_l = math.ceil(cut_w*3/4)*4

    -- Выделяем память, создаем указатели
    local a = ffi.cast("unsigned char*", a)
    local cut_a = ffi.gc(C.malloc(cut_h*cut_l), C.free)
    local aa = ffi.cast("unsigned char*", cut_a)
    -- Добавляем изображение в буфер
    ext.images.add(-1, cut_a, cut_w, cut_h, cut_l)

    local w3 = cut_w*3
    -- Копируем
    local r = {}
    for i = y1*l+x1*3, y2*l + x1*3, l do
        C.memcpy(aa, a+i, w3)
        aa = aa + cut_l
    end

    return tonumber(ffi.cast("int", cut_a)), cut_w, cut_h, cut_l
end

--[[ ext.image_mirror_v
    Допустимый синтаксис:
    <address>
    Переворачивает изображение по вертикали.
    Происходит модификация изображения,
    а не создание нового.
    Возвращает указатель на изображение.
]]
ext.image_mirror_v = function(a)
    local w, h, l
    a  = type(a) == "cdata" and tonumber(ffi.cast("unsigned int", a)) or a
    if type(a) == "number" then
        w = images[a].w
        h = images[a].h
        l = images[a].l
    else
        a = a.address or a.a or a[1]
        w = a.width   or a.w or a[2]
        h = a.height  or a.h or a[3]
        l = math.ceil(w*3/4)*4
    end

    local w3  = w*3
    local buf = ffi.new("unsigned char[".. w*3 .."]")
    local a   = ffi.new("unsigned char*"            , ffi.cast("unsigned char*", a))

    for i = 0, math.floor((h-1)/2)*l, l do
        ffi.copy(buf,              a+i,         w3)
        ffi.copy(a+i,              a+l*(h-1)-i, w3)
        ffi.copy(a+l*(h-1)-i,      buf,         w3)
    end
    buf = nil

    return a
end



ext.images.temp_storage_size(33554432*2)
--ext.getimage([[image\test\96x96\big.bmp]])
--local nn = ext.getimage([[image\test\99x99\big.bmp]])
--ext.getimage([[image\test\99x99\upper_left_9x9.bmp]])
--local raw_color = ext.evalute_color({{181,111,182}}, 1.02, "s")
local raw_color = ext.evalute_color({{255,254,254}}, 1.02, "s")
--ext.getimage([[image\test\99x99\mid_9x9.bmp]])
local t = os.clock()
local result

workwindow(20778700)
for i = 1, 1 do
--ext.findimage_multi ({{659668,0,0,99,99,"abs"}}, {{659668,0,0,10,10,"abs"}}, 90, 1, "s", 1, 1, 1)
--local r = ext.findimage_multi ({{[[image\test\99x99\big.bmp]],0,0,100,100,"abs"}},
--                     {{[[image\test\99x99\upper_left_9x9.bmp]],0,0,10,10,"abs"}},
--                     90, 1, "s", 1000, 1, 1, {1, 2, 3})


--[===[
result = ext.findimage_multi ({
                               --{[[image\random_big_screen2.bmp]]   ,0,0,1919,1079,"abs"},
                               --{[[image\test\96x96\big.bmp]]            ,0,0,99,99,"abs"},
                               --{[[image\test\96x96\big.bmp]]            ,0,0,99,99,"abs"},
                               --{[[image\test\96x96\big.bmp]]            ,0,0,99,99,"abs"},
                               --{[[image\test\96x96\big.bmp]]            ,0,0,99,99,"abs"},
                               --{[[image\test\96x96\big.bmp]]            ,0,0,99,99,"abs"},
                               --{[[image\test\96x96\big.bmp]]            ,0,0,99,99,"abs"},
                               --{[[image\test\96x96\big.bmp]]            ,0,0,99,99,"abs"},
                               --{[[image\test\96x96\big.bmp]]            ,0,0,99,99,"abs"},
                               --{[[image\test\96x96\big.bmp]]            ,0,0,99,99,"abs"},
                               --{[[image\test\96x96\big.bmp]]            ,0,0,99,99,"abs"},

                               {[[image\test\99x99\big.bmp]]            ,0,0,99,99,"abs"}
                               },
                              {
                               --{[[image\random_big.bmp]]   ,0,0,1919,1079,"abs"},
                               --{[[image\test\96x96\upper_left_9x9.bmp]] ,0,0,10,10,"abs"},
                               --{[[image\test\96x96\upper_left_9x9.bmp]] ,0,0,10,10,"abs"},
                               --{[[image\test\96x96\upper_left_9x9.bmp]] ,0,0,10,10,"abs"},
                               --{[[image\test\96x96\upper_left_9x9.bmp]] ,0,0,10,10,"abs"},
                               --{[[image\test\96x96\upper_left_9x9.bmp]] ,0,0,10,10,"abs"},
                               --{[[image\test\96x96\upper_left_9x9.bmp]] ,0,0,10,10,"abs"},
                               --{[[image\test\96x96\upper_left_9x9.bmp]] ,0,0,10,10,"abs"},
                               --{[[image\test\96x96\upper_left_9x9.bmp]] ,0,0,10,10,"abs"},
                               --{[[image\test\96x96\upper_left_9x9.bmp]] ,0,0,10,10,"abs"},
                               --{[[image\test\96x96\upper_left_9x9.bmp]] ,0,0,10,10,"abs"},

                               {[[image\test\99x99\upper_left_9x9.bmp]] ,0,0,10,10,"abs"},
                               --{[[image\test\99x99\mid_9x9.bmp]]        ,0,0,10,10,"abs"}
                               },
                                90, 1, "s", 1000, 1, 1, true)
]===]


result = ext.findimage_multi {{
                                    {[[image\test\99x99\big.bmp]]            ,0,0,99,99,"abs"},
                               },
                              {
                                    {[[image\test\99x99\upper_left_9x9.bmp]] ,0,0,10,10,"abs"},
                               },
                                90, 1, "s", 1000, 1, 1, true}
e.lg(result)

--528534

--print(ext.images.temp_storage_size())
--result = ext.findimage_multi ({{19600396,0,0,1000,1000,"abs"}},
--                              {{19600396,65,65,80,80,"abs"}},
--                               90, 1, "s", 1000, 2, 2, true)
--print(ext.images.temp_storage_size())

--local result = ext.getimage()

--ext.findimage_multi {{{[[image\test\99x99\big.bmp]],51,51,100,100,"abs"}},
--                     {{[[image\test\99x99\mid_9x9.bmp]],0,0,10,10,"abs"}},
--                     90, 1.02, "s", 1000, 1, 1, true}

--result = ext.findimage_multi {{{0,0,0,1919,1079,"abs"}},
--                     {{[[image\test\99x99\mid_9x9.bmp]],0,0,10,10,"abs"}},
--                     90, 1.02, "r", 1000, 1, 1, true}

--[===[
    result = ext.findcolor_multi({{[[image\test\99x99\big.bmp]],0,0,99,99,"abs"}},
                    --{{0,0,0,255,255,255}},
                    {{181,111,182}},
                    --{181,111,182,181,111,182},
                    1,
                    --1, "r"
                    255, "a"
                    --10, "a"
                    --10, "r"
                    --false
                    --{1.02,1.02,1.02}, "s"
                    --{0.98,0.98,0.98,1.02,1.02,1.02}, "s"
                )
]===]

    --result = ext.findcolor(5,5,99,99, {199, 9, 9}, 10000, false)
    --result = ext.findcolor(5,5,99,99, {152, 35, 72}, 10000, false)
    --result = ext.findcolor(5,5,5,5, {100, 0, 0}, 10000, false, false)

--[[
    for y = 0, 5 do
        for x = 0, 5 do
            result = ext.findcolor(x,y,5,5, {100*0x10000, 100*0x10000}, 10000, false, false)
            --result = ext.findcolor(x,y,5,5, {0, 0, 0, 255, 255, 255}, 10000, false, false)
            if result then
                if #result ~= 1 then
                    print("error size "..#result,x,y)
                else
                    print("ok ",x,y)
                end
            else
                print("error nil",x,y)
            end
        end
    end
]]

    --result = ext.findcolor(5,5,5,5, {0, 0, 0, 255, 255, 255}, 10000, false, false)
    --result = ext.findcolor(5,5,5,5, {49,99,199}, 10000, 1.02)


    --[==[result = ext.findcolor_raw(
                                {{[[image\test\99x99\big.bmp]],{0,0,99,99},"abs"}},
                                --{{nn,{0,0,99,99},"abs"}},
                                  raw_color, 1, "s")
                                  ]==]
--e.lg(raw_color)

--    result = ext.findcolor_raw(
--                                {{workwindow(),{0,0,99,99},"abs"}},
--                                  raw_color, 1, "s")


    --print(tostring(ext.is_color(5,5,{127,127,127}, 1.0002, "s")))
    --print(tostring(ext.is_color(5,5,{255,254,254}, 1, "s")))
end

--e.lg(result)

print(os.clock()-t)

print(type(result) == "table" and "#result: "..#result or result and "C_result: "..result or "no result")


-- красный = x%10*10+y%10 + 100
-- зеленый = x
-- синий   = y
local finimage_crds_checker = function()
    for y = 5, 103 do
        for x = 5, 103 do
            local c = (y-5)
                    + (x-5)*0x100
                    + (100 + (x-5)%10*10 + (y-5)%10)*0x10000
            local result = ext.findcolor(x,y,x,y,c, false, false)
            if not (result and #result==1 and result[1].dec == c) then
                result = ext.findcolor(x,y,x,y,{0, 0, 0, 255, 255, 255}, false, false)
                local msg = "Error: x="..(x-5).." y="..(y-5).." c="
                    ..table.concat({ext.rgb_color_to_rgb(c)}, " ")
                    .."\n                 "..table.concat({ext.rgb_color_to_rgb(result[1].dec)}, " ")
                print(msg)
                --e.lg(result)
                --C.Sleep(100000)
            else
                --print"ok"
            end
        end
    end
    print("crds check complete")
end
local finimage_crds_checker_2 = function()
    for y = 5, 103 do
        for x = 5, 103 do
            local c = (y-5)
                    + (x-5)*0x100
                    + (100 + (x-5)%10*10 + (y-5)%10)*0x10000
            for y_end = y, 103 do
                for x_end = x, 103 do
                    local result = ext.findcolor(x,y,x_end,y_end,c, false, false)
                    if not (result and #result==1 and result[1].dec == c) then
                        result = ext.findcolor(x,y,x_end,y_end,{0, 0, 0, 255, 255, 255}, false, false)
                        local msg = "Error: x="..(x-5).." y="..(y-5).." c="
                            ..table.concat({ext.rgb_color_to_rgb(c)}, " ")
                            .."\n                 "..table.concat({ext.rgb_color_to_rgb(result[1].dec)}, " ")
                        print(msg)
                        --e.lg(result)
                        --C.Sleep(100000)
                    else
                        --print"ok"
                    end
                end
            end
            print("x="..x.."/103")
        end
        print("y="..y.."/103")
    end
    print("crds check complete")
end
local finimage_crds_checker_3 = function()
    local paint = ext.getimage(5,5,103,103,workwindow())
    for y = 5, 103 do
        for x = 5, 103 do
            local c = (y-5)
                    + (x-5)*0x100
                    + (100 + (x-5)%10*10 + (y-5)%10)*0x10000
            for y_end = y, 103 do
                for x_end = x, 103 do
                    local result = ext.findcolor_multi({{paint,{x,y,x_end,y_end}}},{{c}}, false, false)
                    if not (result and #result==1 and result[1].dec == c) then
                        result = ext.findcolor_multi({{paint,{x,y,x_end,y_end}}},{{0, 0, 0, 255, 255, 255}}, false, false)
                        local msg = "Error: x="..(x-5).." y="..(y-5).." c="
                            ..table.concat({ext.rgb_color_to_rgb(c)}, " ")
                            .."\n                 "..table.concat({ext.rgb_color_to_rgb(result[1].dec)}, " ")
                        print(msg)
                        --e.lg(result)
                        --C.Sleep(100000)
                    else
                        --print"ok"
                    end
                end
            end
            print("x="..x.."/103")
        end
        print("y="..y.."/103")
    end
    print("crds check complete")
end
--finimage_crds_checker()
--finimage_crds_checker_2()
--finimage_crds_checker_3()


return ext

--[[
TODO
1)+ Переделать метод 0 для поиска по относительным координатам
2)+ Переделать возвращаемый массив в <x> <y> <найденный_цвет <искомый_цвет1> <искомый_цвет2>
3)+ Добавить шаг поиска.
4)+ Добавить в images хранение высоты, ширины, длины
5)+ Использовать images для скринилки с вызовом скринилки только по адресу изображения. Поменять местами аргументы path, a.
6)+ Переделать cоlor в local c = color(x,y[,color][,deviation][,method][,abs])
7)+ Буфер loadimage
8)- Финдимидж
9)+ Проблема в том что она возвращает x y относительно координат поиска а хорошо бы возвращать реальные координаты.
10)+ Переписать loadimage вкрутить его в getimage. loadimage = частный случай getimage. Сохранить обратную совместимость.
11)- Добавить удаление deviation изображений из буфера.
12)- Поддержка хендла в роли метода паттерна. Не забыть, что temp_storage на это не рассчитан - выход за пределы выделенной памяти.

убрать костыль с типами:
    local width  = tonumber(desktopwidth())
    local height = tonumber(desktopheight())
]]


-- Это рабочий код финдимиджа без девиэйшена.
--[===[
local fc = function(area, area_width, area_height, area_lenght,
                    area_offset_x1, area_offset_y1, area_offset_x2, area_offset_y2,
                    pattern, pattern_width, pattern_height, pattern_lenght,
                    result, result_size, accuracy
                    )
    -- Количество минимально совпавшее кооличество пикселей при заданном accuracy
    local accuracy_in_dots = pattern_width * pattern_height - pattern_width * pattern_height * (100-accuracy) / 100;
    -- Достаточное оличество несовпашвших точек при превышении которого признать поиск провальным (в данной точке)
    local accuracy_too_low = pattern_width * pattern_height - accuracy_in_dots;
    local dots_total = pattern_width*pattern_height;

    local catched = 0;
    local from_end_to_start_x = area_lenght - pattern_width*3;
    -- Перебор линий скрина
    for area_y = 0, (area_offset_y2-pattern_height+1)*area_lenght, area_lenght do
        -- Перебор пикселей в линии скрина
        for area_x = area_y, area_y + (area_offset_x2-pattern_width+1)*3, 3 do
            -- Создаем копию текущей позиции в скрине, чтобы не перезаписать.
            local area_pos_x = area_x;
            local dots_wrong = 0;

            -- Перебор линий паттерна
            for pattern_y = 0, (pattern_height-1)*pattern_lenght, pattern_lenght do
                -- Перебор пикселей в линии паттерна
                for pattern_x = pattern_y, pattern_y + pattern_width*3 - 2, 3 do
                    if  area[area_pos_x]    ~=  pattern[pattern_x]
                    or (area+1)[area_pos_x] ~= (pattern+1)[pattern_x]
                    or (area+2)[area_pos_x] ~= (pattern+2)[pattern_x] then
--                    if  area[area_pos_x]   ~= pattern[pattern_x]
--                    or  area[area_pos_x+1] ~= pattern[pattern_x+1]
--                    or  area[area_pos_x+2] ~= pattern[pattern_x+2] then

                        dots_wrong = dots_wrong + 1;
                        if (dots_wrong > accuracy_too_low) then
                            goto next_pos;
                        end
                    end
                    -- Сдвигаем позицию скрина на следующий пиксель в линии (в рамках сличения паттерна, это не общий перебор стартовых позиций)
                    area_pos_x = area_pos_x + 3;
                end
                   -- Переходим на следующую линию скрина (в рамках сличения паттерна, это не общий перебор стартовых позиций)
                area_pos_x = area_pos_x + from_end_to_start_x;
            end
            result[catched][1] = area_y / area_lenght
            result[catched][0] = (area_x - area_lenght*result[catched][1]) / 3
            result[catched][2] = result[catched][0] + pattern_width - 1;
            result[catched][3] = result[catched][1] + pattern_height - 1;
            result[catched][4] = 10000 - dots_wrong * 10000 / dots_total;
            catched = catched + 1;
            ::next_pos::;
        end
    end

    return catched;
end
]===]