--lua
--[[
    Copyright (c) <2021>, <DarkMaster forum.uokit.com> All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
    are permitted provided that the following conditions are met:

    Usage is only allowed in not modifed UOPilot (uopilot.uokit.com) program,
    use in other programs is allowed only with the written permission of the owner.
    Redistribution of the original or modified code must be free, sale or commercial
    gain in any form is possible only with the written permission of the owner.
    Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
    Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.
    Neither the name of the owner nor the names of its contributors
    may be used to endorse or promote products derived from this software
    without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
    ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
    WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
    IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
    INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
    BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
    OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
    WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
    ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
    OF THE POSSIBILITY OF SUCH DAMAGE.
]]

local ffi           = require[[ffi]]













local calc = {}


-- delta = angle_delta(azimuth_1, azimuth_2)
-- Вычисление угла между двумя азимутами.
--
-- delta - результат разницы в углах
--
-- azimuth_1 - первый азимут
--
-- azimuth_2 - второй азимут
calc.angle_delta = function(azimuth_1, azimuth_2)
    local degrees = (azimuth_1 - azimuth_2)%360
    return math.min(degrees, 360 - degrees)
end


calc.distance = function(arr1, arr2, multiple_y)
    multiple_y = multiple_y or 1 -- если у нас одна из осей сплющена, то к y применяем множитель
    return ((arr2[1] - arr1[1])^2 + ((arr2[2] - arr1[2])*multiple_y)^2)^0.5
end


-- result_x, result_y = polartocartesian( x, y,  angle, lenght)
-- result_x, result_y = polartocartesian({x, y}, angle, lenght)
-- Преобразует полярные координаты в декартовы.
-- Эта функция позволяет рассчитать конечную точку отрезка,
-- если известны начальная точка, азимут и длина.
calc.polartocartesian = function(x, y, angle, lenght)
    if not lenght then
        lenght = angle
        angle = y
        y = x[2]
        x = x[1]
    end
    local x2 = x + lenght * math.cos(angle)
    local y2 = y + lenght * math.sin(angle)
    return x2, y2
end


-- angle = point_direction( x1, y1 ,  x2, y2 , offset)
-- angle = point_direction({x1, y1}, {x2, y2}, offset)
-- angle = point_direction( x1, y1 , {x2, y2}, offset)
-- angle = point_direction({x1, y1},  x2, y2 , offset)
-- Вычисление угла направления между двумя точками (азимут)
--
-- x1     - x координата первой точки
--
-- y1     - y координата первой точки
--
-- x2     - x координата второй точки
--
-- y2     - y координата второй точки
--
-- offset - смещение координат. Необязательный параметр.
--          Смещение поумолчанию задано равным 90 градусов,
--          чтобы 0 градусов было сверху (север).
calc.point_direction = function(x1, y1, x2, y2, offset)
    if type(x2) == "table" then
        offset = y2
        y2 = x2[2]
        x2 = x2[1]
    elseif type(y1) == "table" then
        offset = x2
        y2 = y1[2]
        x2 = y1[1]
        y1 = x1[2]
        x1 = x1[1]
    elseif type(x1) == "table" then
        offset = y2
        y2 = x2
        x2 = y1
        y1 = x1[2]
        x1 = x1[1]
    end

    if x1 == x2 and y1 == y2 then return nil end
    offset = offset or 90

    local dx = x2 - x1
    local dy = y2 - y1

    local angle = math.deg(math.atan2(dy, dx))
    angle = (angle + offset) % 360
    return angle
end


-- result = triangle([ab], [abc], [bc], [bca], [ca], [cab], [cab_crds], [abc_crds], [bca_crds])
-- Решение треугольника abc.
--
-- result - решенный треугольник, либо nil,
--          если решение не возможно.
--
-- ab  - сторона ab
--
-- abc - угол abc
--
-- bc  - сторона bc
--
-- bca - угол bca
--
-- ca  - сторона ca
--
-- cab - угол cab
--
-- cab_crds - координа вершины a в виде массива {x, y}
--
-- abc_crds - координа вершины b в виде массива {x, y}
--
-- bca_crds - координа вершины c в виде массива {x, y}
--
-- Примечание:
-- Количество заданных параметров не регламентировано.
-- Тем не менее нужно понимать, что треугольник
-- может быть однозначно решен передано хотя бы одно из:
-- 1) 3 стороны
-- 2) 2 стороны и угол между ними
-- 3) 1 сторона и два прилежащих к ней угла
-- Вершины и углы могут быть заданы в комбинированном виде.
-- При этом задание координаты только одной вершины не
-- имеет смысла, т.к. количество возможных варинтов построения
-- будет бесконечным.
-- При задании координат двух вершин, координаты третьей вершины
-- будут иметь два возможных решения. В этом случае первым
-- результатом будет координата, расположенная справа от линии ab,
-- если смотреть из вершины a.
calc.triangle = function(ab, abc, bc, bca, ca, cab, cab_crds, abc_crds, bca_crds)
    ab  = ab  == 0 and nil or ab
    bc  = bc  == 0 and nil or bc
    ca  = ca  == 0 and nil or ca
    abc = abc == 0 and nil or abc
    bca = bca == 0 and nil or bca
    cab = cab == 0 and nil or cab
    cab_crds = cab_crds == 0 and nil or cab_crds
    abc_crds = abc_crds == 0 and nil or abc_crds
    bca_crds = bca_crds == 0 and nil or bca_crds

    -- Преобразуем координаты вершин в длины ребер.
    if not ab and cab_crds and abc_crds then
        ab = calc.distance(cab_crds, abc_crds)
    end
    if not bc and abc_crds and bca_crds then
        bc = calc.distance(abc_crds, bca_crds)
    end
    if not ca and bca_crds and cab_crds then
        ca = calc.distance(bca_crds, cab_crds)
    end

    -- Если не все углы заданы, то
    -- проверяем есть ли хотя бы два угла.
    -- Если есть, то сразу находим третий.
    if not abc or not bca or not cab then
        if abc and bca then
            cab = cab or 180 - abc - bca
        elseif bca and cab then
            abc = abc or 180 - bca - cab
        elseif cab and abc then
            bca = bca or 180 - cab - abc
        end
    end

    -- Известны три стороны
    if ab and bc and ca then
        cab = cab or math.deg(math.acos((ca^2 + ab^2 - bc^2) / (2 * ca * ab)))
        abc = abc or math.deg(math.acos((bc^2 + ab^2 - ca^2) / (2 * bc * ab)))
        bca = bca or 180 - abc - cab

    -- Известна сторона и два угла.
    -- Попытка вычислить третий угол
    -- на основе двух известных происходит
    -- при входе в функцию.
    -- На данном этапе нам может быть
    -- известно либо 3 угла либо 1 либо 0.
    elseif abc and bca then
        if ab then
            bc = bc or (ab * math.sin(math.rad(cab))) / math.sin(math.rad(bca))
            ca = ca or (ab * math.sin(math.rad(abc))) / math.sin(math.rad(bca))
        elseif bc then
            ab = ab or (bc * math.sin(math.rad(bca))) / math.sin(math.rad(cab))
            ca = ca or (bc * math.sin(math.rad(abc))) / math.sin(math.rad(cab))
        elseif ca then
            ab = ab or (ab * math.sin(math.rad(bca))) / math.sin(math.rad(abc))
            bc = bc or (bc * math.sin(math.rad(cab))) / math.sin(math.rad(abc))
        end

    -- Известна сторона и угол между ними.
    elseif ab and abc and bc then
        ca = math.sqrt(ab^2 + bc^2 - 2*ab*bc*math.cos(math.rad(abc)))
        bca = math.deg(math.acos((ca^2 + bc^2 - ab^2) / (2*ca*bc)))
        cab = 180 - abc - bca
    elseif bc and bca and ca then
        ab = math.sqrt(bc^2 + ca^2 - 2*bc*ca*math.cos(math.rad(bca)))
        cab = math.deg(math.acos((ab^2 + ca^2 - bc^2) / (2*ab*ca)))
        abc = 180 - bca - cab
    elseif ca and cab and ab then
        bc = math.sqrt(ca^2 + ab^2 - 2*ca*ab*math.cos(math.rad(cab)))
        abc = math.deg(math.acos((bc^2 + ab^2 - ca^2) / (2*bc*ab)))
        bca = 180 - cab - abc
    end

    -- Решить получилось?
    if ab and abc and bc and bca and ca and cab then
        -- Есть две и только две вершины с координатами.
        -- Находим координаты третьей вершины.
        if not abc_crds or bca_crds or cab_crds then
            if abc_crds and bca_crds then
                print"123"
                local azimuth = calc.point_direction(abc_crds, bca_crds) + abc
                cab_crds = {calc.polartocartesian(abc_crds, azimuth, ab)}
            elseif bca_crds and cab_crds then
                local azimuth = calc.point_direction(bca_crds, cab_crds) + bca
                abc_crds = {calc.polartocartesian(bca_crds, azimuth, bc)}
            elseif cab_crds and abc_crds then
                print"!@#$"
                local azimuth = calc.point_direction(cab_crds, abc_crds) + cab
                bca_crds = {calc.polartocartesian(cab_crds, azimuth, ca)}
            end
        end

        abc_crds = abc_crds or {}
        bca_crds = bca_crds or {}
        cab_crds = cab_crds or {}

        return ab, abc, bc, bca, ca, cab,
            abc_crds[1], abc_crds[2], bca_crds[1], bca_crds[2], cab_crds[1], cab_crds[2]
    end
end

--print(calc.triangle(3, nil, 4, nil, 5, nil))

--print(math.sin(math.deg(60)))
print(table.concat({
            calc.triangle(nil, 36.869897645844, 5, nil, nil, nil, {0, 0}, {0, 4})
            }, "\n"))


function SSA(ab, bc, abc)
    -- Проверяем, существует ли решение
    if bc < ab * math.sin(abc) then
        return "Решение не существует"
    elseif bc == ab * math.sin(abc) then
        -- Угол B является прямым (90 градусов)
        B = math.pi / 2
        C = math.pi - abc - B
        ca = ab * math.sin(C) / math.sin(abc)
        return "Решение однозначно: ca = " .. ca .. ", вершина cab = " .. math.deg(C)
    else
        -- Существует два возможных значения угла B
        local sin_B = bc * math.sin(abc) / ab
        B1 = math.asin(sin_B)
        B2 = math.pi - B1
        C1 = math.pi - abc - B1
        C2 = math.pi - abc - B2
        ca1 = ab * math.sin(C1) / math.sin(abc)
        ca2 = ab * math.sin(C2) / math.sin(abc)
        return "Решение имеет два возможных значения: ca1 = " .. ca1 ..
        ", вершина cab1 = " .. math.deg(C1) .. ", ca2 = " .. ca2 .. ", вершина cab2 = " .. math.deg(C2)
    end
end

print(SSA(3, 4, 30))


-- result_arr_sorted = pool_size(arr, distance)
-- arr - массив координат, где arr[i][1] и arr[i][2] x и y координаты.
-- т.е. принимает в формате результата работы findimage/findcolor
-- distance - дистанция которая считается единым объектом.
--
-- Вернет массив в котором у каждого элемента будут дополнительные поля:
-- pool_size содержащие количество объектов в группе для каждой точки,
-- массив будет отсортирован в порядке убывания result[1] - будет соответственно
-- содержать самый крупный объект.
-- pool_x - x координата середины группы объектов
-- pool_y - y координата середины группы объектов

-- Внимание! Исходный массив так же будет модифицирован!
-- В него будут добавлены поля, но порядок изменен не будет.
-- Массив с результатом просто набор ссылок на исходные вложенные таблицы.
local function pool_size(arr, distance)
    -- copy array
    local result = {}
    for i = 1, #arr do
        result[i] = arr[i]
    end

    -- add pool_size for each point
    for i = 1, #result do
        result[i].pool_size = 0
        result[i].pool_x = 0
        result[i].pool_y = 0
        for j = 1, #result do
            if ((result[i][1]-result[j][1])^2 + (result[i][2]-result[j][2])^2)^0.5 <= distance then
                result[i].pool_size = result[i].pool_size + 1
                result[i].pool_x = result[i].pool_x + result[j][1]
                result[i].pool_y = result[i].pool_y + result[j][2]
            end
        end
        result[i].pool_x = math.floor(result[i].pool_x / result[i].pool_size + 0.5)
        result[i].pool_y = math.floor(result[i].pool_y / result[i].pool_size + 0.5)
    end

    table.sort(result, function(a, b) return a.pool_size > b.pool_size end)
    return result
end

local arr = {{1, 1}, {1, 2}, {2, 2}, {3, 3}}

local arr_p = pool_size(arr, 1)






















































