--lua
-- hint version 0.9.3
--[==[
    local hint = require[[hint]]
    hint_obj = hint(ваш_конфиг) -- вывести сообщение. Описание cfg{} ниже. Вернет hint_obj.
    hint_obj = hint("текст")    -- упрощенный вызов hint({text="текст"}). Вернет hint_obj.
    hint_obj = hint.hide()      -- скрыть сообщение. Вернет hint_obj.
    hint.destroy()              -- уничтожить поток с сообщением.
    Окно можно таскать мышкой, повторые вызовы будут в тех же координатах, куда вы поместили окно.
    При нажатии правой кнопкой мыши - позиция будет восстановлена на указанную в cfg.

    local cfg = {}               -- таблица с параметрами окна, сообщения. Все параметры являются опциональными,
                                 -- если они не будут указаны, то будут загружены значения по умолчанию.
    cfg.text = "0a123456789abcT" -- текст сообщения
    cfg.font = "Arial"           -- название шрифта который будет использован.
    cfg.font_size = 36           -- размер шрифта
    cfg.font_color = 0xcc6020    -- цвет шрифта
    cfg.font_alpha = 255         -- прозрачность шрифта
    cfg.bold = 700               -- насколько жирным делать шрифт. Стандартно 100-900 с шагом 100.
    cfg.anchor = "bottom_left"   -- якорь от которого считать pox_x, pos_y. Размер окна может быть разным
                                 -- из-за разного текста, и если мы хотим, например, видеть окно в
                                 -- правом нижнем углу, то мы можем задать, что окно должно "заканчиваться"
                                 -- в этих координатах, а не начинаться.
                                 -- top_left/top_right/bottom_left/bottom_right.
    cfg.align_h = "right"        -- выравнить текст по горизонтали. left/right/center
    cfg.align_v = "center"       -- выровнить текст по вертикали. top/bottom/center
    cfg.pos_x = 300              -- позиция на экране x
    cfg.pos_y = 300              -- позиция на экране y
    cfg.width = 0                -- ширина. 0 - подгонит под размер текста
    cfg.height = 50              -- высота. 0 - подгонит под размер текста
    cfg.border_h = 0.15          -- размер горизонтального поля. При >-1 и <1 создаст поле пропорционально шрифту.
                                 -- При значениях больше - поле в пикселях
    cfg.border_v = -5            -- размер вертикального поля. При >-1 и <1 создаст поле пропорционально шрифту.
                                 -- При значениях больше - поле в пикселях
    cfg.bg_color = 0x40A65C      -- цвет фона
    cfg.bg_alpha = 220           -- прозрачность фона
    cfg.sticky = 20              -- Расстояние на котором прилеплять окно к краю экрана при перемещении мышкой.
    cfg.timeout = 1000           -- время жизни окна в мс (1000 = 1 сек).

    hint поддерживает вывод нескольких сообщений одновременно.
    Для дальнейшего понимания его работы необходимо немного углубиться в его структуру:
    hint - это массив с объектами которые выводят сообщения.
    Каждый объект является независимым от других и запущен в отдельном потоке.
    Каждый из этих объектов имеет методы: hint(), hide(), destroy().
    По умолчанию во время запуска созадется объект default и добавляет несколько ссылок для упрощенного вызова.
    hint()         - это hint.default() -> hint.default.hint()
    hint.default() - это hint.default.hint()
    hint.hide()    - это hint.default.hide()
    hint.destroy() - это hint.default.destroy()
    local hint_obj = hint.default.hint()
    hint_obj       - это hint.default
    -- соответственно вызов:
    local hint_obj = hint.name()
    -- создаст:
    hint_obj           = hint.name
    hint_obj()         = hint.name()
    hint_obj.hint()    = hint.name.hint()
    hint_obj.hide()    = hint.name.hide()
    hint_obj.destroy() = hint.name.destroy()

    Для вызова еще одного окна одновременно достаточно вызвать:
    local second_hint = hint.name(ваш_конфиг)
    Вместо "name" укажите любое незанятое имя (default, hide, destroy заняты сразу после старта).
]==]


local ffi = require 'ffi'
local C = ffi.C
local user32   = ffi.load("user32")

-- Структура для передачи конфига.
ffi.cdef[[
        typedef          int   BOOL    ;
        typedef unsigned int   DWORD   ;
        typedef unsigned char  BYTE    ;
        typedef const    char* LPCSTR  ;
        typedef          DWORD COLORREF;
]]
pcall(ffi.cdef, [[
        typedef struct   {
            const char*   text         ;
            int           text_len     ;
            LPCSTR        font         ;
            int           font_size    ;
            COLORREF      font_color   ;
            BYTE          font_alpha   ;
            int           bold         ;
            const char*   anchor       ;
            unsigned int  align_h      ;
            unsigned int  align_v      ;
            int           pos_x        ;
            int           pos_y        ;
            int           width        ;
            int           height       ;
            double        border_h     ;
            double        border_v     ;
            DWORD         bg_color     ;
            BYTE          bg_alpha     ;
            int           sticky       ;
            int           timeout      ;

            // Кусок для синхронизации потоков.
            BOOL    window_cfg_request ; // Запрос на использование конфига хинтом.
            BOOL    parent_cfg_answer  ; // Разрешение основного потока на использование конфига.
            BOOL    parent_cfg_request ; // Запрос разрешения на обновление конфига.
            BOOL    window_cfg_answer  ; // Разрешение на обновление конфига для основного потока.
            char    class_suffix[17]   ; // Итератор имен классов окон.
        } cfg;
]])
-- Убийство классов окон для destroy
ffi.cdef[[
        typedef          int   BOOL    ;
        typedef char CHAR;
        typedef const CHAR *LPCSTR; // must be "__nullterminated", "CONST"
        typedef void *PVOID;
        typedef PVOID HANDLE;
        typedef HANDLE HINSTANCE;
        BOOL UnregisterClassA(
            LPCSTR    lpClassName,
            HINSTANCE hInstance
        );
]]

---------------------------
----------ПОТОКИ-----------
----------НАЧАЛО-----------
---------------------------

pcall(ffi.cdef, [[
    typedef struct lua_State lua_State;
]])
ffi.cdef[[
    lua_State *luaL_newstate(void);
    void luaL_openlibs(lua_State *L);
    int luaL_loadbuffer(lua_State *L, const char *buff, size_t sz, const char *name);
    int lua_pcall(lua_State *L, int nargs, int nresults, int errfunc);
    const char *lua_tolstring(lua_State *L, int idx, size_t *len);
    unsigned long long int strtoull(const char* str, char** endptr, int base);
    void lua_close (lua_State *L);

    typedef int BOOL;
    typedef void* HANDLE;
    typedef void* LPVOID;
    typedef unsigned int DWORD;
    typedef int (__stdcall *THREAD_START_ROUTINE)(LPVOID lpThreadParameter);
    HANDLE __stdcall CreateThread(
        void* lpThreadAttributes,
        size_t dwStackSize,
        THREAD_START_ROUTINE lpStartAddress,
        LPVOID lpParameter,
        DWORD dwCreationFlags,
        DWORD* lpThreadId
    );
    BOOL __stdcall CloseHandle(
        HANDLE hObject
    );
    void Sleep(unsigned int dwMilliseconds);
]]

local kernel32 = ffi.load("kernel32")

-- Входящие данные подразумеваются, как
-- 32 битный или 64 битный указатель,
-- т.е. вида:
-- 0x12345678 либо 0x123456789abcdef
-- префикс 0x не удалять!
-- Основная задача данного кода -
-- хранение полученных указателей.
-- Встроенный tonumber невозможно
-- корректно использовать, т.к.
-- он возвращает double и произойдет
-- потеря точности при получении x64.
-- Подключать msvcrt ради _strtoui64
-- имхо перебор, а пачка вызовов
-- tonumber существенно медленнее.
local char_arr_to_int64 = function(str)end
do
    ffi.cdef[[
        typedef unsigned int size_t;
        size_t strlen(const char *s);
    ]]
    local char_values = {
         [48] = 0x0,  -- Значение символа '0'
         [49] = 0x1,  -- Значение символа '1'
         [50] = 0x2,  -- Значение символа '2'
         [51] = 0x3,  -- Значение символа '3'
         [52] = 0x4,  -- Значение символа '4'
         [53] = 0x5,  -- Значение символа '5'
         [54] = 0x6,  -- Значение символа '6'
         [55] = 0x7,  -- Значение символа '7'
         [56] = 0x8,  -- Значение символа '8'
         [57] = 0x9,  -- Значение символа '9'
         [65] = 0xA,  -- Значение символа 'A'
         [66] = 0xB,  -- Значение символа 'B'
         [67] = 0xC,  -- Значение символа 'C'
         [68] = 0xD,  -- Значение символа 'D'
         [69] = 0xE,  -- Значение символа 'E'
         [70] = 0xF,  -- Значение символа 'F'
         [97] = 0xA,  -- Значение символа 'a'
         [98] = 0xB,  -- Значение символа 'b'
         [99] = 0xC,  -- Значение символа 'c'
        [100] = 0xD,  -- Значение символа 'd'
        [101] = 0xE,  -- Значение символа 'e'
        [102] = 0xF,  -- Значение символа 'f'
    }
    char_arr_to_int64 = function(str)
        local len = C.strlen(str)
        local char_array = ffi.new("unsigned char[8]")

        -- 18 символов (64 бита)
        if len == 18 then
            for i = 0, 7 do
                char_array[i] = char_values[str[16-i*2]]*0x10 +
                                char_values[str[17-i*2]]
            end
        else -- 32 бита
            for i = 0, 3 do
                char_array[i] = char_values[str[8-i*2]]*0x10 +
                                char_values[str[9-i*2]]
            end
        end

        -- Получаем 64-битное целое число из массива unsigned char
        local ptr_uint64_t = ffi.cast("unsigned long long*", char_array)

        return ptr_uint64_t[0]
    end
end

local func_to_new_thread_and_state = function(f, p_opt)end
do
    local init = string.dump(
        function(f)
            local ffi = require "ffi"
            ffi.cdef[[
                typedef void* LPVOID;
                typedef int (__stdcall *THREAD_START_ROUTINE)(LPVOID lpThreadParameter);
            ]]
            f = tostring(ffi.cast("THREAD_START_ROUTINE", f)):gsub("^.-0x", "0x", 1)
            return f
        end
    )

    func_to_new_thread_and_state = function(f, p_opt)
        local lua_state = C.luaL_newstate()
        C.luaL_openlibs(lua_state)

        -- Передача функции возможна только в виде дампа.
        if type(f) == "function" then
            f = string.dump(f)
        end

        C.luaL_loadbuffer(lua_state, init, #init, "=init")
        C.luaL_loadbuffer(lua_state, f, #f, "=f")
        C.lua_pcall(lua_state, 1, 1, 0)

        local raw = C.lua_tolstring(lua_state, -1, nil)
        local pllu = char_arr_to_int64(raw)

        f = ffi.cast("THREAD_START_ROUTINE", pllu)

        local threadId = ffi.new("DWORD[1]")
        local threadHandle = kernel32.CreateThread(nil, 0, f, ffi.cast("LPVOID", p_opt), 0, threadId)

        return lua_state, f, threadId[0], threadHandle
    end
end

---------------------------
----------ПОТОКИ-----------
----------КОНЕЦ------------
---------------------------



-- основная функция
local hint = function(data_pointer)
    local ffi = require 'ffi'
    local C = ffi.C

    pcall(ffi.cdef, [[
        typedef struct lua_State lua_State;
    ]])
    ffi.cdef[[
        lua_State *luaL_newstate();
        void Sleep(unsigned int dwMilliseconds);
        void luaL_openlibs(lua_State *L);
        int luaL_loadstring (lua_State *L, const char *s);
        void lua_call (lua_State *L, int nargs, int nresults);


        typedef void* HANDLE;
        typedef void* hwnd;
        typedef void* HINSTANCE;
        typedef unsigned int UINT;
        typedef int BOOL;
        typedef const char* LPCSTR;
        typedef long LONG;
        typedef unsigned int DWORD;
        typedef unsigned long long UINT_PTR;
        typedef void* LPVOID;
        typedef void* HMODULE;
        typedef int (__stdcall *THREAD_START_ROUTINE)(LPVOID lpThreadParameter);
        typedef UINT_PTR (__stdcall *TIMERPROC)(hwnd, UINT, UINT_PTR, DWORD);
        typedef unsigned int WPARAM;
        typedef long LPARAM;
        typedef void* HFONT;

        hwnd __stdcall CreateWindowExA(
            LONG     dwExStyle,
            LPCSTR   lpClassName,
            LPCSTR   lpWindowName,
            LONG     dwStyle,
            int      x,
            int      y,
            int      nWidth,
            int      nHeight,
            hwnd     hwndParent,
            void*    hMenu,
            HINSTANCE hInstance,
            void*    lpParam
        );

        BOOL __stdcall ShowWindow(
            hwnd hwnd,
            int  nCmdShow
        );

        BOOL __stdcall UpdateWindow(
            hwnd hwnd
        );

        int __stdcall MessageBoxTimeoutA(
            hwnd    hwnd,
            LPCSTR  lpText,
            LPCSTR  lpCaption,
            UINT    uType,
            UINT    wLanguageId,
            UINT    dwMilliseconds
        );

        BOOL __stdcall DestroyWindow(
            hwnd hwnd
        );

        DWORD __stdcall GetCurrentThreadId();

        HMODULE __stdcall GetModuleHandleA(
            LPCSTR lpModuleName
        );

        HANDLE __stdcall CreateThread(
            void* lpThreadAttributes,
            size_t dwStackSize,
            THREAD_START_ROUTINE lpStartAddress,
            LPVOID lpParameter,
            DWORD dwCreationFlags,
            DWORD* lpThreadId
        );

        BOOL __stdcall CloseHandle(
            HANDLE hObject
        );

        UINT_PTR __stdcall SetTimer(
            hwnd      hwnd,
            UINT_PTR  nIDEvent,
            UINT      uElapse,
            TIMERPROC lpTimerFunc
        );

        BOOL __stdcall KillTimer(
            hwnd     hwnd,
            UINT_PTR uIDEvent
        );
    ]]
    pcall(ffi.cdef, [[
        typedef struct {
            int x;
            int y;
        } POINT;
    ]])
    pcall(ffi.cdef, [[
        typedef struct {
            hwnd       hwnd;
            UINT       message;
            uintptr_t  wParam;
            intptr_t   lParam;
            DWORD      time;
            POINT      pt;
        } MSG;
    ]])
    ffi.cdef[[
        typedef intptr_t LRESULT;
    ]]
    pcall(ffi.cdef, [[
        typedef struct {
            uint32_t size;
            uint32_t pos_x;
            uint32_t pos_y;
            uint32_t width;
            uint32_t height;
            uint32_t timeout;
            const char* text;
        } HintStruct;
    ]])
    ffi.cdef[[
        BOOL __stdcall GetMessageA(
            MSG* lpMsg,
            hwnd hwnd,
            UINT wMsgFilterMin,
            UINT wMsgFilterMax
        );

        BOOL __stdcall TranslateMessage(
            const MSG* lpMsg
        );

        LRESULT __stdcall DispatchMessageA(
            const MSG* lpMsg
        );

        int __stdcall SendMessageA(
            hwnd   hwnd,
            UINT   Msg,
            WPARAM wParam,
            LPARAM lParam
        );

        HFONT __stdcall CreateFontA(
            int     nHeight,
            int     nWidth,
            int     nEscapement,
            int     nOrientation,
            int     fnWeight,
            unsigned long fdwItalic,
            unsigned long fdwUnderline,
            unsigned long fdwStrikeOut,
            unsigned long fdwCharSet,
            unsigned long fdwOutputPrecision,
            unsigned long fdwClipPrecision,
            unsigned long fdwQuality,
            unsigned long fdwPitchAndFamily,
            LPCSTR  lpszFace
        );

        void Sleep(unsigned int dwMilliseconds);

        static const int WM_SETFONT = 0x0030;
        ]]
    pcall(ffi.cdef, [[
        typedef struct lua_State lua_State;
    ]])
    ffi.cdef[[
        lua_State *luaL_newstate();
        void Sleep(unsigned int dwMilliseconds);
        void luaL_openlibs(lua_State *L);
        void lua_call (lua_State *L, int nargs, int nresults);
        typedef int (*lua_CFunction)(lua_State *L);
        void lua_pushcclosure (lua_State *L, lua_CFunction fn, int n);

        typedef DWORD COLORREF;
        typedef DWORD* LPCOLORREF;
        typedef HANDLE HDC;
        COLORREF SetTextColor(
          HDC      hdc,
          COLORREF color
        );
        typedef void * HDC;
        HDC GetDC(void * hwnd);
    ]]
    pcall(ffi.cdef, [[
        typedef struct {
            long lfHeight;
            long lfWidth;
            long lfEscapement;
            long lfOrientation;
            long lfWeight;
            unsigned char lfItalic;
            unsigned char lfUnderline;
            unsigned char lfStrikeOut;
            unsigned char lfCharSet;
            unsigned char lfOutPrecision;
            unsigned char lfClipPrecision;
            unsigned char lfQuality;
            unsigned char lfPitchAndFamily;
            char lfFaceName[32];
        } LOGFONTA;
    ]])
    ffi.cdef[[
        int GetObjectA(HANDLE h, int c, LOGFONTA* lf);
        HANDLE SelectObject(void* hdc, HANDLE h);
        int SetBkMode(HANDLE hdc, int mode);
        void TextOutA(void* hdc, int nXStart, int nYStart, const char* lpString, int cbString);
        HANDLE GetDC(HANDLE hwnd);
        int ReleaseDC(HANDLE hwnd, HANDLE hdc);
        typedef void* HANDLE;
        typedef void* HDC;
        ]]
    pcall(ffi.cdef, [[
        typedef struct { int left, top, right, bottom; } RECT, *LPRECT;
    ]])
    ffi.cdef[[
        int DrawTextA(HDC hdc, const char* lpchText, int cchText, RECT* lprc, unsigned int format);
        int DrawTextW(HDC hdc, const wchar_t* lpchText, int cchText, RECT* lprc, unsigned int format);
        HFONT SelectObject(HDC hdc, HFONT hFont);
        typedef void* HBRUSH;
        typedef int INT;
        HBRUSH CreateSolidBrush(DWORD color);
        BOOL DeleteObject(HANDLE hObject);
        BOOL FillRect(HDC hDC, const RECT *lprc, HBRUSH hbr);
        BOOL ExtTextOutA(HDC hdc, INT X, INT Y, DWORD fuOptions, const RECT* lprc, const char* lpString, UINT cbCount, const INT* lpDx);

        BOOL PatBlt(HDC hdc, INT x, INT y, INT w, INT h, DWORD rop);
        BOOL ExtTextOutA(HDC hdc, INT X, INT Y, DWORD fuOptions, const RECT* lprc, const char* lpString, UINT cbCount, const INT* lpDx);
        BOOL ValidateRect(hwnd hwnd, const RECT* lpRect);
        BOOL GetWindowRect(hwnd hwnd, RECT* lpRect);
        hwnd GetForegroundWindow();
        typedef uint16_t ATOM;
        ATOM RegisterClassA(const void *lpWndClass);
        typedef LRESULT(__stdcall* WNDPROC)(hwnd, UINT, WPARAM, LPARAM);
        typedef unsigned char BYTE;
    ]]
    pcall(ffi.cdef, [[
        typedef struct {
            UINT        style;
            WNDPROC     lpfnWndProc;
            int         cbClsExtra;
            int         cbWndExtra;
            HINSTANCE   hInstance;
            HANDLE      hIcon;
            HANDLE      hCursor;
            HANDLE      hbrBackground;
            LPCSTR      lpszMenuName;
            LPCSTR      lpszClassName;
        } WNDCLASSA, *LPWNDCLASSEXA;
    ]])
    ffi.cdef[[
        BOOL GetClassInfoExA(
            HINSTANCE     hInstance,
            LPCSTR        lpszClass,
            LPWNDCLASSEXA lpwcx
        );
        BOOL UnregisterClassA(
            LPCSTR    lpClassName,
            HINSTANCE hInstance
        );
        LRESULT __stdcall DefWindowProcA(hwnd hwnd, UINT Msg, WPARAM wParam, LPARAM lParam);
        BOOL GetClientRect(hwnd hwnd, RECT* lpRect);
        BOOL InvalidateRect(hwnd hwnd, const RECT* lpRect, BOOL bErase);
    ]]
    pcall(ffi.cdef, [[
        typedef struct {
            HDC     hdc;
            BOOL    fErase;
            RECT    rcPaint;
            BOOL    fRestore;
            BOOL    fIncUpdate;
            BYTE    rgbReserved[32];
        } PAINTSTRUCT;
    ]])
    ffi.cdef[[
        HDC BeginPaint(hwnd hwnd, PAINTSTRUCT *lpPaint);
        HANDLE GetStockObject(int fnObject);
        BOOL EndPaint(hwnd hwnd, const PAINTSTRUCT *lpPaint);

        int InvalidateRect(hwnd hwnd, const RECT* lpRect, int bErase);
        int ValidateRect(hwnd hwnd, const RECT* lpRect);
        int RedrawWindow(hwnd hwnd, const RECT* lprcUpdate, void* hrgnUpdate, unsigned int flags);

        typedef void* HWND;
        BOOL SetWindowPos(
            HWND hWnd,
            HWND hWndInsertAfter,
            int X,
            int Y,
            int cx,
            int cy,
            UINT uFlags
        );
    ]]
    pcall(ffi.cdef, [[
        typedef struct {
            int cx;
            int cy;
        } SIZE;
    ]])
    ffi.cdef[[
        typedef SIZE* LPSIZE;
        BOOL GetTextExtentPoint32A(
          HDC    hdc,
          LPCSTR lpString,
          int    cbString,
          LPSIZE lpSize
        );

        BOOL PeekMessageA(MSG *lpMsg, HWND hWnd, UINT wMsgFilterMin, UINT wMsgFilterMax, UINT wRemoveMsg);

        BOOL GetClientRect(
          HWND   hWnd,  // Дескриптор окна
          LPRECT lpRect // Указатель на структуру RECT, в которую будут записаны размеры клиентской области
        );

        typedef uintptr_t ULONG_PTR;
    ]]
    pcall(ffi.cdef, [[
        typedef struct tagLOGBRUSH {
          UINT      lbStyle;
          COLORREF  lbColor;
          ULONG_PTR lbHatch;
        } LOGBRUSH, *PLOGBRUSH, *NPLOGBRUSH, *LPLOGBRUSH;
    ]])
    ffi.cdef[[
        void* CreateBrushIndirect(const LOGBRUSH *lplb);

        BOOL SetLayeredWindowAttributes(HWND hwnd, DWORD crKey, BYTE bAlpha, DWORD dwFlags);
    ]]
    pcall(ffi.cdef, [[
        typedef struct tagPOINT {
            int x;
            int y;
        } POINT;
    ]])
    ffi.cdef[[
        BOOL GetCursorPos(POINT *lpPoint);




        typedef void* HMONITOR;
        typedef unsigned long DWORD;
        typedef int BOOL;
        typedef void* HDC;
        typedef intptr_t LPARAM;

        typedef int (__stdcall *MONITORENUMPROC)(HMONITOR, HDC, RECT*, LPARAM);
    ]]
    pcall(ffi.cdef, [[
        typedef struct {
            int     cbSize;
            RECT    rcMonitor;
            RECT    rcWork;
            DWORD   dwFlags;
        } MONITORINFO;
    ]])
    pcall(ffi.cdef, [[
        typedef struct {
            DWORD   cbSize;
            RECT    rcMonitor;
            RECT    rcWork;
            DWORD   dwFlags;
        } MONITORINFOEX;
    ]])
    ffi.cdef[[
        typedef BOOL(__stdcall *GetMonitorInfoFunc)(HMONITOR, MONITORINFO*);
        typedef BOOL(__stdcall *GetMonitorInfoExFunc)(HMONITOR, MONITORINFOEX*);

        typedef const RECT* LPCRECT;
        typedef HMONITOR(__stdcall *EnumDisplayMonitorsFunc)(HDC, LPCRECT, MONITORENUMPROC, LPARAM);

        BOOL EnumDisplayMonitors(HDC hdc, const RECT* lprcClip, MONITORENUMPROC lpfnEnum, LPARAM dwData);

        int GetSystemMetrics(int nIndex);
        void* GetProcAddress(void* hModule, const char* lpProcName);
        void* GetModuleHandleA(const char* lpModuleName);
        int ReleaseDC(HWND hWnd, HDC hDC);

        typedef void* HMONITOR;
        typedef int BOOL;
        typedef void* HDC;
        typedef intptr_t LPARAM;
    ]]
    pcall(ffi.cdef, [[
        typedef struct {
            int left;
            int top;
            int right;
            int bottom;
        } RECT;
    ]])
    ffi.cdef[[
        typedef int (__stdcall *MONITORENUMPROC)(HMONITOR, HDC, RECT*, LPARAM);
        BOOL EnumDisplayMonitors(HDC hdc, const RECT* lprcClip, MONITORENUMPROC lpfnEnum, LPARAM dwData);
        HDC GetDC(void * hwnd);
        BOOL GetCursorPos(POINT *lpPoint);
        void Sleep(unsigned int dwMilliseconds);
        BOOL MoveWindow(void* hWnd, int X, int Y, int nWidth, int nHeight, BOOL bRepaint);
        int SetBkColor(void *hdc, unsigned long color);
        int SetForegroundWindow(HWND hWnd);


        typedef unsigned int   DWORD;
        typedef unsigned char  BYTE;
        typedef const    char* LPCSTR;
        typedef          DWORD COLORREF;
    ]]
    pcall(ffi.cdef, [[
        typedef struct   {
            const char*   text       ;
            int           text_len   ;
            LPCSTR        font       ;
            int           font_size  ;
            COLORREF      font_color ;
            BYTE          font_alpha ;
            int           bold       ;
            const char*   anchor     ;
            unsigned int  align_h    ;
            unsigned int  align_v    ;
            int           pos_x      ;
            int           pos_y      ;
            int           width      ;
            int           height     ;
            double        border_h   ;
            double        border_v   ;
            DWORD         bg_color   ;
            BYTE          bg_alpha   ;
            int           sticky     ;
            int           timeout    ;

            // Кусок для синхронизации потоков.
            BOOL  window_cfg_request ; // Запрос на использование конфига хинтом.
            BOOL  parent_cfg_answer  ; // Разрешение основного потока на использование конфига.
            BOOL  parent_cfg_request ; // Запрос разрешения на обновление конфига.
            BOOL  window_cfg_answer  ; // Разрешение на обновление конфига для основного потока.
            char    class_suffix[17]   ; // Итератор имен классов окон.
        } cfg;
    ]])
    ffi.cdef[[
        void ExitThread(
            DWORD dwExitCode
        );
    ]]

    local user32   = ffi.load("user32")
    local kernel32 = ffi.load("kernel32")
    local gdi32    = ffi.load("Gdi32.dll")

    local WM_SETCURSOR      = 32
    local DEFAULT_CHARSET   = -1
    local CLEARTYPE_QUALITY = 5
    local NONANTIALIASED_QUALITY = 0x3
    local WS_EX_NOACTIVATE  = 0x08000000
    local WS_EX_TOPMOST     = 0x00000008
    local WS_POPUP          = 0x80000000
    local WS_EX_TOOLWINDOW  = 0x00000080
    local SWP_NOMOVE        = 0x0002
    local WS_EX_TRANSPARENT = 0x00000020
    local SW_HIDE           = 0
    local SW_SHOW           = 5
    local PM_REMOVE         = 0x0001
    local LWA_ALPHA         = 0x00000002
    local WS_EX_LAYERED     = 0x00080000
    local SWP_NOACTIVATE    = 0x0010
    local SWP_NOREDRAW      = 0x0008
    local WM_MOUSEMOVE      = 0x0200
    local WM_PAINT          = 0x000F
    local WM_CLOSE          = 0x0010
    local LWA_COLORKEY      = 0x00000001
    local ALIGN             = {
                                left     = 0x0000,
                                center_h = 0x0001,
                                right    = 0x0002,
                                top      = 0x0000,
                                center_v = 0x0004,
                                bottom   = 0x0008,
                              }
    local window            = nil
    local bg                = nil


    local manual_update = function(hwnd) end
    local move_window   = function(hwnd, lparam, wparam) end -- 512 move
    local left_down     = function(hwnd, lparam, wparam) end -- 513 left_down
    local left_up       = function(hwnd, lparam, wparam) end -- 514 left_up
    local right_down    = function(hwnd, lparam, wparam) end -- 516 left_down
    local right_up      = function(hwnd, lparam, wparam) end -- 517 left_up
    local move_enabled  = false
    local cfg           = ffi.new("cfg*", data_pointer)[0]
    do
        local override_x   = false
        local override_y   = false
        local real_x       = nil
        local real_y       = nil
        local rect         = ffi.new("RECT")
        local point        = ffi.new("POINT")


        local stick_calc = function(rect, threshold) end
        do
            local monitor = {}
            local enumMonitorCallback = function(hMonitor, hdcMonitor, lprcMonitor, dwData)
                -- Правый крайний и нижний крайний пикесль не входят в реальную сетку отображения. Отсчет с 0, 0.
                monitor[#monitor+1] = {left=lprcMonitor.left, top=lprcMonitor.top, right=lprcMonitor.right-1, bottom=lprcMonitor.bottom-1}
                return true -- продолжаем перечисление
            end

            local min_value = function(monitor, rect, field)
                local min = nil
                for i = 1, #monitor do
                    local distance = nil
                    if monitor[i][field] >= rect[field] then
                        distance = monitor[i][field] - rect[field]
                    else
                        distance = rect[field] - monitor[i][field]
                    end
                    if (min == nil or distance < min.distance)
                     -- Принадлежность к монитору. Нам не нужно прилепание по границе монитора на котором нет окна.
                    and (
                            ((field == "left" or field == "right" ) and (   (rect.top    >= monitor[i].top  and rect.top    <= monitor[i].bottom)
                                                                         or (rect.bottom >= monitor[i].top  and rect.bottom <= monitor[i].bottom)))
                            or
                            ((field == "top"  or field == "bottom") and (   (rect.left   >= monitor[i].left and rect.left   <= monitor[i].right)
                                                                         or (rect.right  >= monitor[i].left and rect.right  <= monitor[i].right)))
                        ) then
                        min = {distance=distance, border=monitor[i][field], field=field}
                    end
                end
                return min
            end

            local get_closest_borders = function(monitor, rect)
                local result = {}
                result.left   = min_value(monitor, rect, "left"  )
                result.top    = min_value(monitor, rect, "top"   )
                result.right  = min_value(monitor, rect, "right" )
                result.bottom = min_value(monitor, rect, "bottom")
    --            print(
    --                result.left.distance  , result.left.border,
    --                result.top.distance   , result.top.border,
    --                result.right.distance , result.right.border,
    --                result.bottom.distance, result.bottom.border
    --                )
                return result
            end

            -- Вернет целевые координаты окна, либо nil в полях.
            stick_calc = function(rect, threshold)
                local closest_borders = get_closest_borders(monitor, rect)
                -- У нас только две оси и мы не можем выравнить одновременно верх и низ / лево и право
                local offset  = {}
                local move_to = {}
                if closest_borders.left.distance < closest_borders.right.distance then
                    offset.x        = closest_borders.left.distance
                    offset.border_x = closest_borders.left.border
                else
                    offset.x        = closest_borders.right.distance
                    offset.border_x = closest_borders.right.border - rect.right + rect.left + 1
                end

                if closest_borders.top.distance < closest_borders.bottom.distance then
                    offset.y        = closest_borders.top.distance
                    offset.border_y = closest_borders.top.border
                else
                    offset.y        = closest_borders.bottom.distance
                    offset.border_y = closest_borders.bottom.border - rect.bottom + rect.top + 1
                end
--print(offset.x, offset.y, offset.border_x, offset.border_y)
                -- применяем threshold
                move_to.x = math.abs(offset.x) <= threshold and offset.border_x or nil
                move_to.y = math.abs(offset.y) <= threshold and offset.border_y or nil
                return move_to
            end

            local lpfnEnum = ffi.cast("MONITORENUMPROC", enumMonitorCallback)
            user32.EnumDisplayMonitors(hdc, nil, lpfnEnum, 0)
        end


        manual_update = function(hwnd)               --  15 paint
            if hwnd == bg then return 0 end

            -- Преобразуем размеры полей
            -- Если
            -- 0 < поле <  1
            -- или
            -- 0 > поле > -1
            -- значит нужно рассчитать
            -- относительно размера шрифта.
            -- Допускает отрицательные значения.
            -- Аналогично дипапазон между <0 и >-1.
            -- При cfg.height и cfg.width
            -- не равных нулю (автоподгонка выключена)
            -- поля убираем.
            local border_h = cfg.border_h
            if  cfg.border_h > 0 and cfg.border_h <  1 or
                cfg.border_h < 0 and cfg.border_h > -1 then
                border_h = math.floor(cfg.font_size*cfg.border_h + 0.5)
            end

            local border_v = cfg.border_v
            if  cfg.border_v > 0 and cfg.border_v <  1 or
                cfg.border_v < 0 and cfg.border_v > -1 then
                border_v = math.floor(cfg.font_size*cfg.border_v + 0.5)
            end

            local paintStruct = ffi.new("PAINTSTRUCT")
            local hdc = user32.BeginPaint(hwnd, paintStruct)
            rect = ffi.new("RECT")
            user32.GetClientRect(hwnd, rect)
            user32.FillRect(hdc, rect, C.CreateSolidBrush(0)) -- gdi32.GetStockObject(5) -- NULL_BRUSH

            -- Создаем новый шрифт
            local hFont = C.CreateFontA(cfg.font_size, 0, 0, 0, cfg.bold, 0, 0, 0, DEFAULT_CHARSET, 0, 0, NONANTIALIASED_QUALITY, 0, cfg.font)
            -- Выбираем новый шрифт для использования
            C.SelectObject(hdc, hFont)

            -- Размер статика или подстраивается под текст?
            local text_width  = cfg.width
            local text_height = cfg.height
            local textSize      = nil -- fix убрать если флаги вертикального выравнивания заработают
            if cfg.height == 0 or cfg.width == 0
                -- fix сл. строку убрать если флаги вертикального выравнивания заработают
                or cfg.align_v == ALIGN.center_v or cfg.align_v == ALIGN.bottom
                then
                -- Подстраивается.
                -- Получаем размер текста
                -- fix добавить local перед textSize если флаги вертикального выравнивания заработают
                textSize = ffi.new("SIZE")
                gdi32.GetTextExtentPoint32A(hdc, cfg.text, cfg.text_len, textSize)
                if cfg.width    == 0 then
                    text_width  =    textSize.cx + border_h*2
                end
                if cfg.height   == 0 then
                    text_height =    textSize.cy + border_v*2
                end
            end

            -- Получаем текущую область окна
            -- чтобы не перерисовывать весь рабочий стол.
            local textRect = ffi.new("RECT")
            C.GetClientRect(hwnd, textRect);
            --user32.InvalidateRect(hwnd, textRect, true)

            -- Установка альфа-канала окна
            -- 255 - не прозрачное, 0 - полностью прозрачное
            local windowResult = user32.SetLayeredWindowAttributes(bg  , 0, cfg.bg_alpha  , LWA_ALPHA+LWA_COLORKEY)
                  windowResult = user32.SetLayeredWindowAttributes(hwnd, 0, cfg.font_alpha, LWA_ALPHA+LWA_COLORKEY)

            -- Вычисляем координаты с учетом якоря.
            real_x = cfg.pos_x
            real_y = cfg.pos_y
            if     ffi.string(cfg.anchor) == "top_right" then
                real_x = real_x- text_width
            elseif ffi.string(cfg.anchor) == "bottom_left" then
                real_y = real_y - text_height
            elseif ffi.string(cfg.anchor) == "bottom_right" then
                real_x = real_x - text_width
                real_y = real_y - text_height
            end

            user32.SetWindowPos(bg  , nil,
                                (override_x or real_x),
                                override_y or real_y,
                                text_width, text_height,
                                SWP_NOREDRAW)

            -- Устанавливаем размер окна равный размеру текста
            user32.SetWindowPos(hwnd, nil,
                                override_x or real_x,
                                override_y or real_y,
                                text_width, text_height,
                                SWP_NOREDRAW) -- SWP_NOACTIVATE+

            --local hBrush = gdi32.GetStockObject(5)
            -- Устанавливаем кисть для закраски фона
            --C.SelectObject(hdc, hBrush)
            C.SetBkColor(hdc, 0x990000)
            -- Устанавливаем режим фона в прозрачный
            C.SetBkMode(hdc, 4) -- TRANSPARENT
            -- Устанавливаем цвет текста
            C.SetTextColor(hdc, cfg.font_color)


            -- Костыль для вертикального выравнивания.
            -- флаги почему-то неработают.
                               -- top
            if     cfg.align_v == ALIGN.top then
                -- Прямоугольник, в котором будет отображаться текст
                textRect = ffi.new("RECT", {border_h, border_v, text_width-border_h, text_height})
            elseif cfg.align_v == ALIGN.center_v  then
                -- Прямоугольник, в котором будет отображаться текст
                textRect = ffi.new("RECT", {border_h,
                                            (text_height - textSize.cy)*0.5,
                                            text_width   - border_h,
                                            text_height})
            elseif cfg.align_v == ALIGN.bottom then
                -- Прямоугольник, в котором будет отображаться текст
                textRect = ffi.new("RECT", {border_h,
                                            text_height  - border_v - textSize.cy,
                                            text_width   - border_h,
                                            text_height})
            end

            -- fix расскомменитить если флаги вертикального выравнивания заработают
            --[[local textRect = ffi.new("RECT", {border_h,
                                              border_v,
                                              window_width-border_h,
                                              window_height - border_v})]]

            -- Рисуем текст в прямоугольнике
            -- fix расскомменитить если флаги вертикального выравнивания заработают
            -- user32.DrawTextA(hdc, cfg.text, -1, textRect, cfg.align_h + cfg.align_v)
            user32.DrawTextA(hdc, cfg.text, -1, textRect, cfg.align_h)

            user32.ReleaseDC(hwnd, hdc)
            user32.EndPaint(hwnd, paintStruct)
            user32.ShowWindow(hwnd, SW_SHOW)

            return 0
        end

        move_window = function(hwnd, lparam, wparam) -- 512 move
            if  lparam == 1 then
                local current_point = ffi.new("POINT")
                user32.GetCursorPos   (current_point)

                local rect_new         = ffi.new("RECT")
                rect_new.left   = rect.left     - point.x   + current_point.x
                rect_new.top    = rect.top      - point.y   + current_point.y
                rect_new.right  = rect_new.left - rect.left + rect.right
                rect_new.bottom = rect_new.top  - rect.top  + rect.bottom
                local stick = stick_calc(rect_new, cfg.sticky)
                --lg(stick)

                override_x = stick.x or (rect.left   - point.x + current_point.x)
                override_y = stick.y or (rect.top    - point.y + current_point.y)
                --print""
                --print(current_point.x, current_point.y)
                --print(point.x, point.y)
                --print(rect.left, rect.top, rect.right, rect.bottom)
                user32.MoveWindow(bg  , override_x, override_y, rect.right  - rect.left, rect.bottom - rect.top, 0)
                user32.MoveWindow(hwnd, override_x, override_y, rect.right  - rect.left, rect.bottom - rect.top, 0)
                --user32.SetWindowPos(hwnd, nil, override_x,
                --                               override_y,
                --                               rect.right  - rect.left,
                --                               rect.bottom - rect.top,
                --                               SWP_NOACTIVATE+SWP_NOREDRAW+0x2000+0x0001)--)
                --C.Sleep(1000)
            else
                move_enabled = false
            end
        end


        left_down   = function(hwnd, wparam, lparam) -- 513 left_down
            if not move_enabled then
                user32.GetWindowRect(hwnd, rect)
                user32.GetCursorPos (point)
                move_enabled = true
            end
            user32.SetForegroundWindow(window)
        end


        left_up     = function(hwnd, lparam, wparam) -- 514 left_up
            if  move_enabled then
                move_enabled = false
            end
        end


        right_down  = function(hwnd, lparam, wparam) -- 516 right_down
            user32.MoveWindow(bg    , real_x,
                                      real_y,
                                      rect.right  - rect.left,
                                      rect.bottom - rect.top,
                                      0)--+SWP_NOREDRAW)
            user32.MoveWindow(window, real_x,
                                      real_y,
                                      rect.right  - rect.left,
                                      rect.bottom - rect.top,
                                      0)--+SWP_NOREDRAW)
            user32.SetForegroundWindow(window)
            override_x = false
            override_y = false
        end


        right_up    = function(hwnd, lparam, wparam) -- 517 right_up

        end

    end

    local WndProc = function(hwnd, msg, wparam, lparam)
        --print"ZZZZZZZZZZZZZ"

        --print("WndProc hwnd: ".. tostring(hwnd), msg)
        if msg == WM_PAINT then -- WM_PAINT
            manual_update(hwnd)
    --    elseif msg == 0x0010 then -- WM_CLOSE
    --        user32.DestroyWindow(hwnd)
    --    elseif msg == 0x0011 then -- WM_DESTROY
    --        kernel32.ExitProcess(0)
        elseif msg == 0x0005 then -- WM_SIZE
            -- Сообщить о недействительности всей клиентской области для перерисовки
            --user32.InvalidateRect(hwnd, nil, true)
        elseif msg == 0x0200 then -- мышь. 512 событие move
            move_window(hwnd, wparam, lparam)
        elseif msg == 0x0201 then -- мышь. 513 событие left_down
            left_down  (hwnd, wparam, lparam)
        elseif msg == 0x0202 then -- мышь. 514 событие left_up
            left_up    (hwnd, wparam, lparam)
        elseif msg == 0x0204 then -- мышь. 516 событие right_down
            right_down (hwnd, wparam, lparam)
        elseif msg == 0x0205 then -- мышь. 517 событие right_up
            right_up   (hwnd, wparam, lparam)
        else
            return user32.DefWindowProcA(hwnd, msg, wparam, lparam)
        end
        return 0
    end

    local WndProc_bg = function(hwnd, msg, wparam, lparam)
        --print("WndProc hwnd: ".. tostring(hwnd), msg)
        if msg == WM_PAINT then -- WM_PAINT
            local paintStruct = ffi.new("PAINTSTRUCT")

            local hdc = user32.BeginPaint(hwnd, paintStruct)
            -- Для меня осталось загадкой
            -- что за hdc возвращает BeginPaint.
            -- При его использовании покраска не работает.
            hdc = C.GetDC(hwnd)
            local rect = ffi.new("RECT")
            user32.GetClientRect(hwnd, rect)
            local brush = C.CreateSolidBrush(cfg.bg_color)
            local r = user32.FillRect(hdc, rect, brush)
            user32.ReleaseDC(hwnd, hdc)
            user32.EndPaint(hwnd, paintStruct)
            user32.ShowWindow(hwnd, SW_SHOW)
        elseif msg == 0x0200 then -- мышь. 512 событие move
            move_window(hwnd, wparam, lparam)
        elseif msg == 0x0201 then -- мышь. 513 событие left_down
            left_down  (hwnd, wparam, lparam)
        elseif msg == 0x0202 then -- мышь. 514 событие left_up
            left_up    (hwnd, wparam, lparam)
        elseif msg == 0x0204 then -- мышь. 516 событие right_down
            right_down (hwnd, wparam, lparam)
        elseif msg == 0x0205 then -- мышь. 517 событие right_up
            right_up   (hwnd, wparam, lparam)

        --elseif msg == 132 then -- мышь. 517 событие right_up

        --elseif msg == 32 then -- мышь. 517 событие right_up

        else
            return user32.DefWindowProcA(hwnd, msg, wparam, lparam)
        end
        return 0
    end

    local create_window_class = function()
        -- Создаем кисть
        local window_brush = gdi32.GetStockObject(5) -- NULL_BRUSH

        local class_name = "HintClass_"..ffi.string(cfg.class_suffix, 17)

        -- В пилоте мог остаться класс окна от
        -- прошлых вызовов. Нужно уничтожить.
        local out = ffi.new("LPWNDCLASSEXA")
        if user32.GetClassInfoExA(nil, class_name, out) ~= 0 then
            user32.UnregisterClassA(class_name, nil)
        end

        local hint_class   = ffi.new(
            "WNDCLASSA",
            {
            style = 0,
            lpfnWndProc = ffi.cast("WNDPROC", WndProc),
            cbClsExtra = 0,
            cbWndExtra = 0,
            hInstance = kernel32.GetModuleHandleA(nil),
            hIcon = nil,
            hCursor = nil,
            hbrBackground = window_brush,
            lpszMenuName = nil,
            lpszClassName = class_name
            }
        )

        local atom = user32.RegisterClassA(hint_class)
        if atom == 0 then
            --print("Failed to register window class")
            return nil
        end
        return true
    end

    local create_window_class_bg = function()
        -- Создаем кисть
        local window_brush = gdi32.GetStockObject(5) -- NULL_BRUSH
        local class_name = "HintClass_bg_"..ffi.string(cfg.class_suffix, 17)

        -- В пилоте мог остаться класс окна от
        -- прошлых вызовов. Нужно уничтожить.
        local out = ffi.new("LPWNDCLASSEXA")
        if user32.GetClassInfoExA(nil, class_name, out) ~= 0 then
            user32.UnregisterClassA(class_name, nil)
        end

        local hint_class   = ffi.new(
            "WNDCLASSA",
            {
            style = 0,
            lpfnWndProc = ffi.cast("WNDPROC", WndProc_bg),
            cbClsExtra = 0,
            cbWndExtra = 0,
            hInstance = kernel32.GetModuleHandleA(nil),
            hIcon = nil,
            hCursor = nil,
            hbrBackground = window_brush,
            lpszMenuName = nil,
            lpszClassName = class_name
            }
        )

        local atom = user32.RegisterClassA(hint_class)
        if atom == 0 then
            --print("Failed to register window class")
            return nil
        end
        return true
    end

    local create_window = function()
        local hwnd = user32.CreateWindowExA(
            WS_EX_TOPMOST + WS_EX_LAYERED + WS_EX_TOOLWINDOW + WS_EX_NOACTIVATE,    -- dwExStyle WS_EX_NOACTIVATE +
            "HintClass_"..ffi.string(cfg.class_suffix, 17),   -- lpClassName
            "HintWindow",                     -- lpWindowName
            WS_POPUP,                         -- dwStyle WS_POPUP
            cfg.pos_x,                        -- x
            cfg.pos_y,                        -- y
            0,                                -- width
            0,                                -- height
            nil,                              -- hwndParent
            nil,                              -- hMenu
            kernel32.GetModuleHandleA(nil),   -- hInstance
            nil                               -- lpParam
        )

        if not hwnd then
            --print("Failed to create window")
        end
        return hwnd
    end

    local create_window_bg = function()
        local hwnd = user32.CreateWindowExA(
            WS_EX_TOPMOST + WS_EX_LAYERED + WS_EX_TOOLWINDOW + WS_EX_NOACTIVATE,    -- dwExStyle WS_EX_NOACTIVATE +
            "HintClass_bg_"..ffi.string(cfg.class_suffix, 17),-- lpClassName
            "HintWindow_bg",                  -- lpWindowName
            WS_POPUP,                         -- dwStyle WS_POPUP
            cfg.pos_x,                        -- x
            cfg.pos_y,                        -- y
            0,                                -- width
            0,                                -- height
            nil,                              -- hwndParent
            nil,                              -- hMenu
            kernel32.GetModuleHandleA(nil),   -- hInstance
            nil                               -- lpParam
        )

        if not hwnd then
            --print("Failed to create window")
        end
        return hwnd
    end

    local init = function()
        local hint_class_bg = create_window_class_bg()

        local hint_class    = create_window_class()
        bg                  = create_window_bg()
        window              = create_window()
        -- Fix. WM_SETCURSOR. Иначе подвисает. Я хз.
        user32.SendMessageA(window, WM_SETCURSOR , 0, 0)
        --user32.SendMessageA(window, 132 , 0, 0)
        -- 132 WM_NCHITTEST
        --  32 WM_SETCURSOR
        -- 512 WM_MOUSEMOVE
        --  70 WM_WINDOWPOSCHANGING
        --  71 WM_WINDOWPOSCHANGED
        --   3 WM_MOVE
        --user32.SendMessageA(window,  32 , 0, 0) -- (70 15) (132 32) 70 71
        --user32.SendMessageA(window, 512 , 0, 0)
        --user32.SendMessageA(window, 512 , 0, 1)

        return bg, window
    end

    local main = function()
        local bg, window = init()
        local point_prev    = ffi.new("POINT")
        local point_current = ffi.new("POINT")
        user32.GetCursorPos(point_prev)

        local counter = true
        while true do
            cfg.window_cfg_request = 1
            repeat
                if cfg.parent_cfg_request == 1 then
                    cfg.window_cfg_answer = 1
                end
                --print("window_cfg_request", cfg.window_cfg_request)
                --print("parent_cfg_answer" , cfg.parent_cfg_answer )
                --print("parent_cfg_request", cfg.parent_cfg_request)
                --print("window_cfg_answer" , cfg.window_cfg_answer )

                -- method.destroy()
                if cfg.timeout == -2 then
                    user32.SendMessageA(window, WM_CLOSE , 0, 0)
                    user32.SendMessageA(bg    , WM_CLOSE , 0, 0)
                    cfg.window_cfg_request = 2
                    kernel32.ExitThread(0)
                    return 0
                end
            until cfg.parent_cfg_answer ~= 0 or C.Sleep(1)
            cfg.window_cfg_request = 0
            cfg.parent_cfg_answer  = 0
            --user32.SetForegroundWindow(window)
            -- painting
            user32.InvalidateRect(window, nil, true) -- иначе не обновит текст.
            manual_update(window)
            user32.SendMessageA(bg, WM_PAINT, 0, 0)

            local timeout = os.clock() + cfg.timeout*0.001
            local foreground_timeout = -1
            local msg = ffi.new("MSG")
            repeat
                local clock = os.clock()
                if foreground_timeout < clock then
                    --user32.SetForegroundWindow(window)
                    foreground_timeout = clock + 0.03
                end
                local new_message = user32.PeekMessageA(msg, ffi.cast("void*", 0), 0, 0, 1)
                if new_message ~=0 and msg.message > 0 then
                    --user32.TranslateMessage(msg)
                    user32.DispatchMessageA(msg)
                    --print("msg exist "..msg.message.." "..msg.lParam.." "..msg.wParam)
                end
                if move_enabled then
                    user32.GetCursorPos(point_current)
                    if point_current.x ~= point_prev.x or point_current.y ~= point_prev.y then
                        user32.SendMessageA(window, 512 , 1, point_current.y*0x10000 + point_current.x)
                        point_prev.x = point_current.x
                        point_prev.y = point_current.y
                    end
                end
                C.Sleep(1)
            until timeout < os.clock() or cfg.parent_cfg_request == 1 or cfg.timeout < 0

            -- Не был запрошен новый хинт
            -- до окончания показа хинта.
            -- Скрываем окно.
            if cfg.parent_cfg_request == 0 then
                user32.ShowWindow(window, SW_HIDE)
                user32.ShowWindow(bg    , SW_HIDE)
            end
        end
    end

    main()
    return 0
end

local hint_dump = string.dump(hint)
--hint()

local anti_gc = {}

do
    -- Хранит cfg.
    -- При вызове без параметров вернет текущий конфиг
    -- При передаче параметров (таблица)
    -- создаст обновит конфиг основанный на default_cfg
    -- и перезапишет поверх переданными значениями.
    local set_cfg = function(cfg, old_cfg) end
    do
        local default_cfg = ffi.new("cfg")
        default_cfg.text       = "Text"
        default_cfg.text_len   = 4
        default_cfg.font       = "Courier New"
        default_cfg.font_size  = 36
        default_cfg.font_color = 0xFF4000
        default_cfg.font_alpha = 127
        default_cfg.bold       = 700
        default_cfg.anchor     = "bottom_right"
        default_cfg.align_h    = 0x0001 -- "center"
        default_cfg.align_v    = 0x0004 -- "center"
        default_cfg.pos_x      = 300
        default_cfg.pos_y      = 300
        default_cfg.width      = 0
        default_cfg.height     = 0
        default_cfg.border_h   = 0.1
        default_cfg.border_v   = -0.05
        default_cfg.bg_color   = 0x40A65C
        default_cfg.bg_alpha   = 220
        default_cfg.sticky     = 10
        default_cfg.timeout    = 5000
        default_cfg.window_cfg_request = 0
        default_cfg.parent_cfg_answer  = 0
        default_cfg.parent_cfg_request = 0
        default_cfg.window_cfg_answer  = 0

        local class_suffix = nil

        set_cfg = function(new_cfg, old_cfg)
            new_cfg = new_cfg or {}
            local C_cfg = nil
            if old_cfg then
                C_cfg = old_cfg
            else
                C_cfg = ffi.new("cfg")
                class_suffix = string.format("%016s", tostring(C_cfg):match("0x(.*)"))
            end
            anti_gc[#anti_gc+1] = C_cfg

            -- Ждем пока существующий хинт встанет
            -- на паузу.
            if old_cfg then
                C_cfg.parent_cfg_request = 1
                repeat until C_cfg.window_cfg_answer ~= 0 or C.Sleep(1)
                C_cfg.parent_cfg_request = 0
                C_cfg.window_cfg_answer  = 0
            end

            C_cfg.text       = new_cfg.text       or default_cfg.text
            C_cfg.text_len   = new_cfg.text      and #new_cfg.text or 4
            C_cfg.font       = new_cfg.font       or default_cfg.font
            C_cfg.font_size  = new_cfg.font_size  or default_cfg.font_size
            C_cfg.font_color = new_cfg.font_color or default_cfg.font_color
            C_cfg.font_alpha = new_cfg.font_alpha or default_cfg.font_alpha
            C_cfg.bold       = new_cfg.bold       or default_cfg.bold
            C_cfg.anchor     = new_cfg.anchor     or default_cfg.anchor

            if new_cfg.align_h == "left" then
                C_cfg.align_h  = 0x0000
            elseif new_cfg.align_h == "center" then
                C_cfg.align_h  = 0x0001
            elseif new_cfg.align_h == "right" then
                C_cfg.align_h  = 0x0002
            else
                C_cfg.align_h  = default_cfg.align_h
            end

            if new_cfg.align_v == "top" then
                C_cfg.align_v  = 0x0000
            elseif new_cfg.align_v == "center" then
                C_cfg.align_v  = 0x0004
            elseif new_cfg.align_v == "bottom" then
                C_cfg.align_v  = 0x0008
            else
                C_cfg.align_v  = default_cfg.align_v
            end

            C_cfg.pos_x      = new_cfg.pos_x      or default_cfg.pos_x
            C_cfg.pos_y      = new_cfg.pos_y      or default_cfg.pos_y
            C_cfg.width      = new_cfg.width      or default_cfg.width
            C_cfg.height     = new_cfg.height     or default_cfg.height
            if new_cfg.border_h ==  "left" then
                C_cfg.border_h = 0x0000
            elseif new_cfg.border_h ==  "center" then
                C_cfg.border_h = 0x0001
            elseif new_cfg.border_h ==  "right" then
                C_cfg.border_h = 0x0002
            else
                C_cfg.border_h = default_cfg.border_h
            end

            if new_cfg.border_v ==  "top" then
                C_cfg.border_v = 0x0000
            elseif new_cfg.border_v ==  "center" then
                C_cfg.border_v = 0x0004
            elseif new_cfg.border_v ==  "bottom" then
                C_cfg.border_v = 0x0008
            else
                C_cfg.border_v = default_cfg.border_v
            end
            C_cfg.bg_color   = new_cfg.bg_color   or default_cfg.bg_color
            C_cfg.bg_alpha   = new_cfg.bg_alpha   or default_cfg.bg_alpha
            C_cfg.sticky     = new_cfg.sticky     or default_cfg.sticky
            C_cfg.timeout    = new_cfg.timeout    or default_cfg.timeout
            C_cfg.window_cfg_request = 0
            C_cfg.parent_cfg_answer  = old_cfg and 1 or 0
            C_cfg.parent_cfg_request = 0
            C_cfg.window_cfg_answer  = 0
            if not old_cfg then
                C_cfg.class_suffix   = class_suffix
            end

            return C_cfg
        end
    end

    local create_hint = function(self, key)
        local C_cfg = set_cfg(nil, nil)
        local lua_state, func, threadId, threadHandle = func_to_new_thread_and_state(hint_dump, C_cfg)
        --print("lua_state, func, threadId", lua_state, func, threadId)
        local method = {}
        method.hint = function(cfg)
            if type(cfg) == "string" then
                cfg = {text=cfg}
            end
            set_cfg(cfg, C_cfg)
            --print("method", method)
            return method
        end
        method.hide = function()
            C_cfg.timeout = -1
            return method
        end
        method.destroy = function()
            -- Завершаем существование lua_state,
            -- если он нам больше не нужен.
            C_cfg.timeout = -2
            -- Ждем пока обработка окна встанет на паузу.
            repeat until C_cfg.window_cfg_request == 2 or C.Sleep(1)
            C.lua_close(lua_state)
            -- Уничтожаем созданные классы окон.
            local class_name = "HintClass_"..ffi.string(C_cfg.class_suffix, 17)
            user32.UnregisterClassA(class_name, nil)
            class_name = "HintClass_bg_"..ffi.string(C_cfg.class_suffix, 17)
            user32.UnregisterClassA(class_name, nil)
            rawset(self, key, nil)
            return method
        end
        local mt = {}
        mt.__call = function(self, ...) return method.hint(...) end
        setmetatable(method, mt)

        rawset(self, key, method)
        return true
    end


    local export = {}
    local mt = {}
    setmetatable(export, mt)
    mt.__index = function(self, key)
        create_hint(self, key)
        return self[key]
    end
    mt.__gc = function(self)
        -- Вызываем destroy для каждого элемента
        for k, v in pairs(self) do
            if type(v) == "table" and v.destroy then
                v.destroy()
            end
        end
    end
    mt.__call = function(self, ...) export.default(...) end
    export.hide    = export.default.hide
    export.destroy = export.default.destroy

    return export
end









