
using System;
using Server;
using Server.Mobiles; 
using Server.Gumps; 
using Server.Targeting;
using Server.Scripts.Commands;
using Server.Items;
using Server.Commands;

namespace Server.Scripts.Commands
{
	public class PvPCommands
	{
		public static void Initialize()
		{
			CommandSystem.Register( "BandageSelf", AccessLevel.Player, new CommandEventHandler( BandageSelf_OnCommand ) );
			CommandSystem.Register( "DrinkAgility", AccessLevel.Player, new CommandEventHandler( DrinkAgility_OnCommand ) );
			CommandSystem.Register( "DrinkCure", AccessLevel.Player, new CommandEventHandler( DrinkCure_OnCommand ) );
			CommandSystem.Register( "DrinkHeal", AccessLevel.Player, new CommandEventHandler( DrinkHeal_OnCommand ) );
			CommandSystem.Register( "DrinkRefresh", AccessLevel.Player, new CommandEventHandler( DrinkRefresh_OnCommand ) );
			CommandSystem.Register( "DrinkStrength", AccessLevel.Player, new CommandEventHandler( DrinkStrength_OnCommand ) );
					
		}

		[Usage( "BandageSelf" )]
		[Description( "Uses a bandage if it available." )]
		private static void BandageSelf_OnCommand( CommandEventArgs e )
		{
			BandageSelfSystem.StartBandageSelf( e.Mobile );
		}

		[Usage( "DrinkAgility" )]
		[Description( "Uses an agility potion if it available" )]
		private static void DrinkAgility_OnCommand( CommandEventArgs e )
		{
			DrinkAgilitySystem.StartDrinkAgility( e.Mobile );
		}

		[Usage( "DrinkCure" )]
		[Description( "Uses a cure potion if it available" )]
		private static void DrinkCure_OnCommand( CommandEventArgs e )
		{
			DrinkCureSystem.StartDrinkCure( e.Mobile );
		}

		[Usage( "DrinkHeal" )]
		[Description( "Uses a heal potion if it available" )]
		private static void DrinkHeal_OnCommand( CommandEventArgs e )
		{
			DrinkHealSystem.StartDrinkHeal( e.Mobile );
		}

		[Usage( "DrinkRefresh" )]
		[Description( "Uses a refresh potion if it available" )]
		private static void DrinkRefresh_OnCommand( CommandEventArgs e )
		{
			DrinkRefreshSystem.StartDrinkRefresh( e.Mobile );
		}

		[Usage( "DrinkStrength" )]
		[Description( "Uses a strength potion if it available" )]
		private static void DrinkStrength_OnCommand( CommandEventArgs e )
		{
			DrinkStrengthSystem.StartDrinkStrength( e.Mobile );
		}
		

	}
}