using System;
using System.Collections;
using System.Collections.Generic;
using Server;
using Server.Items;
using Server.Mobiles;
using Server.Commands;

namespace Server
{
	public class BandageSelfSystem
	{
		public static readonly bool BandageSelfEnabled = true;

		public static void BandageSelf( Mobile from, Item m_Bandage )
		{
			if ( BandageContext.BeginHeal( from, from ) != null )
			m_Bandage.Consume();
		}

		public static void StartBandageSelf( Mobile from )
		{
			if (BandageSelfEnabled == true)
			{
				Bandage band = (Bandage) from.Backpack.FindItemByType( typeof( Bandage ) );
				if (band != null && !band.Deleted)
				{
					BandageSelf( from, band );

				}
				else
				{
					from.SendMessage( 38, "You don't have any bandages!");
					return; 
				}
			}
			else
			{
				from.SendMessage( 53, "The BandageSelf command is currently disabled!" );
				return;
			}
		}
	}
}